/*
Ejedrez est un petit logiciel d’échecs suffisamment aimable pour vous laisser gagner.
Version console Dos et Linux. 2023 Vial Jean-Luc Annecy
Contact email: vial.frjl@free.fr
Site web: https://sombrayluz.fr/
*/
#ifndef EJEDREZ_H_INCLUDED
#define EJEDREZ_H_INCLUDED

#define VAL_MAT 1000000
#define VAL_PAT 10// La recherche du nul sera préférée à une situation négative ou faiblement positive
#define VAL_CHECK 10
#define NOMBRE_MAX_TOURS 100
#define PROF_MAX 8 // Profondeur maxi en nombre de coups
#define LAT_PROF_MAX 2 // Latitude maxi d'adaptation de la profondeur par rapport à la profondeur demandée au départ
#include <string>
#include <vector>
#include <map>
#include <ctime> // exigé pour la compilation sous Windows seulement
enum typepieces {pion,cavalier,fou,tour,reine,roi};
enum typeparams {poids_stock,poids_menacees,poids_protegees,poids_couvertes,poids_disposition,valeur_roque};
enum typexit {coup_valide,echec_et_mat,nul,coup_illicite};
//Déclarations avancées
class piece; 
class typ_etatjeu;
class escaque;
//----------------------------------
//surcharge de l'opérateur << pour assurer la compatibilité avec Windows
std::ostream& operator<<(std::ostream& os,const std::string& message);
std::ostream& operator<<(std::ostream& os,const char * chaine);
//----------------------------------
// Fonctions avec rôle de variables globales
typedef std::map<typepieces,std::string> typ_nompieces;
typedef std::vector<piece> typ_listepieces;
typedef std::vector<piece>::iterator iter_liste;
typedef std::map<typeparams,int> typ_listeparams;
typedef std::map<typeparams,int>::iterator iter_listeparams;
typ_nompieces& nompieces();
typ_listepieces& listepieces();
typ_etatjeu& etatjeu();
typ_listeparams& parametres();
//----------------------------------
// Classe gérant les fonctions de chronomètre
// t_total est le temps cumulé de tous les comptages depuis le dernier reset
// t_sub est le dernier comptage (entre clockOn et clockOff)
class chessclock
{
public:
	int t_total,t_sub,t_init;
	chessclock();
	void reset();
	void clockOn();
	int clockOff();
	std::string t_to_ch(int tval);
	std::string clock_aff();
	std::string sub_aff();
};
//----------------------------------
typedef std::vector<escaque> typ_listecases;
typedef std::vector<escaque>::iterator iter_listecases;
//----------------------------------
typedef std::pair<typ_listepieces,typ_etatjeu> typ_snapshot;
typedef std::vector<typ_snapshot> typ_archive;
typ_archive& archive();
//----------------------------------
class typ_etatjeu
{
	public:
	int tron; //Affichage mini (0) à verbeux
	int prof_max; // Profondeur maximale d'analyse en coups (2 coups par tour)
	bool H_blancs; //Humain blanc si vrai
	bool tour_de_B;// vrai si les blancs jouent
	int B_a_roque;//Les blancs ont roqué lors de ce tour (-10 si pas de roque)
	int N_a_roque;//Les noirs  ont roqué lors de ce tour (-10 si pas de roque)
	int compteur_tours;
	typ_etatjeu();
	typ_etatjeu(const typ_etatjeu& valjeu);
	std::string Nomjoueur();// retournera la couleur du joueur humain
	std::string Nomjoueur(bool BoN);// retournera blancs si vrai, noirs si faux
	typ_etatjeu& operator=(const typ_etatjeu& valjeu);
	void RAZ();// Remet à zéro les compteurs mais pas tron ni profmax
};
//----------------------------------
class escaque
{
	int X,Y;
	public:
	escaque();
	escaque(const int Xval,const int Yval);
	escaque(const escaque& valcase);
	escaque& operator=(const escaque& valcase);
	bool operator==(const escaque& valcase);		
	bool setX(int valX);// retourne vrai si l'entrée est invalide
	bool setY(int valY);// retourne vrai si l'entrée est invalide
	bool SetX(char ch); // retourne vrai si l'entrée est invalide
	bool SetY(char ch); // retourne vrai si l'entrée est invalide
	int GetX() const;
	int GetY() const;
	char GetXchar() const;
	char GetYchar() const;
	std::string GetXY();

};
class mouvement
{
	public:
	escaque de;
	escaque al;
	mouvement();
	mouvement(const mouvement& mov);
	mouvement(const escaque& depuis,const escaque& vers);
	mouvement& operator=(const mouvement& mov);
	std::string chaine();
	bool est_mat;
	bool est_pat;
	int mene_au_mat;//-1 mat perdant 1 mat gagnant, 0 sinon
};
class noeud
{
	public:	
	bool BoN;//Couleur du joueur
	bool ami;//De la même couleur que la pièce racine
	int valeur;
	int prof;
	mouvement mouv;
	noeud();
	noeud(const noeud& val_noeud);
	noeud(bool v_BoN,bool v_ami,int v_valeur,int v_prof,mouvement v_mouv);
	noeud& operator=(const noeud& val_noeud);
};
class piece
{
	typepieces t;	
public:	
	piece();
	piece(const piece& pval);
	piece& operator=(const piece& pval);
	bool operator==(const piece& p);
	bool operator!=(const piece& p);
	bool BoN; // Blanc est vrai
	bool pris;	
	int a_bouge;// nécessaire pour le roi et la tour dans le cas du roque 
	//(ne doivent pas avoir été bougées donc a_bouge=0)
	// Nécessaire aussi dans la prise en passant du pion. Le pion cible doit avoir bougé au coup précédent
	// Dans le cas du pion cible il doit avoir bougé de deux cases ce qui est indiqué par une valeur négative
	// exemple mouvement du pion b2 au coup 4 b2-->b3 a_bouge=4 mais b2-->b4 a_bouge=-4
	escaque pos;
	typ_listecases mvt_possibles();
	typ_listecases mvt_possibles(bool menace_et_protection);
	typ_listepieces pieces_menacees_protegees(bool menace);
	typ_listepieces pieces_menacees(); // la pos de ces pièces appartient à mvt_possibles (sauf dans le cas du pion)
	typ_listepieces pieces_protegees();// la pos de ces pièces appartient à mvt_possibles (sauf dans le cas du pion)
	int valeur();
	typepieces Get_t() const;
	void Set_t(typepieces t_val);
};
void affiche_pieces(bool BoN,bool toutes); // Affiche les pièces de couleur BoN toutes ou seulement non prises
void affiche_etat_plateau();// Affiche les pièces non prises des deux joueurs
void affiche_etat_jeu();// Affiche les paramètres de la partie
void affiche_mouvement_details(mouvement mouv);
#endif