#include <iostream>
#include <string.h>
#include <fstream>
#include "ejedrez.h"
#include "calculs.h"
//----------------------------------
// Zone de test
//----------------------------------
//----------------------------------
// Fin zone de test
//----------------------------------
// Gestion des différences entre la version bash-Linux et cmd-Windows
#if defined(__WXMSW__)
std::string Liste_rep("dir "),Masque_message(" >nul 2>&1"),Guillemet("\"");
#else
std::string Liste_rep("ls "),Masque_message(" >/dev/null 2>&1"),Guillemet("'");
#endif
//----------------------------------
// Boîte à outils
//-----------------------------------
// Transforme la lettre minuscule en majuscule
char FaitMaj(const char c)
{
	char res(c);
	int val(0);
	val=(int(res));
	if ((val>94)&&(val<123))
		res=char(val-32);
	return res;
}
//-----------------------------------
// convertit au format page de code IBM 850
// Caractère de type UTF8 c3xx exportés sur 4 octets dans std::string
// souvent comme c283 (11000010 10000011) c1XX (11000001)(xxxxxxxx)
// caractère de type UTF8 c2xx exportés sur 4 octets dans std::string
// souvent comme c282 (11000010 10000010) C1XX (11000001)(xxxxxxxx)
std::string UTF8vers850(std::string message)
{
	std::string resultat;
	for (unsigned int i=0;i<message.size();i++)
		{
		if((int(message[i]==-61))&&(message.size()>i+2))
			{
				int hinge(message[i+3]), car850(0);
				switch (hinge)
				{
					case -110: car850=129; break;//ü
					case -96 : car850=133; break;//à
					case -95 : car850=138; break;//è
					case -94 : car850=131; break;//â
					case -93 : car850=156; break;//£
					case -89 : car850=135; break;//ç
					case -87 : car850=130; break;//é
					case -86 : car850=136; break;//ê
					case -85 : car850=137; break;//ë
					case -82 : car850=140; break;//î
					case -81 : car850=139; break;//ĩ
					case -71 : car850=151; break;//ù
					case -69 : car850=150; break;//û
					default : car850= 88; // non reconnu donne X
				}
				resultat.push_back(car850);
			}		
		else
			if(int(message[i]>0   ))	    resultat.push_back(message[i]);				  // Caractère sur un seul octet
		}
	return resultat;
}
//-----------------------------------
std::ostream& operator<<(std::ostream& os,const std::string& message)
// surcharge de l'opérateur << pour éviter de réécrire toutes les lignes avec cout<< sous windows
// mais l'appel de << ne doit pas contenir <<(std::string) dans le corps de la fonction, sinon la fonction va entrer dans une récursion infinie
// l'appel de cout<<(int) ne pose pas de  problème car le compilateur appelle bien la fonction originale et non la surcharge
// L'autre solution consiste à appeler la fonction standard std::operator<<()
	{
	#if defined(__WXMSW__)
	std::string resultat(UTF8vers850(message));
	#else
	std::string resultat(message);
	#endif
	std::operator<<(os,resultat);
	return os;
	}
//-----------------------------------
// surcharge de l'opérateur << dans le cas d'une chaîne explicite style cout<<"bonjour"
std::ostream& operator<<(std::ostream& os,const char * chaine)
{
	std::string message(chaine);
	os<<message; // appelle la fonction surchargée std::ostream& operator<<(std::ostream& os,std::string& message)
	return os;
}
//----------------------------------
// Fin boîte à outils
//----------------------------------
// Classe gérant les fonctions de chronomètre
// t_total est le temps cumulé de tous les comptages depuis le dernier reset
// t_sub est le dernier comptage (entre clockOn et clockOff)
	chessclock::chessclock(){reset();};
	void chessclock::reset(){t_total=0;t_init=0;t_sub=0;};
	void chessclock::clockOn(){t_init=int(time(NULL));};
	int chessclock::clockOff(){t_sub=int(time(NULL))-t_init;t_total+=t_sub;return t_sub;};
	std::string chessclock::t_to_ch(int nb_sec)
		{
		int th(nb_sec/3600),
		tmn((nb_sec-th*3600)/60),
		tsec(nb_sec-th*3600-tmn*60);
		return std::to_string(th)+":"+std::to_string(tmn)+":"+std::to_string(tsec);		
		};
	std::string chessclock::clock_aff() {return t_to_ch(t_total);};
	std::string chessclock::sub_aff() {return t_to_ch(t_sub);};
//----------------------------------
int prof_cible(3);//Va fixer le temps de réflexion attendu (contenu dans temps_prof[prof_cible], la profondeur effective sera ajustée par rachet_prof() pour s'approcher de ce temps
chessclock clock_hom,clock_mach;// les deux chronomètres
std::vector<int> temps_prof;// Conteneur pour les temps limites, en seconde, pour chaque profondeur d'analyse
void init_temps_prof()
{
	temps_prof.clear();
	temps_prof.push_back(0);
	temps_prof.push_back(1);
	temps_prof.push_back(2);
	temps_prof.push_back(4);
	temps_prof.push_back(40);
	temps_prof.push_back(900);
	temps_prof.push_back(1800);
	temps_prof.push_back(3600);
	temps_prof.push_back(3600);
}
// Fin gestion chrono
//----------------------------------
std::string nomfich_param("ejedrez_parametres.txt"),nomfich_sauvegarde("ejedrez_sauvegarde.eje");
std::string ligne_tirets("----------------------------------------------------------\n");
//----------------------------------
// s'assure que vprof est dans [1:prof_cible+2]
// et que vprof reste inférieure ou égale à PROF_MAX
int cadre_prof(int vprof)
{
	vprof=(vprof<1?1:(vprof>prof_cible+LAT_PROF_MAX?prof_cible+LAT_PROF_MAX:vprof));
	return(vprof>PROF_MAX?PROF_MAX:vprof);
}
//----------------------------------
// si temps_de_reponse<temps_prof[prof_cible] etatjeu().prof_max++
// si temps_de_reponse>temps_prof[prof_cible_+1] etatjeu().prof_max--
void rachet_prof()
{
	int vt(clock_mach.t_sub),vp(etatjeu().prof_max);
	if (vt<temps_prof[prof_cible])   {vp++;etatjeu().prof_max=cadre_prof(vp);}
	if (vt>temps_prof[prof_cible+1]) {vp--;etatjeu().prof_max=cadre_prof(vp);}
}
//----------------------------------
// Fonctions avec rôle de variables globales
//----------------------------------
typ_listepieces& listepieces()
{
	static typ_listepieces contenu;
	return contenu;
}
//----------------------------------
typ_nompieces& nompieces()
{
	static typ_nompieces contenu;
	return contenu;
}
//----------------------------------
typ_etatjeu& etatjeu()
{
	static typ_etatjeu contenu;
	return contenu;
}
//----------------------------------
typ_listeparams& parametres()
{
	static typ_listeparams contenu;
	return contenu;
}
//----------------------------------
typ_archive& archive()
{
	static typ_archive contenu;
	return contenu;
}
//----------------------------------
// Implémentation de l'objet contenant la description de l'état de la partie
// verbosité: 1 par défaut l'échiquier est rappelé à chaque tour
// Profondeur d'analyse: 3 par défaut la profondeur d'analyse est de trois demi tours
//----------------------------------
	typ_etatjeu::typ_etatjeu():tron(1),prof_max(3),H_blancs(true),tour_de_B(true){RAZ();}
	typ_etatjeu::typ_etatjeu(const typ_etatjeu& valjeu){*this=valjeu;}
	typ_etatjeu& typ_etatjeu::operator=(const typ_etatjeu& valjeu)
		{
			tron				=valjeu.tron;
			prof_max			=valjeu.prof_max;
			H_blancs			=valjeu.H_blancs;
			tour_de_B		=valjeu.tour_de_B;
			B_a_roque		=valjeu.B_a_roque;
			N_a_roque		=valjeu.N_a_roque;
			compteur_tours	=valjeu.compteur_tours;
			return *this;
		}
	std::string typ_etatjeu::Nomjoueur(bool BoN){return (BoN?"Blancs":"noirs");}// retournera blancs si vrai, noirs si faux
	std::string typ_etatjeu::Nomjoueur(){return Nomjoueur(H_blancs);}// retournera la couleur du joueur humain
	void typ_etatjeu::RAZ(){H_blancs=true;tour_de_B=true;B_a_roque=-10;N_a_roque=-10;compteur_tours=0;}// Remet à zéro les compteurs mais pas tron ni profmax
//----------------------------------
// Implémentation de l'objet escaque (représente les coordonnées d'une case de l'échiquier)
//----------------------------------
	escaque::escaque():X(0),Y(0){} // Le constructeur par défaut crée une case invalide
	escaque::escaque(const int Xval,const int Yval):X(Xval),Y(Yval){}
	escaque::escaque(const escaque& valcase):X(valcase.X),Y(valcase.Y){}
	escaque& escaque::operator=(const escaque& valcase){X=valcase.X;Y=valcase.Y;return *this;}
	bool escaque::operator==(const escaque& valcase){return((X==valcase.X)&&(Y==valcase.Y));}		
	bool escaque::setX(int valX){bool erreur((valX>8)||(valX<1));if (!erreur) X=valX;return erreur;}
	bool escaque::setY(int valY){bool erreur((valY>8)||(valY<1));if (!erreur) Y=valY;return erreur;}
	bool escaque::SetX(char ch){return (int(ch)>96?setX(int(ch)-96):setX(int(ch)-64));}
	bool escaque::SetY(char ch){return setY(int(ch)-48);}
	int escaque::GetX() const {return X;}
	int escaque::GetY() const {return Y;}
	char escaque::GetXchar()const {return (char(64+X));}
	char escaque::GetYchar()const {return (char(48+Y));}
	std::string escaque::GetXY(){return std::string(std::string(1,GetXchar())+std::string(1,GetYchar()));}

//----------------------------------
// Implémentation de l'objet mouvement
//----------------------------------
	mouvement::mouvement():de(escaque()),al(escaque()),est_mat(false),est_pat(false),mene_au_mat(0){}
	mouvement::mouvement(const mouvement& mov){*this=mov;}
	mouvement::mouvement(const escaque& depuis,const escaque& vers):de(depuis),al(vers),est_mat(false),est_pat(false),mene_au_mat(0){}
	mouvement& mouvement::operator=(const mouvement& mov){de=mov.de;al=mov.al;est_mat=mov.est_mat;est_pat=mov.est_pat;mene_au_mat=mov.mene_au_mat;return *this;}
	std::string mouvement::chaine(){return de.GetXY()+" "+al.GetXY();}
//----------------------------------
// Implémentation de l'objet noeud
//----------------------------------
	noeud::noeud():BoN(true),ami(true),valeur(0),prof(0),mouv(){};
	noeud::noeud(bool v_BoN,bool v_ami,int v_valeur,int v_prof,mouvement v_mouv):BoN(v_BoN),ami(v_ami),valeur(v_valeur),prof(v_prof),mouv(v_mouv){}
	noeud::noeud(const noeud& val_noeud){*this=val_noeud;}
	noeud& noeud::operator=(const noeud& val_noeud)
	{
		BoN=val_noeud.BoN;	
		ami=val_noeud.ami;		
		valeur=val_noeud.valeur;
		prof=val_noeud.prof;
		mouv=val_noeud.mouv;
		return *this;
	}
//----------------------------------
// Description des contraintes de mouvements des pièces
//----------------------------------
// Ajoute une case à la liste si elle est occupée par une pièce mangeable (si mp faux) ou une pièce quelconque (mp vrai)
void mange_case_occupee(typ_listecases& resultat,bool BoN,bool mp,int X,int Y)
{
	bool occupee(false);	
	piece pmangeable;
	caselibre(occupee,pmangeable,X,Y);
	if (occupee&&(!pmangeable.pris)&&(mp||(pmangeable.BoN!=BoN))) resultat.push_back(escaque(X,Y));
}
// pion_mange_case_occupee
// si mp vrai, la case est de toute façon ajoutée aux cases couvertes par le pion
// Qu'elle soit occupée ou non.
void pion_mange_case_occupee(typ_listecases& resultat,bool BoN,bool mp,int X,int Y)
{
	if (mp)
	{
		if (dans_le_plateau(X-1,Y)) resultat.push_back(escaque(X-1,Y));
		if (dans_le_plateau(X+1,Y)) resultat.push_back(escaque(X+1,Y));
	}
	else
	{
		mange_case_occupee(resultat,BoN,mp,X-1,Y);		
		mange_case_occupee(resultat,BoN,mp,X+1,Y);		
	}	
	return;
}
//----------------------------------
// Recherche les cases atteignables (par mouvement ou mouvement-prise) par un pion
// Si mp est vrai la liste contient les cases mangeables ou protégées
// donc pas les cases de déplacement devant le pion
typ_listecases range_pion(piece& p,bool mp)
{
	typ_listecases resultat;resultat.clear();
	int Y0(p.pos.GetY()),X0(p.pos.GetX());
	bool BoN(p.BoN);
	int Y=(BoN?Y0+1:Y0-1);	
	// mange une pièce
	pion_mange_case_occupee(resultat,BoN,mp,X0,Y);
	// avance d'une case
	if ((!mp)&&caselibre(X0,Y)) resultat.push_back(escaque(X0,Y));
	// Le pion n'a pas encore été joué
	// peut avancer de deux cases mais pas sauter
	bool non_joue(BoN?(Y0==2):(Y0==7));
	if (non_joue)
		{
		Y=(BoN?Y0+2:Y0-2);
		if ((!mp)&&caselibre(X0,Y)&&(caselibre(X0,(BoN?Y0+1:Y0-1)))) resultat.push_back(escaque(X0,Y));
		}
	// prise en passant n'est examiné que si le pion est sur la bonne rangée
	if (Y0==(BoN?5:4))
		{
		escaque de(X0,Y0),al(X0+1,Y0+(BoN?+1:-1));
		if (prise_en_passant(BoN,mouvement(de,al))) resultat.push_back(al);
		al.setX(X0-1);
		if (prise_en_passant(BoN,mouvement(de,al))) resultat.push_back(al);	
		}
	return resultat;
}
//----------------------------------
// vect est une esquisse du type complexe pour permettre les rotations
typedef std::pair<int,int>vect;
vect rotvect(vect v1,vect v2)
{
	vect res;
	res.first=v1.first*v2.first-v1.second*v2.second;
	res.second=v1.first*v2.second-v1.second*v2.first;
	return res;
}
//----------------------------------
// Recherche les cases atteignables (par mouvement ou mouvement-prise)
// Déplacement en croix de St George si vrai ou de St André si faux
typ_listecases range_StGeorge_ou_StAndre(piece& p,bool si_stGeorge,bool mp)
{
	vect pas((si_stGeorge?0:1),1),gira(0,1);
	typ_listecases resultat;resultat.clear();
	int Y0(p.pos.GetY()),X0(p.pos.GetX()),X(0),Y(0);
	bool BoN(p.BoN);
	for (int i=1;i<5;++i)
		{
			pas=rotvect(pas,gira);
			for (int j=1;j<8;++j)
			{
				X=X0+j*pas.first;
				Y=Y0+j*pas.second;
				if (caselibre(X,Y)) resultat.push_back(escaque(X,Y));
				else {mange_case_occupee(resultat,BoN,mp,X,Y);j=8;}// Arrête l'exploration de la ligne au premier obstacle		
			}
		}
	return resultat;
}
//----------------------------------
typ_listecases range_tour(piece& p,bool mp)
{
				// Le Roque n'est pas testé. Il n'ajoute pas de case possible au déplacement de la tour
				// si le roque est possible il sera détecté lors de l'étude de range_roi
		return range_StGeorge_ou_StAndre(p,true,mp);
}	
//----------------------------------
typ_listecases range_fou(piece& p,bool mp)
{
		return range_StGeorge_ou_StAndre(p,false,mp);
}
//----------------------------------
typ_listecases range_reine(piece& p,bool mp)
{
		typ_listecases resultat;
		resultat=fusionne(range_StGeorge_ou_StAndre(p,true,mp),range_StGeorge_ou_StAndre(p,false,mp));
		return resultat;
}
//----------------------------------
typ_listecases range_cavalier(piece& p,bool mp)
{
		typ_listecases resultat;
		int Y0(p.pos.GetY()),X0(p.pos.GetX()),X(0),Y(0);
		for (int i=0;i<2;i++)
			{
				X=(i?2:1);
				Y=(i?1:2);	
			for (int j=0;j<4;j++)
					{	
					int X1=X;
					X=-Y;Y=X1;
					// mange une pièce si la case est occupée
					mange_case_occupee(resultat,p.BoN,mp,X+X0,Y+Y0);
					// Déplacement sinon
					if (caselibre(X+X0,Y+Y0)) resultat.push_back(escaque(X+X0,Y+Y0));	
					}							
			}	
		return resultat;
}
//----------------------------------
// le roi ne peut pas bouger sur une case menacée
// ces cases ne sont pas acceptées dans les mouvements possibles pour le roi
// Renvoie vrai si la voie est libre pour le roi
bool test_mat(typ_listecases menaces,escaque case_test)
{
		bool reponse(true);		
		for (iter_listecases i=menaces.begin();i<menaces.end();++i)
			if (case_test==(*i)){reponse=false;i=menaces.end();}
		return reponse;
}
//----------------------------------
// Vérifie si la position al constitue un roque possible
void teste_roque(piece& p,typ_listecases& res, escaque al)
{
if (roque(mouvement(p.pos,al))) res.push_back(al);
}
//----------------------------------
typ_listecases range_roi(piece& p,bool mp)
{
		typ_listecases menaces;
		menaces=liste_menaces(!p.BoN,true);	
		typ_listecases resultat;
		int Y0(p.pos.GetY()),X0(p.pos.GetX()),X(0),Y(0);
		for (int i=-1;i<2;i++)
			for (int j=-1;j<2;j++)
				if (i||j) // position du roi exclue
					{
							X=X0+i;Y=Y0+j;						
							// mange une pièce si la case est occupée
							mange_case_occupee(resultat,p.BoN,mp,X,Y);
							// Déplacement sinon mais les cases menacées sont exclues
							if (test_mat(menaces,escaque(X,Y))&&caselibre(X,Y)) resultat.push_back(escaque(X,Y));
					}
		// Roque (le roque contient son propre test pour les cases menacées)
		if (!p.a_bouge)
			{
			teste_roque(p,resultat,escaque(3,p.pos.GetY()));
			teste_roque(p,resultat,escaque(7,p.pos.GetY()));		
			}
		return resultat;
}
//----------------------------------
// Implementation de l'objet piece (représente une pièce de l'échiquier).
//----------------------------------
	piece::piece():t(pion),BoN(true),pris(false),a_bouge(0){}
	piece::piece(const piece& pval){*this=pval;}
	piece& piece::operator=(const piece& pval){BoN=pval.BoN;pris=pval.pris;a_bouge=pval.a_bouge;t=pval.t;pos=pval.pos;return *this;}
	// L'opérateur == vérifie l'identité physique de deux pièces (couleur, position, statut pris ou non) donc pas a_bouge
	bool piece::operator!=(const piece& pval){return(!(*this==pval));}
	bool piece::operator==(const piece& pval){return((BoN==pval.BoN)&&(pris==pval.pris)&&(t==pval.t)&&(pos==pval.pos));}
	//----------------------------------
	typepieces piece::Get_t() const{return t;}
	void piece::Set_t(typepieces t_val){t=t_val;}
	//----------------------------------
	int piece::valeur()
	{
			int valeur(0);		
			switch (t)
		{
			case pion:		valeur=10				;break;
			case tour:		valeur=50 				;break;
			case cavalier:	valeur=30				;break;
			case fou:		valeur=30				;break;
			case reine:		valeur=90				;break;
			case roi:		valeur=VAL_CHECK	   ;break;// la mise en échec du roi sera refusée en amont (dans evalue_noeud) pour le joueur en cours
			default:			valeur=0					;break;		
		}
		return valeur;
	}
	//----------------------------------
	// Liste des cases libres sur lesquelles la pièce peut se déplacer
	// Ces cases peuvent être libres ou occupées par un pièce adverse mangeable ou pas.
	// Si menace_et_protection est vrai la liste inclut toutes les cases affectées par la pièce
	// y compris les cases "mangeables" occupées par une pièce amie (qui est donc protégée)	
	//----------------------------------
	typ_listecases piece::mvt_possibles(bool menace_et_protection)
	{
		typ_listecases resultat;
		if (!pris)
			switch (t)
			{
				case pion:		resultat=range_pion(*this,menace_et_protection)		;break;
				case tour:		resultat=range_tour(*this,menace_et_protection)		;break;
				case cavalier:	resultat=range_cavalier(*this,menace_et_protection);break;
				case fou:		resultat=range_fou(*this,menace_et_protection)		;break;
				case reine:		resultat=range_reine(*this,menace_et_protection)	;break;
				case roi:		resultat=range_roi(*this,menace_et_protection)		;break;
				default:			resultat=range_pion(*this,menace_et_protection)		;break;		
			}	
		return resultat;
	}
	//----------------------------------
	// Alias retournant la liste des cases effectivement jouables (déplacement ou prise)
	typ_listecases piece::mvt_possibles()
	{
		return mvt_possibles(false);	
	}
//----------------------------------
// liste les pièces prenables au coup suivant par la pièce
// la pos de ces pièces appartient à mvt_possibles  (sauf dans le cas du pion)
// menace=vrai renvoie la liste des pièces prenables au coup suivant par cette pièce
// menace=faux renvoie la liste des pièces amies protégées par cette pièce
	typ_listepieces piece::pieces_menacees_protegees(bool menace)
	{
		typ_listepieces res;
		typ_listecases movts(mvt_possibles(true));	// renvoie aussi la position des cases menacées et protégées	
		for (iter_listecases i=movts.begin();i<movts.end();++i)
					{
					iter_liste p(cherchepiece(*i));
					if (p!=listepieces().end()&&!p->pris)
						if ( ((BoN!=(p->BoN))&&menace) || ((BoN==(p->BoN))&&(!menace) ))
							res.push_back(*cherchepiece(*i));
					}				
		return res;
	}
//----------------------------------
	typ_listepieces piece::pieces_menacees()
	{
		return pieces_menacees_protegees(true);
	}
//----------------------------------
	typ_listepieces piece::pieces_protegees()
	{
		return pieces_menacees_protegees(false);
	}
//----------------------------------
// échiquier de test
/*
void remplis_echiquier(bool BoN)
{
	if (BoN) listepieces().clear();
	piece p;	
	if (BoN)
	{
		p.BoN=BoN;
		p.Set_t(roi);
		p.pos.setX(5);p.pos.setY(1);listepieces().push_back(p);
		//p.Set_t(reine);
		//p.pos.setX(8);p.pos.setY(6);listepieces().push_back(p);
		//p.Set_t(cavalier);
		//p.pos.setX(3);p.pos.setY(4);listepieces().push_back(p);
		//p.pos.setX(4);p.pos.setY(6);listepieces().push_back(p);
		//p.pos.setX(8);p.pos.setY(2);listepieces().push_back(p);		
		p.Set_t(pion);
		p.pos.setX(2);p.pos.setY(2);listepieces().push_back(p);
		//p.pos.setX(3);p.pos.setY(5);listepieces().push_back(p);
		//p.pos.setX(6);p.pos.setY(2);listepieces().push_back(p);
		//p.pos.setX(7);p.pos.setY(3);listepieces().push_back(p);		
		//p.Set_t(tour);
		//p.pos.setX(3);p.pos.setY(7);listepieces().push_back(p);
		//p.pos.setX(4);p.pos.setY(5);listepieces().push_back(p);
		//p.pos.setX(5);p.pos.setY(4);listepieces().push_back(p);
		//p.Set_t(fou);
		//p.pos.setX(4);p.pos.setY(1);listepieces().push_back(p);
	}
	if (!BoN)
	{
		p.BoN=BoN;
		p.Set_t(pion);
		p.pos.setX(1);p.pos.setY(7);listepieces().push_back(p);
		p.pos.setX(3);p.pos.setY(7);listepieces().push_back(p);
		//p.pos.setX(7);p.pos.setY(4);listepieces().push_back(p);
		//p.pos.setX(8);p.pos.setY(7);listepieces().push_back(p);					
		//p.pos.setX(5);p.pos.setY(6);listepieces().push_back(p);
		//p.pos.setX(7);p.pos.setY(7);listepieces().push_back(p);
		//p.pos.setX(8);p.pos.setY(7);listepieces().push_back(p);
		//p.Set_t(cavalier);
		//p.pos.setX(3);p.pos.setY(6);listepieces().push_back(p);
		//p.Set_t(tour);
		//p.pos.setX(4);p.pos.setY(8);listepieces().push_back(p);
		//p.pos.setX(8);p.pos.setY(8);listepieces().push_back(p);	
		p.Set_t(roi);
		p.pos.setX(5);p.pos.setY(8);listepieces().push_back(p);
		//p.Set_t(reine);
		//p.pos.setX(1);p.pos.setY(1);listepieces().push_back(p);
		//p.pos.setX(1);p.pos.setY(2);listepieces().push_back(p);
		//p.Set_t(fou);
		//p.pos.setX(2);p.pos.setY(8);listepieces().push_back(p);
		//p.pos.setX(6);p.pos.setY(5);listepieces().push_back(p);
	}	
}
*/
//----------------------------------
// Echiquier réglementaire
// Met en place les pièces (vrai:blanches, faux:noires) en début de partie)
void remplis_echiquier(bool BoN)
{
	if (BoN) listepieces().clear();	
	piece p;	
	for (int i=1;i<9;i++)
	{
		p.BoN=BoN;
		p.Set_t(pion);
		p.pos.setX(i);
		p.pos.setY(BoN?2:7);
		listepieces().push_back(p);
	}
	p.Set_t(tour); 				// Les tours
	p.pos.setX(1);
	p.pos.setY(BoN?1:8);
	listepieces().push_back(p);
	p.pos.setX(8);
	listepieces().push_back(p);
	p.Set_t(cavalier);			// Les cavaliers
	p.pos.setX(2);
	listepieces().push_back(p);
	p.pos.setX(7);
	listepieces().push_back(p);
	p.Set_t(fou);					// Les fous
	p.pos.setX(3);
	listepieces().push_back(p);
	p.pos.setX(6);
	listepieces().push_back(p);
	p.Set_t(reine);				// La reine
	p.pos.setX(4);
	listepieces().push_back(p);
	p.Set_t(roi);					// Le roi
	p.pos.setX(5);
	listepieces().push_back(p);
}

//----------------------------------
// Initialisations
// Fournit les valeurs par défaut des paramètres
// en l'absence de fichier de paramètres
void init_partie()
{
	// Paramètres de la fonction d'évaluation
	parametres()[poids_stock]=10;
	parametres()[poids_menacees]=3;
	parametres()[poids_couvertes]=2;
	parametres()[poids_protegees]=1;
	parametres()[poids_disposition]=10;
	parametres()[valeur_roque]=30;
	// Nom des pièces
	nompieces()[pion]="pion";
	nompieces()[cavalier]="cavalier";
	nompieces()[fou]="fou";
	nompieces()[tour]="tour";
	nompieces()[reine]="reine";
	nompieces()[roi]="roi";
	// Seuils de temps par profondeur
	init_temps_prof();
}
//----------------------------------
// Gestion de fichiers
//----------------------------------
// Teste présence du fichier nom_fich sur le disque
bool fichier_existe(std::string nom_fich)
{
	std::string commande(Liste_rep+nom_fich+Masque_message);
	const char *cstr = commande.c_str();
	return(system(cstr)==0);
}
//----------------------------------
void sauve_parametres()
{
	std::ofstream ofile;
	ofile.open("./"+nomfich_param);
	int v(0);
	for (typeparams i=poids_stock;i<=valeur_roque;i=suivant(i))
		{	
		v=parametres()[i];		
		ofile<<v<<std::endl;	
		}
	ofile.close();
}
//----------------------------------
// cree_fichier de paramètres sur le disque
void cree_fichier_param_default()
{
	std::cout<<"Fichier de paramètre absent. Création du fichier ";
	std::cout<<nomfich_param;// utiliser + pour ajouter les différentes chaînes appelle la version standard de << et pas la surcharge adaptée à Windows
	std::cout<<" dans le répertoire courant \n";	
	init_partie();
	sauve_parametres();
}
//----------------------------------
void charge_parametres()
{
	std::string cible(nomfich_param);
	if (!fichier_existe(cible)) cree_fichier_param_default();
	std::ifstream infile;
	infile.open("./"+nomfich_param);
	int v(0);
	for (typeparams i=poids_stock;i<=valeur_roque;i=suivant(i))
		{
		infile>>v;
		parametres()[i]=v;		
		}
	infile.close();
}
//----------------------------------
void sauve_sauvegarde()
{
	std::ofstream ofile;
	ofile.open("./"+nomfich_sauvegarde);
	ofile<<listepieces().size()		<<std::endl;
	for (iter_liste i=listepieces().begin();i<listepieces().end();++i)
	{
			ofile<<int(i->Get_t())	<<std::endl;
			ofile<<int(i->BoN)		<<std::endl;
			ofile<<int(i->pris)		<<std::endl;
			ofile<<i->a_bouge			<<std::endl;
			ofile<<i->pos.GetX()		<<std::endl;
			ofile<<i->pos.GetY()		<<std::endl;
	}
	ofile<<etatjeu().tron 				<<std::endl;
	ofile<<etatjeu().prof_max 			<<std::endl;
	ofile<<int(etatjeu().H_blancs)	<<std::endl;
	ofile<<int(etatjeu().tour_de_B)	<<std::endl;
	ofile<<etatjeu().B_a_roque 		<<std::endl;
	ofile<<etatjeu().N_a_roque 		<<std::endl;
	ofile<<etatjeu().compteur_tours 	<<std::endl;
	
	ofile.close();
	std::cout<<"Partie sauvegardée dans "<<nomfich_sauvegarde<<" \n";
}
//----------------------------------
// cree_fichier de sauvegarde sur le disque
// Il contient la disposition des pièces à l'entrée du jeu
void cree_sauvegarde(std::string message)
{
	std::cout<<message;
	std::cout<<nomfich_sauvegarde;// utiliser + pour ajouter les différentes chaînes appelle la version standard de << et pas la surcharge adaptée à Windows
	std::cout<<" dans le répertoire courant \n";	
	remplis_echiquier(true);
	remplis_echiquier(false);
	sauve_sauvegarde();
}
//----------------------------------
void charge_sauvegarde()
{
	std::string cible(nomfich_sauvegarde);
	if (!fichier_existe(cible)) 
		cree_sauvegarde("Fichier de sauvegarde absent. Création du fichier ");	
	else
	{
		int v(0),nb_pieces(0);
		piece p;	
		std::ifstream infile;
		infile.open("./"+nomfich_sauvegarde);
		listepieces().clear();
		infile>>nb_pieces;
		for (int i=0;i<nb_pieces;i++)
		{				
				infile>>v;p.Set_t(typepieces(v));
				infile>>v;p.BoN				=bool(v);
				infile>>v;p.pris				=bool(v);
				infile>>v;p.a_bouge			=v;
				infile>>v;p.pos.setX(v);
				infile>>v;p.pos.setY(v);
				listepieces().push_back(p);
		}
		infile>>v;etatjeu().tron			=v;
		infile>>v;etatjeu().prof_max		=v;
		infile>>v;etatjeu().H_blancs		=bool(v);
		infile>>v;etatjeu().tour_de_B		=bool(v);
		infile>>v;etatjeu().B_a_roque		=v;
		infile>>v;etatjeu().N_a_roque		=v;
		infile>>v;etatjeu().compteur_tours=(v&&(etatjeu().H_blancs)?v-1:v);// Si v==0 (faux) c'est un début de partie.
		// H_blancs le tour sauvegardé est le tour précédent, si Humain joue les noirs (H_blancs faux), le tour en cours est déjà commencé
		infile.close();
		std::cout<<ligne_tirets;
		std::cout<<"Partie chargée depuis "<<nomfich_sauvegarde<<" \n";
	}
}
//----------------------------------
// Fin Gestion de fichiers
//----------------------------------
//Affichage des pièces (toutes(faux) affichera seulement les pièces non prises).
void affiche_pieces(bool BoN,bool toutes)
{
	for (iter_liste i=listepieces().begin();i<listepieces().end();++i)
		{
			if ((i->BoN==BoN)&&(toutes||(!i->pris)))
				std::cout<<"("<<i->pos.GetXchar()<<i->pos.GetY()<<")"<<nompieces()[i->Get_t()]<<" ";
		}
	std::cout<<"\n";
}
//----------------------------------
// Affiche toutes les pièces d'une couleur
void affiche_pieces(bool BoN){affiche_pieces(BoN,true);}
//----------------------------------
// Affiche les pièces non prises des deux joueurs
void affiche_etat_plateau()
{
		std::cout<<ligne_tirets;
		std::cout<<"Blancs"<<"\n";affiche_pieces(true,false);
		std::cout<<"Noirs "<<"\n";affiche_pieces(false,false);
}
//----------------------------------
// Affiche l'état du jeu
void affiche_etat_jeu()
{
	typ_etatjeu& ej(etatjeu());	
	if (ej.tron) std::cout<<"Affichage verbeux on "<<ej.tron<<"/4"<<"\n";
	if (!ej.tron) std::cout<<"Affichage mini on "  <<"\n";
	std::cout<<"Profondeur d'analyse "<<ej.prof_max<<"\n";
	std::cout<<"Humain Joue les "<<ej.Nomjoueur()<<"\n";
}
//----------------------------------
// Affiche le nom de la pièce et son mouvement 
void affiche_mouvement(mouvement mouv)
{
	std::string message("mouvement invalide ");	
	iter_liste p_choisie(cherchepiece(mouv.de));
	if (p_choisie!=listepieces().end())
		message=nompieces()[p_choisie->Get_t()]+" "+mouv.chaine()+"\n";	
	std::cout<<message;
}
//----------------------------------
// Affiche le nom de la pièce et son mouvement et les caractéristiques du coup
void affiche_mouvement_details(mouvement mouv)
{
	affiche_mouvement(mouv);
	std::cout<<(mouv.est_mat?"est mat\n":"n'est pas mat\n");
	std::cout<<(mouv.est_pat?"est pat\n":"n'est pas pat\n");
	std::cout<<(mouv.mene_au_mat?(mouv.mene_au_mat==1?"Mène au mat gagnant":"Mène au mat perdant"):"Ne mène pas au mat")<<"\n";
}
//----------------------------------
// Renvoie vrai si une des commandes licite a été frappée en cours de jeu
// Formate la commande dans ch en la mettant en majuscule
bool est_commande(char& ch)
{	
	ch=FaitMaj(ch);
	return((ch=='R')||(ch=='S')||(ch=='L')||(ch=='+')||(ch=='-'));
}
//----------------------------------
// Traite le cas où une commande valide a été rentrée en cours de jeu
void traite_commande(const char ch)
{
	switch (ch)
	{
	case 'R':
				{
				std::cout<<"\n Un pas en arrière ! \n";
				if (archive().size()>1) 
					{
					archive().pop_back();archive().pop_back();// Revient au coup précédent du même joueur
					listepieces()=archive().back().first;
					etatjeu()=archive().back().second;
					std::cout<<"Tour "<<etatjeu().compteur_tours;
					affiche_etat_plateau();
					}
				break;
				}
	case 'S':{sauve_sauvegarde();break;}
	case 'L':{charge_sauvegarde();
				archive().clear();
				archive().push_back(typ_snapshot(listepieces(),etatjeu()));
				affiche_etat_jeu();
				affiche_etat_plateau();
				break;
				}
	case '+':{prof_cible=cadre_prof(++prof_cible);etatjeu().prof_max=cadre_prof(++etatjeu().prof_max);
				std::cout<<"Augmente la profondeur d'analyse à "<<etatjeu().prof_max<<" \n";
				break;}
	case '-':{prof_cible=cadre_prof(--prof_cible);etatjeu().prof_max=cadre_prof(--etatjeu().prof_max);
				std::cout<<"Diminue la profondeur d'analyse à "<<etatjeu().prof_max<<" \n";
				break;}
	default:;
	}
}
//----------------------------------
//Lit_coup retourne faux si l'entrée est invalide sinon resultat contient une chaîne entre [A1] et [H8]
// Renvoie la commande dans ch si nécessaire
bool lit_coup(char& ch,escaque& case_jouee)
{
	bool correct(true);
	std::cin.get(ch);
	if (!est_commande(ch))
	{
	if (case_jouee.SetX(ch)){std::cout<<std::string(1,ch)+" N'est pas dans [A-H]\n";correct=false;}
	std::cin.get(ch);
	if (case_jouee.SetY(ch)){std::cout<<std::string(1,ch)+" N'est pas dans [1-8]\n";correct=false;}
	}
	std::cin.ignore();
	return correct;
}
//----------------------------------
// Lit_coup_humain
// Autorise la correction d'un mouvement mal saisi ou impossible
// Propose de revenir au coup précédent
mouvement lit_coup_humain()
{
	bool possible(false);
	mouvement mouv;
	char ch(0);
	while(!possible)
	{
		escaque res1,res2;
		std::cout<<"Taper R pour revenir au tour précédent, sinon c'est à vous : ";
		possible=lit_coup(ch,res1);
		if (est_commande(ch))
			{
			traite_commande(ch);
			possible=false;
			}
			else
			{
				if (possible) mouv.de=res1;
				std::cout<<mouv.de.GetXY()<<"-->";
				possible=possible&&(lit_coup(ch,res2));
				if (possible) mouv.al=res2;
				possible=possible&&(mouvement_possible(mouv));
				if (!possible)
		 		{			
		 			std::cout<<"Coup impossible. Un regret :O/N ? \n";
		 			std::cin.get(ch);std::cin.ignore();
		 			if((ch!='O')&&(ch!='o')) possible=true;
		 		}				
			}
	}
	return mouv;
}
//----------------------------------
void affiche_aide()
{
	std::cout<<"\n Petit programme d'échec\n";
	std::cout<<" ./ejedrez B ou Blancs, vous jouez les blancs\n";
	std::cout<<" ./ejedrez N ou Noirs , vous jouez les noirs\n";
	std::cout<<" ./ejedrez A ou Auto mode d'optimisation des paramètres\n";
	std::cout<<" ./ejedrez -h (ou --help) : cette aide\n";
	std::cout<<" ./ejedrez -v (ou --version) : nom de version\n";
	std::cout<<" ./ejedrez N/B [0-4] affichage de plus en plus verbeux\n";
	std::cout<<" ./ejedrez N/B p[0-6] profondeur d'analyse en coups (demi-tour)\n";
	std::cout<<" ./ejedrez N/B c crée une nouvelle partie\n";
	std::cout<<ligne_tirets;
	std::cout<<" En cours de jeu: mouvement [A-H][1-8] ou commande (R S L + -)\n";
	std::cout<<ligne_tirets;
	std::cout<<" Pour jouer un coup: pièce en A1 à bouger en A4 par exemple:\n";
	std::cout<<" taper A1 [enter] puis A4 [enter]\n";
	std::cout<<" R pour annuler le tour précédent\n";
	std::cout<<" S pour sauvegarder la partie\n";
	std::cout<<" L pour restaurer la partie\n";
	std::cout<<" +/- pour augmenter/diminuer la profondeur d'analyse\n";
	std::cout<<ligne_tirets;
}
//----------------------------------
void affiche_version()
{
	std::cout<<"\nProgramme ejedrez (Vial jl Annecy)\n";
	std::cout<<"Contact email: vial.frjl@free.fr\n";
	std::cout<<"Site web: https://sombrayluz.fr\n";
	std::cout<<"1.0     juillet  2023 première version fonctionnelle\n";
	std::cout<<"1.1     août     2023 analyse sur un à 6 coups de profondeur\n";
	std::cout<<"1.2     novembre 2023 pondérations modifiées correction de bogues\n";
	std::cout<<"1.3     décembre 2023 pièce touchée illégal rejouée\n";
	std::cout<<"1.4     décembre 2023 pat ou mat distingués à l'évaluation\n";
	std::cout<<"1.5     janvier  2024 Erreur prise en passant et bogue pat corrigées\n";
	std::cout<<"1.5.1   février  2024 bogue roi invisible corrigée\n";
	std::cout<<"1.5.2   avril    2024 nul par répétition pris en compte\n";
	std::cout<<"1.5.3   mai      2024 Déplacement fou tour reine amélioré\n";
	std::cout<<"1.5.4   juillet  2024 pas de répétition sauf si le pat est préférable\n";	
	std::cout<<"1.5.5   juillet  2024 Déplacement pion amélioré\n";
	std::cout<<"1.5.6   juillet  2024 caselibre() amélioré\n";
	std::cout<<"1.5.7   août     2024 Profondeur d'analyse réglée par le temps de réflexion\n";
	std::cout<<"1.5.8   Novembre 2024 Retouche  évalutation d'un noeud\n";
}
//----------------------------------
// Traitement des fins de partie à coup mat trouvé plus loin dans l'arborescence
// Le mouvement proposé est possible mais a un valeur de VAL_MAT qui montre qu'un mat a été trouvé
// Va chercher la profondeur minimale où le mat apparaît et trouver le mouvement correspondant
// Sinon le mouvement choisi mènera au mat mais cela peut prendre du temps
// Dans le cas où le mouvement a une valeur de -VAL_MAT, le joueur en cours est sûr de perdre
// cherche dans ce cas le dernier coup jouable.
mouvement mat_en_vue(mouvement mouv_mat)
{	
	static int mene_au_mat_init(0);
	static int prof_rec(0);
	if (prof_rec==0) mene_au_mat_init=mouv_mat.mene_au_mat;// Garde trace du type de mat gagnant ou perdant
	++prof_rec;
	if (etatjeu().prof_max>1)
	{	
		--etatjeu().prof_max;// Diminue la profondeur d'analyse jusqu'à la fin du jeu
		mouvement anc_mouv(mouv_mat);
		if (etatjeu().tron>2) std::cout<<"prof="<<etatjeu().prof_max<<" "<<mene_au_mat_init;
		mouv_mat=meilleur_coup(etatjeu().tour_de_B);
		if (mouv_mat.mene_au_mat) // le mat est encore visible
			mouv_mat=mat_en_vue(mouv_mat);// on recommence au niveau inférieur
		else 
			if (mene_au_mat_init==1)
			{
			mouv_mat=anc_mouv;//A Ce niveau d'analyse le mat n'est pas vu,
			// le niveau précédent était le bon	
			++etatjeu().prof_max;				
			}			
	}
	--prof_rec;
	return mouv_mat;
}
//----------------------------------
// Distingue entre les situations pat et mat pour la couleur BoN
typexit pat_ou_mat(bool BoN)
{
	typexit tex;
	if (roi_est_mat(BoN)) 
			tex=echec_et_mat;	// Le roi  est en échec: mat
	else 	tex=nul;				// Aucun coup possible mais le roi n'est pas en échec: pat
	return tex;
}
//----------------------------------
// Choisit un coup valide
mouvement choisit_coup()
{
	if(etatjeu().tour_de_B)	std::cout<<"machine joue les blancs ";
	mouvement mouv(meilleur_coup(etatjeu().tour_de_B));
	return mouv;
}
//----------------------------------
// Jeu d'un coup alternativement blanc ou noir
// Retourne vrai si la partie est arrivée à un échec et mat ou un nul
// Bouge effectivement la pièce
// Supprime la pièce prise si nécessaire
// Retourne le type de sortie, mat, illicite,valide ou nul
bool joue_un_coup(typexit& tex)
{
	bool sortie(false);
	bool humain(etatjeu().tour_de_B==etatjeu().H_blancs);
	std::string message("");
	mouvement mouv;
	// Archive la situation existante
	archive().push_back(typ_snapshot(listepieces(),etatjeu()));
	// Choisit un mouvement
	(humain?clock_hom.clockOn():clock_mach.clockOn());
	if (!humain) mouv=choisit_coup(); else mouv=lit_coup_humain();	
	// Traite le cas d'un mouvement valide (sinon la partie se termine))
	if (mouv.mene_au_mat) 
			{
			mouv=mat_en_vue(mouv);// Le mat est inévitable plus loin dans l'arborescence
			// Si l'adversaire est toujours en mat au coup suivant, il y a échec et mat
			// pour le moment il peut encore être confondu avec un pat
			if (mouv_dans_le_plateau(mouv))
			{
				affiche_mouvement(mouv);// Affiche le nouveau mouvement donnant un mat plus bas dans l'analyse
				realise_mouvement(mouv,tex,message);			
			}
			if ((etatjeu().prof_max==2)&&(mouv.mene_au_mat==1))// Le coup suivant sera un mat gagnant
				{
				tex=echec_et_mat;	// Le roi  est en échec: mat								
				etatjeu().tour_de_B=(!etatjeu().tour_de_B);
				sortie=true;			
				}
			if ((etatjeu().prof_max==1)&&(mouv.mene_au_mat==(-1)))// le mouvement ne permet pas d'échapper au mat
				{
				tex=echec_et_mat;	// Le roi  est en échec: mat	
				sortie=true;					
				}
			}
		else
			{
			affiche_mouvement(mouv); // C'est le mouvement trouvé au départ	
			if (mouvement_possible(mouv))
				{
				sortie=( realise_mouvement(mouv,tex,message));
				if (nb_repetitions()>2) {mouv.est_pat=true;message="Nul par répétition";}
				if (message.size()>0) std::cout<<message<<"\n";
				if (mouv.est_pat){tex=nul;sortie=true;}
				}
			else  
				{
				if (humain)	tex=coup_illicite;		// Le joueur (forcément humain)a fait un coup illicite et perd
					else
						tex=pat_ou_mat(etatjeu().tour_de_B); // Aucun coup possible mais le roi est-il pat ou mat?
				sortie=true;		
				}			
			}
	if (humain) clock_hom.clockOff();
		else {clock_mach.clockOff();rachet_prof();}
	if (etatjeu().tron>1)
		{
		std::cout<<"profondeur d'analyse: "<<etatjeu().prof_max<<" Temps (h:mn:s )";
		(humain?std::cout<<" Homme total="<<clock_hom.clock_aff()<<" coup="<<clock_hom.sub_aff()<<"\n":
		std::cout<<"Machine total="<<clock_mach.clock_aff()<<" coup="<<clock_mach.sub_aff()<<"\n");		
		}
	return sortie;
}
//----------------------------------
// Démarre une partie. Humain joue les blancs si BoN est vrai
// Maintien à jour le compteur des coups (valeur de départ dans ejedrez_sauvegarde.eje)
// Le premier coup est joué par les blancs par défaut (ej.tour_de_B initialisé à true par etat_jeu)
void jeu(bool BoN)
{
	typ_etatjeu& ej(etatjeu());	
	ej.H_blancs=BoN;
	affiche_etat_jeu();
	affiche_etat_plateau();
	std::string vainqueur("Nul");
	typexit tex(coup_valide);
	bool en_jeu(true);
	while(en_jeu)
			{
				if (ej.tour_de_B)
					{std::cout<<"Tour "<<++ej.compteur_tours<<" ";}		// Un tour tous les deux coups, blancs puis noirs		
				en_jeu=((!joue_un_coup(tex))&&(ej.compteur_tours<NOMBRE_MAX_TOURS));		// On joue le coup
				if (en_jeu) ej.tour_de_B=(!ej.tour_de_B);											// Changement de joueur
				if (en_jeu&&etatjeu().tron) affiche_etat_plateau();
			}
	std::string message("Longueur maximale de partie atteinte");
	switch (tex)
	{
		case coup_illicite:{if (ej.H_blancs==ej.tour_de_B) 
									message="Coup illicite les "+ej.Nomjoueur(!ej.tour_de_B)+" gagnent";
									else
									message="Mat inévitable, abandon des "+ej.Nomjoueur(ej.tour_de_B)+" les "+ej.Nomjoueur(!ej.tour_de_B)+" gagnent";
									break;}
		case nul				:{message="Partie nulle ";break;}
		case echec_et_mat	:{message="Echec et mat: les "+ej.Nomjoueur(!ej.tour_de_B)+" gagnent";break;}
		case coup_valide	:break;
		default 				:;	
	}
	std::cout<<message<<"\n";
}
//----------------------------------
// Démarre une partie avec le joueur par défaut
void jeu()
{
	affiche_aide();	
	jeu(etatjeu().H_blancs);
}
//----------------------------------
// Partie automatique
void auto_mode()
{
	std::cout<<"La machine joue contre elle-même (indisponible)"<<"\n";
}
//----------------------------------
// Identifie la commande et l'exécute
void interpreteur(int nbpar,char* params[],std::string& message)
{
	bool goon(true),presence_param(nbpar>1),nouvelle_partie(false);// au minimum un paramètre dans param[0] est la commande elle-même
	std::string cible("parametre");
	if (presence_param) cible=params[1];
	int aiguillage(1);
	if (!presence_param)  											{aiguillage=2;goon=false;}	
	if (goon&&((cible=="-v")||(cible=="--version")))		{aiguillage=0;goon=false;}
	if (goon&&((cible=="-h")||(cible=="--help")))     		{aiguillage=1;goon=false;}
	if (goon&&((cible=="B") ||(cible=="Blancs")))	   	{aiguillage=3;goon=false;}
	if (goon&&((cible=="N") ||(cible=="Noirs")))	   		{aiguillage=4;goon=false;}
	if (goon&&((cible=="A") ||(cible=="Auto")))	   		{aiguillage=5;goon=false;}
	if (nbpar>2)
		for (int i=2;i<(nbpar);i++)
			{
			cible=params[i];
			char ch(cible[0]);
			if( (ch>='0')&&(ch<='9') ) {int v(int(ch-48));etatjeu().tron=(v>4?4:v);}				// fixe la verbosité
			if(ch=='p') if (cible.size()>1) {int v(int(cible[1]-48));prof_cible=cadre_prof(v);etatjeu().prof_max=prof_cible;}	//fixe la profondeur d'analyse
			if(ch=='c') {etatjeu().RAZ();nouvelle_partie=true;} // Crée une nouvelle partie en respectant les autres paramètres de la ligne de commande (B/N, p etc) 
			}
	if (nouvelle_partie) cree_sauvegarde("Nouvelle partie ");		
	switch(aiguillage) 
		{
			case 0 : {affiche_version();			break;}// Demande d'affichage de version
			case 1 : {affiche_aide();				break;}// Demande d'affichage de l'aide
			case 2 : {jeu();							break;}// Joueur par défaut indiqué par ejedrez_sauvegarde.eje
			case 3 : {jeu(true);						break;}// Joueur blanc, L'ordinateur jouera les noirs
			case 4 : {jeu(false);					break;}// Joueur noir,  L'ordinateur jouera les blancs
			case 5 : {auto_mode();					break;}// Mode auto pour affiner la fonction d'évaluation
			default :message="Non prévu";
		}
}
//----------------------------------
int main(int argc,char* argv[])
{					
#if defined(__WXMSW__)
std::cout<<"Version Windows"<<"\n";
#else
std::cout<<"Version Linux"<<"\n";
#endif	
//------------------------
srand((unsigned)time(NULL)); // initialise le générateur de nombres aléatoires
init_partie();
charge_parametres();
charge_sauvegarde();
std::string message("Au revoir :");
interpreteur(argc,argv,message);
std::cout<<"\n"<<message<<" Fin de ejedrez\n";
		//------------------------
		// Zone de test
		//------------------------
/*
		// Test version de caselibre
		//------------------------
		int test_max=10000;
		time_t t=clock();
		for (int i=0;i<test_max;i++)
			for (int k=1;k<9;k++)
				for (int l=1;l<9;l++)
					caselibre(k,l);
		std::cout<<"caselibre(k,l) Terminé en ";
		std::cout<<(clock()-t)/(CLOCKS_PER_SEC/1000)<<" ms\n";// temps em millisecondes
		bool occupee(false);
		piece p;
		t=clock();
		for (int i=0;i<test_max;i++)
			for (int k=1;k<9;k++)
				for (int l=1;l<9;l++)
					caselibre(occupee,p,k,l);
		std::cout<<"caselibre(occupee,p,k,l) Terminé en ";
		std::cout<<(clock()-t)/(CLOCKS_PER_SEC/1000)<<" ms\n";// temps em millisecondes
		//------------------------
		// Mouvement des pièces "à longue portée"
		listepieces().clear();
		piece p;
		p.BoN=true;
		p.Set_t(reine);p.pos.setX(5);p.pos.setY(5);listepieces().push_back(p);
		//p.Set_t(tour);p.pos.setX(8);p.pos.setY(3);listepieces().push_back(p);
		p.Set_t(pion);p.pos.setX(3);p.pos.setY(7);listepieces().push_back(p);
		p.BoN=false;
		p.Set_t(pion);p.pos.setX(1);p.pos.setY(1);listepieces().push_back(p);
		typ_listecases movts(listepieces()[0].mvt_possibles());
		affiche_etat_plateau();
		int total(0),maxloop(1000000);
		for (int i=0;i<maxloop;++i)
		{
		for (iter_liste j=listepieces().begin();j<listepieces().end();++j)
			{			
			movts=j->mvt_possibles();
				for (iter_listecases i=movts.begin();i<movts.end();++i)
				{
						//std::cout<<"["<<i->GetXY()<<"]";
						++total;
				}
			}		
		}
		std::cout<<"total="<<total<<"\n";
		//------------------------
		// Pion à dame
		listepieces().clear();
		piece p;
		mouvement mouv;
		int num(0);	
		p.BoN=true;
		p.Set_t(pion);p.pos.setX(5);p.pos.setY(7);listepieces().push_back(p);
		mouv=mouvement(escaque(5,7),escaque(5,8));
		if (pion_a_dame(mouv)) message="pion à dame "; else message="nope";std::cout<<++num<<" "<<message<<"\n";
		//------------------------
		// Prise en passant
		listepieces().clear();
		piece p;	
		iter_liste pf,t;
		bool est_vrai(false);
		p.BoN=true;
		etatjeu().compteur_tours=5;
		p.Set_t(pion);
		p.BoN=true ;p.pos.setX(5);p.pos.setY(5);p.a_bouge=-4;listepieces().push_back(p);
		p.BoN=false;p.pos.setX(6);p.pos.setY(5);p.a_bouge=-4;listepieces().push_back(p);
		p.BoN=true ;p.pos.setX(8);p.pos.setY(4);p.a_bouge=-5;listepieces().push_back(p);
		p.BoN=false;p.pos.setX(7);p.pos.setY(4);p.a_bouge=-5;listepieces().push_back(p);
		affiche_etat_plateau();
		mouvement mouv;
		mouv=mouvement(escaque(5,5),escaque(4,6));
		est_vrai=prise_en_passant(true,mouv,t,message);std::cout<<mouv.chaine()<<" pep="<<(est_vrai?"oui ":"non ")<<message<<"\n";
		mouv=mouvement(escaque(5,5),escaque(6,6));
		est_vrai=prise_en_passant(true,mouv,t,message);std::cout<<mouv.chaine()<<" pep="<<(est_vrai?"oui ":"non ")<<message<<"\n";
		mouv=mouvement(escaque(7,4),escaque(8,3));
		est_vrai=prise_en_passant(false,mouv,t,message);std::cout<<mouv.chaine()<<" pep="<<(est_vrai?"oui ":"non ")<<message<<"\n";
		mouv=mouvement(escaque(7,4),escaque(7,3));
		est_vrai=prise_en_passant(false,mouv,t,message);std::cout<<mouv.chaine()<<" pep="<<(est_vrai?"oui ":"non ")<<message<<"\n";
		//------------------------
		// Roque		
		p.Set_t(fou);
		p.pos.setX(3);p.pos.setY(4);listepieces().push_back(p);
		p.BoN=false;
		p.Set_t(roi);
		p.pos.setX(5);p.pos.setY(7);listepieces().push_back(p);
		p.Set_t(tour);
		p.pos.setX(1);p.pos.setY(8);listepieces().push_back(p);
		p.pos.setX(8);p.pos.setY(7);listepieces().push_back(p);
		mouvement mouv=mouvement(escaque(5,7),escaque(3,8));
		escaque dest;
		pf=cherchepiece(fou,true);		
		if (roque(mouv,message,t,dest)) message+=" possible";else message+=" impossible";
		std::cout<<"\n"<<nompieces()[pf->Get_t()]<<" "<<pf->pos.GetXY()<<" ";
		std::cout<<"\n"<<((t>=listepieces().begin())&&(t<listepieces().end())?nompieces()[t->Get_t()]:"XX")<<" "<<message<<" "<<"\n";
		//std::cout<<"\n"<<(t!=listepieces().end()?nompieces()[t->Get_t()]:"XX")<<" "<<message<<" "<<mouv.al.GetXY()<<"->"<<(dans_le_plateau(dest)?dest.GetXY():"YY")<<"\n";
		pf->pos.setX(5);pf->pos.setY(6);std::cout<<"\n"<<nompieces()[pf->Get_t()]<<" "<<pf->pos.GetXY()<<" ";
		
		mouvement mouv;iter_liste p,t;
		p=cherchepiece(escaque(5,8));
		escaque dest;

		std::cout<<nompieces()[p->Get_t()]<<p->mvt_possibles(true).size()<<" ";
		p=cherchepiece(escaque(1,7));
		std::cout<<nompieces()[p->Get_t()]<<p->mvt_possibles(true).size()<<" ";
		p=cherchepiece(escaque(8,8));
		std::cout<<nompieces()[p->Get_t()]<<p->mvt_possibles(true).size()<<" ";
		p=cherchepiece(escaque(5,4));
		std::cout<<nompieces()[p->Get_t()]<<p->mvt_possibles(true).size()<<" ";
		etatjeu().compteur_tours=5;
		mouvement mouv;iter_liste p;
		if (roque_effectue(false)) std::cout<<"roque fait"; else std::cout<<"pas fait";
		*/
		//------------------------
}