/*
Ejedrez est un petit logiciel d’échecs suffisamment aimable pour vous laisser gagner.
Version console Dos et Linux. 2023 Vial Jean-Luc Annecy
Contact email: vial.frjl@free.fr
Site web: https://sombrayluz.fr/
*/
#ifndef CALCULS_H_INCLUDED
#define CALCULS_H_INCLUDED

#include <string>
#include "ejedrez.h"
//------------------------
// Outils non spécifiques
template<class Te> Te suivant(Te m)
{
        return (Te(int(m)+1));
}
//---------------------------------------------------------------------------
// Émulation de la fonction RandomRange
// retourne un entier dans l'intervalle [min,max[
int RandomRange_bis(int low,int high);
//---------------------------------------------------------------------------
// Brasse un conteneneur
template<class T> T brasse(T a_brasser)
{
	typename T::value_type v;
	int nb_elements=a_brasser.size();
	if (nb_elements)
		{
		for (int i=0;i<nb_elements;i++)
			{
			int tirage=RandomRange_bis(i,nb_elements);
			v=a_brasser[i];
			a_brasser[i]=a_brasser[tirage];
			a_brasser[tirage]=v;
			}
		}
	return a_brasser;
}
//------------------------
bool dans_le_plateau(const int X, const int Y);
bool dans_le_plateau(const escaque& test_esc);
bool mouv_dans_le_plateau(const mouvement& mouv);
bool caselibre(int X, int Y);
bool caselibre(bool& occupee,piece& p,int X, int Y);
int evalue_un_jeu(bool BoN);
void evalue_noeud(noeud& nd);// évalue les noeuds fils de nd et affecte la valeur au noeud racine 
mouvement meilleur_coup(bool BoN);
iter_liste cherchepiece(escaque XY);// Cherche une pièce par position
iter_liste cherchepiece(typepieces t,bool BoN);// Cherche une pièce par type et couleur retourne la première trouvée
bool mouvement_possible(mouvement mouv);
bool positions_identiques(typ_listepieces l1,typ_listepieces l2);
int nb_repetitions();
bool pion_a_dame(mouvement mouv);
bool prise_en_passant(bool BoN,mouvement mouv,iter_liste& pioncible,std::string& message);
bool prise_en_passant(bool BoN,mouvement mouv);
bool roque(mouvement mouv);
bool roque(mouvement mouv,std::string& message,iter_liste& compagne,escaque& destination_compagne);
bool roque_effectue(bool BoN);
bool realise_mouvement(mouvement mouv,typexit& tex,std::string& message);
bool realise_mouvement(mouvement mouv);
bool roi_est_mat(bool BoN);
typ_listecases liste_menaces(bool BoN,bool ombre_roi);// crée une liste des cases menacées par BoN
// ombre_roi vrai rend le roi !BoN transparent
//------------------------
// Fusionne deux conteneurs
template<class T> T fusionne(T f1,T f2)
{
	T resultat(f1);
	for (typename T::iterator i=f2.begin();i<f2.end();++i)
		resultat.push_back(*i);
	return resultat;
}
#endif