#include "calculs.h"
#include <string.h>
#include <iostream>
//------------------------
// Fonction générant un nombre pseudo aléatoire avec une période plus grande que rand
int rand_bis()
{
	static unsigned long int graine=rand();
	static unsigned long int xn=graine;
	xn=( 1103515245 * xn + 12345 ) % 2147483647;
	return xn;
}
//------------------------
// Émulation de la fonction RandomRange
// retourne un entier dans l'intervalle [min,max[
int RandomRange_bis(int low,int high)
{
	if (high <low) high=low;
	//return (rand() % (high-low))+low; // utilise le générateur de nombre aléatoire de la bibliothèque standard
	return (rand_bis() % (high-low))+low;
}
//------------------------
// Vérifie que la case est dans le tableau (faux si hors plateau)
bool dans_le_plateau(const int X, const int Y)
{
	return ((X>0)&&(X<9)&&(Y>0)&&(Y<9));
}
//------------------------
bool dans_le_plateau(const escaque& test_esc)
{
	return dans_le_plateau(test_esc.GetX(),test_esc.GetY());
}
//------------------------
// renvoie vrai si les mouvements de départ et d'arrivée sont tous deux dans le plateau
bool mouv_dans_le_plateau(const mouvement& mouv)
{
	return ( (dans_le_plateau(mouv.de))&&(dans_le_plateau(mouv.al)) );
}
//------------------------
// renvoie vrai si la case est disponible
// Vérifie que la case est dans le tableau et
// parcourt listepieces pour voir si une pièce l'occupe, renvoie cette pièce dans ce cas avec occupee vrai.
// Les pièces prises "fantômes" ne sont pas vues
bool caselibre(bool& occupee,piece& p,int X, int Y)
{
	bool res(dans_le_plateau(X,Y));
	occupee=false;	
	if (res)
		for (iter_liste i=listepieces().begin();i<listepieces().end();++i)
			if ((i->pos.GetY()==Y)&&(i->pos.GetX()==X)&&(!i->pris))	{p=(*i);occupee=true;res=false;i=listepieces().end();}
	return res;
}
//------------------------
// Vérifie que la case est dans le tableau et
// parcourt listepieces pour voir si une pièce l'occupe
bool caselibre(int X, int Y)
{
	piece p;
	bool oc(false);
	return caselibre(oc,p,X,Y);
}
//----------------------------------
// Fonction d'évaluation
// la valeur de la disposition des pièces est calculée par evalue_un_joueur
// en positif pour le joueur en cours, en négatif pour l'opposant.
// la somme des deux est renvoyée par evalue_un_jeu
// Retourne la valeur de la position
//----------------------------------
// Evalue une disposition des pièces d'un joueur
int evalue_un_joueur(bool BoN)
{
	int resultat(0);
	typ_listepieces& J_eval(listepieces());
	for (iter_liste i=J_eval.begin();i<J_eval.end();++i)
	{
		if ( ((i->BoN)==BoN)&&(!i->pris) )		
		{
			// Le stock: les pièces du joueur
			if (i->Get_t()!=roi)	// les rois n'ont pas de valeur !
				resultat+=i->valeur()*parametres()[poids_stock]; 
			// les pièces qu'il menace
			typ_listepieces provlist(i->pieces_menacees()); 
			for (iter_liste j=provlist.begin();j<provlist.end();++j)
				resultat+=j->valeur()*parametres()[poids_menacees];// là les rois comptent
			//   Les cases qu'il couvre par son déplacement possible
			resultat+=i->mvt_possibles(true).size()*parametres()[poids_couvertes];
			// les pièces amies qu'il protège
			provlist=i->pieces_protegees(); 
			for (iter_liste j=provlist.begin();j<provlist.end();++j)
				if (j->Get_t()!=roi)		// aucun sens à protéger le roi			
					resultat+=j->valeur()*parametres()[poids_protegees];		
			// La qualité de la position
		}
	}
			// il y a eu un roque
	if (roque_effectue(BoN)) resultat+=(parametres()[valeur_roque]*parametres()[poids_disposition]);
	return resultat;
}
//----------------------------------
// Evalue l'échiquier du point de vue du joueur BoN
// en retranchant de la valeur de sa position celle de son adversaire
int evalue_un_jeu(bool BoN)
{
	int resultat(evalue_un_joueur(BoN)-evalue_un_joueur(!BoN));
	return resultat;
}
//------------------------
//Variables comptables
int nb_total_nds_evalues(0);
//------------------------
// évalue les noeuds fils de nd et affecte la meilleure valeur au noeud racine
// nd.valeur contient en sortie la valeur du meilleur mouvement des branches en aval.
// le noeud initial (nd.prof=0) contiendra la valeur du meilleur mouvement dans nd.valeur
// et en plus nd.mouv contiendra le meilleur mouvement au coup suivant
// On rentre dans la fonction avec nd.prof=0 depuis meilleur_coup	
void evalue_noeud(noeud& nd)
{
	// Extrémité de la branche.
	// Ne sera atteinte ni en cas de pat ni en cas de mat
	// On est au bout de l'analyse. la situation est évaluée
	if (nd.prof>=etatjeu().prof_max)
		nd.valeur=evalue_un_jeu(nd.BoN)*(nd.ami?1:-1);// Valeur vue du côté de la pièce amie
	else // il faut aller un coup plus loin
	{
		int alphabeta=nd.valeur;// Le noeud père passe la valeur seuil au fils
		// si le noeud père est ami, ce niveau est ennemi, la première valeur retournée inférieure au seuil
		// entraîne l'arrêt de l'exploration car le fils ne peut que garder des valeurs encore inférieures
		// inversement si le noeud père est ennemi, ce niveau est ami, la première valeur retournée supérieure au seuil
		// entraîne l'arrêt de l'exploration car le fils ne peut garder que des niveaux supérieurs.
		int vmat(nd.ami?VAL_MAT:-VAL_MAT),vpat(VAL_PAT);
		nd.valeur=vmat;	//Un noeud ami considère que l'adversaire jouera le pire coup
		// toute valeur plus faible que VAL_MAT sera gardée et inversement
		std::vector<piece *> indice_pieces;// Réceptacle provisoire pour les pièces brassées
		for (auto i=listepieces().begin();i<listepieces().end();i++) indice_pieces.push_back(&*i);// auto donne à i le type iter_liste.
		// Les iterateurs sont presque, mais pas tout à fait ... des pointeurs vers les éléments du vecteur
		// (&*i) Semble ridicule: déréférence l'itérateur pour le référencer ensuite
		// obtenant un pointeur à partir de l'iterateur.
		indice_pieces=brasse(indice_pieces);
		bool un_mouvement(false);
		for (long unsigned int ipos=0;ipos<indice_pieces.size();++ipos)
		{
			piece* i=indice_pieces[ipos];
			if ((i->BoN!=nd.BoN)&&(!i->pris))// C'est l'autre joueur qui bouge
			{		
				typ_listecases listmov(brasse(i->mvt_possibles()));
				for (iter_listecases j=listmov.begin();j<listmov.end();++j)
				{
					// on met sous naphtaline la situation de départ
					typ_listepieces liste_anc(listepieces());
					typ_etatjeu etat_anc(etatjeu());
					typ_archive arch_anc(archive());
					// Construit le mouvement à tester
					mouvement mouv(i->pos,(*j));
					// Le tour suivant est celui de l'autre joueur
					etatjeu().tour_de_B=(!etatjeu().tour_de_B);
					// Changement de tour tous les deux coups
					if (etatjeu().tour_de_B) etatjeu().compteur_tours++;
					// On joue le coup
					typexit tex;
					std::string message("");											
					realise_mouvement(mouv,tex,message);
					// Vérification qu'on n'est pas dans un cas de nul par répétition
					// En cas de nul par répétition (3 répétitions), les coups suivants n'ont pas de sens, mais ce mouvement
					// peut être conservé s'il donne un meilleur score que les autres
					// S'il y a au moins une répétition (nb_repet>1) cela offre la possibilité d'un pat à l'adversaire au tour suivant
					// Le coup reçoit donc la valeur vpat et ne sera choisi que si la position vaut moins que vpat
					archive().push_back(typ_snapshot(listepieces(),etatjeu()));
					int nb_repet=nb_repetitions();
					// On construit un noeud correspondant à un coup de l'adversaire avec ce mouvement
					noeud nd_eval(!nd.BoN,!nd.ami,nd.valeur,nd.prof+1,mouv);
					if (nb_repet>1) nd_eval.valeur=vpat;// un nul par répétition a la valeur d'un pat
					// On vérifie que le mouvement ne conduit pas à un mat pour la couleur en cours
					// Sinon on ne traite pas le mouvement, pas plus qu'en cas de nul par répétition.														
					if ((!roi_est_mat(!nd.BoN))&&(nb_repet<2))
					{													
						// Evaluation récursive dont on sortira par l'évaluation de l'extrémité de la branche
						++nb_total_nds_evalues;
						un_mouvement=true;//Il y a au moins un mouvement possible
						evalue_noeud(nd_eval);
					}
					if ((nd.prof==0)&&(etatjeu().tron>1)) std::cout<<"[nd0 "<<nd_eval.valeur<<" "<<mouv.chaine()<<"]";
					if ((nd.prof!=0)&&(etatjeu().tron>3)) std::cout<<"["<<nd_eval.valeur<<" "<<mouv.chaine()<<"]";
					// On garde le meilleur (ami)	ou le pire (ennemi) coup de l arbre					
					int anc_val=nd.valeur;
					nd.valeur=(nd_eval.ami?(nd.valeur<nd_eval.valeur?nd_eval.valeur:nd.valeur)
								  :(nd.valeur>nd_eval.valeur?nd_eval.valeur:nd.valeur));
					// Le noeud racine garde la meilleure solution
					if ((nd.prof==0)&&(anc_val!=nd.valeur)) nd.mouv=mouv;
					// élagage alphabeta de l'arbre
					if(nd.ami?nd.valeur<alphabeta:nd.valeur>alphabeta)
						j=listmov.end();
					// on rétablit l'état de départ après chaque coup
					// evalue_noeud évalue mais ne joue pas réellement le coup
					archive()=arch_anc;
					etatjeu()=etat_anc; 					
					listepieces()=liste_anc;					
				}
			}
		}
		nd.mouv.est_pat=((!un_mouvement)&&(!roi_est_mat(!nd.BoN))); // C'est un pat		
		if (nd.mouv.est_pat)	nd.valeur=vpat;
	}
// le coup mène-t'il à un mat gagnant ou perdant ?
// mene_au_mat vaut -1 si mat perdant, 1 si gagnant, 0 sinon
// l'attribut mene_au_mat nest renseigné qu'à la sortie de l'exploration, il n'est pas utilisé avant
nd.mouv.mene_au_mat=((nd.valeur==VAL_MAT)+(nd.valeur==(-VAL_MAT))*(-1));
}
//------------------------
// retourne le meilleur mouvement pour le joueur blanc ou noir
// Analyse jusqu'à profmax coups
// Démarre à la sortie du coup antérieur
mouvement meilleur_coup(bool BoN)
{
	// On entre dans le récursion par la situation résultant du coup antérieur	
	typ_etatjeu etat_anc(etatjeu());			// on préserve la situation pendant l'évaluation
	if (etatjeu().tour_de_B) etatjeu().compteur_tours--;
	mouvement mouv;
	// Le noeud de départ résulte d'un coup adverse
	// où le joueur adverse avait la main
	noeud nd_eval(!BoN,false,VAL_MAT,0,mouv);
	etatjeu().tour_de_B=(!etatjeu().tour_de_B);
	// Entrée dans la récursion qui va explorer tous les noeuds fils de nd_eval
	// En sortie nd_eval.valeur contiendra la valeur du meilleur coup nd_eval.mouv
	nb_total_nds_evalues=0;
	evalue_noeud(nd_eval);
	if (etatjeu().tron>1) std::cout<<"Nombre de noeuds évalués "<<nb_total_nds_evalues<<"\n";	
	if (etatjeu().tron>1) std::cout<<"Valeur "<<nd_eval.valeur<<" pour ";	
	etatjeu()=etat_anc; // on rétablit l'état de départ
	return nd_eval.mouv;	
}	
//------------------------
// Retourne un pointeur sur la pièce de coordonnées XY dans la liste des pièces encore en jeu
iter_liste cherchepiece(escaque XY)
{
	typ_listepieces& J(listepieces());	
	iter_liste cible(J.end());	
	for (iter_liste i=J.begin();i<J.end();++i)
		if ((i->pos==XY)&&(!i->pris)) {cible=i;i=J.end();}
	return cible;
}
//------------------------
iter_liste cherchepiece(typepieces t,bool BoN)// Cherche une pièce par type et couleur
{
	typ_listepieces& J(listepieces());	
	iter_liste cible(J.end());	
	for (iter_liste i=J.begin();i<J.end();++i)
		if ((i->Get_t()==t)&&(i->BoN==BoN)&&(!i->pris)) {cible=i;i=J.end();}
	return cible;
}
//------------------------
// Vérifie qu'un mouvement proposé est légal
// Ne devrait se poser qu'avec le joueur humain
// ou si le mouvement proposé expose le roi du joueur
bool mouvement_possible(mouvement mouv)
{
	bool res(false);	
	typ_listecases cases_possibles;
	iter_liste p(cherchepiece(mouv.de));
	if ( (p!=listepieces().end())&&(p->BoN==etatjeu().tour_de_B) )
	{
	cases_possibles=p->mvt_possibles();
	if (cases_possibles.size()>0)
		for (iter_listecases i=cases_possibles.begin();i<cases_possibles.end();++i)
				if((*i)==mouv.al) res=true;
	}
	// Vérification que le roi n'est pas exposé par le mouvement
	if (res)
	{
		// on met sous naphtaline la situation de départ
		typ_listepieces liste_anc(listepieces());
		typ_etatjeu etat_anc(etatjeu());
		realise_mouvement(mouv);
		res=!roi_est_mat(p->BoN);
		// on rétablit l'état de départ
		etatjeu()=etat_anc; 					
		listepieces()=liste_anc;	
	}	
	if (!res) std::cout<<"Mouvement impossible"<<"\n";
	return res;
}
//------------------------
// Renvoie vrai si les deux échiquiers sont identiques
bool positions_identiques(typ_listepieces l1,typ_listepieces l2)
{
	bool resultat(true);
	for (unsigned int i=0;i<l1.size();i++)
		{
			resultat&=(l1[i]==l2[i]);
			if (!resultat) i=l1.size();
		}
	return resultat;
}
//------------------------
// Renvoie le nombre de fois où la position courante est apparue
// La fonction ne respecte pas complètement les règles puisqu'elle devrait également vérifier
// Que la répétition concerne le même joueur
// Que les droits de roque ne sont pas modifiés (par le mouvement du roi par exemple)
// Que le droit de prise en passant n'a pas été modifié (possible une seule fois,juste après le mouvement double du pion adverse)
// Ce nombre peut-être 1, 2 ou 3
// Le minimum est 1 puisque la position courante compte
// La position n'a pas pu apparaître au coup précédent (donc dans archive()[n-1])
int nb_repetitions()
{
	int resultat(1);
	for (int i=archive().size()-2;i>=0;i--)
		{
			resultat+=positions_identiques(archive()[i].first,listepieces());
		} 
	return resultat;
}
//------------------------
// Le mouvement est supposé valide
// Déplace effectivement les pièces dans le tableau listepieces()
// Retourne vrai si la partie est terminée (mat ou illicite ou nul) faux si elle continue
// retourne tex avec le statut du coup (mat, illicite, valide ou nul)
bool realise_mouvement(mouvement mouv,typexit& tex,std::string& message)
{				
		//------------------------		
		// le mouvement est réellement effectué		
		iter_liste l(cherchepiece(mouv.al)); 		// La case de destination est-elle occupée ?
		if(l!=listepieces().end()) l->pris=true; 	// elle l'est par la pièce l qui est sortie du jeu
		l=cherchepiece(mouv.de);						// l est maintenant la pièce bougée
		//------------------------		
		// traite les coups spéciaux
		bool asuivre(true);
		// Avance de deux cases du pion à son premier mouvement
		bool pion_deux_cases((l->Get_t()==pion)&&(mouv.de.GetY()==(l->BoN?2:7))&&(mouv.al.GetY()==(l->BoN?4:5))&&(mouv.de.GetX()==mouv.al.GetX()));
		if (pion_deux_cases)							{asuivre=false;message="pion avance de deux cases ";}		
		// pion à dame (la transformation en reine est systématique, ce qui limite un peu les possibilités du jeu)
		if (asuivre&&pion_a_dame(mouv)) 			{l->Set_t(reine);asuivre=false;message="pion à dame ";}
		// prise en passant
		iter_liste piececible;
		if (asuivre)
		{
			if (prise_en_passant(etatjeu().tour_de_B,mouv,piececible,message))
				{piececible->pris=true;asuivre=false;}
				else message="";	 // message détaillant la cause de l'échec non utilisé ici		
		}
		if (asuivre)
		{
		// Le cas du roque est le seul où deux pièces sont bougées piececible est une tour
			escaque destcomp;		
			if (roque(mouv,message,piececible,destcomp))
				{piececible->pos=destcomp;piececible->a_bouge=etatjeu().compteur_tours;
				if ( etatjeu().tour_de_B) etatjeu().B_a_roque=etatjeu().compteur_tours;
				if (!etatjeu().tour_de_B) etatjeu().N_a_roque=etatjeu().compteur_tours;
				}
				else message="";	// message détaillant la cause de l'échec non utilisé ici
		}
		// Fin des coups spéciaux
		//------------------------		
		l->pos=mouv.al;									// Bouge la pièce jouée
		l->a_bouge=etatjeu().compteur_tours*(pion_deux_cases?-1:1);	// Enregistre le numéro du tour, le met en négatif si c'est un pion ayant bougé de deux cases
		return false; 										// on continue
}
//------------------------
// Alias de réalise_mouvement
bool realise_mouvement(mouvement mouv)
{
	typexit			tex;
	std::string message("");
	return realise_mouvement(mouv,tex,message);
}
//------------------------
// Mouvements spéciaux
//------------------------
// Pion à dame
bool pion_a_dame(mouvement mouv)
{
	bool res(false);	
	int Y(mouv.al.GetY());	
	if ((Y==1)||(Y==8))
	{
		iter_liste case_jouee(cherchepiece(mouv.de));
		if (case_jouee!=listepieces().end())
			res=(case_jouee->Get_t()==pion);
	}	
	return res;
}
//------------------------
// Prise en passant par un pion
// Retourne le pion pris
bool prise_en_passant(bool BoN,mouvement mouv,iter_liste& pioncible,std::string& message)
{
	bool possible(true);
	message="Prise en passant impossible ";
	// la pièce bougée doit être un pion
	iter_liste p(cherchepiece(mouv.de));
	if ((p==listepieces().end())||(p->Get_t()!=pion))
		{possible=false;message="";}
	// La pièce doit être en 4 (noirs) ou en 5 (blancs))
	if (possible&&(mouv.de.GetY()!=(BoN?5:4)))
		{possible=false;message="mauvaise rangée";}
	// Elle doit prendre dans la rangée suivante à gauche ou à droite
	if ( possible&& ((mouv.al.GetY()!=(mouv.de.GetY()+(BoN?1:-1)))||
		((mouv.al.GetX()!=mouv.de.GetX()+1)&&(mouv.al.GetX()!=mouv.de.GetX()-1)) ) )
		{possible=false;message="pas le bon mouvement";}
	// un pion adverse doit occuper la même rangée du côté de la prise
	if (possible)
	{
		iter_liste pad;
		escaque cible(mouv.al.GetX(),mouv.de.GetY());
		pad=cherchepiece(cible);
		if ( (pad==listepieces().end())||(pad->Get_t()!=pion)||((pad->BoN)==BoN) )
		{possible=false;message="pas de pion à manger ici";}
			// Le dernier mouvement du pion adverse doit être de deux cases (a_bouge<0)
			// Le pion adverse doit avoir bougé au tour précédent, pas avant
		if (possible)
		{
			if ((pad->a_bouge>=0)||((-pad->a_bouge)<(BoN?etatjeu().compteur_tours-1:etatjeu().compteur_tours)))
			{possible=false;message="le pion cible n'a pas bougé au tour précédent";}
		}
		if (possible) pioncible=pad;
	}
	message=(possible?"Prise en passant ":message);
	return possible;
}
bool prise_en_passant(bool BoN,mouvement mouv)
{
	iter_liste l;
	std::string mes;
	return prise_en_passant(BoN,mouv,l,mes);
}
//------------------------
// Roque
// Renvoie vrai si le mouvement est un roque valide
// Le mouvement concerne forcément le roi (la tour bouge en conséquence)
bool roque(mouvement mouv,std::string& message,iter_liste& compagne,escaque& destination_compagne)
{
	static int profondeur(0);
	// garde fou contre l'appel recursif de roque par mouv_possibles
	// Pas gênant car en aucun cas un mouvement de roi2 lié à un roque ne pourrait bloquer un roque de roi1
	if (profondeur>1)	return false;
	profondeur++;
	message="Roque";
	bool petit_roque(mouv.al.GetX()>5); // petit roque ou grand roque ?
	message=(petit_roque?"Petit ":"Grand ")+message;	
	bool possible(true);
	// la pièce jouée doit exister et ce doit être un roi
	iter_liste p(cherchepiece(mouv.de));
	if (p==listepieces().end())
		{possible=false;message+=" pièce non trouvée";}
		else 
		if(p->Get_t()!=roi){possible=false;message="";}
	if (possible)
	{	
	// la pièce jouée doit être dans la première ou dernière rangée
		int Yr(p->BoN?1:8);
		possible=(mouv.al.GetY()==Yr)&&(mouv.de.GetY()==Yr);
		if (!possible) message+=" pas la bonne rangée";
	}
	// La tour compagne doit occuper la place attendue
	if (possible)
	{
		if ( petit_roque) compagne=cherchepiece(escaque(8,(p->BoN?1:8)));
		if (!petit_roque) compagne=cherchepiece(escaque(1,(p->BoN?1:8)));
		if (compagne==listepieces().end()||(compagne->Get_t()!=tour)) {possible=false;message+=" compagne non trouvée";}	
	}
	// Les pièces, tour ou roi ne doivent pas avoir été bougées
	if (possible)
	{			
		if (p->a_bouge)
			{possible =false; message+=" le roi a bougé";}	
		if (possible&&(compagne->a_bouge))
			{possible =false; message+=" la tour a bougé";}
	}
	// le mouvement de la pièce est compatible avec un roque
	if (possible)
	{
		possible=(petit_roque?mouv.al.GetX()==7:mouv.al.GetX()==3);
		if (!possible) message+=" illicite";
	}	
	// la rangée doit être libre entre la tour et le roi
	if (possible)
	{
		for (int X=(petit_roque?6:2);X<(petit_roque?8:5);X++) possible=possible&&(caselibre(X,(p->BoN?1:8)));
		if (!possible) message+=" cases occupées entre roi et tour";	
	}
	// Aucune des pièces au départ, à l'arrivée ou sur le trajet du convoi ne doit être menacée
	if (possible)
	{
		typ_listecases menaces;
		menaces=liste_menaces(!p->BoN,false);// menaces avec le roi non masqué
		for (int i=(petit_roque?5:1);i<(petit_roque?9:6);++i)
			for(iter_listecases j=menaces.begin();j<menaces.end();++j)
				if( (j->GetX()==i)&&(j->GetY()==(p->BoN?1:8)) )
					{j=menaces.end();i=(petit_roque?9:6);possible=false;message+=" une case est menacée";}
	}
	if (possible)
	{
		// Destination de la pièce compagne après le roque
		if ( petit_roque) destination_compagne.setX(6);
		if (!petit_roque) destination_compagne.setX(4);	
		destination_compagne.setY(p->pos.GetY());
	}
	profondeur--;
	return possible;
}
//------------------------
bool roque(mouvement mouv)
{
	std::string message("RASroque");	
	iter_liste pcomp;escaque destcomp;	
	return roque(mouv,message,pcomp,destcomp);
}
//------------------------
// renvoie vrai si la couleur BoN a réalisé un roque
bool roque_effectue(bool BoN)
{
	bool resultat( (BoN?etatjeu().B_a_roque>0:etatjeu().N_a_roque)>0 );
	if (resultat&&(etatjeu().tron>3)) std::cout<<" "<<"roque passé"<<" ";
	return resultat;
}
//------------------------
// crée une liste des cases menacées par BoN
// Le roi adverse peut être rendu transparent (nécessaire pour trouver les cases autorisées de son déplacement)
// ombre_roi vrai rend le roi !BoN transparent
typ_listecases liste_menaces(bool BoN,bool ombre_roi)
{
	typ_listecases menaces;
	static int profondeur(0);
	// garde fou contre l'appel recursif par mouv_possibles
	if (profondeur>0)	return menaces;
	profondeur++;
	iter_liste roi_pas_BoN(cherchepiece(roi,!BoN));
	if (ombre_roi&&(roi_pas_BoN!=listepieces().end())) roi_pas_BoN->pris=true;
	for (iter_liste i=listepieces().begin();i<listepieces().end();++i)
		if ( (!i->pris)&&((i->BoN)==(BoN))) menaces=fusionne(menaces,i->mvt_possibles(true));
	if (ombre_roi&&(roi_pas_BoN!=listepieces().end())) roi_pas_BoN->pris=false;	
	profondeur--;						
	return menaces;
}
//------------------------
// renvoie vrai si le roi de couleur BoN est mat
bool roi_est_mat(bool BoN)
{
	static int profondeur(0);
	// garde fou contre l'appel recursif par mouv_possibles
	if (profondeur>0)	return false;
	profondeur++;
	bool est_mat(false);	
	typ_listecases menaces(liste_menaces(!BoN,false));
	iter_liste roiBoN(cherchepiece(roi,BoN));
	if (roiBoN!=listepieces().end())
		for (iter_listecases i=menaces.begin();i<menaces.end();++i)
			if (roiBoN->pos==(*i))
			{
				est_mat=true;
				i=menaces.end();
			}
	profondeur--;
	return est_mat;
}