#include "ProjetdeBaseApp.h"
#include "ProjetdeBase.h"

// La méthode "OnInit()"
bool ProjetdeBaseApp::OnInit()
{
    // On crée un objet "MainFrame"
    MainFrame* frame=new MainFrame();
    Pointe_vers_Frame=frame;
    // On affiche l'objet "MainFrame"
    frame->Show();
    // On indique que l'application peut continuer
    return true;
}
// Surcharge de la fonction FilterEvent appelée en tête de la gestion des évènements
// Intercepte la frappe de la touche échappe, quel que soit l'objet actif au moment de la frappe
int ProjetdeBaseApp::FilterEvent(wxEvent& event)
{
    if ((event.GetEventType() == wxEVT_KEY_DOWN) &&
        (((wxKeyEvent&)event).GetKeyCode() == WXK_ESCAPE))
    {
        Pointe_vers_Frame->OnStop( (wxCommandEvent&)event );
        return true; // l'évènement est considéré comme traité
    }
    return -1; // Business as usual
}

IMPLEMENT_APP(ProjetdeBaseApp);
