#ifndef MAINFRAME_H_INCLUDED
#define MAINFRAME_H_INCLUDED
/*
    Arbregen permet de construire des arbres généalogiques puis de donner une valeur approchée pour les probabilités des différents génotypes.
    Copyright (C) 1997 (version Dos) 2009-2023 Vial Jean-Luc Annecy
    Contact email: vial.frjl@free.fr

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <wx/wx.h>
#include "BoiteAOutils.h"

class Canvas;
class APropos;
class FicheIndividu;
class wxHtmlHelpController;

//---------------------------------------------------------------------------
// Objets propres au programme arbre généalogique
//---------------------------------------------------------------------------
class TErreur_arbregen
{
public:
        wxString texte_erreur;
        TErreur_arbregen();
        explicit TErreur_arbregen(wxString tex_er);
};
const int nb_max_generations=10;
const int effectif_max_generation=20;
enum typmod {TousLesModes,AutosomalRec,AutosomalDom,LieAuSexeRec,LieAuSexeDom};
//---------------------------------------------------------------------------
class Tmodes
{
        std::map<typmod,wxString> liste_noms;
        void ajoute_un_nom(typmod md,wxString nmd);
public:
        int NbMaxMode;
        Tmodes();
        wxString nom(typmod md);
};
class typechange_de_valeur
        {
            public:
            typechange_de_valeur();
            double precision(int index);// précision souhaitée (+/- n en %)
            double n_arbre_valides(int index);// nombre d'arbre valides à calculer en milliers
            bool calcul_en_cours;
            bool affichage_autorise;
            int curseur;
            long int arbres_valides;
            long int total_arbres;

        };
enum Tphenotype {normal,atteint,inconnu};
const wxString nomph[]={wxT("Indemne"),wxT("Atteint"),wxT("Inconnu")};
enum Tsexe {masculin,feminin,embryon};
const wxString nomsex[]={wxT("Mâle"),wxT("Femelle"),wxT("Embryon")};
const wxString nomgen[]={wxT("(+//+)"),wxT("(+//a)"),wxT("(a//a)")};
enum Tgenotype {homo_normal,hetero,homo_atteint};

class Tindividu
{
        public:
        bool externe,marie,existe;
        Tsexe sexe;
        Tphenotype phe;
        Tgenotype gen;
        int proba_hetero,nb_enfant;
        wxPoint position,positionparent;
        long int proba[homo_atteint+1];
        Tindividu();//reporte
        Tindividu(const Tindividu& t);
        bool mere()const;
        bool possible();
        float proba_pourcent(Tgenotype g) const;
        bool genotype_probable(Tgenotype& g);
        Tindividu& operator=(const Tindividu& t);
};
class Tarbre
{
        const int nbmaxg,nbmaxn;
        void decale(const Tindividu& t,int sens);
public:
        Tindividu TableauInd[nb_max_generations][effectif_max_generation];
        Tarbre();
        Tarbre(const Tarbre& t);
        ~Tarbre();
        Tindividu Ind(int g,int n) const;
        void purge_l_arbre();
        void purge_les_probas();
        void supprime(Tindividu t);
        bool ajoute(Tindividu t);
        void ajoute_un_individu(Tsexe sexe,Tphenotype phe,bool ext, bool etat,int g,int n,int pg,int pn);
        int dernier_ind(int g);
        Tindividu racine();
        bool arbre_possible();
        int nb_individus();
        float ecart_entre_deux_arbres(const Tarbre& t);
        void decale_g_individu(const Tindividu& t);
        void decale_d_individu(const Tindividu& t);
        Tindividu epouxde(const Tindividu& t);
        Tindividu enfantde(const Tindividu& t,int n);
        Tindividu enfantde(const Tindividu& t);
        Tindividu parentde(const Tindividu& t);
        void supprime_les_enfants_de(Tindividu t);
        void ajoute_un_epoux(const Tindividu& t);
        void modifie(Tindividu& t);
        void ajoute_des_enfants(Tindividu t,int n);
        void etat_marital(Tindividu t,bool encouple);
        Tarbre& operator=(const Tarbre& t);
};

//---------------------------------------------------------------------------
// Définition de la classe "MainFrame"
class MainFrame : public wxFrame
{
public:
// Le constructeur
MainFrame();
// Le destructeur
~MainFrame();
        bool item_menu_change;
        bool taille_modifiee;
        void Modifie_individu(Tindividu t);

        Tarbre Arbre_en_cours;
        typmod mode_trans_courant;
        typechange_de_valeur echange;

        void OnStop(wxCommandEvent& event);
private:
        wxHtmlHelpController* helpController; // Aide
        wxString NomFichier;
        wxString InitDir;
        wxString DonneesDir;
        wxString DonneesVarDir;
        wxString NomComplet();
        wxString charge_fichier();
        void FileOpen(wxCommandEvent& event);
        void FilesOpen(wxCommandEvent& event);
        void FileSave(wxCommandEvent& event);
        void FileSaveAs(wxCommandEvent& event);
        void OnImprime(wxCommandEvent& event);
        void OnQuit(wxCommandEvent& event);
        void OnDisclaimer(wxCommandEvent& event);
        void OnAbout(wxCommandEvent& event);
        void OnHelp(wxCommandEvent& event);
        void OnNouvelArbre(wxCommandEvent& event);
        void OnCalcule(wxCommandEvent& event);
        void Onfr(wxCommandEvent& event);
        void Onen(wxCommandEvent& event);
        void Ones(wxCommandEvent& event);
        void OnFixeNbEssais(wxCommandEvent& event);
        void OnChangeNbEssais(wxCommandEvent& event);
        void OnChangeNbMaxArbres(wxCommandEvent& event);
        void OnFixeMode(wxCommandEvent& event);
        void OnReglePrecision(wxScrollEvent& event);

        void OnPaint(wxPaintEvent& event);
        void OnValideModifie(wxCommandEvent& event);
        void rafraichit();
        void OnSize(wxSizeEvent& event);

        void arbre_test();

        //Identificateurs(MyFrame)

        static const long id_frame;
        static const long ID_BUTTON1;
        static const long ID_STATICTEXT1;
        static const long idMenuQuit;
        static const long idMenuNouvelArbre;
        static const long idMenuImprime;
        static const long idMenuCalcule;
        static const long idMenuStop;
        static const long idMenuStop_button;
        static const long idMenuStop_esc;
        static const long idMenuDisclaimer;
        static const long idMenuAbout;
        static const long idMenuHelp;
        static const long idMenufr;
        static const long idMenuen;
        static const long idMenues;
        static const long idMenuToolbar1;
        static const long ID_STATUSBAR1;
        static const long ID_DIALOGS_FILES_OPEN;
        static const long ID_DIALOGS_FILE_SAVE;
        static const long ID_DIALOGS_FILE_SAVE_AS;

        static const long idOnPaint;
        //Les différents contrôles

        wxStaticText* TextEchap;
        static const long idTextEchap;
        // Affichage des probas des différents modes
        wxStaticText* TextAutR;
        wxStaticText* TextProbaAR;
        wxStaticText* TextAutD;
        wxStaticText* TextProbaAD;
        wxStaticText* TextSexeR;
        wxStaticText* TextProbaSR;
        wxStaticText* TextSexeD;
        wxStaticText* TextProbaSD;
        //ComboBox Choix Mode
        wxComboBox* ChoixMod;
        static const long idChoixMode;
        // Barre de progression
        wxWindow* CoconValidTotal;
        wxStaticText* TextValidTotal;
        wxGauge* ProgressBar1;
        static const long idProgressBar1;
        // Curseur réglage précision et  nombre maximum d'arbres
        wxStaticText* TextPrecision;
        wxSlider* ReglPrecision;
        static const long idReglPrecision;
        wxSlider* ReglNbMaxArbres;
        static const long idReglNbMaxArbres;
        wxStaticText* TextEchelleG;
        wxStaticText* TextEchelleM;
        wxStaticText* TextEchelleD;
        wxStaticText* TextNomFichier;

        APropos* AProposinst;
        static const long idaproposinst;
        // Fenêtre d'affichage des arbres
        Canvas* Canvas1;
        static const long idCanvas1;
        static const long idFicheIndividuinst;
        FicheIndividu* FicheIndividuinst;
        wxPrintData *g_printData;

        DECLARE_EVENT_TABLE()
};
//---------------------------------------------------------------------------
        // Variable globale retournant un pointeur vers la fenêtre principale
        MainFrame*& firstwin();
#endif // MAINFRAME_H_INCLUDED
