#include "ProjetdeBase.h"
#include "ProjetdeBaseApp.h"
#include "Dessin.h"
#include "FicheIndividu.h"
#include "APropos.h"
#include "Calcule.h"
#include "../Icones/arbregen16.xpm"
#include "../Icones/sortie16.xpm"
#include "../Icones/files16.xpm"
#include "../Icones/save16.xpm"
#include "../Icones/impr16.xpm"
#include "../Icones/go16.xpm"
#include "../Icones/delete16.xpm"
#include "../Icones/fr16.xpm"
#include "../Icones/eng16.xpm"
#include "../Icones/es16.xpm"
#include "../Icones/help16.xpm"

#include <wx/file.h>
#include <wx/filename.h>
#include <wx/stdpaths.h>
#include <wx/splash.h>
#include "wx/fs_zip.h"
#include <wx/html/helpctrl.h>
//---------------------------------------------------------------------------
//Variables utilisées pour tests
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
// Gestion des impressions
//---------------------------------------------------------------------------
// Déclaration du Printout utilisé
class GraphPrintout: public BasePrintout
{
 public:
  GraphPrintout(const wxString title =wxT("My printout"),Canvas* canva=NULL,const wxString* textaff=NULL):BasePrintout(title),ca(canva),taf(textaff) {}
  Canvas* ca;
  const wxString* taf;
  bool OnPrintPage(int page);
  bool HasPage(int page);
  //bool OnBeginDocument(int startPage, int endPage);
  void GetPageInfo(int *minPage, int *maxPage, int *selPageFrom, int *selPageTo);
};
//---------------------------------------------------------------------------
bool GraphPrintout::HasPage(int page)
{   // HasPage n'est pas appelé avant OnPrintPage pour la première page affichée
    // Mais est appelée d'abord pour toutes les autres pages.
    return page==1;
}
//---------------------------------------------------------------------------
void GraphPrintout::GetPageInfo(int *minPage, int *maxPage, int *selPageFrom, int *selPageTo)
{
    (*minPage)=1;
    (*maxPage)=1;
}
//---------------------------------------------------------------------------
bool GraphPrintout::OnPrintPage(int page)
{
    wxDC *dc = GetDC();
    if (dc)
    {
        FixeFontEtTaille();
        //MapScreenSizeToPage();
        wxSize taille_texte=dc->GetTextExtent(wxT("Q"));
        Tindividu rac(ca->Arbre_en_cours->racine());
        wxChar buf[200];
        wxSprintf(buf, *taf);
        dc->DrawText(buf, 0, dc->GetSize().GetHeight()-taille_texte.GetHeight());
        ca->dessine_arbre(rac,*dc);
        return true;
    }
    else
        return false;
}
//---------------------------------------------------------------------------
//      Fin Objet Print out pour l'impression
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
//      Implémentation de l'objet TErreur_arbregen
//---------------------------------------------------------------------------
        // type "lancé" en cas d'erreur
        TErreur_arbregen::TErreur_arbregen():texte_erreur(wxT("Erreur")){}
        TErreur_arbregen::TErreur_arbregen(wxString tex_er):texte_erreur(tex_er){}
//---------------------------------------------------------------------------
//      Fin TErreur_arbregen
//---------------------------------------------------------------------------
//Classes retournant les variables globales
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
MainFrame*& firstwin()
{
    static MainFrame* fen=0;
    return fen;
}
//---------------------------------------------------------------------------
typechange_de_valeur::typechange_de_valeur():calcul_en_cours(false),affichage_autorise(true),curseur(0),arbres_valides(0),total_arbres(0)
{
    total_arbres=0;
}
double typechange_de_valeur::precision(int index)
{static double vp[]={10 ,  7,  5,  4,  3, 2, 1,0.5,0.4,0.2, 0.1};// précision souhaitée (+/- n en %)
return vp[index];
}
double typechange_de_valeur::n_arbre_valides(int index)
{static double vn[]={0.4,0.8,1.6,2.5,4.4,10,40,160,250,1000,4000};// nombre d'arbre valides à calculer en milliers
return vn[index];
}
//---------------------------------------------------------------------------
//      Initialisation de la classe Tmodes
//---------------------------------------------------------------------------
        void Tmodes::ajoute_un_nom(typmod md,wxString nmd)
{
        liste_noms.insert(std::make_pair(md,nmd));
}
//---------------------------------------------------------------------------
        Tmodes::Tmodes()
{
        NbMaxMode=int(LieAuSexeDom);
        ajoute_un_nom(TousLesModes,wxT("Tous les Modes"));
        ajoute_un_nom(AutosomalRec,wxT("Autosomal Récessif"));
        ajoute_un_nom(AutosomalDom,wxT("Autosomal Dominant"));
        ajoute_un_nom(LieAuSexeRec,wxT("Lié au sexe Récessif"));
        ajoute_un_nom(LieAuSexeDom,wxT("Lié Au sexe Dominant"));
}
//---------------------------------------------------------------------------
        wxString Tmodes::nom(typmod md)
{
        return liste_noms[md];
}
//---------------------------------------------------------------------------
// fonctions globales
//---------------------------------------------------------------------------
Tsexe sexe_oppose(const Tindividu& t)
{
        Tsexe s=feminin;
        if (t.sexe==feminin) s=masculin;
        return(s);
}
//---------------------------------------------------------------------------
// Implémentation de l'objet Tindividu
//---------------------------------------------------------------------------
Tindividu::Tindividu()
        {externe=true;
        marie=false;
        existe=false;
        phe = inconnu;
        sexe = embryon;
        gen=homo_normal;
        position=wxPoint(0,0);
        positionparent=wxPoint(0,0);
        proba_hetero=50;
        nb_enfant=0;
        proba[homo_normal]=0;
        proba[hetero]=0;
        proba[homo_atteint]=0;
        }
//---------------------------------------------------------------------------
Tindividu::Tindividu(const Tindividu& t)
    {
        *this=t;
    }
//---------------------------------------------------------------------------
bool Tindividu::mere() const
         {
         return ((position.x+position.y)==0);
         }
//---------------------------------------------------------------------------
float Tindividu::proba_pourcent(Tgenotype g) const
        {
        Tgenotype gr;
        long int total=0;
        for (gr=homo_normal;gr<=homo_atteint;gr=suivant(gr))
                total+=proba[gr];
        return proba[g]/(total+0.01)*100;
        }
//---------------------------------------------------------------------------
// Retourne vrai si un des génotypes est presque certain
bool Tindividu::genotype_probable(Tgenotype& g)
        {
        for (g=homo_normal;g<=homo_atteint;g=suivant(g))
                if (proba_pourcent(g)>99) return true;
        return false;
        }
//---------------------------------------------------------------------------
// L'individu existe et au moins un génotype a une probabilité non nulle
bool Tindividu::possible()
        {if (!existe)return false;
        for (Tgenotype i=homo_normal;i<=homo_atteint;i=suivant(i))
                if(proba[i]>0) return true;
        return false ;
        }
//---------------------------------------------------------------------------
Tindividu& Tindividu::operator=(const Tindividu& t)
{
        if (this!= &t)
        {
            externe=t.externe;
            marie=t.marie;
            existe=t.existe;
            phe = t.phe;
            sexe = t.sexe;
            gen = t.gen;
            position=t.position;
            positionparent=t.positionparent;
            proba_hetero=t.proba_hetero;
            nb_enfant=t.nb_enfant;
            proba[homo_normal]=t.proba[homo_normal];
            proba[hetero]=t.proba[hetero];
            proba[homo_atteint]=t.proba[homo_atteint];
        }
        return *this;
}
//---------------------------------------------------------------------------
// Implémentation de l'objet arbre
//---------------------------------------------------------------------------
// L'arbre contient nbmaxg générations (de 0 à nbmaxg-1) de nbmaxn individus (de 0 à nbmaxn-1)
//---------------------------------------------------------------------------
//Constructeur par défaut
Tarbre::Tarbre():nbmaxg(nb_max_generations),nbmaxn(effectif_max_generation)
{
}
//---------------------------------------------------------------------------
//Constructeur de copie
Tarbre::Tarbre(const Tarbre& t):nbmaxg(nb_max_generations),nbmaxn(effectif_max_generation)
{
        *this=t;
}
//---------------------------------------------------------------------------
Tarbre::~Tarbre()
{
}
//---------------------------------------------------------------------------
// Renvoie une copie de l'individu TableauInd[g][n]
Tindividu Tarbre::Ind(int g,int n) const
        {return TableauInd[g][n];
        }
//---------------------------------------------------------------------------
// Décale un individu d'une position vers la gauche (sens=0) ou vers la droite (sens=1)
void Tarbre::decale(const Tindividu& t,int sens)
{
      if (t.existe)
        {
        int g=t.position.x, n=t.position.y;
        Tindividu* enfant;
        for (int i=0;i!=nbmaxn;++i)
                {enfant=&TableauInd[g+1][i];
                if (enfant->positionparent==t.position)
                        {enfant->positionparent.y+= sens*2-1;}
                }
        TableauInd[g][n+sens]= Ind(g,n+1-sens);
        TableauInd[g][n+sens].position.y+=sens*2-1;
        }
}
//---------------------------------------------------------------------------
// Décale toute la génération à droite de t d'une case vers la gauche
// écrase t par son voisin de droite
void Tarbre::decale_g_individu(const Tindividu& t)
{
        decale(t,0);
}
//---------------------------------------------------------------------------
// Décale toute la génération à partir de t compris d'une case à droite
// Crée une emplacement libre à gauche de t
void Tarbre::decale_d_individu(const Tindividu& t)
{
        decale(t,1);
}
//---------------------------------------------------------------------------
void Tarbre::purge_l_arbre()
        {Tindividu vide;
        for (int i=0;i<nbmaxg;++i)
                for (int j=0;j<nbmaxn;++j)
                 TableauInd[i][j]=vide;
        }
//---------------------------------------------------------------------------
void Tarbre::purge_les_probas()
        {
        for (int i=0;i<nbmaxg;++i)
                for (int j=0;j<nbmaxn;++j)
                        for (Tgenotype k=homo_normal;k<=homo_atteint;k=suivant(k))
                                TableauInd[i][j].proba[k]=0;
        }
//---------------------------------------------------------------------------
Tindividu Tarbre::parentde(const Tindividu& t)
        {
        return Ind(t.positionparent.x,t.positionparent.y);
        }
//---------------------------------------------------------------------------
Tindividu Tarbre::epouxde(const Tindividu& t)
{
        int prvg=t.position.x;
        int prvn=t.position.y;
        if (t.externe)  return(Ind(prvg,prvn-1));
                else    return(Ind(prvg,prvn+1));
}
//---------------------------------------------------------------------------
// Retourne le nème enfant de l'individu t
// Renvoie une exception si aucun n'enfant n'est trouvé.
// Ne devrait pas arriver car le contrôle doit être fait en amont
Tindividu Tarbre::enfantde(const Tindividu& t,int n)
{
        TErreur_arbregen erreur(wxT("Enfant non trouvé"));
        int j=0;
        bool enfant_existe(false);
        Tindividu enfant,trouve;
        for (int i=0;i<nbmaxn;i++)
            {enfant=Ind(t.position.x+1,i);
            if ((enfant.positionparent==t.position)&&(!enfant.externe))
                    ++j;
            if (j==n){enfant_existe=true;trouve=enfant;i=nbmaxn;} // enfant trouvé sortie de boucle
            }
        if (!enfant_existe) throw erreur;
        return(trouve);
}
//---------------------------------------------------------------------------
// Retourne le premier enfant de l'individu t
Tindividu Tarbre::enfantde(const Tindividu& t)
{
        return(enfantde(t,1));
}
//---------------------------------------------------------------------------
void Tarbre::supprime_les_enfants_de(Tindividu t)
{
        while (t.nb_enfant>0)
                {supprime(enfantde(t));
                 --t.nb_enfant;
                }
}
//---------------------------------------------------------------------------
//Supprime l'individu t, son conjoint éventuel et, de façon récursive, toute sa descendance
void Tarbre::supprime(Tindividu t)
{
    try
    {
        if (t.marie)
        {  if (t.externe)
                        {supprime_les_enfants_de(epouxde(t));
                         etat_marital(epouxde(t),false);
                         }
                else
                        {supprime_les_enfants_de(t);
                        supprime(epouxde(t));
                        }
        }
        if (!t.externe)
                --TableauInd[t.positionparent.x][t.positionparent.y].nb_enfant;
        for(int i=t.position.y;i!=nbmaxn-1;i++)
                decale_g_individu(Ind(t.position.x,i));
      }
    catch (TErreur_arbregen& err)
    {
        wxMessageBox(err.texte_erreur);
    }
}
//---------------------------------------------------------------------------
// Retourne l'indice du dernier individu valide de la génération g
int Tarbre::dernier_ind(int g)
{
        int dernier=0;
        for (int i=0;i!=nbmaxn;++i)
             if (Ind(g,i).existe) dernier=i;
        return (dernier);
}
//---------------------------------------------------------------------------
// Retourne le premier individu (normalement la "mère", quoiqu'on puisse se débrouiller pour que ce soit un père !)
Tindividu Tarbre:: racine()
        {return(TableauInd[0][0]);
        }
//---------------------------------------------------------------------------
// si un des individus a été conservé comme possible, tous le sont
bool Tarbre::arbre_possible()
        {
         return Ind(0,0).possible();
        }
//---------------------------------------------------------------------------
int Tarbre::nb_individus()
        {int nombre=0;
        for (int i=0;i<nbmaxg;++i)
                for (int j=0;j<nbmaxn;++j)
                        if (Ind(i,j).existe) ++nombre;
        return nombre;
        }
//---------------------------------------------------------------------------
float Tarbre::ecart_entre_deux_arbres(const Tarbre& t)
        {float total=0;
                for (int i=0;i<nbmaxg;++i)
                        for (int j=0;j<nbmaxn;++j)
                         if (Ind(i,j).possible())
                          for (Tgenotype k=homo_normal;k<=homo_atteint;k=suivant(k))
                           {
                           float carre=(Ind(i,j).proba_pourcent(k)-t.Ind(i,j).proba_pourcent(k));
                           carre*=carre;
                           total+=carre;
                           }
        return sqrt(total/(nb_individus()+0.001))*100;
        }
//---------------------------------------------------------------------------
// fait une place à t dans sa génération
// Incrémente le nombre d'enfant du parent sauf si on ajoute un individu externe ou la mère
// Retourne vrai si l'ajout est réussi
bool Tarbre::ajoute(Tindividu t)
        {bool possible=false;
        if (dernier_ind(t.position.x)<nbmaxn)
                {
                for (int i=nbmaxn-1;i>=t.position.y;--i)
                        decale_d_individu(Ind(t.position.x,i));
                TableauInd[t.position.x][t.position.y]=t;
                int gpar=t.positionparent.x; int npar=t.positionparent.y;
                if ((t.position.x!=0)&&(!t.externe)) ++TableauInd[gpar][npar].nb_enfant;
                possible=true;
                }
        return(possible);
        }
//---------------------------------------------------------------------------
// Ajoute n enfants à l'individu t
void Tarbre::ajoute_des_enfants(Tindividu t,int n)
{ for (;n>0;--n) // n n'a pas besoin d'être initialisé dans la boucle
        {Tindividu enfant,t1,t2;
        enfant.existe=true;
        enfant.externe=false;
        enfant.positionparent=t.position;
        enfant.position.x=t.position.x+1;
        enfant.position.y=0;
        ++t.nb_enfant;
        if (t.nb_enfant>1) // Cherche la position de la place libre à côté de l'enfant précédent du même couple
                {t1=enfantde(t,t.nb_enfant-1);
                enfant.position.y=t1.position.y+1+int(t1.marie);
                }
        if (t.nb_enfant==1)  // Cherche la place libre à côté du dernier enfant du couple précédent dans cette génération
               {
                int poslibre=-1;
                // en sortie de boucle poslibre contiendra l'indice du dernier enfant d'un parent à gauche de t
                // ou -1 si les parents à gauche de t n'ont aucun enfant
                for (int i=0;i<nbmaxn;++i)
                    {
                        t1=Ind(t.position.x+1,i);
                        if (t1.existe&&(t1.positionparent.y<t.position.y)) poslibre=i;
                    }
                if (poslibre>-1)
                    {
                    t2=Ind(t.position.x+1,poslibre);
                    enfant.position.y=t2.position.y+int(t2.marie)+1;
                    }
               }
        // Si t est le premier enfant ou si ses ainés n'ont pas d'enfant, enfant.position.y reste à 0
        ajoute(enfant);
        }
}
//---------------------------------------------------------------------------
void Tarbre::ajoute_un_epoux(const Tindividu& t)
{
        Tindividu epoux;
        epoux.existe=true;
        epoux.externe=true;
        epoux.marie=true;
        epoux.sexe=sexe_oppose(t);
        epoux.position=t.position;
        ++epoux.position.y;
        ajoute(epoux);
}
//---------------------------------------------------------------------------
void Tarbre::modifie(Tindividu& t)
        {Tindividu tanc=Ind(t.position.x,t.position.y);
        if (!t.existe)
                {// Ne tient pas compte des modifications autres que la suppression
                supprime(tanc);}
                // Si t n'est pas supprimé
        else {
                if (tanc.marie!=t.marie)
                // Changement d'état matrimonial
                    {
                    if (t.marie) {ajoute_un_epoux(t);} // crée le couple
                                 else
                                    {// supprime le couple et sa descendance
                                    t.marie=true;
                                    supprime(t);
                                    t.nb_enfant=0;
                                    // rajoute le même individu mais célibataire
                                    t.marie=false;
                                    ajoute(t);
                                    }
                    }
              // Ajoute les enfants si le nombre a augmenté
              // Chaque enfant ne peut être supprimé qu'individuellement
              int n=t.nb_enfant-tanc.nb_enfant;
              if (n>0) ajoute_des_enfants(tanc,n);
              TableauInd[t.position.x][t.position.y]=t;
              }
        }
//---------------------------------------------------------------------------
// Fixe l'état marital de l'individu t
void Tarbre::etat_marital(Tindividu t,bool encouple)
{
        TableauInd[t.position.x][t.position.y].marie=encouple;
}
//---------------------------------------------------------------------------
// Ajout explicite d'un individu à l'arbre
void Tarbre::ajoute_un_individu(Tsexe sexe,Tphenotype phe,bool ext, bool etat,int g,int n,int pg,int pn)
{       Tindividu t;
        t.sexe=sexe;
        t.phe=phe;
        t.externe=ext;
        t.existe=true;
        t.marie=etat;
        t.position.x=g;
        t.position.y=n;
        t.positionparent.x=pg;
        t.positionparent.y=pn;
        ajoute(t);
}
//---------------------------------------------------------------------------
Tarbre& Tarbre::operator=(const Tarbre& t)
{
        if (this!= &t)
            for (int g=0;g<nbmaxg;++g)
                    for (int n=0;n<nbmaxn;++n)
                            TableauInd[g][n]=t.TableauInd[g][n];
        return *this;
}
//---------------------------------------------------------------------------
// Fenêtre principale
//---------------------------------------------------------------------------

const long MainFrame::id_frame = wxNewId();
const long MainFrame::idMenuQuit = wxNewId();
const long MainFrame::idMenuNouvelArbre = wxNewId();
const long MainFrame::idMenuImprime = wxNewId();
const long MainFrame::idMenuCalcule = wxNewId();
const long MainFrame::idMenuStop = wxNewId();
const long MainFrame::idMenuDisclaimer = wxNewId();
const long MainFrame::idMenuAbout = wxNewId();
const long MainFrame::idMenuHelp = wxNewId();
const long MainFrame::idMenufr = wxNewId();
const long MainFrame::idMenuen = wxNewId();
const long MainFrame::idMenues = wxNewId();
const long MainFrame::idMenuToolbar1 = wxNewId();
const long MainFrame::ID_STATUSBAR1 = wxNewId();
const long MainFrame::ID_DIALOGS_FILES_OPEN = wxNewId();
const long MainFrame::ID_DIALOGS_FILE_SAVE = wxNewId();
const long MainFrame::ID_DIALOGS_FILE_SAVE_AS = wxNewId();
const long MainFrame::idOnPaint = wxNewId();
const long MainFrame::idaproposinst = wxNewId();
const long MainFrame::idFicheIndividuinst= wxNewId();

// identifiants des contrôles
const long MainFrame::idChoixMode = wxNewId();
const long MainFrame::idProgressBar1= wxNewId();
const long MainFrame::idReglPrecision= wxNewId();
const long MainFrame::idReglNbMaxArbres= wxNewId();
const long MainFrame::idCanvas1= wxNewId();

BEGIN_EVENT_TABLE(MainFrame, wxFrame)
    EVT_PAINT(MainFrame::OnPaint)
    EVT_SIZE(MainFrame::OnSize)
    EVT_MENU(idMenuQuit, MainFrame::OnQuit)
    EVT_MENU(ID_DIALOGS_FILES_OPEN, MainFrame::FileOpen)
    EVT_MENU(ID_DIALOGS_FILE_SAVE, MainFrame::FileSave)
    EVT_MENU(ID_DIALOGS_FILE_SAVE_AS, MainFrame::FileSaveAs)
    EVT_MENU(idMenuImprime, MainFrame::OnImprime)
    EVT_MENU(idMenuDisclaimer, MainFrame::OnDisclaimer)
    EVT_MENU(idMenuAbout, MainFrame::OnAbout)
    EVT_MENU(idMenuHelp, MainFrame::OnHelp)
    EVT_MENU(idMenuNouvelArbre, MainFrame::OnNouvelArbre)
    EVT_MENU(idMenuCalcule,MainFrame::OnCalcule)
    EVT_MENU(idMenuStop,MainFrame::OnStop)
    EVT_MENU(idMenufr,MainFrame::Onfr)
    EVT_MENU(idMenuen,MainFrame::Onen)
    EVT_MENU(idMenues,MainFrame::Ones)
    EVT_COMMAND_SCROLL(idReglPrecision,MainFrame::OnReglePrecision)
    EVT_COMBOBOX (idChoixMode,MainFrame::OnFixeMode)
    EVT_COMMAND  (wxID_ANY, wxEVT_COMMAND_BUTTON_CLICKED, MainFrame::OnValideModifie)
END_EVENT_TABLE()
//---------------------------------------------------------------------------
// Le constructeur
MainFrame::MainFrame() : wxFrame(NULL,id_frame,wxT("Interprétation d'arbres généalogiques"),wxPoint(800,100),wxSize(100,100),wxDEFAULT_FRAME_STYLE|wxFULL_REPAINT_ON_RESIZE)
                        ,item_menu_change(true)
                        ,taille_modifiee(true)
{
    firstwin()=this;
    Calculs::initcalcule();
    Traducteur tr;
    tr.langue_demarrage();
    SetBackgroundColour(Couleur_Fenetres_defaut());
    // Calcule la taille de départ de la fenêtre
    SetSize(Taille_Fenetres_defaut());
    // Calcule la taille minimale de la fenêtre (ne marche pas avec Wine)
    SetSizeHints(200,200,-1,-1,-1,-1);
    FixeFontEtTaille(this);
    SetIcon(arbregen16_xpm);

    AProposinst=new APropos(this,idaproposinst);
    FicheIndividuinst=new FicheIndividu(this,idFicheIndividuinst,wxSize(300,450));
    mode_trans_courant=AutosomalRec;
    // Fenêtre d'affichage des arbres
    Canvas1= new Canvas(this,idCanvas1,FicheIndividuinst,Arbre_en_cours,mode_trans_courant);
    // Initialisation des chemins

      //wxStandardPaths Chemins; // wxStandardPaths est protected dans wxWidgets 3 donc pas instanciable
#if defined(__WXMSW__)
    InitDir=wxStandardPaths::Get().GetDataDir();
    DonneesDir=InitDir;
    DonneesVarDir=DonneesDir;
#elif defined(__UNIX__)
    //Chemins.SetInstallPrefix(wxT("/usr/bin"));
    //InitDir=Chemins.GetInstallPrefix();
    InitDir=wxT("/usr/bin");
    DonneesDir=wxT("/usr/share/arbregen"); // Le répertoire usr peut-être en lecture seule
    DonneesVarDir=wxT("/var/lib/arbregen");// d'où la nécessité d'un répertoire dans var pour les données modifiables
#endif
    // Aide
    wxImage::AddHandler(new wxPNGHandler());
    wxFileSystem::AddHandler(new wxZipFSHandler);
    helpController = new wxHtmlHelpController(wxHF_DEFAULT_STYLE,this);
    helpController->Initialize(DonneesDir+wxT("/")+wxT("arbregenfrahlp.zip"));
    helpController->AddBook(wxFileName(DonneesDir+wxT("/")+wxT("arbregenenghlp.zip")));
    helpController->AddBook(wxFileName(DonneesDir+wxT("/")+wxT("arbregenesphlp.zip")));
    NomFichier=wxT("default.arbre");
    // Charge l'arbre par défaut
    if (charge_fichier()!=wxT(""))
    {
        wxCommandEvent ev;
        OnNouvelArbre(ev);
        FileSave(ev);
    }
    // Mise en place des menus
    wxMenuItem* MenuItem1;
    wxMenuItem* MenuItem2;
    wxMenuItem* MenuItem3;
    wxMenuItem* MenuItem4;
    wxMenuItem* MenuItem5;
    wxMenuItem* MenuItem6;
    wxMenuItem* MenuItem7;
    wxMenuItem* MenuItem8;
    wxMenuItem* MenuItem9;
    wxMenuItem* MenuItem10;
    wxMenuItem* MenuItem11;
    wxMenuItem* MenuItem12;
    wxMenuItem* MenuItem13;
    wxMenuItem* MenuItem14;
    wxMenu* Menu1;
    wxMenu* Menu2;
    wxMenu* Menu3;
    wxMenuBar* MenuBar1;
    MenuBar1 = new wxMenuBar();
    Menu1 = new wxMenu();
        MenuItem1 = new wxMenuItem(Menu1, idMenuNouvelArbre, wxT("Nouvel arbre"), wxT("Nouvel arbre"), wxITEM_NORMAL);
        Menu1->Append(MenuItem1);
        MenuItem2 = new wxMenuItem(Menu1, ID_DIALOGS_FILES_OPEN, wxT("&Ouvrir"), wxT("Charge un fichier"), wxITEM_NORMAL);
        Menu1->Append(MenuItem2);
        MenuItem3 = new wxMenuItem(Menu1, ID_DIALOGS_FILE_SAVE, wxT("&Enregistrer"), wxT("Sauve le fichier en cours"), wxITEM_NORMAL);
        Menu1->Append(MenuItem3);
        MenuItem4 = new wxMenuItem(Menu1,ID_DIALOGS_FILE_SAVE_AS, wxT("Enregistrer &sous..."), wxT("Sauv sous un nouveau nom"), wxITEM_NORMAL);
        Menu1->Append(MenuItem4);
        MenuItem5 = new wxMenuItem(Menu1, idMenuImprime, wxT("Impression"), wxT("Imprime le diagramme"), wxITEM_NORMAL);
        Menu1->Append(MenuItem5);
        Menu1->AppendSeparator();
        MenuItem6 = new wxMenuItem(Menu1, idMenuCalcule, wxT("Lance un calcul"), wxT("Lance un calcul"), wxITEM_RADIO);
        Menu1->Append(MenuItem6);
        MenuItem7 = new wxMenuItem(Menu1, idMenuStop, wxT("Arrêt"), wxT("Arrêt"), wxITEM_RADIO);
        Menu1->Append(MenuItem7);
        Menu1->AppendSeparator();
        MenuItem8 = new wxMenuItem(Menu1, idMenuQuit, wxT("Quit\tAlt-F4"), wxT("Quit the application"), wxITEM_NORMAL);
        Menu1->Append(MenuItem8);
        MenuBar1->Append(Menu1, wxT("Fichiers"));
    Menu2 = new wxMenu();
        MenuItem9 = new wxMenuItem(Menu2, idMenufr, wxT("Français"), wxT("Version Française"), wxITEM_CHECK );
        Menu2->Append(MenuItem9);
        MenuItem10 = new wxMenuItem(Menu2, idMenuen, wxT("English"), wxT("English version"), wxITEM_CHECK );
        Menu2->Append(MenuItem10);
        MenuItem11 = new wxMenuItem(Menu2, idMenues, wxT("Castellano"), wxT("Versión Castellana"), wxITEM_CHECK );
        Menu2->Append(MenuItem11);
        MenuBar1->Append(Menu2, wxT("Langue"));
    Menu3 = new wxMenu();
        MenuItem12 = new wxMenuItem(Menu3, idMenuDisclaimer, wxT("Avertissement"), wxT("Avertissement"), wxITEM_NORMAL);
        Menu3->Append(MenuItem12);
        MenuItem13 = new wxMenuItem(Menu3, idMenuAbout, wxT("About\tF1"), wxT("Show info about this application"), wxITEM_NORMAL);
        Menu3->Append(MenuItem13);
        MenuItem14 = new wxMenuItem(Menu3, idMenuHelp, wxT("Aide"), wxT("Aide sur Arbregen"), wxITEM_NORMAL);
        Menu3->Append(MenuItem14);
        MenuBar1->Append(Menu3, wxT("Aide"));

    SetMenuBar(MenuBar1);
    // Barre d'outils
    wxToolBar* Toolbar1;
    Toolbar1= CreateToolBar(wxNO_BORDER | wxTB_HORIZONTAL,idMenuToolbar1);
    wxImage::AddHandler(new wxXPMHandler());
    wxBitmap* toolBarBitmaps[9];
    toolBarBitmaps[0]=new wxBitmap(files16_xpm);
    toolBarBitmaps[1]=new wxBitmap(save16_xpm);
    toolBarBitmaps[2]=new wxBitmap(impr16_xpm);
    toolBarBitmaps[3]=new wxBitmap(delete16_xpm);
    toolBarBitmaps[4]=new wxBitmap(go16_xpm);
    toolBarBitmaps[5]=new wxBitmap(fr16_xpm);
    toolBarBitmaps[6]=new wxBitmap(eng16_xpm);
    toolBarBitmaps[7]=new wxBitmap(es16_xpm);
    toolBarBitmaps[8]=new wxBitmap(help16_xpm);
    toolBarBitmaps[9]=new wxBitmap(sortie16_xpm);

    Toolbar1->SetToolBitmapSize(wxSize(toolBarBitmaps[0]->GetWidth(),toolBarBitmaps[0]->GetHeight()));
    Toolbar1->AddTool(ID_DIALOGS_FILES_OPEN ,wxT("Ouvrir")        ,*(toolBarBitmaps[0]),wxT("Fichiers"),wxITEM_NORMAL);
    Toolbar1->AddTool(ID_DIALOGS_FILE_SAVE ,wxT("&Enregistrer")        ,*(toolBarBitmaps[1]),wxT("Enregistrer l'arbre en cours"),wxITEM_NORMAL);
    Toolbar1->AddTool(idMenuImprime          ,wxT("Imprime")     ,*(toolBarBitmaps[2]),wxT("Imprime l'arbre")                ,wxITEM_NORMAL);

    Toolbar1->AddSeparator();
    Toolbar1->AddTool(idMenuStop            ,wxT("Arrêt")          ,*(toolBarBitmaps[3]),wxT("Arrêt"),wxITEM_RADIO);
    Toolbar1->AddTool(idMenuCalcule          ,wxT("Lance un calcul") ,*(toolBarBitmaps[4]),wxT("Lance un calcul"),wxITEM_RADIO);

    Toolbar1->AddSeparator();
    Toolbar1->AddTool(idMenufr              ,wxT("Français")        ,*(toolBarBitmaps[5]),wxT("Français"),wxITEM_RADIO);
    Toolbar1->AddTool(idMenuen              ,wxT("English")         ,*(toolBarBitmaps[6]),wxT("English"),wxITEM_RADIO);
    Toolbar1->AddTool(idMenues              ,wxT("español")         ,*(toolBarBitmaps[7]),wxT("español")                    ,wxITEM_RADIO);
    Toolbar1->AddSeparator();
    Toolbar1->AddTool(idMenuHelp            ,wxT("Aide")         ,*(toolBarBitmaps[8]),wxT("Aide"),wxITEM_NORMAL);
    Toolbar1->AddSeparator();
    Toolbar1->AddTool(idMenuQuit            ,wxT("Quitter")         ,*(toolBarBitmaps[9]),wxT("Sortie"),wxITEM_NORMAL);
    Toolbar1->Realize();
    SetToolBar(Toolbar1);

    // Insertion des contrôles
    wxPoint pos(100,100);
    wxSize taille(100,20);

    TextNomFichier= new wxStaticText(this,wxID_ANY,wxT("Nom fichier"),pos);
    TextEchap= new wxStaticText(this,wxID_ANY,wxT("Echap pour interrompre"),pos);
    // Affichage des probas des différents modes
    Tmodes tm;
    TextAutR= new wxStaticText(this,wxID_ANY,tm.nom(AutosomalRec),pos);
    TextProbaAR= new wxStaticText(this,wxID_ANY,wxT("00,00"),pos);

    TextAutD= new wxStaticText(this,wxID_ANY,tm.nom(AutosomalDom),pos);
    TextProbaAD= new wxStaticText(this,wxID_ANY,wxT("00,00"),pos);

    TextSexeR= new wxStaticText(this,wxID_ANY,tm.nom(LieAuSexeRec),pos);
    TextProbaSR= new wxStaticText(this,wxID_ANY,wxT("00,00"),pos);

    TextSexeD= new wxStaticText(this,wxID_ANY,tm.nom(LieAuSexeDom),pos);
    TextProbaSD= new wxStaticText(this,wxID_ANY,wxT("00,00"),pos);

    //ComboBox Choix Mode
    taille=wxSize(10,20);
    wxString Choix[LieAuSexeDom+1];
    for (typmod i=TousLesModes;i<=LieAuSexeDom;i=suivant(i))
        Choix[i]=tm.nom(i);
    ChoixMod= new wxComboBox(this,idChoixMode,wxT(""),pos,taille,int(LieAuSexeDom+1),Choix,wxCB_READONLY,wxDefaultValidator,wxT("comboBox"));
    // Barre de progression
    ProgressBar1=new wxGauge(this,idProgressBar1,100,pos,taille,wxGA_HORIZONTAL);
    // Curseur réglage précision et  nombre maximum d'arbres
    ReglPrecision= new wxSlider(this,idReglPrecision,3,0,10,pos,taille,wxSL_AUTOTICKS|wxSL_HORIZONTAL);
    ReglPrecision->SetToolTip(wxT("Précision"));
    ReglNbMaxArbres= new wxSlider(this,idReglNbMaxArbres,1,0,3,pos,taille,wxSL_AUTOTICKS|wxSL_HORIZONTAL);
    ReglNbMaxArbres->SetToolTip(wxT("Nombre maximum d'arbres examinés"));
    taille=wxSize(10,40);
    pos=wxPoint(15,25);
    // Encapsulage de l'affichage TextValid total dans un wxWindow nécessaire sous Linux, sinon, le calcul fige lors du passage de Yield(). Je ne vois as bien pourquoi
    // Sous Window, pas de problème même si le wxStatixText est posé directement dans MainFrame et mis à jour en cours de calcul
    // Si on enlève Yield les évènements 'Button" ne sont plus traités en cours de calcul
    CoconValidTotal= new wxWindow(this,wxID_ANY,pos,wxSize(100,100),wxDEFAULT_FRAME_STYLE|wxFULL_REPAINT_ON_RESIZE);
    CoconValidTotal->SetBackgroundColour(Couleur_Fenetres_defaut());
    TextValidTotal= new wxStaticText(CoconValidTotal,wxID_ANY,wxT("Non déterminé"),wxPoint(0,0),wxSize(300,50),wxST_NO_AUTORESIZE);
    TextPrecision= new wxStaticText(this,wxID_ANY,wxT("Non déterminé"),pos,taille);

    TextEchelleG= new wxStaticText(this,wxID_ANY,wxT("10E5"),pos,taille);
    TextEchelleM= new wxStaticText(this,wxID_ANY,wxT("Max arbres"),pos,taille);
    TextEchelleD= new wxStaticText(this,wxID_ANY,wxT("10E8"),pos,taille);

    g_printData =new wxPrintData;
    g_printData->SetPaperId(wxPAPER_A4);
}
//---------------------------------------------------------------------------
// Le Destructeur
MainFrame::~MainFrame()
{
    delete g_printData;
    DestroyChildren();
    Destroy();
}
//---------------------------------------------------------------------------
wxString MainFrame::NomComplet()
{
    return DonneesVarDir+wxT("/")+NomFichier;
}
//---------------------------------------------------------------------------
void MainFrame::OnImprime(wxCommandEvent& event)
{
    Traducteur tr;
    wxPrintDialogData g_printDialogData(*g_printData);
    g_printDialogData.EnablePageNumbers(true);
    g_printDialogData.SetMaxPage(3);
    wxPrintPreview *preview = new wxPrintPreview(new GraphPrintout(tr.trad(wxT("Prévisualisation")),Canvas1,&NomFichier), new GraphPrintout(tr.trad(wxT("Impression")),Canvas1,&NomFichier),& g_printDialogData);
    if (!preview->Ok())
    {
        delete preview;
        wxMessageBox(_T("There was a problem previewing.\nPerhaps your current printer is not set correctly?"), _T("Previewing"), wxOK);
        return;
    }
    wxPreviewFrame *frame = new wxPreviewFrame(preview, this, tr.trad(wxT("Aliments")), wxPoint(100, 100), wxSize(600, 650));
    frame->Centre(wxBOTH);
    frame->Initialize();
    frame->Show();
}
//---------------------------------------------------------------------------
// Met à jour l'arbre en cours en cas de modification d'un individu.
// La mise à jour de l'affichage de l'arbre sera assurée au prochain rafraîchissement de la fiche
void MainFrame::Modifie_individu(Tindividu t)
{
         Arbre_en_cours.modifie(t);
}
//---------------------------------------------------------------------------
void MainFrame::OnQuit(wxCommandEvent& event)
{
    Close();
}
//---------------------------------------------------------------------------
void MainFrame::OnDisclaimer(wxCommandEvent& event)
{
    Traducteur tr;
    wxBitmap bitmap;
    wxImage::AddHandler(new wxPNGHandler());
    if (bitmap.LoadFile(DonneesDir+wxT("/")+tr.trad(wxT("DisclaimimageFra.png")), wxBITMAP_TYPE_PNG))
    {
        wxSplashScreen* splash __attribute__ ((unused));
        splash = new wxSplashScreen(bitmap,
          wxSPLASH_CENTRE_ON_SCREEN|wxSPLASH_TIMEOUT,
          6000, NULL, -1, wxDefaultPosition, wxDefaultSize,
          wxSIMPLE_BORDER|wxSTAY_ON_TOP);
    }
    wxYield();
}
//---------------------------------------------------------------------------
void MainFrame::OnAbout(wxCommandEvent& event)
{
    AProposinst->Show();
}
//---------------------------------------------------------------------------
 void MainFrame::OnHelp(wxCommandEvent& event)
{
    Traducteur tr;
    helpController->DisplayContents();
    helpController->Display(tr.trad(wxT("arbregenfrahlp")));
}
//---------------------------------------------------------------------------
void MainFrame::OnCalcule(wxCommandEvent& event)
{
        Traducteur tr;
        echange.affichage_autorise=true;
        echange.calcul_en_cours=true;
        item_menu_change=true;
        Refresh();
        Update();              // force l'affichage correct des différents boutons.
        echange.affichage_autorise=false;
        ReglPrecision->SetFocus();
        int nummaxarbres=typmod(ReglNbMaxArbres->GetValue());
        int valprecision=typmod(ReglPrecision->GetValue());

        Calculs::calcule_un_arbre(valprecision,nummaxarbres);
        echange.affichage_autorise=true;
        echange.calcul_en_cours=false;
        item_menu_change=true;
        Refresh();
        Update();// force l'affichage correct des différents boutons.
        wxMessageBox(tr.trad(wxT("Terminé")));
}
//---------------------------------------------------------------------------
void MainFrame::OnNouvelArbre(wxCommandEvent& event)
{
        NomFichier=wxT("default.arbre");
        Arbre_en_cours.purge_l_arbre();
        Arbre_en_cours.ajoute_un_individu(feminin,normal,false,true,0,0,0,0);
        Arbre_en_cours.ajoute_un_individu(masculin,normal,true,true,0,1,0,0);
        Refresh();
}
//---------------------------------------------------------------------------
void MainFrame::OnStop(wxCommandEvent& event)
{
    echange.calcul_en_cours=false;
    item_menu_change=true;
}
//---------------------------------------------------------------------------
void MainFrame::Onfr(wxCommandEvent& event)
{
    Traducteur tr;
    tr.fixe_langue()=fr;
    item_menu_change=true;
    Refresh();
}
//---------------------------------------------------------------------------
void MainFrame::Onen(wxCommandEvent& event)
{
    Traducteur tr;
    tr.fixe_langue()=ang;
    item_menu_change=true;
    Refresh();
}
void MainFrame::Ones(wxCommandEvent& event)
{
    Traducteur tr;
    tr.fixe_langue()=esp;
    item_menu_change=true;
    Refresh();
}
//---------------------------------------------------------------------------
void MainFrame::FileOpen(wxCommandEvent& WXUNUSED(event) )
{
    Traducteur tr;
    wxFileDialog dialog
                 (
                    this,
                    tr.trad(wxT("Ouvrir un arbre existant")),
                    wxEmptyString,
                    wxEmptyString,
                    wxString(tr.trad(wxT("Fichiers arbregen"))+wxT("(*.arbre)|*.arbre|")+tr.trad(wxT("Tous fichiers"))+wxT("(*.*)|*.*"))
                 );

    dialog.CentreOnParent();
    dialog.SetDirectory(DonneesVarDir);
    item_menu_change=true;
    if (dialog.ShowModal() == wxID_OK)
    {
// Chargemement du fichier Arbre sélectionné.

    DonneesVarDir=dialog.GetDirectory();
    NomFichier=dialog.GetFilename();
    wxString message_erreur=charge_fichier();
    if (message_erreur!=wxT(""))
        wxMessageBox(message_erreur);
    Refresh();
    }
}
//---------------------------------------------------------------------------
// Chargement du fichier arbre courant.
wxString MainFrame::charge_fichier()
{
    Traducteur tr;
    wxString message_erreur=wxT("");
    wxFile fichier_en_cours(NomComplet(),wxFile::read);
    bool succes=fichier_en_cours.IsOpened();
    if (succes)
        if (fichier_en_cours.Length()==sizeof(Arbre_en_cours.TableauInd))
            fichier_en_cours.Read((Tindividu*) &Arbre_en_cours.TableauInd, sizeof(Arbre_en_cours.TableauInd));
            else message_erreur=tr.trad(wxT("Erreur: format de fichier incorrect"));
        else message_erreur=tr.trad(wxT("Erreur: impossible d'ouvrir le fichier ")+NomFichier);;
    return message_erreur;
}
//---------------------------------------------------------------------------
void MainFrame::FileSave(wxCommandEvent& WXUNUSED(event) )
{
// enregistrement du fichier Arbre en cours.
    wxFile fichier_en_cours(NomComplet(),wxFile::write);
    fichier_en_cours.Write((Tindividu*) &Arbre_en_cours.TableauInd, sizeof(Arbre_en_cours.TableauInd));
    Refresh();
}
//---------------------------------------------------------------------------
void MainFrame::FileSaveAs(wxCommandEvent& WXUNUSED(event) )
{
    Traducteur tr;
    wxFileDialog dialog(this,
                        tr.trad(wxT("Enregistrer l'arbre en cours")),
                        wxEmptyString,
                        tr.trad(wxT("sans titre"))+wxT(".arbre"),
                        wxString(tr.trad(wxT("Fichiers arbregen"))+wxT("(*.arbre)|*.arbre|")+tr.trad(wxT("Tous fichiers"))+wxT("(*.*)|*.*")),
                        wxFD_SAVE|wxFD_OVERWRITE_PROMPT);

    dialog.SetFilterIndex(0);
    dialog.CentreOnParent();
    dialog.SetDirectory(DonneesVarDir);

    if (dialog.ShowModal() == wxID_OK)
    {
// enregistrement du fichier Arbre sélectionné.
    DonneesVarDir=dialog.GetDirectory();
    NomFichier=dialog.GetFilename();
    wxFile fichier_en_cours(NomComplet(),wxFile::write);
    fichier_en_cours.Write((Tindividu*) &Arbre_en_cours.TableauInd, sizeof(Arbre_en_cours.TableauInd));
    }
    Refresh();
}
//---------------------------------------------------------------------------
void MainFrame::OnFixeMode(wxCommandEvent& event)
{
        mode_trans_courant=typmod(ChoixMod->GetSelection());
}
//---------------------------------------------------------------------------
void MainFrame::OnReglePrecision(wxScrollEvent& event)
{
        Traducteur tr;
        item_menu_change=true;
        Refresh();
}
//---------------------------------------------------------------------------
void MainFrame::OnSize(wxSizeEvent& event)
{
    taille_modifiee=true;
}
//---------------------------------------------------------------------------
void MainFrame::OnValideModifie(wxCommandEvent& event)
{
            wxString message= event.GetString();
            if (message==wxT("Validation"))
                Canvas1->ValideModifie();
            else wxMessageBox(wxT("Pas de Validation")+message);
}
//---------------------------------------------------------------------------
void MainFrame::OnPaint(wxPaintEvent& event)
{
    wxPaintDC dc(this);
    rafraichit();
}
//---------------------------------------------------------------------------
void MainFrame::arbre_test()
{
        Arbre_en_cours.purge_l_arbre();
        Arbre_en_cours.ajoute_un_individu(feminin,normal,false,true,0,0,0,0);
        Arbre_en_cours.ajoute_un_individu(masculin,normal,true,true,0,1,0,0);
        Arbre_en_cours.ajoute_un_individu(masculin,normal,false,false,1,0,0,0);
        Arbre_en_cours.ajoute_un_individu(masculin,atteint,false,true,1,1,0,0);
        Arbre_en_cours.ajoute_un_individu(feminin,normal,true,true,1,2,0,0);
}
//---------------------------------------------------------------------------
void MainFrame::rafraichit()
{
    Traducteur tr;
    Tmodes tm;
    TextEchap->Enable(echange.calcul_en_cours);

     if (item_menu_change)
        {
            // Mise à jour réglage précision
            int index=ReglPrecision->GetValue();
            TextPrecision->SetLabel(tr.trad(wxT("Erreur visée"))+wxT("=")+wxString::Format(wxT("%4.1f"),float(echange.precision(index))));
            // Traduit les titres des enfants
            RenommeEnfants(this);
            // Traduit les items des menus
            wxMenuBar* Menuprov=GetMenuBar();
             // Titres de menus
            size_t nb_menus=Menuprov->GetMenuCount();
            for (size_t i=0;i<nb_menus;i++)
                Menuprov->SetMenuLabel(i,tr.trad_tout(Menuprov->GetMenuLabel(i)));
            //Items de chaque menu
            Menuprov->SetLabel(idMenuNouvelArbre,tr.trad_tout(wxT("&Nouvel arbre")));
            Menuprov->SetLabel(ID_DIALOGS_FILE_SAVE_AS,tr.trad_tout(wxT("Enregistrer &sous...")));
            Menuprov->SetLabel(ID_DIALOGS_FILES_OPEN,tr.trad_tout(wxT("&Ouvrir")));
            Menuprov->SetLabel(ID_DIALOGS_FILE_SAVE,tr.trad_tout(wxT("&Enregistrer")));
            Menuprov->SetLabel(idMenuImprime,tr.trad(wxT("Impression")));
            Menuprov->SetLabel(idMenuCalcule,tr.trad_tout(wxT("Lance un calcul")));
            Menuprov->SetLabel(idMenuStop,tr.trad_tout(wxT("Arrêt")));
            Menuprov->SetLabel(idMenuQuit,tr.trad_tout(wxT("Quitter")));
            Menuprov->SetLabel(idMenuDisclaimer, tr.trad(wxT("Avertissement")));
            Menuprov->SetLabel(idMenuAbout, tr.trad_tout(wxT("A propos")));
            Menuprov->SetLabel(idMenuHelp, tr.trad_tout(wxT("Aide")));
            Menuprov->SetLabel(idMenufr,tr.trad_tout(wxT("Français")));
            Menuprov->SetLabel(idMenuen,tr.trad_tout(wxT("English")));
            // Boutons actifs ou non sur la barre d'outils
            wxToolBar* Toolbarprov=GetToolBar();
            if (echange.affichage_autorise)
            {
                langues langue_en_cours=tr.fixe_langue();
                Menuprov->Check(idMenufr,(langue_en_cours==fr));
                Menuprov->Check(idMenuen,(langue_en_cours==ang));
                Menuprov->Check(idMenues,(langue_en_cours==esp));
                Toolbarprov->ToggleTool(idMenufr,langue_en_cours==fr);
                Toolbarprov->ToggleTool(idMenuen,langue_en_cours==ang);
                Toolbarprov->ToggleTool(idMenues,langue_en_cours==esp);
            #if defined(__WXMSW__)
                Menuprov->Check(idMenuCalcule,(echange.calcul_en_cours));
                Menuprov->Check(idMenuStop,(!echange.calcul_en_cours));// Sous Linux semble provoquer l'émission de l'évènement correspondant
            #elif defined(__UNIX__)
                // Sous Linux Check semble provoquer l'émission de l'évènement correspondant
            #endif
                Toolbarprov->ToggleTool(idMenuCalcule,echange.calcul_en_cours);
                Toolbarprov->ToggleTool(idMenuStop,!echange.calcul_en_cours);
            }
            Toolbarprov->SetToolShortHelp(ID_DIALOGS_FILES_OPEN,tr.trad_tout(wxT("Ouvrir un arbre existant")));
            Toolbarprov->SetToolShortHelp(ID_DIALOGS_FILE_SAVE,tr.trad_tout(wxT("Enregistrer l'arbre en cours")));
            Toolbarprov->SetToolShortHelp(idMenuImprime,tr.trad(wxT("Impression")));
            Toolbarprov->SetToolShortHelp(idMenuCalcule,tr.trad_tout(wxT("Lance un calcul")));
            Toolbarprov->SetToolShortHelp(idMenuStop,tr.trad_tout(wxT("Arrêt")));
            Toolbarprov->SetToolShortHelp(idMenuHelp, tr.trad_tout(wxT("Aide")));
            Toolbarprov->SetToolShortHelp(idMenuQuit,tr.trad_tout(wxT("Quitter")));
            TextNomFichier->SetLabel(NomFichier);
            // mise à jour de la comboox
            for (typmod i=TousLesModes;i<=LieAuSexeDom;i=suivant(i))
                ChoixMod->SetString(i,tr.trad(tm.nom(i)));
            ChoixMod->SetValue(tr.trad_tout(tm.nom(mode_trans_courant)));
            FicheIndividuinst->item_menu_change=true;
        }

    if (!echange.calcul_en_cours) //Seules les valeurs variables en cours de calcul sont rafraichies
    {

        if(taille_modifiee)
        {
            taille_modifiee=false;
              // paramètres d'affichage
            int labx(20),ecart(200),laby(50),pasy(70);
            int ecart1=ecart*0.5; // Longeur labels numériques
            int LongRegles=ecart+ecart1;   // longueur de la fenêtre déroulante et des réglages
            int posX_zone_graphique=labx*2+ecart+ecart1;
              // Ajuste la taille de la zone graphique
            wxPoint pos(posX_zone_graphique,laby);
            wxSize taille(1000-posX_zone_graphique-labx,1000-laby-labx);
            Ajuste_taille_et_pos(pos,taille,this,Canvas1);
            // Ajuste la taille des contrôles
            wxSize taille1(LongRegles,pasy);
            taille=wxSize(ecart,pasy/2);
            int ligne=0;
            Ajuste_taille_et_pos(wxPoint(posX_zone_graphique,0                 ),taille,this,TextNomFichier);
            Ajuste_taille_et_pos(wxPoint(labx      ,laby+ (ligne++)*pasy),taille1,this,ChoixMod);
            Ajuste_taille_et_pos(wxPoint(labx      ,laby+ (ligne++)*pasy),wxSize(LongRegles,pasy/2),this,ProgressBar1);
            Ajuste_taille_et_pos(wxPoint(labx      ,laby+ (ligne++)*pasy),taille1,this,CoconValidTotal);
            Ajuste_taille_et_pos(wxPoint(labx      ,laby+ (ligne++)*pasy),taille,this,TextPrecision);
            Ajuste_taille_et_pos(wxPoint(labx      ,laby+ (ligne++)*pasy),taille1,this,ReglPrecision);
            Ajuste_taille_et_pos(wxPoint(labx      ,laby+ (ligne++)*pasy),taille1,this,ReglNbMaxArbres);

            taille1=wxSize(ecart/4,pasy);
            Ajuste_taille_et_pos(wxPoint(labx               ,laby+ (ligne  )*pasy),taille1,this,TextEchelleG);
            Ajuste_taille_et_pos(wxPoint((LongRegles-labx)/2,laby+ (ligne  )*pasy),taille,this,TextEchelleM);
            Ajuste_taille_et_pos(wxPoint(LongRegles-labx    ,laby+ (ligne++)*pasy),taille1,this,TextEchelleD);
            Ajuste_taille_et_pos(wxPoint(labx      ,laby+ (ligne++)*pasy),taille,this,TextEchap);
            Ajuste_taille_et_pos(wxPoint(labx      ,laby+ (ligne  )*pasy),taille,this,TextAutR);
            Ajuste_taille_et_pos(wxPoint(labx+ecart,laby+ (ligne++)*pasy),taille1,this,TextProbaAR);
            Ajuste_taille_et_pos(wxPoint(labx      ,laby+ (ligne  )*pasy),taille,this,TextAutD);
            Ajuste_taille_et_pos(wxPoint(labx+ecart,laby+ (ligne++)*pasy),taille1,this,TextProbaAD);
            Ajuste_taille_et_pos(wxPoint(labx      ,laby+ (ligne  )*pasy),taille,this,TextSexeR);
            Ajuste_taille_et_pos(wxPoint(labx+ecart,laby+ (ligne++)*pasy),taille1,this,TextProbaSR);
            Ajuste_taille_et_pos(wxPoint(labx      ,laby+ (ligne  )*pasy),taille,this,TextSexeD);
            Ajuste_taille_et_pos(wxPoint(labx+ecart,laby+ (ligne++)*pasy),taille1,this,TextProbaSD);
        }
    }
    else
    {
          // Rafraichit le texte des contrôles pendant le calcul
         if (item_menu_change) // la condition n'est pas nécessaire sous windows, mais sous linux, il semble y avoir un problème avec la fonction yield du module calcul
         {
            TextAutR->Enable(Calculs::Mode_possible(AutosomalRec));
            TextAutD->Enable(Calculs::Mode_possible(AutosomalDom));
            TextSexeR->Enable(Calculs::Mode_possible(LieAuSexeRec));
            TextSexeD->Enable(Calculs::Mode_possible(LieAuSexeDom));

            TextProbaAR->Enable(Calculs::Mode_possible(AutosomalRec));
            TextProbaAD->Enable(Calculs::Mode_possible(AutosomalDom));
            TextProbaSR->Enable(Calculs::Mode_possible(LieAuSexeRec));
            TextProbaSD->Enable(Calculs::Mode_possible(LieAuSexeDom));

            TextProbaAR->SetLabel(wxString::Format(wxT("%6.2f"),Calculs::proba_du_mode(AutosomalRec)));
            TextProbaAD->SetLabel(wxString::Format(wxT("%6.2f"),Calculs::proba_du_mode(AutosomalDom)));
            TextProbaSR->SetLabel(wxString::Format(wxT("%6.2f"),Calculs::proba_du_mode(LieAuSexeRec)));
            TextProbaSD->SetLabel(wxString::Format(wxT("%6.2f"),Calculs::proba_du_mode(LieAuSexeDom)));
         }
        // mise à jour des valeurs variables en cours de calcul
        // L'absence du paramètre l (pour long int) dans format provoque un plantage avec wxWidgets 3.0.2 en 64 bits
        // Non détecté, probablement à tort, sous 2.8.12
            TextValidTotal->SetLabel(tr.trad(wxT("Valides"))
                                    +wxT(":")+wxString::Format(wxT("%04ld"),echange.arbres_valides)
                                    +wxT("  ")+tr.trad(wxT("Total :"))
                                    +wxString::Format(wxT("%04ld"),echange.total_arbres)+wxT("      "));

        // mise à jour de la barre de progression
        ProgressBar1->SetValue(echange.curseur<ProgressBar1->GetRange()?echange.curseur:ProgressBar1->GetRange());
        // titre de la fenêtre de l'arbre A refaire
    }
item_menu_change=false;
}
//---------------------------------------------------------------------------
