#ifndef FICHEINDIVIDU_H_INCLUDED
#define FICHEINDIVIDU_H_INCLUDED
/*
    Arbregen permet de construire des arbres généalogiques puis de donner une valeur approchée pour les probabilités des différents génotypes.
    Copyright (C) 1997 (version Dos) 2009-2023 Vial Jean-Luc Annecy
    Contact email: vial.frjl@free.fr

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

class Tindividu;

class FicheIndividu : public wxFrame
{
public:

// Le constructeur
        FicheIndividu(wxWindow* parent,wxWindowID idficheindividu,wxSize taillefiche);
        void Passe_individu(const Tindividu& t);
        void fixe_mode_fiche(typmod m);
        Tindividu FicheDonneIndividu();
        bool item_menu_change;

// Le destructeur
~FicheIndividu();
private:
        bool existe;
        bool fiche_active;
        bool fiche_modifiee;
        bool taille_modifiee;

        wxStaticText* LabelGeneration;
        wxStaticText* LabelGenerationVal;
        wxStaticText* LabelNumDansGen;
        wxStaticText* LabelNumDansGenVal;
        wxStaticText* LabelExterne;
        wxStaticText* LabelNbEnfants;
        wxStaticText* LabelNbEnfantsVal;
        wxStaticText* LabelGenotype;
        wxStaticText* LabelProbabilite;
        wxStaticText* LabelApriori;
        wxStaticText* LabelAprescalcul;
        wxStaticText* LabelProbaHetApriori;
        wxStaticText* LabelProbaHomoNormResultat;
        wxStaticText* LabelProbaHetResultat;
        wxStaticText* LabelProbaHomoAttResultat;
        wxStaticText* LabelHomoNormal;
        wxStaticText* LabelHomoAtteint;
        wxStaticText* LabelHetero;

        static const long idBoutonPlus10;
        wxButton* BoutonPlus10;
        void OnBoutonPlus10(wxCommandEvent& event);
        static const long idBoutonMoins10;
        wxButton* BoutonMoins10;
        void OnBoutonMoins10(wxCommandEvent& event);
        static const long idBoutonPlus1;
        wxButton* BoutonPlus1;
        void OnBoutonPlus1(wxCommandEvent& event);
        static const long idBoutonMoins1;
        wxButton* BoutonMoins1;
        void OnBoutonMoins1(wxCommandEvent& event);
        static const long idBoutonIncNbEnf;
        wxButton* BoutonIncNbEnf;
        void OnBoutonIncNbEnf(wxCommandEvent& event);

        static const long idChoixSexe;
        wxRadioBox* ChoixSexe;
        void OnChoixSexe(wxCommandEvent& event);
        static const long idChoixPhen;
        wxRadioBox* ChoixPhen;
        void OnChoixPhen(wxCommandEvent& event);
        static const long idChoixMari;
        wxRadioBox* ChoixMari;
        void OnChoixMari(wxCommandEvent& event);

        static const long idBoutonSupprime;
        wxButton* BoutonSupprime;
        void OnBoutonSupprime(wxCommandEvent& event);
        static const long idBoutonModife;
        wxButton* BoutonModife;
        void OnBoutonModife(wxCommandEvent& event);
        static const long idBoutonValide;
        wxButton* BoutonValide;
        void OnBoutonValide(wxCommandEvent& event);

        void OnQuit1(wxCloseEvent& event);

        wxPanel* BoutonsRadio;

        void rafraichit();
        void Active_la_fiche(bool f);
        wxPoint ALaPlace(wxWindow* Fen_Cible,int x,int y);
        wxPoint ALaPlace(int x,int y);
        void OnPaint(wxPaintEvent& event);
        void OnSize(wxSizeEvent& event);

        DECLARE_EVENT_TABLE()
};

#endif // FICHEINDIVIDU_H_INCLUDED
