#include "ProjetdeBase.h"
#include "FicheIndividu.h"
#include <wx/button.h>
#include <wx/radiobox.h>
#include "../Icones/arbregen16.xpm"

const wxString nommar[]={wxT("Non"),wxT("Oui")};
Tindividu Contenu_fiche;
typmod mode_fiche=AutosomalRec;

const long FicheIndividu::idBoutonPlus10 = wxNewId();
const long FicheIndividu::idBoutonMoins10 = wxNewId();
const long FicheIndividu::idBoutonPlus1 = wxNewId();
const long FicheIndividu::idBoutonMoins1 = wxNewId();
const long FicheIndividu::idBoutonIncNbEnf = wxNewId();
const long FicheIndividu::idBoutonSupprime = wxNewId();
const long FicheIndividu::idBoutonValide = wxNewId();
const long FicheIndividu::idBoutonModife = wxNewId();
const long FicheIndividu::idChoixSexe = wxNewId();
const long FicheIndividu::idChoixPhen = wxNewId();
const long FicheIndividu::idChoixMari = wxNewId();

BEGIN_EVENT_TABLE(FicheIndividu, wxFrame)
    EVT_PAINT(FicheIndividu::OnPaint)
    EVT_SIZE(FicheIndividu::OnSize)
    EVT_BUTTON(idBoutonPlus10,FicheIndividu::OnBoutonPlus10)
    EVT_BUTTON(idBoutonMoins10,FicheIndividu::OnBoutonMoins10)
    EVT_BUTTON(idBoutonPlus1,FicheIndividu::OnBoutonPlus1)
    EVT_BUTTON(idBoutonMoins1,FicheIndividu::OnBoutonMoins1)
    EVT_BUTTON(idBoutonIncNbEnf,FicheIndividu::OnBoutonIncNbEnf)
    EVT_BUTTON(idBoutonSupprime,FicheIndividu::OnBoutonSupprime)
    EVT_BUTTON(idBoutonValide,FicheIndividu::OnBoutonValide)
    EVT_BUTTON(idBoutonModife,FicheIndividu::OnBoutonModife)
    EVT_CLOSE(FicheIndividu::OnQuit1)
    EVT_RADIOBOX(idChoixSexe,FicheIndividu::OnChoixSexe)
    EVT_RADIOBOX(idChoixPhen,FicheIndividu::OnChoixPhen)
    EVT_RADIOBOX(idChoixMari,FicheIndividu::OnChoixMari)
END_EVENT_TABLE()

//---------------------------------------------------------------------------
// Constructeur
//---------------------------------------------------------------------------

FicheIndividu::FicheIndividu(wxWindow* parent,wxWindowID ficheindividu,wxSize taillefiche):wxFrame(parent,ficheindividu,wxT("Fiche d'identité"),
                wxPoint(300,100),taillefiche,wxFULL_REPAINT_ON_RESIZE|wxDEFAULT_FRAME_STYLE),
                item_menu_change(false),
                fiche_active(false),
                fiche_modifiee(false),
                taille_modifiee(true)
{
    // Mise en page et insertion des contrôles
    wxPoint pos; wxSize taille;
    pos=FaitReelle_Pos(wxPoint(10,100),this);
    taille=FaitReelle_Taille(wxSize(50,50),this);
    //InheritAttributes(); ne met pas à jour la police après 3.0
    FixeFontEtTaille(this);
    LabelGeneration=new wxStaticText(this,wxID_ANY,wxT("Génération"),pos);
    LabelGenerationVal=new wxStaticText(this,wxID_ANY,wxT("nd"),pos);
    LabelNumDansGen=new wxStaticText(this,wxID_ANY,wxT("Numéro dans la génération"),pos);
    LabelNumDansGenVal=new wxStaticText(this,wxID_ANY,wxT("nd"),pos);
    LabelExterne=new wxStaticText(this,wxID_ANY,wxT("Externe"),pos);
    LabelNbEnfants=new wxStaticText(this,wxID_ANY,wxT("Nombre d'enfants"),pos);
    LabelNbEnfantsVal=new wxStaticText(this,wxID_ANY,wxT("nd"),pos);
    LabelGenotype=new wxStaticText(this,wxID_ANY,wxT("Génotype"),pos);
    LabelProbabilite=new wxStaticText(this,wxID_ANY,wxT("Probabilités"),pos);
    LabelApriori=new wxStaticText(this,wxID_ANY,wxT("A priori"),pos);
    LabelAprescalcul=new wxStaticText(this,wxID_ANY,wxT("Après calcul"),pos);
    LabelProbaHetApriori=new wxStaticText(this,wxID_ANY,wxT("nd"),pos);
    LabelProbaHomoNormResultat=new wxStaticText(this,wxID_ANY,wxT("nd"),pos);
    LabelProbaHetResultat=new wxStaticText(this,wxID_ANY,wxT("nd"),pos);
    LabelProbaHomoAttResultat=new wxStaticText(this,wxID_ANY,wxT("nd"),pos);
    LabelHomoNormal=new wxStaticText(this,wxID_ANY,wxT("nd"),pos);
    LabelHomoAtteint=new wxStaticText(this,wxID_ANY,wxT("nd"),pos);
    LabelHetero=new wxStaticText(this,wxID_ANY,wxT("nd"),pos);
    BoutonPlus10=new wxButton(this,idBoutonPlus10,wxT("+10"),pos,wxSize(50,20));
    BoutonMoins10=new wxButton(this,idBoutonMoins10,wxT("-10"),pos,wxSize(50,20));
    BoutonPlus1=new wxButton(this,idBoutonPlus1,wxT("+1"),pos,wxSize(40,20));
    BoutonMoins1=new wxButton(this,idBoutonMoins1,wxT("-1"),pos,wxSize(40,20));
    BoutonIncNbEnf=new wxButton(this,idBoutonIncNbEnf,wxT("+"),pos,wxSize(40,20));
    BoutonSupprime=new wxButton(this,idBoutonSupprime,wxT("Supprimer"),pos,wxSize(60,20));
    BoutonModife=new wxButton(this,idBoutonModife,wxT("Modifier"),pos,wxSize(60,20));
    BoutonValide=new wxButton(this,idBoutonValide,wxT("Valider"),pos,wxSize(60,20));

    BoutonsRadio= new wxPanel(this,wxID_ANY,pos,wxSize(taillefiche.GetX(),100));
                ChoixSexe=new wxRadioBox(BoutonsRadio,idChoixSexe,wxT("Sexe"),pos,wxSize(75,80),3,nomsex,1,wxRA_SPECIFY_COLS);
                ChoixPhen=new wxRadioBox(BoutonsRadio,idChoixPhen,wxT("Phénotype"),pos,wxSize(75,80),3,nomph,1,wxRA_SPECIFY_COLS);
                ChoixMari=new wxRadioBox(BoutonsRadio,idChoixMari,wxT("Marié"),pos,wxSize(75,80),2,nommar,1,wxRA_SPECIFY_COLS);

    SetBackgroundColour(Couleur_Fenetres_defaut());
    wxRect Pos=Taille_Fenetres_defaut();
    Pos.SetX(Pos.GetX()+Pos.GetWidth()/2);
    Pos.SetY(Pos.GetY()+Pos.GetHeight()/2);
    Pos.SetWidth(taillefiche.GetX());
    Pos.SetHeight(taillefiche.GetY());
    SetPosition(Pos.GetPosition());
    SetIcon(arbregen16_xpm);
}
//---------------------------------------------------------------------------
void FicheIndividu::rafraichit()
{
    Traducteur tr;
    if (item_menu_change)
    {
    // Renomme la fenêtre principale
    SetLabel(tr.trad(GetLabel()));
    // Active ou inactive les contrôles
    Active_la_fiche(fiche_active);
    //Renseigne les champs variables
    LabelExterne->Show(Contenu_fiche.externe||Contenu_fiche.mere());
    // Condition complexe d'affichage des proba à priori qui n'ont pas de sens car le phénotype contraint le génotype
    bool Affichage_proba_hetero=(Contenu_fiche.externe||Contenu_fiche.mere()) //proba ajustable seulement aux frontières de l'arbe
                 &&(!(((mode_fiche==LieAuSexeDom)||(mode_fiche==AutosomalDom))&&(Contenu_fiche.phe==normal)))// Pas de sens si le phénotype est normal et l'allèle dominant
                 &&(!(((mode_fiche==LieAuSexeRec)||(mode_fiche==AutosomalRec))&&(Contenu_fiche.phe==atteint)))// Pas de sens si le phénotype est atteint et l'allèle récessif
                 &&(!(((mode_fiche==LieAuSexeRec)||(mode_fiche==LieAuSexeDom))&&(Contenu_fiche.sexe==masculin)));// pas de sens pour les mâles mode lié au sexe
    LabelProbaHetApriori->Show(Affichage_proba_hetero);
    LabelGenerationVal->SetLabel(wxString::Format(wxT("%3i"),Contenu_fiche.position.x+1));
    LabelNumDansGenVal->SetLabel(wxString::Format(wxT("%3i"),Contenu_fiche.position.y+1));
    LabelNbEnfantsVal->SetLabel(wxString::Format(wxT("%3i"),Contenu_fiche.nb_enfant));
        //Renseigne les champs des génotypes
       wxString homat,het,homind,malat,malind;
        bool recessif=(mode_fiche==AutosomalRec||mode_fiche==LieAuSexeRec);
        bool autosomal=(mode_fiche==AutosomalRec||mode_fiche==AutosomalDom);
        if (autosomal)
            {if(recessif)
                         {homat=wxT("(a//a)");het=wxT("(N//a)");homind=wxT("(N//N)");}
                         else {homat=wxT("(A//A)");het=wxT("(A//n)");homind=wxT("(n//n)");}
            LabelHomoNormal->SetLabel(homind);
            LabelHetero->Show(true);
            LabelHetero->SetLabel(het);
            LabelHomoAtteint->SetLabel(homat);
            }
        else
            {if(recessif)
                         {homat=wxT("(Xa//Xa)");het=wxT("(XN//Xa)");homind=wxT("(XN//XN)");
                         malat=wxT("(Xa//Y)");malind=wxT("(XN//Y)");}
                         else {homat=wxT("(XA//XA)");het=wxT("(XA//Xn)");homind=wxT("(Xn//Xn)");
                         malat=wxT("(XA//Y)");malind=wxT("(Xn//Y)");}
            switch(Contenu_fiche.sexe)
               { case masculin:
                {LabelHomoNormal->SetLabel(malind);
                 LabelHetero->Show(false);
                 LabelHomoAtteint->SetLabel(malat);
                 break;}
                case feminin:
                 {LabelHomoNormal->SetLabel(homind);
                 LabelHetero->Show(true);
                 LabelHetero->SetLabel(het);
                 LabelHomoAtteint->SetLabel(homat);
                 break;}
                default:
                 {LabelHomoNormal->SetLabel(homind+tr.trad(wxT("ou"))+malind);
                 LabelHetero->Show(true);
                 LabelHetero->SetLabel(het);
                 LabelHomoAtteint->SetLabel(homat+tr.trad(wxT("ou"))+malat);
                 }
                }
               }
        // Renseigne les valeurs des probabilités
        LabelProbaHomoNormResultat->SetLabel(wxString::Format(wxT("%2.2f"),Contenu_fiche.proba_pourcent(homo_normal)));
        LabelProbaHetResultat->SetLabel(wxString::Format(wxT("%2.2f"),Contenu_fiche.proba_pourcent(hetero)));
        LabelProbaHomoAttResultat->SetLabel(wxString::Format(wxT("%2.2f"),Contenu_fiche.proba_pourcent(homo_atteint)));
        LabelProbaHetApriori->SetLabel(wxString::Format(wxT("%3i"),Contenu_fiche.proba_hetero));
    // renomme les labels des contrôles
    ChoixSexe->SetSelection(Contenu_fiche.sexe);
    ChoixPhen->SetSelection(Contenu_fiche.phe);
    ChoixMari->SetSelection(Contenu_fiche.marie);
    for (int i=0;i<3;i++) ChoixSexe->SetString(i,tr.trad(nomsex[i]));
    for (int i=0;i<3;i++) ChoixPhen->SetString(i,tr.trad(nomph[i]));
    for (int i=0;i<2;i++) ChoixMari->SetString(i,tr.trad(nommar[i]));
    RenommeEnfants(this);
    item_menu_change=false;
    }
    if(taille_modifiee)
    {
        taille_modifiee=false;
        Ajuste_taille_et_pos(wxPoint( 30, 50),wxSize(250, 50),this,LabelGeneration);
        Ajuste_taille_et_pos(wxPoint(280, 50),wxSize( 50, 50),this,LabelGenerationVal);
        Ajuste_taille_et_pos(wxPoint(365, 50),wxSize(550, 50),this,LabelNumDansGen);
        Ajuste_taille_et_pos(wxPoint(900, 50),wxSize( 50, 50),this,LabelNumDansGenVal);
        Ajuste_taille_et_pos(wxPoint( 30,125),wxSize(250, 50),this,LabelExterne);
        Ajuste_taille_et_pos(wxPoint(550,125),wxSize(600, 50),this,LabelNbEnfants);
        Ajuste_taille_et_pos(wxPoint(900,125),wxSize( 50, 50),this,LabelNbEnfantsVal);
        Ajuste_taille_et_pos(wxPoint(400,450),wxSize(250, 50),this,LabelGenotype);
        Ajuste_taille_et_pos(wxPoint(700,450),wxSize(250, 50),this,LabelProbabilite);
        Ajuste_taille_et_pos(wxPoint(520,500),wxSize(250, 50),this,LabelApriori);
        Ajuste_taille_et_pos(wxPoint(700,500),wxSize(250, 50),this,LabelAprescalcul);
        Ajuste_taille_et_pos(wxPoint(580,625),wxSize(250, 50),this,LabelProbaHetApriori);
        Ajuste_taille_et_pos(wxPoint(700,575),wxSize(100, 50),this,LabelProbaHomoNormResultat);
        Ajuste_taille_et_pos(wxPoint(700,625),wxSize(100, 50),this,LabelProbaHetResultat);
        Ajuste_taille_et_pos(wxPoint(700,675),wxSize(100, 50),this,LabelProbaHomoAttResultat);
        Ajuste_taille_et_pos(wxPoint(400,575),wxSize(250, 50),this,LabelHomoNormal);
        Ajuste_taille_et_pos(wxPoint(400,675),wxSize(250, 50),this,LabelHomoAtteint);
        Ajuste_taille_et_pos(wxPoint(400,625),wxSize(250, 50),this,LabelHetero);
        Ajuste_taille_et_pos(wxPoint( 40,575),wxSize(150, 50),this,BoutonPlus10);
        Ajuste_taille_et_pos(wxPoint( 40,675),wxSize(150, 50),this,BoutonMoins10);
        Ajuste_taille_et_pos(wxPoint(200,575),wxSize(150, 50),this,BoutonPlus1);
        Ajuste_taille_et_pos(wxPoint(200,675),wxSize(150, 50),this,BoutonMoins1);
        Ajuste_taille_et_pos(wxPoint(350,125),wxSize(150, 50),this,BoutonIncNbEnf);
        Ajuste_taille_et_pos(wxPoint(100,850),wxSize(200, 50),this,BoutonSupprime);
        Ajuste_taille_et_pos(wxPoint(400,850),wxSize(200, 50),this,BoutonModife);
        Ajuste_taille_et_pos(wxPoint(700,850),wxSize(200, 50),this,BoutonValide);
        Ajuste_taille_et_pos(wxPoint( 10,200),wxSize(980,240),this,BoutonsRadio);
        Ajuste_taille_et_pos(wxPoint(  0,  0),wxSize(310,1000),BoutonsRadio,ChoixSexe);
        Ajuste_taille_et_pos(wxPoint(345,  0),wxSize(310,1000),BoutonsRadio,ChoixPhen);
        Ajuste_taille_et_pos(wxPoint(690,  0),wxSize(310,1000),BoutonsRadio,ChoixMari);
/*
    BoutonsRadio= new wxPanel(this,wxID_ANY,ALaPlace(0,7),wxSize(taillefiche.GetX(),100));
                ChoixSexe=new wxRadioBox(BoutonsRadio,idChoixSexe,wxT("Sexe"),ALaPlace(0,1),wxSize(75,80),3,nomsex,1,wxRA_SPECIFY_COLS);
                ChoixPhen=new wxRadioBox(BoutonsRadio,idChoixPhen,wxT("Phénotype"),ALaPlace(7,1),wxSize(75,80),3,nomph,1,wxRA_SPECIFY_COLS);
                ChoixMari=new wxRadioBox(BoutonsRadio,idChoixMari,wxT("Marié"),ALaPlace(14,1),wxSize(75,80),2,nommar,1,wxRA_SPECIFY_COLS);
*/
    }
}
//---------------------------------------------------------------------------
void    FicheIndividu::Active_la_fiche(bool f)
        {bool externe=Contenu_fiche.externe||Contenu_fiche.mere();
        ChoixMari->Enable(f&&(Contenu_fiche.sexe!=embryon)&&(!externe||Contenu_fiche.mere()));
        ChoixPhen->Enable(f);
        ChoixSexe->Enable(f&&(!Contenu_fiche.marie)&&(!externe));
        BoutonSupprime->Enable(f);
        BoutonValide->Enable(f&&fiche_modifiee);
        BoutonPlus1->Enable(f&&externe);
        BoutonMoins1->Enable(f&&externe);
        BoutonPlus10->Enable(f&&externe);
        BoutonMoins10->Enable(f&&externe);
        BoutonIncNbEnf->Enable(f&&(!externe||Contenu_fiche.mere())&&Contenu_fiche.marie);
        LabelProbaHetApriori->Enable(Contenu_fiche.externe||Contenu_fiche.mere());
        }
//---------------------------------------------------------------------------
wxPoint FicheIndividu::ALaPlace(int x,int y)
{
    return ALaPlace(this,x,y);
}
//---------------------------------------------------------------------------
wxPoint FicheIndividu::ALaPlace(wxWindow* Fen_Cible,int x,int y)
{
    return wxPoint((*Fen_Cible).GetSize().GetX()/25*x,(*this).GetSize().GetY()/40*y);
}
//---------------------------------------------------------------------------
void FicheIndividu::Passe_individu(const Tindividu& t)
{
    Contenu_fiche=t;
    fiche_active=false;
    fiche_modifiee=false;
    item_menu_change=true;
    Refresh();
}
//---------------------------------------------------------------------------
void FicheIndividu::fixe_mode_fiche(typmod m)
{
    mode_fiche=m;
}
FicheIndividu::~FicheIndividu()
{
}
//---------------------------------------------------------------------------
void FicheIndividu::OnSize(wxSizeEvent& event)
{
    taille_modifiee=true;
}
//---------------------------------------------------------------------------
void FicheIndividu::OnBoutonPlus10(wxCommandEvent& event)
{
    Contenu_fiche.proba_hetero+=10;
    if (Contenu_fiche.proba_hetero>100) Contenu_fiche.proba_hetero=100;
    fiche_modifiee=true;
    item_menu_change=true;
    Refresh();
}
void FicheIndividu::OnBoutonMoins10(wxCommandEvent& event)
{
    Contenu_fiche.proba_hetero-=10;
    if (Contenu_fiche.proba_hetero<0) Contenu_fiche.proba_hetero=0;
    fiche_modifiee=true;
    item_menu_change=true;
    Refresh();
}
void FicheIndividu::OnBoutonPlus1(wxCommandEvent& event)
{
    Contenu_fiche.proba_hetero+=1;
    if (Contenu_fiche.proba_hetero>100) Contenu_fiche.proba_hetero=100;
    fiche_modifiee=true;
    item_menu_change=true;
    Refresh();
}
void FicheIndividu::OnBoutonMoins1(wxCommandEvent& event)
{
    Contenu_fiche.proba_hetero-=1;
    if (Contenu_fiche.proba_hetero<0) Contenu_fiche.proba_hetero=0;
    fiche_modifiee=true;
    item_menu_change=true;
    Refresh();
}
//---------------------------------------------------------------------------
void FicheIndividu::OnBoutonIncNbEnf(wxCommandEvent& event)
{
    Contenu_fiche.nb_enfant++;
    if (Contenu_fiche.nb_enfant>effectif_max_generation) Contenu_fiche.nb_enfant=effectif_max_generation;
    fiche_modifiee=true;
    item_menu_change=true;
    Refresh();
}
void FicheIndividu::OnBoutonSupprime(wxCommandEvent& event)
{
    Contenu_fiche.existe=false;
    fiche_modifiee=true;
    item_menu_change=true;
    Refresh();
}
void FicheIndividu::OnBoutonValide(wxCommandEvent& event)
{
    wxCommandEvent MyEvent(wxEVT_COMMAND_BUTTON_CLICKED);
    MyEvent.SetEventObject(this);
    MyEvent.SetString(wxT("Validation"));
    wxPostEvent(this->GetParent(),MyEvent);
    fiche_modifiee=false;
    Refresh();
}
void FicheIndividu::OnBoutonModife(wxCommandEvent& event)
{
    fiche_active=true;
    item_menu_change=true;
    Refresh();
}
void FicheIndividu::OnChoixSexe(wxCommandEvent& event)
{
    Contenu_fiche.sexe=Tsexe(ChoixSexe->GetSelection());
    fiche_modifiee=true;
    item_menu_change=true;
    Refresh();
}
void FicheIndividu::OnChoixPhen(wxCommandEvent& event)
{
    Contenu_fiche.phe=Tphenotype(ChoixPhen->GetSelection());
    fiche_modifiee=true;
    item_menu_change=true;
    Refresh();
}
void FicheIndividu::OnChoixMari(wxCommandEvent& event)
{
    Contenu_fiche.marie=bool(ChoixMari->GetSelection());
    fiche_modifiee=true;
    item_menu_change=true;
    Refresh();
}
void FicheIndividu::OnQuit1(wxCloseEvent& event)
{
        Hide();
}
void FicheIndividu::OnPaint(wxPaintEvent& event)
{
    wxPaintDC dc(this);
    rafraichit();
}
//---------------------------------------------------------------------------
// Met à jour le conteneur individu de la fiche en accord avec les options affichées
// Retourne un individu identique au conteneur de la fiche
Tindividu FicheIndividu::FicheDonneIndividu()
{
        return(Contenu_fiche);
}
