#ifndef DESSIN_H_INCLUDED
#define DESSIN_H_INCLUDED
/*
Arbregen permet de construire des arbres généalogiques puis de donner une valeur approchée pour les probabilités des différents génotypes.
Copyright (C) 1997 (version Dos) 2009-2023 Vial Jean-Luc Annecy
Contact email: vial.frjl@free.fr

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
class Tarbre;

//---------------------------------------------------------------------------
// Définition de la classe de dessin Canvas

class Tindividu;
class Canvas: public wxWindow
{
        public:
        Canvas(wxWindow* parent,wxWindowID id,FicheIndividu* FicheIndiv,Tarbre& Arbre, typmod& mode);
        void OnPaint (wxPaintEvent& WXUNUSED(event));
        void OnButton1(wxMouseEvent& event);
        void ValideModifie();
        void efface_arbre(wxDC& dc);
        void dessine_arbre(const Tindividu& t,wxDC& dc);
        Tarbre* Arbre_en_cours;

        private:
        FicheIndividu* FicheIndividu1;
        typmod* mode_trans_courant;
        wxPoint centre_individu(const Tindividu& t,wxDC& dc);
        const wxPoint nbmaxaff;
        const int offset;
        int val_pas(wxDC& dc);
        int val_pas();
        void dessine(Tindividu t,wxDC& dc);

        void trait_hymen(const Tindividu& t,wxDC& dc);
        void trait_fratrie(const Tindividu& t,wxDC& dc);

        Tindividu clic_gauche_individu(int x,int y);

        DECLARE_EVENT_TABLE()
};

#endif // DESSIN_H_INCLUDED
