#include "ProjetdeBase.h"
#include "FicheIndividu.h"
#include "Dessin.h"
// Assure la compatibilité avec la version 2.8 de wxWidgets. A faire sauter ultérieurement
// wxCHECK(x,y,z) retourne vrai si la version est égale ou postérieure à la version x y z.
#if !wxCHECK_VERSION(2,9,0)
    #define wxPENSTYLE_SOLID wxSOLID
    #define wxPENSTYLE_DOT wxDOT
    #define wxPENSTYLE_LONG_DASH wxLONG_DASH
    #define wxBRUSHSTYLE_TRANSPARENT wxTRANSPARENT
    #define wxBRUSHSTYLE_SOLID wxSOLID
#endif
//---------------------------------------------------------------------------
// Espace de nommage Dessin
//---------------------------------------------------------------------------
// Paramètres graphiques
// Nombre de segments occupés par un individu (y compris l'espace qui le sépare du suivant
// Par exemple 4, dont deux (PASIND) pour le dessin de l'individu et deux espaces
// Toutes les combinaisons ne marchent pas (6,4 marche et donne des individus plus gros)
const int NBPAS(4),PASIND(2);
//---------------------------------------------------------------------------
// Définition d'un classe Canvas pour les dessins

BEGIN_EVENT_TABLE(Canvas, wxWindow)
EVT_PAINT(Canvas::OnPaint)
EVT_LEFT_DOWN(Canvas::OnButton1)
END_EVENT_TABLE()

Canvas::Canvas(wxWindow* parent,wxWindowID id,FicheIndividu* FicheIndiv, Tarbre& Arbre, typmod& mode):
            wxWindow(parent,id,wxPoint(150,10),wxSize(200,200),wxFULL_REPAINT_ON_RESIZE|wxBORDER_SUNKEN)
            ,FicheIndividu1(FicheIndiv)
            ,nbmaxaff(10,10)
            ,offset(1)
{
Arbre_en_cours=&Arbre;
mode_trans_courant=&mode;
}
//---------------------------------------------------------------------------
void Canvas::OnPaint(wxPaintEvent& WXUNUSED(event))
{
    wxPaintDC dc(this);
    if(!firstwin()->echange.calcul_en_cours) efface_arbre(dc);
    dessine_arbre(Arbre_en_cours->racine(),dc);
}
//---------------------------------------------------------------------------
void Canvas::OnButton1(wxMouseEvent& event)
{
    wxPoint p;
    p=event.GetPosition();
    Tindividu t;
    t=clic_gauche_individu(p.x,p.y);
    if (t.existe)
        {
        FicheIndividu1->fixe_mode_fiche(*mode_trans_courant);
        FicheIndividu1->Passe_individu(t);
        FicheIndividu1->Show();
        FicheIndividu1->Raise();
        }
        else
        FicheIndividu1->Hide();
}
//---------------------------------------------------------------------------
void Canvas::ValideModifie()
{
            Tindividu t=FicheIndividu1->FicheDonneIndividu();
            Arbre_en_cours->modifie(t);
            Refresh();
}
//---------------------------------------------------------------------------
// Les individus sont répartis tous les 4 val_pas sur la grille
int Canvas::val_pas(wxDC& dc)
{
    return(dc.GetSize().GetWidth()/(nbmaxaff.y*NBPAS));
}
//---------------------------------------------------------------------------
int Canvas::val_pas()
{
    return(GetClientSize().GetWidth()/(nbmaxaff.y*NBPAS));
}
//---------------------------------------------------------------------------
wxPoint Canvas::centre_individu(const Tindividu& t,wxDC& dc)
{
    wxPoint p1;
    int pas=val_pas(dc);
    p1.x=pas*NBPAS*t.position.x;
    p1.y=pas*NBPAS*t.position.y;
    p1.x+=(offset+PASIND/2)*pas;p1.y+=(offset+PASIND/2)*pas;
    return(p1);
}
//---------------------------------------------------------------------------
void Canvas::dessine(Tindividu t,wxDC& dc)
{
    wxPoint p1,p2;
    int pas=val_pas(dc);
    int cote_ind(PASIND*pas);
    p1=centre_individu(t,dc);
    dc.SetPen(wxPen(*wxBLACK,1,wxPENSTYLE_SOLID));// c.Pen->Color=clWhite;
    bool enfantunique=Arbre_en_cours->Ind(t.positionparent.x,t.positionparent.y).nb_enfant==1;
    if (!t.externe && !enfantunique)
                  dc.DrawLine(p1.y,p1.x,p1.y,p1.x-(NBPAS/2)*pas);
    switch(t.phe)
            {case normal:dc.SetBrush(wxBrush(*wxWHITE,wxBRUSHSTYLE_SOLID));break;
            case atteint:dc.SetBrush(wxBrush(*wxBLACK,wxBRUSHSTYLE_SOLID));break;
            default:dc.SetBrush(wxBrush(*wxCYAN,wxBRUSHSTYLE_SOLID));break;
            }

    switch(t.sexe)
            {
            case masculin:dc.DrawRectangle(p1.y-cote_ind/2,p1.x-cote_ind/2,cote_ind,cote_ind);break;
            case feminin: dc.DrawEllipse  (p1.y-cote_ind/2,p1.x-cote_ind/2,cote_ind,cote_ind);break;
            case embryon:
                    {wxPoint losange[4];
                    losange[0]=wxPoint(p1.y,p1.x-cote_ind/2);
                    losange[1]=wxPoint(p1.y-cote_ind/2,p1.x);
                    losange[2]=wxPoint(p1.y,p1.x+cote_ind/2);
                    losange[3]=wxPoint(p1.y+cote_ind/2,p1.x);
                    dc.DrawPolygon(4,losange);
                    }
            }
    Tgenotype g;
    if(t.genotype_probable(g)&&(g==hetero)&&(t.phe==normal))
            {
            dc.SetBrush(wxBrush(*wxRED,wxBRUSHSTYLE_SOLID));
            dc.DrawEllipse(p1.y-cote_ind/2/2,p1.x-cote_ind/2/2,cote_ind/2,cote_ind/2);
            }
}
//---------------------------------------------------------------------------
        void Canvas::efface_arbre(wxDC& dc)
                {
                PalettePerso p;
                dc.SetBackground(wxBrush(p.clLtGray,wxBRUSHSTYLE_SOLID));
                dc.Clear();
                //dc.SetBrush(wxBrush(*wxLIGHT_GREY,wxSOLID));
                //dc.FloodFill(1,1,*wxGREEN,wxFLOOD_SURFACE);
                }
//---------------------------------------------------------------------------
        void Canvas::trait_hymen(const Tindividu& t,wxDC& dc)
                {wxPoint p1;
                int pas=val_pas(dc);
                p1=centre_individu(t,dc);
                dc.SetPen(wxPen(*wxBLACK,1,wxPENSTYLE_SOLID));
                dc.DrawLine(p1.y,p1.x,p1.y+NBPAS*pas,p1.x);
                }
//---------------------------------------------------------------------------
        void Canvas::trait_fratrie(const Tindividu& t,wxDC& dc)
                {
                int pas=val_pas(dc);
                int nb=t.nb_enfant;
                int demi(NBPAS/2);// Mi distance entre deux individus
                wxPoint p1=centre_individu(t,dc);
                wxPoint p2=centre_individu(Arbre_en_cours->enfantde(t),dc);
                if (nb==1)
                   dc.DrawLine(p1.y+demi*pas,p1.x,p2.y,p2.x);
                if (nb>1)
                   {int j=0;
                   for (int i=1;i!=nb;++i)
                        {++j;
                        if (Arbre_en_cours->enfantde(t,i).marie) ++j;
                        }
                    dc.DrawLine(p2.y,p2.x-demi*pas,p2.y+j*NBPAS*pas,p2.x-demi*pas);
                    dc.DrawLine(p1.y+demi*pas,p1.x,p2.y+j*demi*pas,p2.x-demi*pas);
                   }
                }
//---------------------------------------------------------------------------
        void Canvas::dessine_arbre(const Tindividu& t,wxDC& dc)
                {
                Tindividu enfant;
                if (t.existe)
                        {if (t.marie&&!t.externe)
                                {trait_hymen(t,dc);
                                int i=t.nb_enfant;
                                if (i>0) trait_fratrie(t,dc);
                                dessine(Arbre_en_cours->epouxde(t),dc);
                                while(i>0)
                                        {
                                        enfant=Arbre_en_cours->enfantde(t,i);
                                        --i;
                                        dessine_arbre(enfant,dc);
                                        }
                              } //fin si marie
                        dessine(t,dc);
                        } //fin si existe
               }  //fin dessine
//---------------------------------------------------------------------------
        Tindividu Canvas::clic_gauche_individu(int x,int y)
                {
                Tindividu t;// T.existe false par construction
                int pas=val_pas();
                x-=offset*pas;y-=offset*pas;// Retire les marges
                int g= y/(NBPAS*pas);int n=x/(NBPAS*pas);
                t=Arbre_en_cours->Ind(g,n);
                double xn=x*1.0/pas;double yg=y*1.0/pas;
                xn=modulo_double(xn,NBPAS);yg=modulo_double(yg,NBPAS);// Un individu tous les NBPAS (quatre) pas
                if ((yg>PASIND)||(xn>PASIND)) t.existe=false;// Pointeur souris entre deux individus
                return(t);
                }
