#include "Calcule.h"
#include "ProjetdeBaseApp.h"
//typmod mode_trans_courant=AutosomalRec;
const int BaseNbMaxEssai=100000; // nombre max de base quelle que soit la précision(évite les recherches infinies).
long int NbMaxEssai=BaseNbMaxEssai;// nombre max pourra être ajusté jusqu'à 1000 fois BaseNbMaxEssai
const int NbMaxSansSucces=10000; //Nombre max d'arbres sans aucun arbre valide, pour éviter de
// perdre trop de temps sur les arbres impossibles.
long int Nb_Essai=100;  // Nombre maximum d'arbres valides considéré comme suffisant. Dépend de la précision souhaitée.

struct mtr
        {
        bool possible;
        float proba;
        };
std::vector <mtr> Mode_trans_record(5);// 5 substitué à LieAuSexeDom sinon plantage on exit non compris

float precision_souhaitee=5;
//---------------------------------------------------------------------------
// Espace de nommage Calcule
//---------------------------------------------------------------------------
namespace Calculs
{
Tarbre* meilleur;
Tarbre* Arbre_en_cours;
typmod* mode_trans_courant;
typechange_de_valeur* a_afficher;
//---------------------------------------------------------------------------
void initcalcule()
    {
    meilleur=new Tarbre();
    Arbre_en_cours=&firstwin()->Arbre_en_cours;
    mode_trans_courant=&firstwin()->mode_trans_courant;
    a_afficher=&firstwin()->echange;
    }
//---------------------------------------------------------------------------
// Déclaration des fonctions privée de l'espace Calculs
void purge_records();
bool donne_un_genotype_valide_a(Tindividu t,typmod md);
bool calcule_un_couple(typmod md, Tindividu t);
typmod meilleur_mode();
void affiche_rapport();
void pour_un_mode(typmod md);
//---------------------------------------------------------------------------
// Retourne un nombre pseudo aléatoire dans l'intervalle [0 100[
float alea()
        {return (float(rand())/RAND_MAX)*100;
        }
//---------------------------------------------------------------------------
// Tire au sort un des deux allèles du génotype de t comme dans une méiose
// la réponse est "vrai" si c'est un allèle "atteint
bool allele(Tindividu t)
        {
        switch (t.gen)
                {
                case homo_normal: return false;
                case homo_atteint:return true;
                default:return(alea()>50);
                }
        }
//---------------------------------------------------------------------------
// fonctions tugx tire un génotype en accord avec le mode de transmission et le génotype des parents
// C'est ici qu'est simulée la méiose et la fécondation
// fonctions cxx retourne vrai si le génotype tiré est compatible avec le phénotype observé.
//---------------------------------------------------------------------------
// Cas autosomal récessif
// Tire un génotype
Tgenotype tugar(const Tindividu& t)
        {if (t.externe||t.mere())
                {if (t.phe==atteint) return homo_atteint;
                else if ( alea()<(t.proba_hetero)) return hetero;
                        else return homo_normal;
                }
            else
                {switch (allele(Arbre_en_cours->parentde(t))+ allele(Arbre_en_cours->epouxde(Arbre_en_cours->parentde(t))))
                        {case 0:return homo_normal;
                        case 1:return hetero;
                        default:return homo_atteint;
                        }
                 }
        }
//---------------------------------------------------------------------------
// Compatibilité au phénotype
bool    car(const Tindividu& t)
        {if (t.phe==inconnu) return true;
        return (((t.gen!=homo_atteint)&&(t.phe==normal))||((t.gen==homo_atteint)&&(t.phe==atteint)));
        }
//---------------------------------------------------------------------------
// Cas autosomal dominant
// Tire un génotype
Tgenotype    tugad(const Tindividu& t)
        {if (t.externe||t.mere())
                {if (t.phe==normal) return homo_normal;
                else if ( alea()<(t.proba_hetero)) return hetero;
                        else return homo_atteint;
                }
            else
                {switch (allele(Arbre_en_cours->parentde(t))+ allele(Arbre_en_cours->epouxde(Arbre_en_cours->parentde(t))))
                        {case 0:return homo_normal;
                        case 1:return hetero;
                        default:return homo_atteint;
                        }
                 }
        }
//---------------------------------------------------------------------------
// Compatibilité au phénotype
bool    cad(const Tindividu& t)
        {if (t.phe==inconnu) return true;
        return (((t.gen==homo_normal)&&(t.phe==normal))||((t.gen!=homo_normal)&&(t.phe==atteint)));
        }
//---------------------------------------------------------------------------
// Cas lié au sexe récessif
// Tire un génotype
Tgenotype    tugsr(const Tindividu& t)
        {Tarbre* a=Arbre_en_cours;
        Tsexe sexe_individu=t.sexe;
        if (sexe_individu==embryon)
                {sexe_individu=feminin; if (alea()>50) sexe_individu=masculin;}
        if (sexe_individu==masculin)
                if (t.externe)
                                if (t.phe==atteint) return homo_atteint;
                                else return homo_normal;
                else { Tindividu maman_de_t=(a->parentde(t).sexe==feminin)? a->parentde(t):a->epouxde(a->parentde(t));
                                switch (allele(maman_de_t))
                                        {case false:return homo_normal;
                                        default:return homo_atteint;
                                        }
                              }
        else
                if (t.externe||t.mere())
                        if (t.phe==atteint) return homo_atteint;
                        else if (alea()<t.proba_hetero) return hetero;
                                                else return homo_normal;
                else switch (allele(a->parentde(t))+ allele(a->epouxde(a->parentde(t))))
                                {case 0:return homo_normal;
                                case 1:return hetero;
                                default:return homo_atteint;
                                }
        }
//---------------------------------------------------------------------------
// Compatibilité au phénotype
bool    csr(const Tindividu& t)
        {return car(t);
         }
//---------------------------------------------------------------------------
// Cas lié au sexe dominant
// Tire un génotype
Tgenotype tugsd(const Tindividu& t)
        {Tarbre* a=Arbre_en_cours;
        Tsexe sexe_individu=t.sexe;
        if (sexe_individu==embryon)
                {sexe_individu=feminin; if (alea()>50) sexe_individu=masculin;}
        if (sexe_individu==masculin)
                if (t.externe)
                        if (t.phe==atteint) return homo_atteint;
                                else return homo_normal;
                        else { Tindividu maman_de_t=(a->parentde(t).sexe==feminin)? a->parentde(t):a->epouxde(a->parentde(t));
                                switch (allele(maman_de_t))
                                        {case false:return homo_normal;
                                        default:return homo_atteint;
                                        }
                              }
                else
                if (t.externe||t.mere())
                        if (t.phe==normal) return homo_normal;
                                else if (alea()<t.proba_hetero) return hetero;
                                                else return homo_atteint;
                        else switch (allele(a->parentde(t))+ allele(a->epouxde(a->parentde(t))))
                                {case 0:return homo_normal;
                                case 1:return hetero;
                                default:return homo_atteint;
                                }
        }
//---------------------------------------------------------------------------
// Compatibilité au phénotype
bool    csd(const Tindividu& t)
        {return cad(t);
        }
//---------------------------------------------------------------------------
// Fonctions associées au tableau de résultat Mode_trans_record
//---------------------------------------------------------------------------
// Retourne la probabilité du mode de transmission md en pourcent
float proba_du_mode(const typmod& md)
        {float total=0;
        for (typmod i=AutosomalRec;i<=LieAuSexeDom;i=suivant(i))
                total+=Mode_trans_record[i].proba;
        return (Mode_trans_record[md].proba/(total+0.00001))*100;
        }
//---------------------------------------------------------------------------
    bool Mode_possible(typmod m)
        {
            return Mode_trans_record[m].possible;
        }
//---------------------------------------------------------------------------
void purge_records()
        {
        for (typmod i=TousLesModes;i<=LieAuSexeDom;i=suivant(i))
            {Mode_trans_record[i].possible=false;
            Mode_trans_record[i].proba=0;
            }
        }
//---------------------------------------------------------------------------
// Donne un génotype à t, vérifie la compatibilité génotype phénotpe
// en cas de succès, met à jour t dans l'arbre_en_cours en incrémentant la probabilité du génotype choisi
bool donne_un_genotype_valide_a(Tindividu t,typmod md)
        {

            switch(md)
            {
            case AutosomalRec:t.gen=tugar(t);break;
            case AutosomalDom:t.gen=tugad(t);break;
            case LieAuSexeRec:t.gen=tugsr(t);break;
            case LieAuSexeDom:t.gen=tugsd(t);break;
            default:;
            }
            bool possible=false;
            switch(md)
            {
            case AutosomalRec:possible=car(t);break;
            case AutosomalDom:possible=cad(t);break;
            case LieAuSexeRec:possible=csr(t);break;
            case LieAuSexeDom:possible=csd(t);break;
            default:;
            }
        if(!possible) return false;
        ++t.proba[t.gen];
        Arbre_en_cours->TableauInd[t.position.x][t.position.y]=t;
        return true;
        }
//---------------------------------------------------------------------------
// tire au sort un génotype conforme aux contraintes de l'arbre
// retourne vrai si l'individu pointé son conjoint et leur éventuelle descendance sont possibles
// appliqué à l'individu racine, tout l'arbre est évalué
bool calcule_un_couple(typmod md, Tindividu t)
        {
        if (!donne_un_genotype_valide_a(t,md)) return false;
        if (t.marie)
                {Tindividu epoux=Arbre_en_cours->epouxde(t);
                if (!donne_un_genotype_valide_a(epoux,md)) return false;
                if (t.nb_enfant>0)
                        for (int i=1;i<=t.nb_enfant;++i)
                        {Tindividu enfant=Arbre_en_cours->enfantde(t,i);
                        if (!calcule_un_couple(md,enfant)) return false;
                        }
                }
        return true;
        }
//---------------------------------------------------------------------------
// Retourne le mode qui donne l'arbre le plus plausible
typmod meilleur_mode()
        {float meilleur_total=0;
        typmod mode_resultat=TousLesModes;
        for (typmod i=AutosomalRec;i<=LieAuSexeDom;i=suivant(i))
                if (Mode_trans_record[i].possible)
                        if (Mode_trans_record[i].proba>meilleur_total)
                                {meilleur_total=Mode_trans_record[i].proba;
                                mode_resultat=i;
                                }
        return (mode_resultat);
        }
//---------------------------------------------------------------------------
// Avertissement émit en cas d'absence de solution
void affiche_rapport()
        {       Traducteur tr;
                if (!Arbre_en_cours->arbre_possible())
                wxMessageBox(tr.trad(wxT("Il n'y a pas de solution")));
        }
//---------------------------------------------------------------------------
long int Par_palier_de(long int nb)
        {
        //return pow(10.0,int(log10(nb)/2))+0.5;// l'arrondi int (pow...) se comporte différemment sous debug et release
        return (nb>100?(nb>10000?(nb>1000000?1000:100):10):1);
        }
//---------------------------------------------------------------------------
// Evalue les probabiités des génotypes de chaque individus pour un mode de transmission
// met à jour le tableau Mode_trans_Record qui permettra de comparer les différents modes
// Gère également les affichages en cours de calcul
// un nb_arbres_valides nul signalera un arbre impossible
void pour_un_mode(typmod md)
        {
        long int nb_arbres_valides=0,Nb_arbres_testes=0;
        // remet l'affichage à 0
        a_afficher->arbres_valides=0;
        a_afficher->total_arbres=0;
        a_afficher->curseur=0;
        //firstwin()->Refresh();
        Tmodes tm;
        Traducteur tr;
        Arbre_en_cours->purge_les_probas();

        for (int i=1;i<=NbMaxEssai;++i)
            {
            Tarbre provarbre,ancien_arbre;
             provarbre= *Arbre_en_cours;
             ancien_arbre= *Arbre_en_cours;
             Nb_arbres_testes++;
            if (TicTac(50))
            {
            wxTheApp->Yield(); // évite les freeze en vidant le tampon messages de Windows
            // wxGetApp().Yield() pose problème sous linux dans ce programme et je ne comprends pas pourquoi
            }
             if (calcule_un_couple(md,Arbre_en_cours->Ind(0,0)))// Va parcourir tout l'arbre puisqu'il commence par l'individu racine
                {++nb_arbres_valides;
                // Afficher à chaque fois les nombres d'arbres double approximativement le temps de calcul
                if(!(nb_arbres_valides % Par_palier_de(nb_arbres_valides)))
                        {
                        float precision_atteinte=Arbre_en_cours->ecart_entre_deux_arbres(ancien_arbre);
                        // Les fluctuations entre deux arbres successifs permettent d'évaluer la précision atteinte
                        if (precision_souhaitee>precision_atteinte)
                                i=NbMaxEssai;
                        a_afficher->curseur=int((precision_souhaitee/(precision_atteinte+0.01))*100);
                        a_afficher->arbres_valides=nb_arbres_valides;
                        a_afficher->total_arbres=Nb_arbres_testes;
                        firstwin()->Refresh();
                        firstwin()->Update();
                        ancien_arbre= *Arbre_en_cours;
                        }
                if (nb_arbres_valides>Nb_Essai) i=NbMaxEssai; //Suffisamment d'arbres valides
                }
                else *Arbre_en_cours=provarbre;// L'arbre était impossible, Restaure l'arbre à l'état précen
             // Pas d'arbre valide trouvé en NbMaxSansSucces essais* effectif de l'arbre, l'arbre est réputé impossible
             if ((i>=NbMaxSansSucces*(Arbre_en_cours->nb_individus()))&&(!nb_arbres_valides)) i=NbMaxEssai;
             // Abandon de la simulation
             if (!a_afficher->calcul_en_cours) i=NbMaxEssai;
             }
        Mode_trans_record[md].possible=(nb_arbres_valides>0);
        Mode_trans_record[md].proba=nb_arbres_valides/(Nb_arbres_testes+0.00001);
        firstwin()->item_menu_change=true;
        firstwin()->Refresh();
        firstwin()->Update();
        }
//---------------------------------------------------------------------------
// Evalue l'abre pour le ou les modes choisis
// En sortie Arbre_en_cours contient l'état correspondant au mode le plus probable
// mode_trans_courant contient le mode qui donne l'arbre le plus probable
void calcule_un_arbre(int indexprecision,int indexnbmaxarbre)
        {
        precision_souhaitee=a_afficher->precision(indexprecision);
        Nb_Essai=a_afficher->n_arbre_valides(indexprecision)*1000;
        NbMaxEssai=BaseNbMaxEssai;
        for(int i=1;i<=indexnbmaxarbre;i++) NbMaxEssai*=10;
        srand((unsigned)time(NULL));
        purge_records();
        if (Arbre_en_cours->nb_individus()>0)
            {
              if (*mode_trans_courant==TousLesModes)
                           {*meilleur= (*Arbre_en_cours);
                           for (typmod i=AutosomalRec;i<=LieAuSexeDom;i=suivant(i))
                                {pour_un_mode(i);
                                if (i==meilleur_mode()) (*meilleur)= (*Arbre_en_cours);
                                }
                           *Arbre_en_cours=(*meilleur);
                           }
                   else pour_un_mode(*mode_trans_courant);
            *mode_trans_courant=meilleur_mode();
            }
        affiche_rapport(); // Affiche une alerte seulement si aucun arbre n'est trouvé
        }
}
// Fin espace de nommage calcule
