#ifndef BOITEAOUTILS_H_INCLUDED
#define BOITEAOUTILS_H_INCLUDED
/*
    Arbregen permet de construire des arbres généalogiques puis de donner une valeur approchée pour les probabilités des différents génotypes.
    Copyright (C) 1997 (version Dos) 2009-2023 Vial Jean-Luc Annecy
    Contact email: vial.frjl@free.fr

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <vector>
#include <map>
#include <wx/string.h>
#include <wx/wx.h>
#include <wx/print.h>
//---------------------------------------------------------------------------
// Déclaration du Printout utilisé
class BasePrintout: public wxPrintout
{
 public:
  explicit BasePrintout(const wxString title);
  void FixeFontEtTaille();
  void OnPreparePrinting();
};
//---------------------------------------------------------------------------
// Utilitaires divers
template<class Te> Te suivant(Te m)
{
        return (Te(int(m)+1));
};
//---------------------------------------------------------------------------
        void RenommeEnfants(wxWindow* Sujet);
//---------------------------------------------------------------------------
// Traducteur
//---------------------------------------------------------------------------
        typedef enum {fr,ang,esp}langues;
        class Traducteur
{
        typedef std::map<langues,wxString> Dictionnaire;
        std::map<wxString,Dictionnaire>textes;
        void ajoute_une_entree(wxString Tf,wxString Ta,wxString Te);
public:
        Traducteur();
        void langue_demarrage();
        langues& fixe_langue();
        wxString trad(wxString T);
        wxString trad_tout(wxString T);
};
//---------------------------------------------------------------------------
// Paramètres globaux
        wxColor& Couleur_Fenetres_defaut();
        wxRect& Taille_Fenetres_defaut();
        void FixeFontEtTaille(wxWindow* fen);
        class PalettePerso
{
public:
        PalettePerso();
        wxColour clDkGray,clCream,clAqua,clLtGray,clRed,clBlack,clYellow,clLime;
};
//---------------------------------------------------------------------------
// Conversion taille et position virtuelle sur une grille 1000 x 1000 en taille réelle sur la fenêtre
        wxPoint FaitReelle_Pos(wxPoint posvirtuelle,wxWindow* fen);
        wxSize FaitReelle_Taille(wxSize Sizevirtuelle,wxWindow* fen);
        void Ajuste_taille_et_pos(wxPoint pos,wxSize taille,wxWindow* fen_mere,wxWindow* fen_fille);
        bool TicTac(int periode);
        double modulo_double(double dividende, double diviseur);
//---------------------------------------------------------------------------
#endif //BOITEAOUTILS_H_INCLUDED
