#include "BoiteAOutils.h"
#include <wx/intl.h>
#include <wx/tooltip.h>
//---------------------------------------------------------------------------
// Gestion des impressions
//---------------------------------------------------------------------------
// Implémentation du Printout minimal
BasePrintout::BasePrintout(const wxString title =wxT("My printout")):wxPrintout(title){}
//---------------------------------------------------------------------------
void BasePrintout::FixeFontEtTaille()
{
    wxDC *dc = GetDC();
    if (dc)
    {
        dc->SetUserScale(1, 1);
        wxFont fnt(10, wxFONTFAMILY_SWISS, wxFONTSTYLE_ITALIC, wxFONTWEIGHT_NORMAL);
        dc->SetFont(fnt);
    }
}
//---------------------------------------------------------------------------
void BasePrintout::OnPreparePrinting()
{
    FixeFontEtTaille();
}
//---------------------------------------------------------------------------
// Fin gestion impression
//---------------------------------------------------------------------------
//      Implémentation de l'objet Traducteur
//---------------------------------------------------------------------------
        void Traducteur::ajoute_une_entree(wxString Tf,wxString Ta,wxString Te)
{
        Dictionnaire di;
        di.insert(std::make_pair(ang,Ta));
        di.insert(std::make_pair(esp,Te));
        textes.insert(std::make_pair(Tf,di));
}
//---------------------------------------------------------------------------
        Traducteur::Traducteur()
{
        ajoute_une_entree(wxT("&A propos"),wxT("&About"),wxT("&Acerca de Arbregen"));
        ajoute_une_entree(wxT("&Calcul"),wxT("&Compute"),wxT("&Calcula"));
        ajoute_une_entree(wxT("&Enregistrer"),wxT("&Save"),wxT("&Almacenar"));
        ajoute_une_entree(wxT("&Nouvel arbre"),wxT("&New tree"),wxT("&Nuevo árbol"));
        ajoute_une_entree(wxT("&Outils"),wxT("&Tools"),wxT("&Herramientas"));
        ajoute_une_entree(wxT("&Ouvrir"),wxT("&Open..."),wxT("&Abrir"));
        ajoute_une_entree(wxT("&Quitter"),wxT("&Exit"),wxT("&Salir"));
        ajoute_une_entree(wxT("&Réglage précision"),wxT("&Accuracy tuning"),wxT("&Ajuste de la precisión"));
        ajoute_une_entree(wxT("&Rubriques d'aide"),wxT("&help topics"),wxT("Rubricas de ayuda"));
        ajoute_une_entree(wxT("00,00"),wxT("00.00"),wxT("00,00"));
        ajoute_une_entree(wxT("3 mars 1997 / mars 2024"),wxT("3-Mar-1997 / March-2024"),wxT("3 de Mayo de 1997 /Marzo 2024"));
        ajoute_une_entree(wxT("A propos"),wxT("About"),wxT("Acerca de Arbregen"));
        ajoute_une_entree(wxT("Aide"),wxT("Help"),wxT("Ayuda"));
        ajoute_une_entree(wxT("Ajoute"),wxT("Add"),wxT("Añade"));
        ajoute_une_entree(wxT("Annule"),wxT("Cancel"),wxT("Cancela"));
        ajoute_une_entree(wxT("Après calcul"),wxT("Observed"),wxT("Al cabo del cálculo"));
        ajoute_une_entree(wxT("arbregenfrahlp"),wxT("arbregenenghlp"),wxT("arbregenesphlp"));
        ajoute_une_entree(wxT("Arbres  testés"),wxT("Scanned trees"),wxT("Árboles recurridos"));
        ajoute_une_entree(wxT("Arbres généalogiques"),wxT("Pedigree"),wxT("Árboles genealógicos"));
        ajoute_une_entree(wxT("Arrêt"),wxT("Stop"),wxT("Parar"));
        ajoute_une_entree(wxT("Atteint"),wxT("Affected"),wxT("Afectado"));
        ajoute_une_entree(wxT("Autosomal Dominant"),wxT("Autosomal dominant"),wxT("Autosómico dominante"));
        ajoute_une_entree(wxT("Autosomal Récessif"),wxT("Autosomal recessive"),wxT("Autosómico recesivo"));
        ajoute_une_entree(wxT("Avertissement"),wxT("Disclaimer"),wxT("Advertencia"));
        ajoute_une_entree(wxT("Defaut"),wxT("Default"),wxT("afalta"));
        ajoute_une_entree(wxT("DisclaimimageFra.png"),wxT("DisclaimimageEng.png"),wxT("DisclaimimageEsp.png"));
        ajoute_une_entree(wxT("Echap pour interrompre"),wxT("Esc Key to stop"),wxT("Tecla Esc para parar"));
        ajoute_une_entree(wxT("Embryon"),wxT("Embryo"),wxT("Embrión"));
        ajoute_une_entree(wxT("En cours: "),wxT("Checking: "),wxT("En curso"));
        ajoute_une_entree(wxT("Enregistrer &sous..."),wxT("Save &as..."),wxT("Almacenar &como"));
        ajoute_une_entree(wxT("Enregistrer l'arbre en cours"),wxT("Save the current tree"),wxT("Almacenar el árbol corriente"));
        ajoute_une_entree(wxT("Erreur visée"),wxT("Expected accuracy"),wxT("Precisión apuntada"));
        ajoute_une_entree(wxT("Erreur: format de fichier incorrect"),wxT("Error: invalid file type"),wxT("Error: tipo de archivo incorrecto"));
        ajoute_une_entree(wxT("Erreur: impossible d'ouvrir le fichier "),wxT("Error: unable to open the file "),wxT("Error: imposible abrir este archivo"));
        ajoute_une_entree(wxT("Erreur"),wxT("Error"),wxT("Error"));
        ajoute_une_entree(wxT("Externe"),wxT("External"),wxT("Externo"));
        ajoute_une_entree(wxT("Femelle"),wxT("Female"),wxT("Hembra"));
        ajoute_une_entree(wxT("Fermer"),wxT("Close"),wxT("Cerrar"));
        ajoute_une_entree(wxT("Fiche d'identité"),wxT("Identity form"),wxT("Ficha de identidad"));
        ajoute_une_entree(wxT("Fichier arbre en cours"),wxT("Current tree file"),wxT("Archivo del árbol corriente"));
        ajoute_une_entree(wxT("Fichier d'aide non trouvé\n"),wxT("Help file not found\n"),wxT("Falta el archivo de ayuda "));
        ajoute_une_entree(wxT("Fichier"),wxT("Files"),wxT("Archivo"));
        ajoute_une_entree(wxT("Fichiers arbregen"),wxT("Arbregen files"),wxT("Archivos de arbregen"));
        ajoute_une_entree(wxT("Fichiers"),wxT("Files"),wxT("Archivos"));
        ajoute_une_entree(wxT("Garçon"),wxT("Boy"),wxT("Niño"));
        ajoute_une_entree(wxT("Génération"),wxT("Generation"),wxT("Generación"));
        ajoute_une_entree(wxT("Génotype"),wxT("Genotype"),wxT("Genotipo"));
        ajoute_une_entree(wxT("Il n'y a pas de solution"),wxT("No available solution"),wxT("Ninguna solución encontrada"));
        ajoute_une_entree(wxT("Impossible !"),wxT("No way !"),wxT("Imposible !"));
        ajoute_une_entree(wxT("Impression"),wxT("Print"),wxT("Impresión"));
        ajoute_une_entree(wxT("Inconnu"),wxT("Unknown"),wxT("Desconocido"));
        ajoute_une_entree(wxT("Indemne"),wxT("Unaffected"),wxT("Normal"));
        ajoute_une_entree(wxT("Interprétation d'arbres généalogiques"),wxT("Pedigrees and genotypes"),wxT("Árboles genealógicos y genotipos"));
        ajoute_une_entree(wxT("Lance un calcul"),wxT("Starts computation"),wxT("Empieza el cálculo"));
        ajoute_une_entree(wxT("Langue"),wxT("Language"),wxT("Idioma"));
        ajoute_une_entree(wxT("Lié Au sexe Dominant"),wxT("Sex linked dominant"),wxT("Ligado al sexo dominante"));
        ajoute_une_entree(wxT("Lié au sexe Récessif"),wxT("Sex linked recessive"),wxT("Ligado al sexo recesivo"));
        ajoute_une_entree(wxT("Mâle"),wxT("Male"),wxT("Varón"));
        ajoute_une_entree(wxT("Marié"),wxT("Married"),wxT("Casado"));
        ajoute_une_entree(wxT("Max arbres"),wxT("Max Trees"),wxT("Max árboles"));
        ajoute_une_entree(wxT("Mode de transmission"),wxT("Transmission modes"),wxT("Modo de transmisión"));
        ajoute_une_entree(wxT("Modifie"),wxT("Change"),wxT("Cambia"));
        ajoute_une_entree(wxT("Modifier"),wxT("Edit"),wxT("Cambiar"));
        ajoute_une_entree(wxT("nom"),wxT("name"),wxT("nombre"));
        ajoute_une_entree(wxT("Nombre d'enfants"),wxT("Number of children"),wxT("Número de niños"));
        ajoute_une_entree(wxT("Nombre maximum d'arbres examinés"),wxT("Max number of trees screened"),wxT("Número máximo de arboles recurridos"));
        ajoute_une_entree(wxT("Non déterminé"),wxT("Undefined"),wxT("Indeterminado"));
        ajoute_une_entree(wxT("Non"),wxT("No"),wxT("No"));
        ajoute_une_entree(wxT("Nouv. nom"),wxT("New name"),wxT("Nuervo nombre"));
        ajoute_une_entree(wxT("Nouvel arbre"),wxT("New tree"),wxT("Nuevo árbol"));
        ajoute_une_entree(wxT("Numéro dans la génération"),wxT("Place in this generation"),wxT("Número en esta generación"));
        ajoute_une_entree(wxT("ou"),wxT("or"),wxT("o"));
        ajoute_une_entree(wxT("Oui"),wxT("Yes"),wxT("Sí"));
        ajoute_une_entree(wxT("Outils"),wxT("Tools"),wxT("Herramientas"));
        ajoute_une_entree(wxT("Ouvrir un arbre existant"),wxT("Open a tree"),wxT("Abrir un árbol"));
        ajoute_une_entree(wxT("Phénotype"),wxT("Phenotype"),wxT("Fenotipo"));
        ajoute_une_entree(wxT("Précision"),wxT("Accuracy"),wxT("Precisión"));
        ajoute_une_entree(wxT("Prévisualisation"),wxT("Preview"),wxT("Preestreno"));
        ajoute_une_entree(wxT("Probabilités"),wxT("Probabilities"),wxT("Probabilidades"));
        ajoute_une_entree(wxT("Projet de base"),wxT("Bottom line project"),wxT("Proyecto básico"));
        ajoute_une_entree(wxT("Quitter"),wxT("Exit"),wxT("Salida"));
        ajoute_une_entree(wxT("Réglage précision"),wxT("Accuracy tuning"),wxT("Ajuste de precisión"));
        ajoute_une_entree(wxT("Renomme"),wxT("Rename"),wxT("Nuevo nombre"));
        ajoute_une_entree(wxT("sans titre"),wxT("untitled"),wxT("Sin título"));
        ajoute_une_entree(wxT("Sexe"),wxT("Gender"),wxT("Sexo"));
        ajoute_une_entree(wxT("Supprimer"),wxT("Delete"),wxT("Suprimir"));
        ajoute_une_entree(wxT("Terminé"),wxT("Task completed"),wxT("Acabado"));
        ajoute_une_entree(wxT("Tous fichiers"),wxT("All files"),wxT("Todos achivos"));
        ajoute_une_entree(wxT("Tous les Modes"),wxT("All modes"),wxT("Todos modos"));
        ajoute_une_entree(wxT("Valider"),wxT("Confirm"),wxT("Confirmar"));
        ajoute_une_entree(wxT("Valides"),wxT("Valids"),wxT("Válido"));
}
//---------------------------------------------------------------------------
        langues& Traducteur::fixe_langue()
{
        static langues Langue_active=fr;
        return Langue_active;
}
//---------------------------------------------------------------------------
        //fixe la langue de départ
        void Traducteur::langue_demarrage()
{
        wxString lg;
        wxGetEnv(wxT("LANG"),&lg);
        lg=lg.Left(2);
        if (lg==wxT("en")) fixe_langue()=ang;
        if (lg==wxT("es")) fixe_langue()=esp;
}
//---------------------------------------------------------------------------
        wxString Traducteur::trad(wxString T)
{
        if (textes.find(T)==textes.end()) return T;
        langues L=fixe_langue();
        if (L==fr) return T;
        return textes[T][L];
}
//---------------------------------------------------------------------------
        wxString Traducteur::trad_tout(wxString T)
{
        wxString traduction=T;
        for(std::map<wxString,Dictionnaire>::iterator i=textes.begin();i!=textes.end();++i)
                if (T==i->first) traduction=trad(T);
                else  for(langues j=suivant(fr);j<=esp;j=suivant(j))
                        if (T==i->second[j])
                                traduction=trad(i->first);
        return traduction;
}
//---------------------------------------------------------------------------
//      Fin de l'objet Traducteur
//---------------------------------------------------------------------------
wxColor& Couleur_Fenetres_defaut()
{
        static wxColor couleur_fen=wxSystemSettings::GetColour(wxSYS_COLOUR_ACTIVEBORDER);
        return couleur_fen;
}
wxRect& Taille_Fenetres_defaut()
{
        //Fixe une position et une taille initiale
        // format pos.x, pos.y, Largeur, Hauteur
        static wxRect taille_fen(100,50,700,550);
        return taille_fen;
}
//---------------------------------------------------------------------------
        PalettePerso::PalettePerso():clDkGray(128,128,128),clCream(255,251,240),clAqua(0,255,255),clLtGray(192,192,192),clRed(255,0,0),clBlack(0,0,0),
                                    clYellow(255,255,0),clLime(0,255,0)
        {
        }
wxPoint FaitReelle_Pos(wxPoint posvirtuelle,wxWindow* fen)
{
        int X= fen->GetClientSize().GetWidth();
        int Y= fen->GetClientSize().GetHeight();
        return wxPoint(int(posvirtuelle.x*X/1000.0),int(posvirtuelle.y*Y/1000.0));
}
wxSize FaitReelle_Taille(wxSize Sizevirtuelle,wxWindow* fen)
{
        int X= fen->GetClientSize().GetWidth();
        int Y= fen->GetClientSize().GetHeight();
        Sizevirtuelle.Scale(float(X/1000.0),float(Y/1000.0));
        return Sizevirtuelle;
}
void Ajuste_taille_et_pos(wxPoint pos,wxSize taille,wxWindow* fen_mere,wxWindow* fen_fille)
{
        pos=FaitReelle_Pos(pos,fen_mere);
        taille=FaitReelle_Taille(taille,fen_mere);
        fen_fille->SetSize(wxRect(pos,taille));
}
void FixeFontEtTaille(wxWindow* fen)
{
        wxFont Police(fen->GetFont());
        Police.SetPointSize(8);
        fen->SetFont(Police);
}
//---------------------------------------------------------------------------
void RenommeEnfants(wxWindow* Sujet)
{
        Traducteur tr;
        wxToolTip* tt;
        wxFrame* p_frame;
        // Sous Windows Setlabel ajuste correctement le titre des "Frames' mais pas sous Linux
        // d'où la nécessité de distinguer WxXindow et wxFrame
        p_frame=dynamic_cast<wxFrame*>(Sujet);
        if (p_frame!=NULL) // C'est une wxWFrame
            p_frame->SetTitle(tr.trad_tout(p_frame->GetTitle()));
        else // C'est une simple wxWindow
            Sujet->SetLabel(tr.trad_tout(Sujet->GetLabel()));
        tt=Sujet->GetToolTip();
        if (tt!=NULL)
            Sujet->SetToolTip(tr.trad_tout(tt->GetTip()));
        // Même chose pour les enfants
        wxWindowList list;
        list=Sujet->GetChildren();
        wxWindowList::compatibility_iterator node;
        for (node = list.GetFirst(); node; node = node->GetNext() )
            {
            wxWindow *current = node->GetData();
            RenommeEnfants(current);
            }
}
//---------------------------------------------------------------------------
bool TicTac(int periode)
{
    static int compteur;
    return (!(++compteur % periode));
}
//-------------------------------------------------------------------------
// Modulo_double
// la fonction standard fmod donne un résultat ... non standard pour les nombres négatifs
double modulo_double(double dividende, double diviseur)
{
    double resultat(fmod(dividende,diviseur));
    resultat=(resultat<0?resultat+diviseur:resultat);
    return resultat;
}
