#ifndef MAINFRAME_H_INCLUDED
#define MAINFRAME_H_INCLUDED
/*
    SquirrelPocketCalc. Copyright (C) 2015 - 2021
    Vial Jean-Luc Annecy
    Contact email: vial.frjl@free.fr

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

// On ajoute les headers "basiques" de wxWidgets
#include <wx/wx.h>
#include "BoiteAOutils.h"
#include "Calcule.h"
#include <wx/html/helpctrl.h>
#include <wx/richtext/richtextctrl.h>
//---------------------------------------------------------------------------
// Objets propres au programme
//---------------------------------------------------------------------------
class Erreur_SC
{
  public:
  wxString message;
  explicit Erreur_SC(wxString message_erreur);
};
//---------------------------------------------------------------------------
// Modes possibles pour la calculette
typedef enum {int_composes,abaque_pret,per_ordinaire,per_a_echoir} type_de_modes;
//---------------------------------------------------------------------------
// Noms des modes en clair
//---------------------------------------------------------------------------
class Modes_Calculette
{
public:
    Modes_Calculette();
    wxString Nom_mode(type_de_modes m);
private:
    std::map<type_de_modes,wxString> contenu;
};
class APropos;
//---------------------------------------------------------------------------
// variables globales
//---------------------------------------------------------------------------
type_de_modes& mode_courant();
//---------------------------------------------------------------------------
// Dfinition de la classe "MainFrame"
class MainFrame : public wxFrame
{
public:
// Le constructeur
MainFrame();
// Le destructeur
~MainFrame();
        bool init_done;
        bool item_menu_change;
        bool taille_modifiee;
        bool calcul_en_cours;
        bool affichage_en_cours;
        wxString Titre_Fen;
        std::map<type_de_valeurs,wxTextCtrl*> FenBoutTable;
        // Aide
        wxHtmlHelpController* helpController;
        // Boite texte affichage des rsultats
        //wxTextCtrl* Fen_result;
        wxRichTextCtrl* Fen_result;
        static const long idFen_result;
        // Boutons choix de mode de fonctionnement
        wxButton* BoutChoix1;
        static const long idBoutChoix1;
        void OnBoutChoix1(wxCommandEvent& event);
        wxButton* BoutChoix2;
        static const long idBoutChoix2;
        void OnBoutChoix2(wxCommandEvent& event);
        wxButton* BoutChoix3;
        static const long idBoutChoix3;
        void OnBoutChoix3(wxCommandEvent& event);
        wxButton* BoutChoix4;
        static const long idBoutChoix4;
        void OnBoutChoix4(wxCommandEvent& event);
        //Boutons et boites de saisies associes
        wxButton* Bout1;
        static const long idBout1;
        void OnBout1(wxCommandEvent& event);
        wxTextCtrl* FenBout1;
        static const long idFenBout1;
        void OnFenBout1(wxCommandEvent& event);
        wxButton* Bout2;
        static const long idBout2;
        void OnBout2(wxCommandEvent& event);
        wxTextCtrl* FenBout2;
        static const long idFenBout2;
        void OnFenBout2(wxCommandEvent& event);
        wxButton* Bout3;
        static const long idBout3;
        void OnBout3(wxCommandEvent& event);
        wxTextCtrl* FenBout3;
        static const long idFenBout3;
        void OnFenBout3(wxCommandEvent& event);
        wxButton* Bout4;
        static const long idBout4;
        void OnBout4(wxCommandEvent& event);
        wxTextCtrl* FenBout4;
        static const long idFenBout4;
        void OnFenBout4(wxCommandEvent& event);
        wxButton* Bout5;
        static const long idBout5;
        void OnBout5(wxCommandEvent& event);
        wxTextCtrl* FenBout5;
        static const long idFenBout5;
        void OnFenBout5(wxCommandEvent& event);
        wxButton* Bout6;
        static const long idBout6;
        void OnBout6(wxCommandEvent& event);
        wxTextCtrl* FenBout6;
        static const long idFenBout6;
        void OnFenBout6(wxCommandEvent& event);
        wxButton* Bout7;
        static const long idBout7;
        void OnBout7(wxCommandEvent& event);
        wxTextCtrl* FenBout7;
        static const long idFenBout7;
        void OnFenBout7(wxCommandEvent& event);

        wxString NomFichier;

        wxPrintData* g_printData;

private:
        // Utilitaires
        wxPoint ALaPlace(int x,int y);
        void Affiche_chaine(wxString ch); //pour test
        // Noms par dfaut
        wxString InitDir;
        wxString DonneesDir;
        wxString DonneesVarDir;
        wxString NomComplet();
        void Bouton_de_choix(type_de_modes m);
        void Affiche_les_bons_boutons();
        void Affichage_valeurs();
        void Affichage_tableau();
        void saisie_val(wxTextCtrl* boite_active,type_de_valeurs typval);
        bool Affiche_resultat_calcul(type_de_valeurs typval,double val);
        bool charge_fichier(wxString nomfich);
        void FileOpen(wxCommandEvent& event);
        void FilesOpen(wxCommandEvent& event);
        void FileSave(wxCommandEvent& event);
        void FileSaveAs(wxCommandEvent& event);
        void OnImprime(wxCommandEvent& event);
        void OnQuit(wxCommandEvent& event);
        void OnClose(wxCloseEvent& event);
        void OnDisclaimer(wxCommandEvent& event);
        void OnAbout(wxCommandEvent& event);
        void OnHelp(wxCommandEvent& event);
        void Onfr(wxCommandEvent& event);
        void Onen(wxCommandEvent& event);
        void OnCloseAbout(wxCommandEvent& event);
        void OnPaint(wxPaintEvent& event);
        void rafraichit();
        void OnSize(wxSizeEvent& event);

        // Identificateurs
        static const long idMenuQuit;
        static const long idMenuImprime;
        static const long idMenuDisclaimer;
        static const long idMenuAbout;
        static const long idMenuHelp;
        static const long idMenufr;
        static const long idMenuen;
        static const long idMenuToolbar1;
        static const long ID_DIALOGS_FILES_OPEN;
        static const long ID_DIALOGS_FILE_SAVE;
        static const long ID_DIALOGS_FILE_SAVE_AS;
        static const long idaproposinst;

        static const long idOnPaint;

        APropos* AProposinst;

        DECLARE_EVENT_TABLE()
};
//---------------------------------------------------------------------------
        // Variable globale retournant un pointeur vers la fentre principale
        MainFrame*& firstwin();
//---------------------------------------------------------------------------
#endif // MAINFRAME_H_INCLUDED
