#include "ProjetdeBase.h"
#include "APropos.h"
#include "../Icones/SquirrelPocketCalc32.xpm"
#include "../Icones/impr16.xpm"
#include "../Icones/go16.xpm"
#include "../Icones/sortie16.xpm"
#include "../Icones/files16.xpm"
#include "../Icones/fr16.xpm"
#include "../Icones/eng16.xpm"
#include "../Icones/help16.xpm"
#include "../Icones/save16.xpm"
#include <wx/file.h>
#include <wx/filename.h>
#include <wx/stdpaths.h>
#include <wx/splash.h>
#include "wx/filesys.h"
#include "wx/fs_zip.h"
#include <wx/dcps.h>
#include <wx/print.h>
//---------------------------------------------------------------------------
//Constantes de paramtrages
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
//Variables utilises pour tests
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
// variables globales
//--------------------------------------------------------------------------
MainFrame*& firstwin()
{
    static MainFrame* fen=0;
    return fen;
}
//--------------------------------------------------------------------------
type_de_modes& mode_courant()
{
    static type_de_modes modcrt=int_composes;
    return modcrt;
}
//---------------------------------------------------------------------------
// Conteneur de donnes
//--------------------------------------------------------------------------
Jeu_de_valeurs Valeurs_courantes;
//---------------------------------------------------------------------------
wxString Statut_epargne_ou_pret()
{
    Traducteur tr;
    wxString ep_ou_pret(wxT("Compte pargne")),ordinaire_ou_a_echoir(wxT("chance ordinaire (en fin de priode)"));
    if (Valeurs_courantes.contenu[ValeurInit].Valeur()>=Valeurs_courantes.contenu[ValeurFinale].Valeur())
        ep_ou_pret=(wxT("Remboursement de prt"));
    if (!Valeurs_courantes.periode_ordinaire) ordinaire_ou_a_echoir=(wxT("opration  echoir (en dbut de priode"));
    return tr.trad(ep_ou_pret)+tr.trad(" avec ")+tr.trad(ordinaire_ou_a_echoir);
}
//---------------------------------------------------------------------------
// Gestion des impressions
//---------------------------------------------------------------------------
// Dclaration du Printout utilis

class BilanPrintout: public wxPrintout
{
 public:
    explicit BilanPrintout(const wxString title = wxT("My printout")):wxPrintout(title),margeG(2),margeB(6), Nb_de_pages(1){}
    int margeG,margeB;
    void FixeFontEtTaille();
    float correctif_preview();
    void OnPreparePrinting();
    bool OnPrintPage(int page);
    int Nb_de_pages;
    void Tabule_ecrit(wxString st,wxPoint pos);
    int Nombre_de_lignes_par_pages();
    int Nombre_de_pages();
    bool OnBeginDocument(int startpage,int endpage);
    bool HasPage(int page);
    void GetPageInfo(int *minPage, int *maxPage, int *selPageFrom, int *selPageTo);
    bool PrintPage_Interet_Composes(int page);
    bool PrintPage_Tableau_annuites(int page);
};
//---------------------------------------------------------------------------
void BilanPrintout::OnPreparePrinting()
{
   FixeFontEtTaille();
   Nb_de_pages=Nombre_de_pages();
}
//---------------------------------------------------------------------------
float BilanPrintout::correctif_preview()
{
    // Correctif pitoyable mais je n'ai pas trouv mieux pour le moment
    #if defined(__WXMSW__)
    return (IsPreview()?1.7:1.6);
    #elif defined(__UNIX__)
    return(IsPreview()?2.0:2.4);
    #endif
}
//---------------------------------------------------------------------------
void BilanPrintout::FixeFontEtTaille()
{
    wxDC *dc = GetDC();
    if (dc)
    {
    // la police est mise  l'chelle lors de l'impression
    // cela tient compte des diffrences de dfinition entre l'cran et la page imprime
    // ainsi que de la diffrence de taille entre les deux.

    // le bloc suivant peut tre remplac par l'instruction MapScreenSizeToPage()
    // mais le rsultat semble moins prcis
    int ppiScreenX, ppiScreenY;
    GetPPIScreen(&ppiScreenX, &ppiScreenY);
    int ppiPrinterX, ppiPrinterY;
    GetPPIPrinter(&ppiPrinterX, &ppiPrinterY);
    float scale = (float)((float)ppiPrinterX/(float)ppiScreenX);
    int pageWidth, pageHeight;
    int w, h;
    dc->GetSize(&w, &h);
    GetPageSizePixels(&pageWidth,&pageHeight);
    float overallScale =scale*(float)(w/(float)pageWidth);
    dc->SetUserScale(overallScale, overallScale);
    // Fin du bloc
    // Gestion descouleurs d'impression
    dc->SetBackground(*wxWHITE_BRUSH);
    dc->SetFont(wxFont(10,wxFONTFAMILY_DEFAULT,wxFONTSTYLE_ITALIC,wxFONTWEIGHT_NORMAL,false));
    // Dbut bloc correction fond noir
    // Ce bloc est ncessaire du fait d'un bug sous Linux depuis Ubuntu 18.04
    // Si on ne trace pas un rectangle (non blanc!) la page est imprime en noir
    dc->SetBrush(wxBrush(wxColour(254,255,255)));
    dc->Clear();
    int L,H;dc->GetSize(&L,&H);
    dc->DrawRectangle(0,0,L,H);
    //Fin bloc correction fond noir
    }
}
//---------------------------------------------------------------------------
bool BilanPrintout::OnBeginDocument(int startpage,int endpage)
{
    if (!wxPrintout::OnBeginDocument(startpage, endpage))
    {
        return false;
    }
    return true;
}
//---------------------------------------------------------------------------
bool BilanPrintout::HasPage(int page)
{   // HasPage n'est pas appel avant OnPrintPage pour la premire page affiche
    // Mais est appele d'abord pour toutes les autres pages.
    return page<=Nb_de_pages;
}
//---------------------------------------------------------------------------
void BilanPrintout::GetPageInfo(int *minPage, int *maxPage, int *selPageFrom, int *selPageTo)
{
    (*minPage)=1;// un appel direct de Nombre_de_pages() serait plus logique, mais il semble y avoir un bug
    (*maxPage)=Nb_de_pages;// GetPageInfo semble parfois appele avant qu'un wxDC valide existe (le test de "if (dc)" ne suffit pas
                        // l'appel de sc->GetSize() fait planter le programme
    (*selPageFrom)=1;
    (*selPageTo)=(*maxPage);
}
//---------------------------------------------------------------------------
bool BilanPrintout::OnPrintPage(int page)
{
    bool correct=(Valeurs_courantes.mode_tableau_on?PrintPage_Tableau_annuites(page):PrintPage_Interet_Composes(page));
    return correct;
}
//---------------------------------------------------------------------------
bool BilanPrintout::PrintPage_Interet_Composes(int page)
{
    wxDC *dc = GetDC();
    if (dc)
    {
        FixeFontEtTaille();
        Tabule_ecrit(wxString::Format(wxT("PAGE %d"),page),wxPoint(0,0));
        Traducteur tr;
        int ligne(2);
        Tabule_ecrit(tr.trad(Statut_epargne_ou_pret()),wxPoint(margeG,ligne++));
        wxPoint decale(0,0);
         for (type_de_valeurs i=ValeurInit;i<=TauxNominal;i=suivant(i))
            {
            Tabule_ecrit(tr.trad(Valeurs_courantes.contenu[i].NomVal()).Left(25),wxPoint(margeG,ligne));
            Tabule_ecrit(Valeurs_courantes.contenu[i].Valeur_chaine()           ,wxPoint(margeG+28,ligne));
            ligne++;
            }
        return true;
    }
    else
        return false;
}
//---------------------------------------------------------------------------
bool BilanPrintout::PrintPage_Tableau_annuites(int page)
{
    wxDC *dc = GetDC();
    if (dc)
    {
        FixeFontEtTaille();
        Traducteur tr;
        int nb_lignes_par_pages(Nombre_de_lignes_par_pages()-margeB),
            ligne(2), //Num de ligne dans la page courante (forme de deux colonnes chanes)
            ligne_du_tableau(2), //Num des lignes dans le tableau des valeurs
            premiere_ligne=(page-1)*nb_lignes_par_pages*2,
            dernier_ligne=premiere_ligne+nb_lignes_par_pages*2;
        bool colonne2(false);
        wxPoint decale(0,0);
        double RembInt,RembCap,RestDu;
        Tabule_ecrit(wxString::Format(wxT("PAGE %d"),page),wxPoint(margeG,ligne++));
        Tabule_ecrit(tr.trad(wxT("N pr."))    ,wxPoint(margeG+ 0,ligne));
        Tabule_ecrit(tr.trad(wxT("Intrts"))   ,wxPoint(margeG+ 5,ligne));
        Tabule_ecrit(tr.trad(wxT("Capital"))    ,wxPoint(margeG+15,ligne));
        Tabule_ecrit(tr.trad(wxT("Reste du"))   ,wxPoint(margeG+25,ligne));
        for (int i=Valeurs_courantes.contenu[NbPeriodes].Liminf()+1;i<=Valeurs_courantes.contenu[NbPeriodes].Valeur();i++)
                {
                ++ligne_du_tableau;
                colonne2=((ligne_du_tableau-1)/nb_lignes_par_pages)%2;
                decale=wxPoint((colonne2?35:0),(colonne2?-nb_lignes_par_pages:0));
                if ((ligne_du_tableau>premiere_ligne)&&(ligne_du_tableau<=dernier_ligne))
                    {
                    Calculs::Calcul_une_ligne_tableau(i,RembInt,RembCap,RestDu,Valeurs_courantes);
                    Tabule_ecrit(tr.trad(wxString::Format(wxT(  "%3i"),i      )) ,wxPoint(margeG+ 0+decale.x,(++ligne)+decale.y));
                    Tabule_ecrit(tr.trad(wxString::Format(wxT("%6.2f"),RembInt)) ,wxPoint(margeG+ 5+decale.x,(  ligne)+decale.y));
                    Tabule_ecrit(tr.trad(wxString::Format(wxT("%6.2f"),RembCap)) ,wxPoint(margeG+15+decale.x,(  ligne)+decale.y));
                    Tabule_ecrit(tr.trad(wxString::Format(wxT("%6.2f"),RestDu )) ,wxPoint(margeG+25+decale.x,(  ligne)+decale.y));
                    }
                }
        return true;
    }
    else
        return false;
}
//---------------------------------------------------------------------------
// crit st  la position pos (x en nombre de caractre et y nombre de lignes de texte)
void BilanPrintout::Tabule_ecrit(wxString st,wxPoint pos)
{
    wxDC *dc = GetDC();
    Base_Tabule_ecrit(dc,st,pos);
}
//---------------------------------------------------------------------------
int BilanPrintout::Nombre_de_lignes_par_pages()
{
    wxDC *dc = GetDC();
    int wp(10),wh(10),charH(10),nb_lignes_par_page(40);
    double scx(1),scy(1);
    if (dc)
    {
        charH=int(dc->GetCharHeight());
        dc->GetSize(&wp,&wh);
        dc->GetUserScale(&scx,&scy);
    }
    nb_lignes_par_page=int(wh/(charH*scy+0.01));
    return nb_lignes_par_page+1;
}
//---------------------------------------------------------------------------
int BilanPrintout::Nombre_de_pages()
{
    int nb_lignes=0;
    if (Valeurs_courantes.mode_tableau_on)
        nb_lignes=Valeurs_courantes.contenu[NbPeriodes].Valeur();
    return int((nb_lignes+2)/((Nombre_de_lignes_par_pages()-margeB)*2))+1;
}
//---------------------------------------------------------------------------
// Fin gestion des impressions
//---------------------------------------------------------------------------
// Implmentation des objets propres au programme
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
// Classe ddie aux erreurs
//---------------------------------------------------------------------------
  Erreur_SC::Erreur_SC(wxString message_erreur)
  {
      Traducteur tr;
      message=(message_erreur!=wxT("")?tr.trad(message_erreur):tr.trad(wxT("Pas d'erreur")));
  }
//---------------------------------------------------------------------------
// Traduction des noms des modes
//---------------------------------------------------------------------------
Modes_Calculette::Modes_Calculette()
{
    contenu.insert(std::make_pair(int_composes,wxT("Intrts composs")));
    contenu.insert(std::make_pair(abaque_pret,wxT("Abaque prt")));
    contenu.insert(std::make_pair(per_ordinaire,wxT("Priode ordinaire : versement/retrait en fin de priode")));
    contenu.insert(std::make_pair(per_a_echoir,wxT("Priode  choir : versement/retrait en dbut de priode")));
}
wxString Modes_Calculette::Nom_mode(type_de_modes m)
{
    Traducteur tr;
    return tr.trad(contenu[m]);
}
// Fentre principale
//---------------------------------------------------------------------------
//Identificateurs
const long MainFrame::idMenuQuit = wxNewId();
const long MainFrame::idMenuImprime = wxNewId();
const long MainFrame::idMenuDisclaimer = wxNewId();
const long MainFrame::idMenuAbout = wxNewId();
const long MainFrame::idMenuHelp = wxNewId();
const long MainFrame::idMenufr = wxNewId();
const long MainFrame::idMenuen = wxNewId();
const long MainFrame::idMenuToolbar1 = wxNewId();
const long MainFrame::ID_DIALOGS_FILES_OPEN = wxNewId();
const long MainFrame::ID_DIALOGS_FILE_SAVE = wxNewId();
const long MainFrame::ID_DIALOGS_FILE_SAVE_AS = wxNewId();
const long MainFrame::idOnPaint = wxNewId();
const long MainFrame::idBoutChoix1= wxNewId();
const long MainFrame::idBoutChoix2= wxNewId();
const long MainFrame::idBoutChoix3= wxNewId();
const long MainFrame::idBoutChoix4= wxNewId();
const long MainFrame::idBout1= wxNewId();
const long MainFrame::idBout2= wxNewId();
const long MainFrame::idBout3= wxNewId();
const long MainFrame::idBout4= wxNewId();
const long MainFrame::idBout5= wxNewId();
const long MainFrame::idBout6= wxNewId();
const long MainFrame::idBout7= wxNewId();
const long MainFrame::idaproposinst = wxNewId();

// identifiants des contrles
const long MainFrame::idFen_result = wxNewId();
const long MainFrame::idFenBout1 = wxNewId();
const long MainFrame::idFenBout2 = wxNewId();
const long MainFrame::idFenBout3 = wxNewId();
const long MainFrame::idFenBout4 = wxNewId();
const long MainFrame::idFenBout5 = wxNewId();
const long MainFrame::idFenBout6 = wxNewId();
const long MainFrame::idFenBout7 = wxNewId();
//---------------------------------------------------------------------------
BEGIN_EVENT_TABLE(MainFrame, wxFrame)
    EVT_PAINT(MainFrame::OnPaint)
    EVT_SIZE(MainFrame::OnSize)
    EVT_CLOSE(MainFrame::OnClose)
    EVT_MENU(idMenuQuit, MainFrame::OnQuit)
    EVT_MENU(idMenuImprime, MainFrame::OnImprime)
    EVT_MENU(ID_DIALOGS_FILES_OPEN, MainFrame::FileOpen)
    EVT_MENU(ID_DIALOGS_FILE_SAVE, MainFrame::FileSave)
    EVT_MENU(ID_DIALOGS_FILE_SAVE_AS, MainFrame::FileSaveAs)
    EVT_MENU(idMenuDisclaimer, MainFrame::OnDisclaimer)
    EVT_MENU(idMenuAbout, MainFrame::OnAbout)
    EVT_MENU(idMenuHelp, MainFrame::OnHelp)
    EVT_MENU(idMenufr,MainFrame::Onfr)
    EVT_MENU(idMenuen,MainFrame::Onen)
    EVT_BUTTON(idBoutChoix1,MainFrame::OnBoutChoix1)
    EVT_BUTTON(idBoutChoix2,MainFrame::OnBoutChoix2)
    EVT_BUTTON(idBoutChoix3,MainFrame::OnBoutChoix3)
    EVT_BUTTON(idBoutChoix4,MainFrame::OnBoutChoix4)
    EVT_BUTTON(idBout1,MainFrame::OnBout1)
    EVT_BUTTON(idBout2,MainFrame::OnBout2)
    EVT_BUTTON(idBout3,MainFrame::OnBout3)
    EVT_BUTTON(idBout4,MainFrame::OnBout4)
    EVT_BUTTON(idBout5,MainFrame::OnBout5)
    EVT_BUTTON(idBout6,MainFrame::OnBout6)
    EVT_BUTTON(idBout7,MainFrame::OnBout7)
    EVT_TEXT(idFenBout1,MainFrame::OnFenBout1)
    EVT_TEXT(idFenBout2,MainFrame::OnFenBout2)
    EVT_TEXT(idFenBout3,MainFrame::OnFenBout3)
    EVT_TEXT(idFenBout4,MainFrame::OnFenBout4)
    EVT_TEXT(idFenBout5,MainFrame::OnFenBout5)
    EVT_TEXT(idFenBout6,MainFrame::OnFenBout6)
    EVT_TEXT(idFenBout7,MainFrame::OnFenBout7)
END_EVENT_TABLE()
//---------------------------------------------------------------------------
// Le constructeur
MainFrame::MainFrame() : wxFrame(NULL,wxID_ANY,wxT("Calculette financire SquirrelPocketCalc"),wxPoint(800,100),wxSize(100,100),wxDEFAULT_FRAME_STYLE|wxFULL_REPAINT_ON_RESIZE),
                            init_done(false),item_menu_change(true),taille_modifiee(true),affichage_en_cours(true),Titre_Fen(wxT("Paramtres"))

{
    firstwin()=this;
    Traducteur tr;
    tr.langue_demarrage();
    PalettePerso p;
    SetBackgroundColour(Couleur_Fenetres_defaut());
    // Calcule la taille de dpart de la fentre
    SetSize(Taille_Fenetres_defaut());
    // Calcule la taille minimale de la fentre (ne marche pas avec Wine)
    SetSizeHints(300,200,-1,-1,-1,-1);
    FixeFontEtTaille(this);
    SetIcon(SquirrelPocketCalc32_xpm);
    // Fiche Apropos
    AProposinst=new APropos(this,idaproposinst);
    // Initialisation des chemins

    //wxStandardPaths Chemins; // wxStandardPaths est protected dans wxWidgets 3 donc pas instanciable
#if defined(__WXMSW__)
    InitDir=wxStandardPaths::Get().GetDataDir();
    DonneesDir=InitDir;
    DonneesVarDir=DonneesDir;
#elif defined(__UNIX__)
    //Chemins.SetInstallPrefix(wxT("/usr/bin"));
    //InitDir=Chemins.GetInstallPrefix();
    InitDir=wxT("/usr/bin");
    DonneesDir=wxT("/usr/share/SquirrelPocketCalc"); // Le rpertoire usr peut-tre en lecture seule
    DonneesVarDir=wxT("/var/lib/SquirrelPocketCalc");// d'o la ncessit d'un rpertoire dans var pour les donnes modifiables
#endif
    NomFichier=tr.trad(wxT("defaut.sqrl"));
    // Aide
    wxImage::AddHandler(new wxPNGHandler());
    wxFileSystem::AddHandler(new wxZipFSHandler);
    helpController = new wxHtmlHelpController(wxHF_DEFAULT_STYLE,this);
    helpController->Initialize(DonneesDir+wxT("/")+wxT("SquirrelPocketCalcfrahlp.zip"));
    helpController->AddBook(wxFileName(DonneesDir+wxT("/")+wxT("SquirrelPocketCalcenghlp.zip")));
#if wxCHECK_VERSION(2,9,0)
    helpController->SetShouldPreventAppExit(true);// Valeur par dfaut false provoque le plantage sous wx3.0.2 pas 2.8.2
#endif
    //---------------------------------------------------------------------------
    // Mise en place des menus
    wxMenuItem* MenuItem1;
    wxMenuItem* MenuItem2;
    wxMenuItem* MenuItem3;
    wxMenuItem* MenuItem4;
    wxMenuItem* MenuItem5;
    wxMenuItem* MenuItem6;
    wxMenuItem* MenuItem7;
    wxMenuItem* MenuItem8;
    wxMenuItem* MenuItem9;
    wxMenuItem* MenuItem10;

    wxMenu* Menu1;
    wxMenu* Menu2;
    wxMenu* Menu3;

    wxMenuBar* MenuBar1;
    MenuBar1 = new wxMenuBar();
    Menu1 = new wxMenu();
        MenuItem1 = new wxMenuItem(Menu1, ID_DIALOGS_FILES_OPEN, wxT("Ouvrir"), wxT("Charge un fichier"), wxITEM_NORMAL);
        Menu1->Append(MenuItem1);
        MenuItem2 = new wxMenuItem(Menu1, ID_DIALOGS_FILE_SAVE, wxT("Enregistrer"), wxT("Sauve le fichier en cours"), wxITEM_NORMAL);
        Menu1->Append(MenuItem2);
        MenuItem3 = new wxMenuItem(Menu1,ID_DIALOGS_FILE_SAVE_AS, wxT("Enregistrer sous..."), wxT("Sauve sous un nouveau nom"), wxITEM_NORMAL);
        Menu1->Append(MenuItem3);
        MenuItem4 = new wxMenuItem(Menu1, idMenuImprime, wxT("Impression"), wxT("Imprime le diagramme"), wxITEM_NORMAL);
        Menu1->Append(MenuItem4);
        Menu1->AppendSeparator();
        MenuItem5 = new wxMenuItem(Menu1, idMenuQuit, wxT("Quitter"), wxT("Quit the application"), wxITEM_NORMAL);
        Menu1->Append(MenuItem5);
        MenuBar1->Append(Menu1, wxT("Fichiers"));
    Menu2 = new wxMenu();
        MenuItem6 = new wxMenuItem(Menu2, idMenufr, wxT("Franais"), wxT("Version Franaise"), wxITEM_CHECK );
        Menu2->Append(MenuItem6);
        MenuItem7 = new wxMenuItem(Menu2, idMenuen, wxT("English"), wxT("English version"), wxITEM_CHECK );
        Menu2->Append(MenuItem7);
        MenuBar1->Append(Menu2, wxT("Langage"));
    Menu3 = new wxMenu();
        MenuItem8 = new wxMenuItem(Menu3, idMenuDisclaimer, wxT("Avertissement"), wxT("Avertissement"), wxITEM_NORMAL);
        Menu3->Append(MenuItem8);
        MenuItem9 = new wxMenuItem(Menu3, idMenuAbout, wxT("A propos"), wxT("A propos"), wxITEM_NORMAL);
        Menu3->Append(MenuItem9);
        MenuItem10 = new wxMenuItem(Menu3, idMenuHelp, wxT("Aide"), wxT("Aide"), wxITEM_NORMAL);
        Menu3->Append(MenuItem10);
        MenuBar1->Append(Menu3, wxT("Aide"));
    SetMenuBar(MenuBar1);
    //---------------------------------------------------------------------------
    // Barre d'outils
    wxToolBar* Toolbar1;
    Toolbar1= CreateToolBar(wxNO_BORDER | wxTB_HORIZONTAL,idMenuToolbar1);
    wxImage::AddHandler(new wxXPMHandler());
    wxBitmap* toolBarBitmaps[7];
    toolBarBitmaps[0]=new wxBitmap(files16_xpm);
    toolBarBitmaps[1]=new wxBitmap(save16_xpm);
    toolBarBitmaps[2]=new wxBitmap(impr16_xpm);
    toolBarBitmaps[3]=new wxBitmap(fr16_xpm);
    toolBarBitmaps[4]=new wxBitmap(eng16_xpm);
    toolBarBitmaps[5]=new wxBitmap(help16_xpm);
    toolBarBitmaps[6]=new wxBitmap(sortie16_xpm);

    Toolbar1->SetToolBitmapSize(wxSize(toolBarBitmaps[0]->GetWidth(),toolBarBitmaps[0]->GetHeight()));

    Toolbar1->AddTool(ID_DIALOGS_FILES_OPEN ,wxT("Fichiers")        ,*(toolBarBitmaps[0]),wxT("Fichiers")                   ,wxITEM_NORMAL);
    Toolbar1->AddTool(ID_DIALOGS_FILE_SAVE  ,wxT("Sauve le fichier en cours")    ,*(toolBarBitmaps[1]),wxT("Sauve le fichier en cours")  ,wxITEM_NORMAL);
    Toolbar1->AddTool(idMenuImprime         ,wxT("Imprime")         ,*(toolBarBitmaps[2]),wxT("Imprime le rapport")                ,wxITEM_NORMAL);
    Toolbar1->AddSeparator();
    Toolbar1->AddTool(idMenufr              ,wxT("Franais")        ,*(toolBarBitmaps[3]),wxT("Franais")                   ,wxITEM_RADIO);
    Toolbar1->AddTool(idMenuen              ,wxT("English")         ,*(toolBarBitmaps[4]),wxT("English")                    ,wxITEM_RADIO);
    Toolbar1->AddSeparator();
    Toolbar1->AddTool(idMenuHelp            ,wxT("Aide")            ,*(toolBarBitmaps[5]),wxT("Aide")                       ,wxITEM_NORMAL);
    Toolbar1->AddSeparator();
    Toolbar1->AddTool(idMenuQuit            ,wxT("Quitter")         ,*(toolBarBitmaps[6]),wxT("Sortie")                     ,wxITEM_NORMAL);
    Toolbar1->Realize();
    SetToolBar(Toolbar1);
    //---------------------------------------------------------------------------
    // Mise en page et insertion des contrles
    wxPoint pos; wxSize taille;
    pos=FaitReelle_Pos(wxPoint(10,100),this);
    taille=FaitReelle_Taille(wxSize(50,50),this);
    // Boutons choix mode
    BoutChoix1=new wxButton(this,idBoutChoix1,wxT("Intrts composs") ,pos,taille);
    BoutChoix2=new wxButton(this,idBoutChoix2,wxT("Abaque prt")       ,pos,taille);
    BoutChoix3=new wxButton(this,idBoutChoix3,wxT("Priode ordinaire") ,pos,taille);
    BoutChoix4=new wxButton(this,idBoutChoix4,wxT("Priode  choir")  ,pos,taille);
    // Boutons dclenchement des calculs
    Bout1=new wxButton(this,idBout1,Valeurs_courantes.contenu[ValeurInit].NomVal(),pos,taille);
    Bout2=new wxButton(this,idBout2,Valeurs_courantes.contenu[ValeurFinale].NomVal(),pos,taille);
    Bout3=new wxButton(this,idBout3,Valeurs_courantes.contenu[VersementParPeriode].NomVal(),pos,taille);
    Bout4=new wxButton(this,idBout4,Valeurs_courantes.contenu[NbPeriodes].NomVal(),pos,taille);
    Bout5=new wxButton(this,idBout5,Valeurs_courantes.contenu[TauxAnnuel].NomVal(),pos,taille);
    Bout6=new wxButton(this,idBout6,Valeurs_courantes.contenu[NbPeriodesParAn].NomVal(),pos,taille);
    Bout7=new wxButton(this,idBout7,Valeurs_courantes.contenu[TauxNominal].NomVal(),pos,taille);
    // Boites textes de rentre des paramtres
    FenBout1=new wxTextCtrl(this,idFenBout1,wxT("az1"),pos,taille);
    FenBout2=new wxTextCtrl(this,idFenBout2,wxT("az2"),pos,taille);
    FenBout3=new wxTextCtrl(this,idFenBout3,wxT("az3"),pos,taille);
    FenBout4=new wxTextCtrl(this,idFenBout4,wxT("az4"),pos,taille);
    FenBout5=new wxTextCtrl(this,idFenBout5,wxT("a5z"),pos,taille);
    FenBout6=new wxTextCtrl(this,idFenBout6,wxT("az6"),pos,taille);
    FenBout7=new wxTextCtrl(this,idFenBout7,wxT("az7"),pos,taille);
    // Tableau permettant d'accder aux fentres de rsultats
    FenBoutTable.insert(std::make_pair(ValeurInit,FenBout1));
    FenBoutTable.insert(std::make_pair(ValeurFinale,FenBout2));
    FenBoutTable.insert(std::make_pair(VersementParPeriode,FenBout3));
    FenBoutTable.insert(std::make_pair(NbPeriodes,FenBout4));
    FenBoutTable.insert(std::make_pair(TauxAnnuel,FenBout5));
    FenBoutTable.insert(std::make_pair(NbPeriodesParAn,FenBout6));
    FenBoutTable.insert(std::make_pair(TauxNominal,FenBout7));
    // Boite texte affichage des rsultats du calcul
    Fen_result=new wxRichTextCtrl(this,idFen_result,wxT(""),pos,taille,wxTE_LEFT|wxTE_MULTILINE|wxTE_READONLY|wxTE_RICH);
    wxRichTextAttr Style;
    Style=Fen_result->GetDefaultStyle();
    wxArrayInt Tabs; // Tabulations en dixime de mm
    Tabs.Add(200);
    Tabs.Add(400);
    Tabs.Add(600);
    Tabs.Add(800);
    Style.SetFlags(wxTEXT_ATTR_TABS);
    Style.SetTabs(Tabs);
    Style.SetFontSize(8);// Normalement hrit de Fen_result mais ne marche pas depuis wxWidgets 3.0  revoir
    Fen_result->SetBasicStyle(Style);
    Fen_result->SetDefaultStyle(Style);
    // Charge le fichier par dfaut le cre s'il n'existe pas
    if(!charge_fichier(NomComplet()))
        {
        wxCommandEvent ev;
        FileSave(ev);
        charge_fichier(NomComplet());
        }
    // Conservation des paramtres d'impression
    g_printData =new wxPrintData;
    g_printData->SetPaperId(wxPAPER_A4);
    // Prparation de l'affichage
    Affiche_les_bons_boutons();
    init_done=true;
}
//---------------------------------------------------------------------------
// Le Destructeur
MainFrame::~MainFrame()
{
    delete g_printData;
}
wxPoint MainFrame::ALaPlace(int x,int y)
{
    return wxPoint(GetSize().GetWidth()/100*x,GetSize().GetHeight()/100*y);
}
//---------------------------------------------------------------------------
void MainFrame::Affiche_chaine(wxString ch) //pour test
{
    Fen_result->AppendText(ch+LF);
}
//---------------------------------------------------------------------------
wxString MainFrame::NomComplet()
{
    return DonneesVarDir+wxT("/")+NomFichier;
}
//---------------------------------------------------------------------------
void MainFrame::Affiche_les_bons_boutons()
{
    BoutChoix1->Enable(Valeurs_courantes.mode_tableau_on);
    BoutChoix2->Enable(!Valeurs_courantes.mode_tableau_on);
    BoutChoix3->Enable(!Valeurs_courantes.periode_ordinaire);
    BoutChoix4->Enable(Valeurs_courantes.periode_ordinaire);
}
//---------------------------------------------------------------------------
void MainFrame::Affichage_valeurs()
{
    Traducteur tr;
    Fen_result->Clear();
    Fen_result->AppendText(Titre_Fen+LF);
    Fen_result->AppendText(Statut_epargne_ou_pret()+LF);
    for(type_de_valeurs i=ValeurInit;i<=TauxNominal;i=suivant(i))
    {
    Fen_result->AppendText( Ajuste_chaine_a_longueur(tr.trad(Valeurs_courantes.contenu[i].NomVal()),25,true)
                            +TAB+Valeurs_courantes.contenu[i].Valeur_chaine()+LF);
    }
    Refresh();
}
//---------------------------------------------------------------------------
void MainFrame::Affichage_tableau()
{
    Traducteur tr;
    int NbPeriodesTotal=Valeurs_courantes.contenu[NbPeriodes].Valeur();
    double RembInt,RembCap,RestDu;
    Fen_result->AppendText(tr.trad(wxT("N pr."))
                            +TAB+tr.trad(wxT("Intrts"))
                            +TAB+tr.trad(wxT("Capital"))
                            +TAB+tr.trad(wxT("Reste du"))+LF);
    for (int i=1;i<=NbPeriodesTotal;i++)
        {
        Calculs::Calcul_une_ligne_tableau(i,RembInt,RembCap,RestDu,Valeurs_courantes);
        Fen_result->AppendText(wxString::Format(wxT("%3i"),i)
            +TAB+wxString::Format(wxT("%6.2f"),RembInt)
            +TAB+wxString::Format(wxT("%6.2f"),RembCap)
            +TAB+wxString::Format(wxT("%6.2f"),RestDu)
            +TAB+LF);
        }
}
//---------------------------------------------------------------------------
void MainFrame::OnImprime(wxCommandEvent& event)
{
    Traducteur tr;
    g_printData->SetPaperSize(wxSize(200,500));
    wxPrintDialogData g_printDialogData(*g_printData);
    g_printDialogData.EnablePageNumbers(true);
    wxPrintPreview *preview = new wxPrintPreview(new BilanPrintout(tr.trad(wxT("Prvisualisation"))), new BilanPrintout(tr.trad(wxT("Impression"))), & g_printDialogData);

    if (!preview->Ok())
    {
        delete preview;
        wxMessageBox(wxT("There was a problem previewing.\nPerhaps your current printer is not set correctly?"), wxT("Previewing"), wxOK);
        return;
    }
    wxPreviewFrame *frame = new wxPreviewFrame(preview, this, tr.trad(wxT("Rapport")), wxPoint(100, 100), wxSize(600, 650));
    frame->Centre(wxBOTH);
    frame->Initialize();
    frame->Show();
}
//---------------------------------------------------------------------------
void MainFrame::OnQuit(wxCommandEvent& event)
{
                wxCloseEvent eventclose;
                OnClose(eventclose);
}
void MainFrame::OnClose(wxCloseEvent& event)
{
                this->Destroy();
}
//---------------------------------------------------------------------------
void MainFrame::OnDisclaimer(wxCommandEvent& event)
{
    Traducteur tr;
    wxBitmap bitmap;
    wxImage::AddHandler(new wxPNGHandler());
    if (bitmap.LoadFile(DonneesDir+wxT("/")+tr.trad(wxT("DisclaimimageFra.png")), wxBITMAP_TYPE_PNG))
    {
        wxSplashScreen* splash __attribute__ ((unused));
        splash = new wxSplashScreen(bitmap,
          wxSPLASH_CENTRE_ON_SCREEN|wxSPLASH_TIMEOUT,
          6000, NULL, -1, wxDefaultPosition, wxDefaultSize,
          wxSIMPLE_BORDER|wxSTAY_ON_TOP);
    }
    wxYield();
}
//---------------------------------------------------------------------------
void MainFrame::OnAbout(wxCommandEvent& event)
{
    AProposinst->Show();
}
 void MainFrame::OnHelp(wxCommandEvent& event)
{
    Traducteur tr;
    helpController->DisplayContents();
    helpController->Display(tr.trad(wxT("SquirrelPocketCalcfrahlp")));
}
//---------------------------------------------------------------------------
void MainFrame::Onfr(wxCommandEvent& event)
{
    Traducteur tr;
    tr.fixe_langue()=fr;
    item_menu_change=true;
    Refresh();
}
void MainFrame::Onen(wxCommandEvent& event)
{
    Traducteur tr;
    tr.fixe_langue()=ang;
    item_menu_change=true;
    Refresh();
}
//---------------------------------------------------------------------------
// Chargement du fichier sqrl slectionn.
bool MainFrame::charge_fichier(wxString nomfich)
{
    wxFile fichier_en_cours(nomfich,wxFile::read);
    double valeurs_a_garder[Calculs::nb_de_valeurs()+1];
    bool succes=fichier_en_cours.IsOpened();
    if (succes)
        {
        int L=0;
        size_t ld(sizeof(valeurs_a_garder));
                L=fichier_en_cours.Read(&valeurs_a_garder,ld);
    int indice=0;
    for (type_de_valeurs i=ValeurInit;i<=TauxNominal;i=suivant(i))
            {Valeurs_courantes.contenu[i].Set_Valeur(valeurs_a_garder[indice]);
            indice++;
            }
        Valeurs_courantes.periode_ordinaire=bool(valeurs_a_garder[indice]);
        }
    Titre_Fen=NomFichier;
    item_menu_change=true;
    Refresh();
    return succes;
}
//---------------------------------------------------------------------------
void MainFrame::FileOpen(wxCommandEvent& WXUNUSED(event) )
{
    Traducteur tr;
    wxFileDialog dialog
                 (
                    this,
                    tr.trad(wxT("Ouvrir")),
                    wxEmptyString,
                    wxEmptyString,
                    wxString(tr.trad(wxT("Fichiers"))+wxT("(*.sqrl)|*.sqrl|")+tr.trad(wxT("Tous fichiers"))+wxT("(*.*)|*.*"))
                 );
    dialog.CentreOnParent();
    dialog.SetDirectory(DonneesVarDir);
    if (dialog.ShowModal() == wxID_OK)
        {
        DonneesVarDir=dialog.GetDirectory();
        NomFichier=dialog.GetFilename();
        Affiche_chaine(tr.trad(wxT("Ouverture de "))+NomComplet());
        if(!charge_fichier(NomComplet()))
                {
                };
        }
}
//---------------------------------------------------------------------------
//Sauve le fichier de configuration
void MainFrame::FileSave(wxCommandEvent& event)
{
    wxFile fichier_en_cours(NomComplet(),wxFile::write);
    wxString f;
    size_t L;
    size_t Lw=0;
    double valeurs_a_garder[Calculs::nb_de_valeurs()+1];
    int indice=0;
    for (type_de_valeurs i=ValeurInit;i<=TauxNominal;i=suivant(i))
        {valeurs_a_garder[indice]=Valeurs_courantes.contenu[i].Valeur();
        indice++;
        }
    valeurs_a_garder[indice]=double(Valeurs_courantes.periode_ordinaire);
    L=sizeof(valeurs_a_garder);
    Lw=fichier_en_cours.Write(&valeurs_a_garder,L);
    Refresh();
}
//---------------------------------------------------------------------------
void MainFrame::FileSaveAs(wxCommandEvent& event)
{
    Traducteur tr;

    wxFileDialog dialog(this,
                        tr.trad(wxT("Enregistrer sous...")),
                        wxEmptyString,
                        tr.trad(wxT("Sans titre"))+wxT(".sqrl"),
                        wxString(tr.trad(wxT("Fichiers"))+wxT("(*.sqrl)|*.sqrl|")+tr.trad(wxT("Tous fichiers"))+wxT("(*.*)|*.*")),
                        wxFD_SAVE|wxFD_OVERWRITE_PROMPT);

    dialog.SetFilterIndex(0);
    dialog.CentreOnParent();
    dialog.SetDirectory(DonneesVarDir);

    if (dialog.ShowModal() == wxID_OK)
    {
// enregistrement du fichier slectionn.
    DonneesVarDir=dialog.GetDirectory();
    NomFichier=dialog.GetFilename();
    FileSave(event);
    }

    Refresh();
}
//---------------------------------------------------------------------------
void MainFrame::OnSize(wxSizeEvent& event)
{
    taille_modifiee=true;
}
//---------------------------------------------------------------------------
void MainFrame::OnPaint(wxPaintEvent& event)
{
    wxPaintDC dc(this);
    rafraichit();
}
//---------------------------------------------------------------------------
void MainFrame::rafraichit()
{
Traducteur tr;
affichage_en_cours=true;
if (init_done)
    {
    if (item_menu_change)
        {
        item_menu_change=false;
        wxMenuBar* Menuprov=GetMenuBar();
        // Traduit les titres des enfants
        RenommeEnfants(this);
        // Titres de menus
        size_t nb_menus=Menuprov->GetMenuCount();
        for (size_t i=0;i<nb_menus;i++)
            Menuprov->SetMenuLabel(i,tr.trad_tout(Menuprov->GetMenuLabel(i)));
        //Items de chaque menu
        Menuprov->SetLabel(ID_DIALOGS_FILE_SAVE_AS,tr.trad(wxT("Enregistrer sous...")));
        Menuprov->SetLabel(ID_DIALOGS_FILES_OPEN,tr.trad(wxT("Ouvrir")));
        Menuprov->SetLabel(ID_DIALOGS_FILE_SAVE,tr.trad(wxT("Enregistrer")));
        Menuprov->SetLabel(idMenuQuit,tr.trad(wxT("Quitter")));
        Menuprov->SetLabel(idMenuImprime,tr.trad(wxT("Impression")));
        Menuprov->SetLabel(idMenuDisclaimer, tr.trad(wxT("Avertissement")));
        Menuprov->SetLabel(idMenuAbout, tr.trad(wxT("A propos")));
        Menuprov->SetLabel(idMenuHelp, tr.trad(wxT("Aide")));
        Menuprov->SetLabel(idMenufr,wxT("Franais"));
        Menuprov->SetLabel(idMenuen,wxT("English"));
        // Fentres de valeurs
        for (type_de_valeurs i=ValeurInit;i<=TauxNominal;i=suivant(i))
            {
            FenBoutTable[i]->Clear();
            FenBoutTable[i]->AppendText(tr.trad(Valeurs_courantes.contenu[i].Valeur_chaine()));
            FenBoutTable[i]->SetInsertionPoint(Valeurs_courantes.contenu[i].pos_curseur);
            }
        // Graphique
        // Boutons actifs ou non sur la barre d'outils
        bool fr_on=(tr.fixe_langue()==fr);
        Menuprov->Check(idMenufr,(fr_on));
        Menuprov->Check(idMenuen,(!fr_on));
        wxToolBar* Toolbarprov=GetToolBar();
        Toolbarprov->ToggleTool(idMenufr,fr_on);
        Toolbarprov->ToggleTool(idMenuen,!fr_on);
        Toolbarprov->SetToolShortHelp(ID_DIALOGS_FILES_OPEN,tr.trad(wxT("Ouvrir")));
        Toolbarprov->SetToolShortHelp(ID_DIALOGS_FILE_SAVE,tr.trad(wxT("Sauve le fichier en cours")));
        Toolbarprov->SetToolShortHelp(idMenuImprime,tr.trad(wxT("Impression")));
        Toolbarprov->SetToolShortHelp(idMenuHelp, tr.trad(wxT("Aide")));
        Toolbarprov->SetToolShortHelp(idMenuQuit,tr.trad(wxT("Quitter")));
        Menuprov->Refresh();
        Toolbarprov->Refresh();
        // Boutons actifs ou non
        Affiche_les_bons_boutons();
        }
    if(taille_modifiee)
        {
            taille_modifiee=false;
              // paramtres d'affichage
            int margex(20),ecart(300),margey(150),pasy(105);
            // Ajuste la taille de la Boite texte affichage rsultat
            int ecart1(ecart*0.5); // taille affichages textes
            int ecart2((1000-margex*5)/4); // largeur des boutons de choix
            int margey1(margey-100); // sommet des boutons de choix
            int margey2(margey+(1000-margey-7*pasy)/2); //sommet des boutons de paramtres
            int posX_zone_Resultat=margex*2+ecart+ecart1;
            wxPoint pos(posX_zone_Resultat,margey);
            wxSize taille(1000-posX_zone_Resultat-margex,1000-margey-margex);
            Ajuste_taille_et_pos(pos,taille,this,Fen_result);
            // Ajuste la taille des contrles
            taille=wxSize(ecart,pasy*0.8);
            wxSize taille1(ecart1,pasy*0.8); // taille boite de saisie texte
            wxSize taille2(ecart2,pasy*0.8); // taille des boutons de choix
            // Boutons choix
            Ajuste_taille_et_pos(wxPoint(margex                 ,margey1),taille2,this,BoutChoix1);
            Ajuste_taille_et_pos(wxPoint(margex*2+ecart2        ,margey1),taille2,this,BoutChoix2);
            Ajuste_taille_et_pos(wxPoint(margex*3+ecart2 *2     ,margey1),taille2,this,BoutChoix3);
            Ajuste_taille_et_pos(wxPoint(margex*4+ecart2 *3     ,margey1),taille2,this,BoutChoix4);
            int ligne=0;
            // Boutons calcul
            Ajuste_taille_et_pos(wxPoint(margex                 ,margey2+ (ligne  )*pasy),taille,this,Bout1);
            Ajuste_taille_et_pos(wxPoint(margex+ecart           ,margey2+ (ligne++)*pasy),taille1,this,FenBout1);
            Ajuste_taille_et_pos(wxPoint(margex                 ,margey2+ (ligne  )*pasy),taille,this,Bout2);
            Ajuste_taille_et_pos(wxPoint(margex+ecart           ,margey2+ (ligne++)*pasy),taille1,this,FenBout2);
            Ajuste_taille_et_pos(wxPoint(margex                 ,margey2+ (ligne  )*pasy),taille,this,Bout3);
            Ajuste_taille_et_pos(wxPoint(margex+ecart           ,margey2+ (ligne++)*pasy),taille1,this,FenBout3);
            Ajuste_taille_et_pos(wxPoint(margex                 ,margey2+ (ligne  )*pasy),taille,this,Bout4);
            Ajuste_taille_et_pos(wxPoint(margex+ecart           ,margey2+ (ligne++)*pasy),taille1,this,FenBout4);
            Ajuste_taille_et_pos(wxPoint(margex                 ,margey2+ (ligne  )*pasy),taille,this,Bout5);
            Ajuste_taille_et_pos(wxPoint(margex+ecart           ,margey2+ (ligne++)*pasy),taille1,this,FenBout5);
            Ajuste_taille_et_pos(wxPoint(margex                 ,margey2+ (ligne  )*pasy),taille,this,Bout6);
            Ajuste_taille_et_pos(wxPoint(margex+ecart           ,margey2+ (ligne++)*pasy),taille1,this,FenBout6);
            Ajuste_taille_et_pos(wxPoint(margex                 ,margey2+ (ligne  )*pasy),taille,this,Bout7);
            Ajuste_taille_et_pos(wxPoint(margex+ecart           ,margey2+ (ligne++)*pasy),taille1,this,FenBout7);
        }
    }
affichage_en_cours=false;
}
//---------------------------------------------------------------------------
void MainFrame::Bouton_de_choix(type_de_modes m)
{
    Traducteur tr;
    Modes_Calculette mcal;
    mode_courant()=m;
    Fen_result->AppendText(tr.trad(wxT("Mode de calcul "))+mcal.Nom_mode(m)+LF);
    item_menu_change=true;
    Refresh();
}
//---------------------------------------------------------------------------
void  MainFrame::OnBoutChoix1(wxCommandEvent& event)
{
    Valeurs_courantes.mode_tableau_on=false;
    Bouton_de_choix(int_composes);
}
//---------------------------------------------------------------------------
void  MainFrame::OnBoutChoix2(wxCommandEvent& event)
{
    Valeurs_courantes.mode_tableau_on=true;
    Bouton_de_choix(abaque_pret);
}
//---------------------------------------------------------------------------
void  MainFrame::OnBoutChoix3(wxCommandEvent& event)
{
    Valeurs_courantes.periode_ordinaire=true;
    Bouton_de_choix(per_ordinaire);
}
//---------------------------------------------------------------------------
void  MainFrame::OnBoutChoix4(wxCommandEvent& event)
{
    Valeurs_courantes.periode_ordinaire=false;
    Bouton_de_choix(per_a_echoir);
}
bool MainFrame::Affiche_resultat_calcul(type_de_valeurs typval,double val)
{
    bool est_valide(true);
    if (!affichage_en_cours)
    {
        Traducteur tr;
        wxString message(wxT("Anormal"));
        item_menu_change=true;
        try
            {
            Valeurs_courantes.contenu[typval].Set_Valeur(val);
            message=tr.trad(Valeurs_courantes.contenu[typval].NomVal())+wxT(" ")+tr.trad(wxT("recalcul(e)"));
            }
        catch(Erreur_SC& err1)
            {
            message=err1.message;
            est_valide=false;
            }
        Titre_Fen=message;
        Affichage_valeurs();
        if (Valeurs_courantes.mode_tableau_on) Affichage_tableau();
        Refresh();
    }
    return est_valide;
}
//---------------------------------------------------------------------------
void  MainFrame::OnBout1(wxCommandEvent& event)
{
    Affiche_resultat_calcul(ValeurInit,Calculs::Calcul_valeur_initiale(Valeurs_courantes));
}
//---------------------------------------------------------------------------
void  MainFrame::OnBout2(wxCommandEvent& event)
{
    Affiche_resultat_calcul(ValeurFinale,Calculs::Calcul_valeur_finale(Valeurs_courantes));
}
//---------------------------------------------------------------------------
void  MainFrame::OnBout3(wxCommandEvent& event)
{
    Affiche_resultat_calcul(VersementParPeriode,Calculs::Calcul_valeur_Versement(Valeurs_courantes));
}
//---------------------------------------------------------------------------
void  MainFrame::OnBout4(wxCommandEvent& event)
{
    // Le nombre de priodes de capitalisation recalcul est celui qui permet une valeur finale au moins gale
    //  la valeur existante. Comme c'est un entier, la valeur finale doit tre recalcule.
    if(Affiche_resultat_calcul(NbPeriodes,Calculs::Calcul_valeur_Nb_periodes(Valeurs_courantes)))
        Affiche_resultat_calcul(ValeurFinale,Calculs::Calcul_valeur_finale(Valeurs_courantes));
}
//---------------------------------------------------------------------------
void  MainFrame::OnBout5(wxCommandEvent& event)
{
    if(Affiche_resultat_calcul(TauxAnnuel,Calculs::Calcul_valeur_taux(Valeurs_courantes)))
        Affiche_resultat_calcul(TauxNominal,Calculs::Conversion_taux_reel_Taux_Nominal(Valeurs_courantes));
}
//---------------------------------------------------------------------------
void  MainFrame::OnBout6(wxCommandEvent& event)
{
    // Le nombre de priodes de capitalisation par an recalcul est celui qui permet une valeur finale le plus proche
    // de la valeur existante. Comme c'est un entier, la valeur finale doit tre recalcule.
    if(Affiche_resultat_calcul(NbPeriodesParAn,Calculs::Calcul_valeur_Nb_periodes_par_an(Valeurs_courantes)))
        Affiche_resultat_calcul(ValeurFinale,Calculs::Calcul_valeur_finale(Valeurs_courantes));
}
//---------------------------------------------------------------------------
void  MainFrame::OnBout7(wxCommandEvent& event)
{
    if(Affiche_resultat_calcul(TauxAnnuel,Calculs::Calcul_valeur_taux(Valeurs_courantes)))
        Affiche_resultat_calcul(TauxNominal,Calculs::Conversion_taux_reel_Taux_Nominal(Valeurs_courantes));
}
//---------------------------------------------------------------------------
void MainFrame::saisie_val(wxTextCtrl* boite_active,type_de_valeurs typval)
{
if (!affichage_en_cours)
    {
        Traducteur tr;
        wxString message(wxT("Anormal"));
        item_menu_change=true;
        try
            {
            Valeurs_courantes.contenu[typval].pos_curseur=boite_active->GetInsertionPoint();
            Valeurs_courantes.contenu[typval].Set_Valeur(boite_active->GetLineText(0));
            message=tr.trad(Valeurs_courantes.contenu[typval].NomVal())+wxT(" ")+tr.trad(wxT("modifi(e)"));
            }
        catch(Erreur_SC& err1)
            {
            message=message+wxT(" ")+err1.message;
            }
        Titre_Fen=message;
        Affichage_valeurs();
        Refresh();
    }
}
//---------------------------------------------------------------------------
void  MainFrame::OnFenBout1(wxCommandEvent& event)
{    saisie_val(FenBout1,ValeurInit);}
//---------------------------------------------------------------------------
void  MainFrame::OnFenBout2(wxCommandEvent& event)
{    saisie_val(FenBout2,ValeurFinale);}
//---------------------------------------------------------------------------
void  MainFrame::OnFenBout3(wxCommandEvent& event)
{    saisie_val(FenBout3,VersementParPeriode);}
//---------------------------------------------------------------------------
void  MainFrame::OnFenBout4(wxCommandEvent& event)
{    saisie_val(FenBout4,NbPeriodes);}
//---------------------------------------------------------------------------
void  MainFrame::OnFenBout5(wxCommandEvent& event)
{   // les valeurs Taux nominal et rel sont modifies simultanment
    saisie_val(FenBout5,TauxAnnuel);
    Affiche_resultat_calcul(TauxNominal,Calculs::Conversion_taux_reel_Taux_Nominal(Valeurs_courantes));
}
//---------------------------------------------------------------------------
void  MainFrame::OnFenBout6(wxCommandEvent& event)
{   // La modification affecte la valeur du taux nominal, le taux annuel rel tant gard constant
    saisie_val(FenBout6,NbPeriodesParAn);
    Affiche_resultat_calcul(TauxNominal,Calculs::Conversion_taux_reel_Taux_Nominal(Valeurs_courantes));
}
//---------------------------------------------------------------------------
void  MainFrame::OnFenBout7(wxCommandEvent& event)
{   // les valeurs Taux nominal et rel sont modifies simultanment
    saisie_val(FenBout7,TauxNominal);
    Affiche_resultat_calcul(TauxAnnuel,Calculs::Conversion_Taux_Nominal_taux_reel(Valeurs_courantes));
}
