#ifndef CALCULE_H_INCLUDED
#define CALCULE_H_INCLUDED
/*
    SquirrelPocketCalc. Copyright (C) 2015 - 2021
    Vial Jean-Luc Annecy
    Contact email: vial.frjl@free.fr

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#include "BoiteAOutils.h"
typedef enum {ValeurInit,ValeurFinale,VersementParPeriode,NbPeriodes,TauxAnnuel,NbPeriodesParAn,TauxNominal} type_de_valeurs;

class Element_contenu_de_valeurs
{
public:
    Element_contenu_de_valeurs();
    Element_contenu_de_valeurs(wxString nv,wxString ft,double va,double li,double ls,bool est_ent,int pv);
    double Valeur();
    double Liminf();
    double Limsup();
    wxString NomVal();
    void Set_Valeur(wxString val_chaine);
    void Set_Valeur(double val);
    wxString Valeur_chaine();
    int pos_virgule;
    int pos_curseur;
    int pos_curseur_anc;
private:
    wxString nomval,formatAff,val_chaine_anc;
    double valeur,valeur_anc,lim_inf,lim_sup;
    bool est_un_entier;
    double filtre_valeurs(wxString val_chaine);
    double filtre_valeurs(bool affichable,double val);
    int longueur_format();
};
class Jeu_de_valeurs
{
public:
    bool periode_ordinaire;
    bool mode_tableau_on;
    Jeu_de_valeurs();
    double Taux_par_periode();// correspondant au taux annuel courant en %
    double Taux_par_periode(double taux);// correspondant à un taux annuel quelconque en %
    double Taux_min_par_periode();
    double Taux_max_par_periode();
    std::map<type_de_valeurs,Element_contenu_de_valeurs> contenu;
};
    namespace Calculs
{
    int nb_de_valeurs();
    double Calcul_valeur_finale(Jeu_de_valeurs& jv);
    double Calcul_valeur_initiale(Jeu_de_valeurs& jv);
    double Calcul_valeur_Versement(Jeu_de_valeurs& jv);
    double Calcul_valeur_taux(Jeu_de_valeurs& jv);
    double Calcul_valeur_Nb_periodes(Jeu_de_valeurs& jv);
    double Calcul_valeur_Nb_periodes_par_an(Jeu_de_valeurs& jv);
    double Conversion_taux_reel_Taux_Nominal(Jeu_de_valeurs& jv);
    double Conversion_Taux_Nominal_taux_reel(Jeu_de_valeurs& jv);
    void Calcul_une_ligne_tableau(int periode, double& RembInt,double& RembCap,double& ResteDu,Jeu_de_valeurs jv);
};
#endif //CALCULE_H_INCLUDED
