#include "Calcule.h"
#include "ProjetdeBase.h"

//---------------------------------------------------------------------------
// lment du conteneur de valeurs
//---------------------------------------------------------------------------
    //Constructeurs
    Element_contenu_de_valeurs::Element_contenu_de_valeurs(){};
    Element_contenu_de_valeurs::Element_contenu_de_valeurs(wxString nv,wxString ft,double va,double li,double ls,bool est_ent,int pv)
        :nomval(nv),formatAff(ft),valeur(va),valeur_anc(va),lim_inf(li),lim_sup(ls),est_un_entier(est_ent),pos_virgule(pv),pos_curseur(0),pos_curseur_anc(-100),val_chaine_anc(wxT("0.00")){pos_curseur_anc=longueur_format()-pos_virgule;}
//---------------------------------------------------------------------------
    double Element_contenu_de_valeurs::filtre_valeurs(wxString val_chaine)
    {
        double val;bool affichable;
        val_chaine=val_chaine.AfterLast(' ');
        val_chaine_anc=val_chaine_anc.AfterLast(' ');
        int long_chaine(val_chaine.length());
        int deltaL(val_chaine_anc.length()-long_chaine); //Variation de longueur de la valeur
        if ((deltaL>0)&&(pos_curseur<=longueur_format()-pos_virgule)) pos_curseur+=deltaL; // il y a eu une dletion de chiffres dans la partie entire
        if ((deltaL<0)&&(pos_curseur>longueur_format()-pos_virgule)) pos_curseur-=deltaL; // il y a eu une addition de chiffres dans la partie dcimale
        if (long_chaine==1) pos_curseur=longueur_format()-pos_virgule; // cas d'une slection-remplacement (toute la ligne slectionne remplace par un caractre)
        if (long_chaine==0) {val_chaine=wxT("0");pos_curseur=longueur_format()-pos_virgule;}// effacement de la chane
        affichable=(val_chaine.ToDouble(&val)); // nombre valide
        // possde un sparateur dcimal ? Si oui, ce n'est pas un entier valide
        // La fonction virgule() renvoie la chane correcte conforme  la localisation
        // mais sous windows, wxString.format semble mettre toujours un point dcimal
        bool a_un_separateur_decimal((val_chaine.Find(wxT(","))!=wxNOT_FOUND)||(val_chaine.Find(wxT("."))!=wxNOT_FOUND));
        affichable=(est_un_entier?affichable&&(!a_un_separateur_decimal):affichable);
        // Il semble que la gestion du curseur soit diffrente dans les versions Windows et Linux
        #if defined(__WXMSW__)
        if (deltaL<0)
            {pos_curseur--;
            if (pos_curseur==(longueur_format()-pos_virgule)+1) pos_curseur--;
            }
        #endif
        if (!affichable) pos_curseur=pos_curseur_anc;
            else pos_curseur_anc=pos_curseur;
        return filtre_valeurs(affichable,val);
    }
//---------------------------------------------------------------------------
    double Element_contenu_de_valeurs::filtre_valeurs(bool affichable,double val)
    {
        Traducteur tr;
        wxString Message_erreur=tr.trad(NomVal())+wxT(" ")+tr.trad(wxT("hors limite"));
        if ((!affichable)||(!Est_dans(val,lim_inf,lim_sup)))
                throw (Erreur_SC(Message_erreur));
        val_chaine_anc=wxString::Format(formatAff,val);
        return val;
    }
//---------------------------------------------------------------------------
    int Element_contenu_de_valeurs::longueur_format()
    {
        return wxString::Format(formatAff,1.0).length();
    }
//---------------------------------------------------------------------------
    void Element_contenu_de_valeurs::Set_Valeur(wxString val_chaine)
    {
        double resultat=filtre_valeurs(val_chaine);
        if (est_un_entier) resultat=int(resultat+0.5);
        valeur=resultat;
    }
    void Element_contenu_de_valeurs::Set_Valeur(double val)
    {
        double resultat=filtre_valeurs(true,val);
        if (est_un_entier) resultat=int(resultat+0.5);
        valeur=resultat;
    }
//---------------------------------------------------------------------------
    double Element_contenu_de_valeurs::Valeur(){return valeur;}
//---------------------------------------------------------------------------
    double Element_contenu_de_valeurs::Liminf(){return lim_inf;}
//---------------------------------------------------------------------------
    double Element_contenu_de_valeurs::Limsup(){return lim_sup;}
//---------------------------------------------------------------------------
    wxString Element_contenu_de_valeurs::Valeur_chaine(){return wxString::Format(formatAff,valeur);}
//---------------------------------------------------------------------------
    wxString Element_contenu_de_valeurs::NomVal(){return nomval;}
//---------------------------------------------------------------------------
// Conteneur de valeurs
//---------------------------------------------------------------------------
    Jeu_de_valeurs::Jeu_de_valeurs()
    {
    // Paramtres d'Element_contenu_devaleurs 1 nom du paramtre, 2 format d'affichage, 3 valeur par dfaut, 3 valeur mini 4 valeur maxi, 5 valeur entire,6 position virgule
    periode_ordinaire=true;
    mode_tableau_on=false;
    contenu.insert(std::make_pair(ValeurInit         ,Element_contenu_de_valeurs(wxT("Valeur initiale"          ),wxT("%9.2f"),1000,0,999999,false,3 )));
    contenu.insert(std::make_pair(ValeurFinale       ,Element_contenu_de_valeurs(wxT("Valeur finale"            ),wxT("%9.2f"),1000,0,999999,false,3 )));
    contenu.insert(std::make_pair(VersementParPeriode,Element_contenu_de_valeurs(wxT("Versement par priode"    ),wxT("%9.2f"),0,-999999,999999,false,3 )));
    contenu.insert(std::make_pair(NbPeriodes         ,Element_contenu_de_valeurs(wxT("Nombre de priodes"       ),wxT("%3.0f"),1,0,999,true,0 )));
    contenu.insert(std::make_pair(TauxAnnuel         ,Element_contenu_de_valeurs(wxT("Taux annuel en %"         ),wxT("%7.3f"),10,-99,999,false,4 )));
    contenu.insert(std::make_pair(NbPeriodesParAn    ,Element_contenu_de_valeurs(wxT("Nombre de priodes par an"),wxT("%3.0f"),1,1,365,true,0 )));
    contenu.insert(std::make_pair(TauxNominal        ,Element_contenu_de_valeurs(wxT("Taux nominal en %"        ),wxT("%7.3f"),10,-99,999,false,4 )));
   }
    //---------------------------------------------------------------------------
    // Calcule le taux par priode de capitalisation  partir du taux annuel et du nombre de priode par an
    // taux en %
    double Jeu_de_valeurs::Taux_par_periode()
        {return Taux_par_periode(contenu[TauxAnnuel].Valeur());}
    //---------------------------------------------------------------------------
    // Calcule le taux par priode de capitalisation  partir d'un taux annuel quelconque et du nombre de priode par an
    // taux en %
    double Jeu_de_valeurs::Taux_par_periode(double taux)
        {return (pow(1+taux/100,1/contenu[NbPeriodesParAn].Valeur())-1)*100;}
    //---------------------------------------------------------------------------
    double Jeu_de_valeurs::Taux_min_par_periode()
        {return Taux_par_periode(contenu[TauxAnnuel].Liminf());}
    //---------------------------------------------------------------------------
    double Jeu_de_valeurs::Taux_max_par_periode()
        {return Taux_par_periode(contenu[TauxAnnuel].Limsup());}
//---------------------------------------------------------------------------
// Espace de nommage Calculs
//---------------------------------------------------------------------------
namespace Calculs
{
    // test
    void voit_vecteur(std::vector<double> v)
    {
        double t[3]={0.0};
        double prov(0);
        for (int i=0;i<3;i++)
        {
            prov=v[i];
            t[i]=v[i];
        }
        t[2]=0;
    }
    //---------------------------------------------------------------------------
    int nb_de_valeurs()
    {
        // retourne le nombre de valeurs dans un jeu de valeurs
        int resultat(0);
        for (type_de_valeurs i=ValeurInit;i<=TauxNominal;i=suivant(i)){resultat++;}
        return resultat;
    }
    //---------------------------------------------------------------------------
    double Calcul_valeur_finale(Jeu_de_valeurs& jv)
    {
        double vp(jv.contenu[VersementParPeriode].Valeur()),correctif(jv.periode_ordinaire?0:vp);
        double Resultat,v0(jv.contenu[ValeurInit].Valeur()+correctif),T(1+jv.Taux_par_periode()/100),n(jv.contenu[NbPeriodes].Valeur());
        if (T==1) Resultat=v0+n*vp;
        else Resultat=v0*pow(T,n)+vp*(1-pow(T,n))/(1-T);
        return Resultat-correctif;
    }
    //---------------------------------------------------------------------------
    double Calcul_valeur_initiale(Jeu_de_valeurs& jv)
    {
        double vp(jv.contenu[VersementParPeriode].Valeur()),correctif(jv.periode_ordinaire?0:vp);
        double Resultat,v1(jv.contenu[ValeurFinale].Valeur()+correctif),T(1+jv.Taux_par_periode()/100),n(jv.contenu[NbPeriodes].Valeur());
        if (T==1) Resultat=v1-n*vp;
        else Resultat=(v1-vp*(1-pow(T,n))/(1-T))/pow(T,n);
        return Resultat-correctif;
    }
    //---------------------------------------------------------------------------
    double Calcul_valeur_Versement(Jeu_de_valeurs& jv)
    {
        double T(1+jv.Taux_par_periode()/100),correctif(jv.periode_ordinaire?1:T);
        double Resultat,v0(jv.contenu[ValeurInit].Valeur()),v1(jv.contenu[ValeurFinale].Valeur()),n(jv.contenu[NbPeriodes].Valeur());
        if (T==1) Resultat=(v1-v0)/n;
        else Resultat=(v1-v0*pow(T,n))*(1-T)/((1-pow(T,n))*correctif);
        return Resultat;
    }
    //---------------------------------------------------------------------------
    double fonction_de_T(double v0,double v1,double vp,double n,double T,bool p_ord)
    // Calcule valeur finale observe - valeur finale calcule
    // S'annule quand le taux est le bon
    {
        double resultat;
        if (p_ord)
                resultat=v0*pow(T,n+1)-(v0-vp)*pow(T,n)-v1*T+v1-vp;
        else    resultat=(vp+v0)*pow(T,n+1)-v0*pow(T,n)-(vp+v1)*T+v1;
        return resultat;
    }
    //---------------------------------------------------------------------------
    // On cherche  annuler la fonction de T sur le segment donn
    // Si aucune valeur n'est trouve, retourne la valeur T de dpart
    // Sinon met la variable trouve  true
    // L'exploration s'arrte quand le segment est plus court que precisionresultat (en %) /100
    double cherche_inversion(bool& trouve,double v0,double v1,double vp,double n,double T,double segment,double pr,bool p_ord)
    {
    double precisionresultat(pr),incr(segment/10.0),k,k0(fonction_de_T(v0,v1,vp,n,T,p_ord)),resultat(T);
        if(segment>(precisionresultat/100))
            {
            for (double i=T;i<(T+segment+incr/2);i+=incr)//+incr/2 pour s'assurer que la valeur T+ segment est couverte
                {
                k=fonction_de_T(v0,v1,vp,n,i,p_ord);
                if ((k*k0)<=0) // si le signe a chang ou que la valeur est nulle.
                    {
                    resultat=(k?i-incr:i);// Si k est nul, i est la solution exacte
                    i=T+segment+incr; // sortie de boucle i
                    trouve=true;
                    }
                }
            if (k!=0) resultat=cherche_inversion(trouve,v0,v1,vp,n,resultat,incr,precisionresultat,p_ord); // recommence tant que la prcision voulue n'est pas atteinte
            }
    return resultat;
    }
    //---------------------------------------------------------------------------
    // Retourne le taux d'intrt approch en %
    double Calcul_valeur_taux(Jeu_de_valeurs& jv)
    {
        Jeu_de_valeurs jprov(jv);
        double  Resultat,v0(jv.contenu[ValeurInit].Valeur()),v1(jv.contenu[ValeurFinale].Valeur()),
                vp(jv.contenu[VersementParPeriode].Valeur()),
                T,n(jv.contenu[NbPeriodes].Valeur()),
                precisionresultat(0.0000001), // prcision vise en % du taux annuel
                precision_par_periode=jprov.Taux_par_periode(precisionresultat),
                // C'est la prcision sur le taux par priode (en %) qui est utilise
                segment,v1_si_taux_1(v0+vp*n);
        bool trouve(false),p_ord(jv.periode_ordinaire);
        // La racine vidente T=1 est-elle avant ou aprs le taux rel;
        if(v1_si_taux_1>v1)     // le taux est <1
        {
            segment=(-jv.Taux_min_par_periode()-precision_par_periode)/100;
            T=(jv.Taux_min_par_periode()+100)/100;
        }
        if(v1_si_taux_1<v1) // le taux est >1
        {
            segment=(jv.Taux_max_par_periode()-precision_par_periode/2)/100;
            T=(100+precision_par_periode/2)/100;
        }
        // Encadrement du segment o la valeur du taux est indistinguable de 1
        jprov.contenu[TauxAnnuel].Set_Valeur(-precisionresultat);
        double v1_min_si_taux_1=Calcul_valeur_finale(jprov);
        jprov.contenu[TauxAnnuel].Set_Valeur( precisionresultat);
        double v1_max_si_taux_1=Calcul_valeur_finale(jprov);
        // Peu de chances d'avoir le taux rel entre 1-prcision par priode et 1+ prcision par priode
        // Mais si cela arrive la fonction cherche_inversion ne converge pas
        // il faut donc sparer ce cas
        if((v1_min_si_taux_1<v1)&&(v1_max_si_taux_1>v1))
            {
                Resultat=1;
                trouve=true;
            }
            else // toutes les autres valeurs
                Resultat=cherche_inversion(trouve,v0,v1,vp,n,T,segment,precision_par_periode,p_ord);
        Resultat=(trouve?pow(Resultat,jv.contenu[NbPeriodesParAn].Valeur()):jv.contenu[TauxAnnuel].Limsup()+10);
        return (Resultat-1)*100;
    }
    //---------------------------------------------------------------------------
    //Retourne le nombre de priodes total ou par an amenant au plus proche de la valeur finale
    //retourne la valeur invalide bornsup+1 en cas d'chec
    // Echec si on atteint la bonsup sans avoir trouv la valeur exacte de valeur finale
    double Calcul_valeur_Nb_per(type_de_valeurs m,Jeu_de_valeurs& jv)
    {
    int Resultat(0);
    if ((m==NbPeriodes)||(m==NbPeriodesParAn))
        {
        int     borninf(jv.contenu[m].Liminf()),
                bornsup(jv.contenu[m].Limsup());
        Resultat=borninf;
        double  Valeur_finale_cible(jv.contenu[ValeurFinale].Valeur()),Valeur_finale_nouvelle(0),
                ecartmin(jv.contenu[ValeurFinale].Limsup()),ecart(0);
        for (int i=borninf;i<=bornsup;i++)
            {
            jv.contenu[m].Set_Valeur(i);
            Valeur_finale_nouvelle=Calcul_valeur_finale(jv);
            ecart=std::abs(Valeur_finale_cible-Valeur_finale_nouvelle);
            if (ecartmin>ecart)
                {Resultat=i;
                ecartmin=ecart;
                }
            }
         Resultat=((Resultat<bornsup)||(!ecartmin)?Resultat:++Resultat) ;
        }
    return Resultat;
    }
    //---------------------------------------------------------------------------
    // Retourne le nombre de priodes amenant au plus proche de la valeur finale
    double Calcul_valeur_Nb_periodes(Jeu_de_valeurs& jv)
    {
        return Calcul_valeur_Nb_per(NbPeriodes,jv);
    }
    //---------------------------------------------------------------------------
    // Retourne le nombre de priodes par an amenant au plus proche de la valeur finale
    double Calcul_valeur_Nb_periodes_par_an(Jeu_de_valeurs& jv)
    {
        return Calcul_valeur_Nb_per(NbPeriodesParAn,jv);
    }
    //---------------------------------------------------------------------------
    // Retourne nb_per_par_an fois (en gnral douze fois) le taux par priode
    double Conversion_taux_reel_Taux_Nominal(Jeu_de_valeurs& jv)
    {
        return jv.Taux_par_periode()*jv.contenu[NbPeriodesParAn].Valeur();
    }
    //---------------------------------------------------------------------------
    // Retourne Taux_par_priode  la puissance Nb_per_par_an.
        double Conversion_Taux_Nominal_taux_reel(Jeu_de_valeurs& jv)
    {
        return ((pow(1+jv.contenu[TauxNominal].Valeur()/(100*jv.contenu[NbPeriodesParAn].Valeur()),jv.contenu[NbPeriodesParAn].Valeur())-1)*100);
    }
    //---------------------------------------------------------------------------
    // Retourne une ligne du tableau des annuit
    // Reoit la priode  calculer, le jeu de valeurs courantes n'est pas modifi
    void Calcul_une_ligne_tableau(int periode, double& RembInt,double& RembCap,double& RestDu,Jeu_de_valeurs jv)
    {
        jv.contenu[NbPeriodes].Set_Valeur(periode-1);
        RembCap=Calcul_valeur_finale(jv);
        jv.contenu[NbPeriodes].Set_Valeur(periode);
        RestDu=Calcul_valeur_finale(jv);
        RembCap-=RestDu;// Capital restant  la priode (n-1) - capital restant  n
        RembInt=-(RembCap+jv.contenu[VersementParPeriode].Valeur());
    }
}
