#include "BoiteAOutils.h"
#include <wx/intl.h>
#include <wx/tooltip.h>
//---------------------------------------------------------------------------
vecteur fait_vecteur(wxPoint p){return vecteur(p.x,p.y);}
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
// Formate une chane  la longueur L en ajoutant des espaces avant ou aprs.
// Si la chane est de longueur suprieure  L, tronque  L.
wxString Ajuste_chaine_a_longueur(wxString chaine, int L,bool espaces_apres)
{
    int long_ch(chaine.Len());
    if (long_ch>L) chaine.Truncate(L);
    chaine.Pad(L-chaine.Len(),wxT(' '),espaces_apres);
    return chaine;
}
//---------------------------------------------------------------------------
// Emulation de la fonction RandomRange
// retourne un entier dans l'intervalle [low, High[
int RandomRange_bis(int low,int high)
{
        if (high <low) high=low;
        return (rand() % (high-low))+low;
}
//---------------------------------------------------------------------------
//      Implmentation de l'objet Traducteur
//---------------------------------------------------------------------------
        void Traducteur::ajoute_une_entree(wxString Tf,wxString Ta)
{
        Dictionnaire di;
        di.insert(std::make_pair(ang,Ta));
        textes.insert(std::make_pair(Tf,di));
}
//---------------------------------------------------------------------------
        Traducteur::Traducteur()
{
        ajoute_une_entree(wxT(" active"),wxT(" enabled"));
        ajoute_une_entree(wxT(" inactive"),wxT(" disabled"));
        ajoute_une_entree(wxT(" avec "),wxT(" with "));
        ajoute_une_entree(wxT("&Rubriques d'aide"),wxT("&Help topics"));
        ajoute_une_entree(wxT("A propos"),wxT("About"));
        ajoute_une_entree(wxT("Abaque prt"),wxT("Loan table"));
        ajoute_une_entree(wxT("Aide"),wxT("Help"));
        ajoute_une_entree(wxT("Annule"),wxT("Cancel"));
        ajoute_une_entree(wxT("Avertissement"),wxT("Disclaimer"));
        ajoute_une_entree(wxT("Bonjour !"),wxT("Hello !"));
        ajoute_une_entree(wxT("Calculette financire SquirrelPocketCalc"),wxT("Finance calculator SquirrelPocketCalc"));
        ajoute_une_entree(wxT("Capital"),wxT("Capital"));
        ajoute_une_entree(wxT("Compte pargne"),wxT("Saving account"));
        ajoute_une_entree(wxT("Conversion taux nominal /effectif"),wxT("Conversion nominal/effective yield"));
        ajoute_une_entree(wxT("DisclaimimageFra.png"),wxT("DisclaimimageEng.png"));
        ajoute_une_entree(wxT("Enregistrer sous..."),wxT("Save as ..."));
        ajoute_une_entree(wxT("Enregistrer"),wxT("Save"));
        ajoute_une_entree(wxT("chance ordinaire (en fin de priode)"),wxT("due date at the end of the period "));
        ajoute_une_entree(wxT("opration  echoir (en dbut de priode)"),wxT("due date at the beginning of the period "));
        ajoute_une_entree(wxT("Fermer"),wxT("Close"));
        ajoute_une_entree(wxT("Fichier d'aide non trouv\n"),wxT("Help file not found\n"));
        ajoute_une_entree(wxT("Fichiers"),wxT("Files"));
        ajoute_une_entree(wxT("hors limite"),wxT("off bounds"));
        ajoute_une_entree(wxT("Impression"),wxT("Print"));
        ajoute_une_entree(wxT("Intrts composs"),wxT("Compound interest"));
        ajoute_une_entree(wxT("Intrts"),wxT("Interests"));
        ajoute_une_entree(wxT("Langage"),wxT("Language"));
        ajoute_une_entree(wxT("mars 2015 / janvier 2021"),wxT("March 2015 / January 2021"));
        ajoute_une_entree(wxT("Mode de calcul "),wxT("Active mode "));
        ajoute_une_entree(wxT("modifi(e)"),wxT("changed"));
        ajoute_une_entree(wxT("N pr."),wxT("N"));
        ajoute_une_entree(wxT("Nombre de priodes par an"),wxT("Number of periods per year"));
        ajoute_une_entree(wxT("Nombre de priodes"),wxT("Number of periods"));
        ajoute_une_entree(wxT("Outils"),wxT("Tools"));
        ajoute_une_entree(wxT("Ouverture de "),wxT("Opening"));
        ajoute_une_entree(wxT("Ouvrir"),wxT("Open"));
        ajoute_une_entree(wxT("Paramtres"),wxT("Parameters"));
        ajoute_une_entree(wxT("Pas d'erreur"),wxT("Everything OK"));
        ajoute_une_entree(wxT("Priode  choir : versement/retrait en dbut de priode"),wxT("Annuity due : deposit/withdrawal at the beginning of the period"));
        ajoute_une_entree(wxT("Priode ordinaire : versement/retrait en fin de priode"),wxT("Ordinary period : deposit/withdrawal at the end of the period"));
        ajoute_une_entree(wxT("Priode  choir"),wxT("Annuity due"));
        ajoute_une_entree(wxT("Priode ordinaire"),wxT("Ordinary period"));
        ajoute_une_entree(wxT("Prvisualisation"),wxT("Preview"));
        ajoute_une_entree(wxT("Quitter"),wxT("Exit"));
        ajoute_une_entree(wxT("recalcul(e)"),wxT("updated"));
        ajoute_une_entree(wxT("Renomme"),wxT("Rename"));
        ajoute_une_entree(wxT("Remboursement de prt"),wxT("Repayment of a loan"));
        ajoute_une_entree(wxT("Reste du"),wxT("Still due"));
        ajoute_une_entree(wxT("Sans titre"),wxT("untitled"));
        ajoute_une_entree(wxT("Sauve le fichier en cours"),wxT("Save the current file"));
        ajoute_une_entree(wxT("SquirrelPocketCalcfrahlp"),wxT("SquirrelPocketCalcenghlp"));
        ajoute_une_entree(wxT("Supprime"),wxT("Delete"));
        ajoute_une_entree(wxT("Taux annuel en %"),wxT("interest rate (%)"));
        ajoute_une_entree(wxT("Taux nominal en %"),wxT("Annualised Percentage Rate"));
        ajoute_une_entree(wxT("Tous fichiers"),wxT("All files"));
        ajoute_une_entree(wxT("Valeur finale"),wxT("Future value"));
        ajoute_une_entree(wxT("Valeur initiale"),wxT("Principal amount"));
        ajoute_une_entree(wxT("Versement par priode"),wxT("Periodic deposit"));
}
//---------------------------------------------------------------------------
        langues& Traducteur::fixe_langue()
{
        static langues Langue_active=fr;
        return Langue_active;
}
//---------------------------------------------------------------------------
// Variable globale donnant le type de sparateur de la partie dcimale
    wxString& virgule()
    {
        static wxString vrg(wxT(","));
        return vrg;
    }
//---------------------------------------------------------------------------
        //fixe la langue de dpart
        void Traducteur::langue_demarrage()
{
        bool est_francais(true);
#if defined(__WXMSW__)
        // 1036 pour le franais
        est_francais=(GetSystemDefaultLangID()==1036);
#elif defined(__UNIX__)
        wxString lg;
        wxGetEnv(wxT("LANG"),&lg);
        lg=lg.Left(2);
        est_francais=(lg==wxT("fr"));
#endif
        if (est_francais) fixe_langue()=fr;
                else
                {
                    virgule()=wxT(".");
                    fixe_langue()=ang;
                }
}
//---------------------------------------------------------------------------
        wxString Traducteur::trad(wxString T)
{
        if (textes.find(T)==textes.end()) return T;
        langues L=fixe_langue();
        if (L==fr) return T;
        return textes[T][L];
}
//---------------------------------------------------------------------------
        wxString Traducteur::trad_tout(wxString T)
{
        wxString traduction=T;
        for(std::map<wxString,Dictionnaire>::iterator i=textes.begin();i!=textes.end();++i)
                if (T==i->first) traduction=trad(T);
                else  for(langues j=suivant(fr);j<=ang;j=suivant(j))
                        if (T==i->second[j])
                                traduction=trad(i->first);
        return traduction;
}
//---------------------------------------------------------------------------
//      Fin de l'objet Traducteur
//---------------------------------------------------------------------------
wxColor& Couleur_Fenetres_defaut()
{
        static wxColor couleur_fen=wxSystemSettings::GetColour(wxSYS_COLOUR_ACTIVEBORDER);
        return couleur_fen;
}
wxRect& Taille_Fenetres_defaut()
{
        //Fixe une position et une taille initiale
        // format pos.x, pos.y, Largeur, Hauteur
        static wxRect taille_fen(150,50,700,400);
        return taille_fen;
}
wxPoint FaitReelle_Pos(wxPoint posvirtuelle,wxWindow* fen)
{
        int X= fen->GetClientSize().GetWidth();
        int Y= fen->GetClientSize().GetHeight();
        return wxPoint(int(posvirtuelle.x*X/1000.0),int(posvirtuelle.y*Y/1000.0));
}
wxSize FaitReelle_Taille(wxSize Sizevirtuelle,wxWindow* fen)
{
        int X= fen->GetClientSize().GetWidth();
        int Y= fen->GetClientSize().GetHeight();
        Sizevirtuelle.Scale(float(X/1000.0),float(Y/1000.0));
        return Sizevirtuelle;
}
void Ajuste_taille_et_pos(wxPoint pos,wxSize taille,wxWindow* fen_mere,wxWindow* fen_fille)
{
        pos=FaitReelle_Pos(pos,fen_mere);
        taille=FaitReelle_Taille(taille,fen_mere);
        fen_fille->SetSize(wxRect(pos,taille));
}
void FixeFontEtTaille(wxWindow* fen)
{
        wxFont Police(fen->GetFont());
        Police.SetPointSize(8);
        fen->SetFont(Police);
}
//---------------------------------------------------------------------------
        PalettePerso::PalettePerso():clDkGray(128,128,128),clCream(255,251,240),clAqua(0,255,255),clLtGray(192,192,192),clRed(255,0,0),clBlack(0,0,0),
                                    clYellow(255,255,0),clLime(0,255,0)
        {
        }
//---------------------------------------------------------------------------
void RenommeEnfants(wxWindow* Sujet)
{
        Traducteur tr;
        wxToolTip* tt;
        wxFrame* p_frame;
        // Sous Windows Setlabel ajuste correctement le titre des "Frames' mais pas sous Linux
        // d'o la ncessit de distinguer WxXindow et wxFrame
        p_frame=dynamic_cast<wxFrame*>(Sujet);
        if (p_frame!=NULL) // C'est une wxWFrame
            p_frame->SetTitle(tr.trad_tout(p_frame->GetTitle()));
        else // C'est une simple wxWindow
            Sujet->SetLabel(tr.trad_tout(Sujet->GetLabel()));
        tt=Sujet->GetToolTip();
        if (tt!=NULL)
            Sujet->SetToolTip(tr.trad_tout(tt->GetTip()));
        // Mme chose pour les enfants
        wxWindowList list;
        list=Sujet->GetChildren();
        wxWindowList::compatibility_iterator node;
        for (node = list.GetFirst(); node; node = node->GetNext() )
            {
            wxWindow *current = node->GetData();
            RenommeEnfants(current);
            }
}
//---------------------------------------------------------------------------
//      Ajuste la taille de la police  celle de la fentre courante
        void fixe_taille_police(wxDC& dc,float correctif)
        {
        // Correctif introduit pour tenir compte du problme avec la dfinition de l'impression sous Linux
        // en mode impression mais pas en preview. Je n'ai pas trouv mieux pour le moment
        float hauteur_police=8;
        float hauteur_ecran=dc.GetSize().GetHeight();
        float largeur_ecran=dc.GetSize().GetWidth();
        float def_ecran=dc.GetPPI().GetHeight();
        if (hauteur_ecran>largeur_ecran)hauteur_ecran=largeur_ecran; //ne tient compte que de la plus petite dimension
        hauteur_police*=hauteur_ecran/(def_ecran*2*correctif);
        hauteur_police=(hauteur_police<3?3:hauteur_police);
        dc.SetFont(wxFont(int(hauteur_police),wxFONTFAMILY_DEFAULT,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false));
        }
//---------------------------------------------------------------------------
void Base_Tabule_ecrit(wxDC* dc,wxString st,wxPoint pos)
{   // crit st  la position pos (x en nombre de caractre et y nombre de lignes de texte)
    wxSize taille_texte=dc->GetTextExtent(wxT("Q"));
    dc->DrawText(st,pos.x*taille_texte.GetWidth(),pos.y*taille_texte.GetHeight());
}
