#ifndef MAINFRAME_H_INCLUDED
#define MAINFRAME_H_INCLUDED
/*
    Simulation panneaux photovoltaques. Copyright (C) 2013-2021
    Vial Jean-Luc Annecy
    Contact email: vial.frjl@free.fr

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

// On ajoute les headers "basiques" de wxWidgets
#include <wx/wx.h>
#include "BoiteAOutils.h"
#include <wx/html/helpctrl.h>
#include "Dessin.h"

//---------------------------------------------------------------------------
// Objets propres au programme PanneauxPPV_puissance
//---------------------------------------------------------------------------
class Erreur_PV
{
  public:
  wxString message;
  explicit Erreur_PV(wxString message_erreur);
};
//---------------------------------------------------------------------------
class base_site_et_date
{
    protected:
    int& lngtde();
    int& dclge();
    base_site_et_date();
    public:
    bool Est_affichable; // False si la valeur est en cours de saisie
    bool& heure_ete_activee();
    int longitude(wxString p);
    int longitude();
    int decalage(wxString p);
    int decalage();
    void fixe_longitude(int l);
    void fixe_decalage(int d);
};
//---------------------------------------------------------------------------
class Date_PV: public base_site_et_date
{
    protected:
    int mn,hh,jj,mm,aa; // valeurs correspondant  l'heure GMT
    int bissextile() const; // retourne 1 si l'anne est bissextile
    int longueur_mois() const;
    int longueur_mois(int m) const;
    long val;
    Date_PV decaldate();

    public:
    bool Est_une_Date;
    Date_PV();
    Date_PV(const Date_PV &d1);
    Date_PV(int mnt,int h,int j, int m,int a);
    virtual int h() const;
    virtual int h(wxString heure);
    virtual int j() const;
    virtual int j(wxString jour);
    virtual int m() const;
    virtual int m(wxString mois);
    int a() const;
    int a(wxString an);
    wxString h_s() const;
    wxString j_s() const;
    wxString m_s() const;
    wxString a_s() const;
    Date_PV date_legal() ;
    int h_legal();
    int j_legal();
    int m_legal();
    int a_legal();
    Date_PV date_reelle();
    virtual double nombre_d_heures() const;
    double nombre_de_secondes() const;
    double nombre_de_jours_annees_precedentes() const;
    bool zero() const;
    bool c_est_l_ete() const;
    bool heure_ete_courante();
    bool est_une_date_valide() const;
    bool est_une_duree_valide() const;
    Date_PV& operator=(const Date_PV &d1);
    Date_PV operator+(const Date_PV& op2) const;
    Date_PV operator-(Date_PV op2) const;
    void operator+=(const Date_PV& op2);
    bool operator>(Date_PV op2) const;
    bool operator<(Date_PV op2) const;
    bool operator>=(const Date_PV& op2) const;
    bool operator<=(const Date_PV& op2) const;
    bool operator==(const Date_PV& op2) const;
};
class Date_duree_PV:public Date_PV
{
    public:
    Date_duree_PV();
    void operator=(const Date_PV &d1);
    using Date_PV::h;
    using Date_PV::j;
    using Date_PV::m;

    int h(wxString heure);
    int j(wxString jour);
    int m(wxString mois);
    double nombre_d_heures() const;
};
//---------------------------------------------------------------------------
class Site_PV: public base_site_et_date
{
    private:
    int zmt,pdg,lttd,srfc,mdl;
    public:
    Site_PV();
    int azimut() const;
    int azimut(wxString p);
    int pendage() const;
    int pendage(wxString p);
    int latitude() const;
    int latitude(wxString p);
    int surface() const;
    int surface(wxString p);
    int modele() const;
    int modele(int m);
    wxString azimut_s() const;
    wxString pendage_s() const;
    wxString latitude_s() const;
    wxString longitude_s();
    wxString Decalage_s();
    wxString surface_s() const;
    double Rendement() const;
};
//---------------------------------------------------------------------------
class Donnees_mesure
{
    int dclg,lngtd;
    bool hdte;
    public:
    Date_PV Date_depart;
    Date_duree_PV Duree_mesure;
    Date_duree_PV Increment;
    Site_PV Installation;
    int val_increment();
    Donnees_mesure();
    Donnees_mesure(const Donnees_mesure &d1);
    void sauve_valeurs_statiques();
    void restaure_valeurs_statiques();
    bool Donnees_mesure_valides() const;
    Donnees_mesure& operator=(const Donnees_mesure &d1);
};
class Resultat_mesure
{
    double puiss,incid,puiss_max,puiss_min,incid_max,incid_min;
    double puiss_incid(bool &initialise_pi,double &vpi,double & vpi_max,double &vpi_min,double val_vpi);
    bool initialise_puiss,initialise_incid;
    public:
    Resultat_mesure();
    double puissance(double val_puiss);
    double incidence(double val_incid);
    double puissance() const;
    double incidence() const;
    double y(double val_y);//alias de puissance
    double y() const;
    double x(double val_x);// alias d'incindence
    double x() const;
    double puissance_max() const;
    double puissance_min() const;
    double incidence_max() const;
    double incidence_min() const;
    void prend_valeurs_de(const Resultat_mesure& R);
};
//---------------------------------------------------------------------------
typedef std::map<int,wxString> TModeles_panneaux; // conteneur des types de panneaux
//---------------------------------------------------------------------------
class APropos;
//---------------------------------------------------------------------------
// variables globales
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
// Dfinition de la classe "MainFrame"
class MainFrame : public wxFrame
{
public:
// Le constructeur
MainFrame();
// Le destructeur
~MainFrame();
private:
        bool init_done;
        bool item_menu_change;
        bool taille_modifiee;
        bool calcul_en_cours;
        bool affichage_en_cours;
        wxString Titre_Fen;
        // Aide
        wxHtmlHelpController* helpController;
        // Contrles
        Tgraphique* Courbe_production;
        static const long idCourbe_production;
        // Boite texte affichage saisie valeur nergtique
        static const long idFen_result;
        wxTextCtrl* Fen_result;
        //Boite saisie paramtres
            // Azimut
        void OnPar_Azimut(wxCommandEvent& event);
        static const long idPar_Azimut;
        wxTextCtrl* Par_Azimut;
        wxStaticText* Text_Par_Azimut;
            // Latitude
        void OnPar_Latitude(wxCommandEvent& event);
        static const long idPar_Latitude;
        wxTextCtrl* Par_Latitude;
        wxStaticText* Text_Par_Latitude;
            // Longitude
        void OnPar_Longitude(wxCommandEvent& event);
        static const long idPar_Longitude;
        wxTextCtrl* Par_Longitude;
        wxStaticText* Text_Par_Longitude;
            // Dcalage heure locale heure solaire
        void OnPar_Decalage(wxCommandEvent& event);
        static const long idPar_Decalage;
        wxTextCtrl* Par_Decalage;
        wxStaticText* Text_Par_Decalage;
            //Pendage
        void OnPar_Pendage(wxCommandEvent& event);
        static const long idPar_Pendage;
        wxTextCtrl* Par_Pendage;
        wxStaticText* Text_Par_Pendage;
            // Surface
        void OnPar_Surface(wxCommandEvent& event);
        static const long idPar_Surface;
        wxTextCtrl* Par_Surface;
        wxStaticText* Text_Par_Surface;
            // Titre dates
        wxStaticText* Text_Dates_h;
        wxStaticText* Text_Dates_j;
        wxStaticText* Text_Dates_m;
        wxStaticText* Text_Dates_a;
            // Dbut (hh jj mm)
        void OnPar_DatDeb_aa(wxCommandEvent& event);
        void OnPar_DatDeb_hh(wxCommandEvent& event);
        void OnPar_DatDeb_jj(wxCommandEvent& event);
        void OnPar_DatDeb_mm(wxCommandEvent& event);
        static const long idPar_DatDeb_aa;
        static const long idPar_DatDeb_hh;
        static const long idPar_DatDeb_jj;
        static const long idPar_DatDeb_mm;
        wxTextCtrl* Par_DatDeb_aa;
        wxTextCtrl* Par_DatDeb_hh;
        wxTextCtrl* Par_DatDeb_jj;
        wxTextCtrl* Par_DatDeb_mm;
        wxStaticText* Text_Par_DatDeb;
            // Dure (hh jj mm)
        void OnPar_DurMes_hh(wxCommandEvent& event);
        void OnPar_DurMes_jj(wxCommandEvent& event);
        void OnPar_DurMes_mm(wxCommandEvent& event);
        static const long idPar_DurMes_hh;
        static const long idPar_DurMes_jj;
        static const long idPar_DurMes_mm;
        wxTextCtrl* Par_DurMes_hh;
        wxTextCtrl* Par_DurMes_jj;
        wxTextCtrl* Par_DurMes_mm;
        wxStaticText* Text_Par_DurMes;
            // Incrment (hh jj mm)
        void OnPar_Increm_hh(wxCommandEvent& event);
        void OnPar_Increm_jj(wxCommandEvent& event);
        void OnPar_Increm_mm(wxCommandEvent& event);
        static const long idPar_Increm_hh;
        static const long idPar_Increm_jj;
        static const long idPar_Increm_mm;
        wxTextCtrl* Par_Increm_hh;
        wxTextCtrl* Par_Increm_jj;
        wxTextCtrl* Par_Increm_mm;
        wxStaticText* Text_Par_Increm;
            // Combobox Choix type panneaux
        static const long idBoitChoixPann;
        void OnBoitChoixPann(wxCommandEvent& event);
        wxComboBox* BoitChoixPann;
            // Checkbox heure d't
        static const long idHeureEte;
        void OnHeureEte(wxCommandEvent& event);
        wxCheckBox* HeureEte;

        wxString NomFichier;

        wxPrintData* g_printData;

        // Utilitaires
        void MAJ_boite_saisie(wxTextCtrl* boite,base_site_et_date site_ou_date,wxString contenu_boite);
        void Affiche_date(const wxString& message,const Date_PV& d);
        void Affiche(wxString message);
        void saisie_val_date(Date_PV* d,wxTextCtrl* boite_active,char hjm);
        void saisie_val_site(char alp);
        wxPoint ALaPlace(int x,int y);
        TModeles_panneaux modeles_panneaux;
        // Noms par defaut
        wxString InitDir;
        wxString DonneesDir;
        wxString DonneesVarDir;
        wxString NomComplet();

        bool charge_fichier(wxString nomfich);
        void FileOpen(wxCommandEvent& event);
        void FilesOpen(wxCommandEvent& event);
        void FileSave(wxCommandEvent& event);
        void FileSaveAs(wxCommandEvent& event);
        void OnImprime(wxCommandEvent& event);
        void OnQuit(wxCommandEvent& event);
        void OnClose(wxCloseEvent& event);
        void OnDisclaimer(wxCommandEvent& event);
        void OnAbout(wxCommandEvent& event);
        void OnHelp(wxCommandEvent& event);
        void Onfr(wxCommandEvent& event);
        void Onen(wxCommandEvent& event);
        void OnCloseAbout(wxCommandEvent& event);
        void OnPaint(wxPaintEvent& event);
        void rafraichit();
        void OnCalcul(wxCommandEvent& event);
        void OnCalcul_positions(wxCommandEvent& event);
        void OnSize(wxSizeEvent& event);

        // Identificateurs
        static const long idMenuQuit;
        static const long idMenuImprime;
        static const long idMenuDisclaimer;
        static const long idMenuAbout;
        static const long idMenuHelp;
        static const long idMenufr;
        static const long idMenuen;
        static const long idMenuToolbar1;
        static const long ID_DIALOGS_FILES_OPEN;
        static const long ID_DIALOGS_FILE_SAVE;
        static const long ID_DIALOGS_FILE_SAVE_AS;
        static const long idCalcul;
        static const long idCalcul_pos;
        static const long idaproposinst;

        static const long idOnPaint;
        //identificateurs des diffrents contrles

        APropos* AProposinst;

        DECLARE_EVENT_TABLE()
};
//---------------------------------------------------------------------------
        // Variable globale retournant un pointeur vers la fentre principale
        MainFrame*& firstwin();
//---------------------------------------------------------------------------
#endif // MAINFRAME_H_INCLUDED
