#include "ProjetdeBase.h"
#include "APropos.h"
#include "Calcule.h"
#include "../Icones/PuissPV16.xpm"
#include "../Icones/impr16.xpm"
#include "../Icones/go16.xpm"
#include "../Icones/sortie16.xpm"
#include "../Icones/files16.xpm"
#include "../Icones/fr16.xpm"
#include "../Icones/eng16.xpm"
#include "../Icones/help16.xpm"
#include "../Icones/save16.xpm"
#include <wx/file.h>
#include <wx/filename.h>
#include <wx/stdpaths.h>
#include <wx/splash.h>
#include "wx/filesys.h"
#include "wx/fs_zip.h"
#include <wx/dcps.h>
#include <wx/print.h>
//---------------------------------------------------------------------------
//Constantes de paramtrages
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
//Variables utilises pour tests
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
// variables globales
//--------------------------------------------------------------------------
MainFrame*& firstwin()
{
    static MainFrame* fen=0;
    return fen;
}
//---------------------------------------------------------------------------
// Gestion des impressions
//---------------------------------------------------------------------------
// Dclaration du Printout utilis

class BilanPrintout: public wxPrintout
{
 public:
    BilanPrintout(const wxString title = wxT("My printout"),const Donnees_mesure& d=Donnees_mesure())
    :wxPrintout(title),donnees_imp(d),margeG(2),margeB(5),margeH(3),EnTete(2),Nb_de_pages(1){}
    Donnees_mesure donnees_imp;
    int margeG,margeB,margeH,EnTete;
    void FixeFontEtTaille();
    void OnPreparePrinting();
    bool OnPrintPage(int page);
    void Tabule_ecrit(wxString st,wxPoint pos);
    int Nombre_de_lignes_par_pages();
    int Nb_lignes_HorsMarges();
    int Nombre_de_pages();
    int Nb_de_pages;
    bool OnBeginDocument(int startpage,int endpage);
    bool HasPage(int page);
    void GetPageInfo(int *minPage, int *maxPage, int *selPageFrom, int *selPageTo);
};
//---------------------------------------------------------------------------
void BilanPrintout::OnPreparePrinting()
{
   FixeFontEtTaille();
   Nb_de_pages=Nombre_de_pages();
}
//---------------------------------------------------------------------------
void BilanPrintout::FixeFontEtTaille()
{
    wxDC *dc = GetDC();
    if (dc)
    {
    // la police est mise  l'chelle lors de l'impression
    // cela tient compte des diffrences de dfinition entre l'cran et la page imprime
    // ainsi que de la diffrence de taille entre les deux.
    dc->SetFont(wxFont(10,wxFONTFAMILY_DEFAULT,wxFONTSTYLE_ITALIC,wxFONTWEIGHT_NORMAL,false));
    // le bloc suivant peut tre remplac par l'instruction MapScreenSizeToPage()
    // mais le rsultat semble moins prcis
    int ppiScreenX, ppiScreenY;
    GetPPIScreen(&ppiScreenX, &ppiScreenY);
    int ppiPrinterX, ppiPrinterY;
    GetPPIPrinter(&ppiPrinterX, &ppiPrinterY);
    float scale = (float)((float)ppiPrinterX/(float)ppiScreenX);
    int pageWidth, pageHeight;
    int w, h;
    dc->GetSize(&w, &h);
    GetPageSizePixels(&pageWidth,&pageHeight);
    float overallScale =scale*(float)(w/(float)pageWidth);
    dc->SetUserScale(overallScale, overallScale);
    // Fin du bloc
    // Dbut bloc correction fond noir
    // Ce bloc est ncessaire du fait d'un bug sous Linux depuis Ubuntu 18.04
    // Si on ne trace pas un rectangle (non blanc!) la page est imprime en noir
    dc->SetBrush(wxBrush(wxColour(254,255,255)));
    dc->Clear();
    int L,H;dc->GetSize(&L,&H);
    dc->DrawRectangle(0,0,L,H);
    //Fin bloc correction fond noir
    }
}
//---------------------------------------------------------------------------
bool BilanPrintout::OnBeginDocument(int startpage,int endpage)
{
    if (!wxPrintout::OnBeginDocument(startpage, endpage)) {
        return false;
    }
    return true;
}
//---------------------------------------------------------------------------
bool BilanPrintout::HasPage(int page)
{   // HasPage n'est pas appel avant OnPrintPage pour la premire page affiche
    // Mais est appele d'abord pour toutes les autres pages.
    return page<=Nb_de_pages;
}
//---------------------------------------------------------------------------
void BilanPrintout::GetPageInfo(int *minPage, int *maxPage, int *selPageFrom, int *selPageTo)
{
    (*minPage)=1;// un appel direct de Nombre_de_pages() serait plus logique, mais il semble y avoir un bug
    (*maxPage)=Nb_de_pages;// GetPageInfo semble parfois appele avant qu'un wxDC valide existe (le test de "if (dc)" ne suffit pas
                        // l'appel de sc->GetSize() fait planter le programme

    (*selPageFrom)=1;
    (*selPageTo)=(*maxPage);
}
//---------------------------------------------------------------------------
bool BilanPrintout::OnPrintPage(int page)
{
    wxDC *dc = GetDC();
    if (dc)
    {
        FixeFontEtTaille(); // appel ncessaire sinon le calcul d'chelle semble perdu d'une page  l'autre
        int ligne(margeH); //Num de ligne dans la page courante (forme de deux colonnes chanes)
        Traducteur tr;
        Tabule_ecrit(wxString::Format(wxT("PAGE %2d"),page),wxPoint(margeG,ligne++));
        Tabule_ecrit(tr.trad(wxT("Puissance")).Left(10) ,wxPoint( 0+margeG,ligne));
        Tabule_ecrit(tr.trad(wxT("Incidence")).Left(10) ,wxPoint(10+margeG,ligne));
        Tabule_ecrit(tr.trad(wxT("heure")).Left(4)      ,wxPoint(20+margeG,ligne));
        Tabule_ecrit(tr.trad(wxT("jour")).Left(4)       ,wxPoint(25+margeG,ligne));
        Tabule_ecrit(tr.trad(wxT("mois")).Left(4)       ,wxPoint(30+margeG,ligne));
        bool colonne2(false);
        wxPoint decale(0,0);
        ligne=EnTete+margeH;
        int ligne_du_tableau(0), //Num des lignes dans le tableau des valeurs
            premiere_ligne=(page-1)*(Nb_lignes_HorsMarges()*2-EnTete),
            dernier_ligne=premiere_ligne+(Nb_lignes_HorsMarges()*2-EnTete);
        Date_PV d1(donnees_imp.Date_depart),d2(donnees_imp.Duree_mesure),inc(donnees_imp.Increment);
        Resultat_mesure R;
        if (!inc.zero())
            for (Date_PV i(d1);i<=(d1+d2);i=i+inc)
            {
                ++ligne_du_tableau;
                colonne2=((ligne-margeH)/Nb_lignes_HorsMarges())%2;
                decale=wxPoint((colonne2?35:0),(colonne2?-Nb_lignes_HorsMarges():0));
                if (ligne_du_tableau>premiere_ligne&&ligne_du_tableau<=dernier_ligne)
                {
                R=Calculs::Pour_une_date(i,donnees_imp.Installation);
                Tabule_ecrit(wxString::Format(wxT("%2d"),int(R.puissance())),wxPoint(   margeG+decale.x,(++ligne)+decale.y));
                Tabule_ecrit(wxString::Format(wxT("%2d"),int(R.incidence())),wxPoint(10+margeG+decale.x,(  ligne)+decale.y));
                Tabule_ecrit(wxString::Format(wxT("%2d"),i.h_legal())       ,wxPoint(20+margeG+decale.x,(  ligne)+decale.y));
                Tabule_ecrit(wxString::Format(wxT("%2d"),i.j_legal())       ,wxPoint(25+margeG+decale.x,(  ligne)+decale.y));
                Tabule_ecrit(wxString::Format(wxT("%2d"),i.m_legal())       ,wxPoint(30+margeG+decale.x,(  ligne)+decale.y));
                }
            }
        if (page==Nombre_de_pages())
            {
                ++ligne;
                Tabule_ecrit(tr.trad(wxT("Production sur la priode"))
                +wxString::Format(wxT(" = %6.1f"),Calculs::Production_entre_deux_dates(d1,d2,donnees_imp.Installation)/1000.0)
                +wxT(" kWh"),wxPoint(margeG+decale.x,ligne+decale.y));
            }
        return true;
    }
    else
        return false;
}
//---------------------------------------------------------------------------
void BilanPrintout::Tabule_ecrit(wxString st,wxPoint pos)
{   // Ecrit st  la position pos (x en nombre de caractre et y nombre de lignes de texte)
    wxDC *dc = GetDC();
    Base_Tabule_ecrit(dc,st,pos);
}
//---------------------------------------------------------------------------
int BilanPrintout::Nombre_de_lignes_par_pages()
{
    wxDC *dc = GetDC();
    int wp(10),wh(10),charH(10),nb_lignes_par_page(40);
    double scx(1),scy(1);
    if (dc)
    {
        charH=int(dc->GetCharHeight());
        dc->GetSize(&wp,&wh);
        dc->GetUserScale(&scx,&scy);
    }
    nb_lignes_par_page=int(wh/(charH*scy+0.01));
    return nb_lignes_par_page+1;
}
//---------------------------------------------------------------------------
int BilanPrintout::Nb_lignes_HorsMarges()
{
    return Nombre_de_lignes_par_pages()-(margeB+margeH);
}
//---------------------------------------------------------------------------
int BilanPrintout::Nombre_de_pages()
{
    int nb_lignes=0;
        Date_PV d1(donnees_imp.Date_depart),d2(donnees_imp.Duree_mesure),inc(donnees_imp.Increment);
        if (!inc.zero())
        for (Date_PV i(d1);i<=(d1+d2);i=i+inc)
        {
        nb_lignes++;
        }
    return int((nb_lignes)/((Nb_lignes_HorsMarges())*2-EnTete))+1;
}
//---------------------------------------------------------------------------
// Fin gestion des impressions
//---------------------------------------------------------------------------
// Implmentation des objets propres au programme PanneauxPPV_puissance
//---------------------------------------------------------------------------
// conteneurs des valeurs
Donnees_mesure Donnees_en_cours;
//---------------------------------------------------------------------------
// Classe ddie aux erreurs
//---------------------------------------------------------------------------
  Erreur_PV::Erreur_PV(wxString message_erreur)
  {
      Traducteur tr;
      message=(message_erreur!=wxT("")?tr.trad(message_erreur):tr.trad(wxT("Pas d'erreur")));
  }
// Fin classe Erreur PV
//---------------------------------------------------------------------------
// Fonction gnrique de filtrage disponible pour site_PV et Date_PV
int filtre_valeurs(bool& affichable,wxString val_chaine,wxString Message_erreur,int lim_inf,int lim_sup)
{
    long val;
    affichable=val_chaine.ToLong(&val);
    if ((!affichable)||(!Est_dans(int(val),lim_inf,lim_sup)))
            throw (Erreur_PV(Message_erreur));
    return int(val);
}
//---------------------------------------------------------------------------
// Implmentation de l'objet base_site_et_date qui fournit des variables globales
// uniformes pour l'heure d't et le dcalage horaire
//---------------------------------------------------------------------------
base_site_et_date::base_site_et_date():Est_affichable(true){}
//---------------------------------------------------------------------------
// Les paramtres du site qui ont un impact sur l'heure sont fixs pour toutes les instances de site_PV et Date_PV
// C'est le cas de longitude, Dcalage et heure d't
int& base_site_et_date::lngtde()
  {
    static int longt(0);
    return longt;
  }
int& base_site_et_date::dclge()
{
    static int declg(0);
    return declg;
}
// L'heure d't s'appliquera pendant la priode estivale
bool& base_site_et_date::heure_ete_activee()
{
    static bool hdete(false);
    return hdete;
}
//--------------------------------------------------------------------------
int base_site_et_date::longitude(wxString p)
  {
    lngtde()=filtre_valeurs(Est_affichable,p,wxT("Longitude non valide"),-180,180);
    return lngtde();
  }
int base_site_et_date::longitude() {return lngtde();}
void base_site_et_date::fixe_longitude(int l){lngtde()=l;}
//--------------------------------------------------------------------------
int base_site_et_date::decalage(wxString p)
  {
    dclge()=filtre_valeurs(Est_affichable,p,wxT("Dcalage non valide"),-12,12);
    return dclge();
  }
int base_site_et_date::decalage() {return dclge();}
void base_site_et_date::fixe_decalage(int d) {dclge()=d;}
//---------------------------------------------------------------------------
// Implmentation de l'objet Date_PV date pour photovoltaque
// Gre les dates  partir de l'an 2000
// l'heure interne conserve est l'heure GMT
//---------------------------------------------------------------------------
    // Constructeurs
    // Par dfaut
Date_PV::Date_PV():mn(0),hh(0),jj(1),mm(1),aa(0),val(0),Est_une_Date(true){};
    // de copie
Date_PV::Date_PV(const Date_PV &d1) {(*this)=d1;};
    // explicite
Date_PV::Date_PV(int mnt,int h,int j, int m,int a):mn(mnt),hh(h),jj(j),mm(m),aa(a),val(0),Est_une_Date(true){};
//---------------------------------------------------------------------------
    //Utilitaires de calendrier
        // retourne 1 si l'anne est bissextile on ne considre que le sicle en cours [2000,2099]
        // L'an 2000 tait bissextile (divisible par 400)
int Date_PV::bissextile() const {return (div(aa,4).rem?0:1);}
        // Retourne la longueur du mois m
int Date_PV::longueur_mois(int m) const
{
    int resultat;
    switch (m)
    {
    case 1:case 3:case 5:case 7:case 8:case 10:case 12:resultat=31;break;
    case 4:case 6:case 9:case 11:resultat=30;break;
    default:resultat=28+bissextile();
    }
    return resultat;
}
        // retourne la longueur du mois courant
int Date_PV::longueur_mois() const
{
    return longueur_mois(mm);
}

//---------------------------------------------------------------------------
    // Gestion des donnes
    // Saisie contrle des h j m  partir de chanes.
    // En cas de valeur non valide la variable "Est_affichable" est positionne  "false"
int Date_PV::h() const {return hh;}
int Date_PV::h(wxString heure)
{
    hh=filtre_valeurs(Est_affichable,heure,wxT("Heure non valide"),0,23);
    return hh;
}
//---------------------------------------------------------------------------
int Date_PV::j() const {return jj;};
int Date_PV::j(wxString jour)
{
    jj=filtre_valeurs(Est_affichable,jour,wxT("Jour non valide"),1,longueur_mois());
    return jj;
}
//---------------------------------------------------------------------------
int Date_PV::m() const {return mm;};
int Date_PV::m(wxString mois)
{
    mm=filtre_valeurs(Est_affichable,mois,wxT("Mois non valide"),1,12);
    if (jj>longueur_mois())jj=longueur_mois();
    return mm;
}
//---------------------------------------------------------------------------
int Date_PV::a() const {return aa;};
int Date_PV::a(wxString an)
{
    aa=filtre_valeurs(Est_affichable,an,wxT("Anne non valide"),0,99);
    return aa;
}
//---------------------------------------------------------------------------
// Date nulle (date non valide mais dure valide)
bool Date_PV::zero() const
{
    return ((!hh)&&(!jj)&&(!mm));
}
// On est en priode t
bool Date_PV::c_est_l_ete() const
{
    Date_PV hiver(0,0,27,10,aa),ete(0,0,27,3,aa);// l'heure d't devrait dmarrer au dernier dimanche de mars ...
    return ((*this)>ete)&&((*this)<hiver);
}
// L'heure d't est active et c'est la bonne priode
bool Date_PV::heure_ete_courante()
{
    return (heure_ete_activee()&&c_est_l_ete());
}
// Retournera faux si le format de date est corrompu ou incorrect.
// Seul l'intervalle [2000-2099] est accept
bool Date_PV::est_une_date_valide() const
{
    bool resultat(Est_dans(mn,0,60)
        &&(Est_dans(hh,0,24))
        &&(Est_dans(jj,1,longueur_mois()))
        &&(Est_dans(mm,1,12))
        &&(Est_dans(aa,0,99)));
    return resultat;
}
//Retournera faux si le format d'incrment ou de dure est corrompu ou incorrect.
// une seule des valeurs mn hh jj mm aa doit tre diffrente de zro
bool Date_PV::est_une_duree_valide() const
{
    int nb_vals_non_nulles=(mn==0?0:1)+(hh==0?0:1)+(jj==0?0:1)+(mm==0?0:1)+(aa==0?0:1);
    bool resultat(nb_vals_non_nulles<=1);
    return resultat;


}
// Fonctions renvoyant la date et l'heure compte tenu  du fuseau horaire origine et de l'heure d't
Date_PV Date_PV::decaldate()
{
    int decalhete=(heure_ete_courante()?1:0);
    Date_PV resultat(0,decalhete+decalage(),0,0,0);
    return resultat;
}
//---------------------------------------------------------------------------
Date_PV Date_PV::date_legal() // de la date relle GMT vers la date lgale
{
    return (*this)+decaldate();
}
int Date_PV::h_legal() {return date_legal().h();}
int Date_PV::j_legal() {return date_legal().j();}
int Date_PV::m_legal() {return date_legal().m();}
int Date_PV::a_legal() {return date_legal().a();}
//---------------------------------------------------------------------------
Date_PV Date_PV::date_reelle() // de la date lgale vers la date relle GMT
{
    return (*this)-decaldate();
}
//---------------------------------------------------------------------------
// Prsentation des donnes en texte
wxString Date_PV::h_s() const {return wxString::Format(wxT(" %2d"),h());}
wxString Date_PV::j_s() const {return wxString::Format(wxT(" %2d"),j());}
wxString Date_PV::m_s() const {return wxString::Format(wxT(" %2d"),m());}
wxString Date_PV::a_s() const {return wxString::Format(wxT(" %2d"),a());}
//---------------------------------------------------------------------------
// nombre d'heures coules depuis le dbut de l'an zro (2000)
double Date_PV::nombre_d_heures() const
{
    double resultat(0);
    for (int i=1;i<mm;i++)
        resultat+=longueur_mois(i)*24;
    return mn/60.0+hh+(jj-1)*24+resultat+24*nombre_de_jours_annees_precedentes();
}
double Date_PV::nombre_de_jours_annees_precedentes() const
{
    double resultat(0);
    for (int i=0;i<aa;i++)
        resultat+=((i % 4)?365:366);
    return resultat;
}
//---------------------------------------------------------------------------
// nombre de secondes coules depuis le dbut de l'anne
double Date_PV::nombre_de_secondes() const
{
    return nombre_d_heures()*3600.0;
}
//---------------------------------------------------------------------------
// Oprateurs sur les Date_PV
Date_PV& Date_PV::operator=(const Date_PV &d1)
{
    if (this!=(&d1))
        {
        mn=d1.mn;
        hh=d1.hh;
        jj=d1.jj;
        mm=d1.mm;
        aa=d1.aa;
        val=d1.val;
        Est_affichable=d1.Est_affichable;
        Est_une_Date=d1.Est_une_Date;
        }
    return *this;
}
Date_PV Date_PV::operator+(const Date_PV& op2) const
{
    Date_PV resultat;
    resultat.Est_affichable=(*this).Est_affichable;
    resultat.Est_une_Date=(*this).Est_une_Date;
    // Minutes de 0  59
    div_t provval(div(mn+op2.mn,60));
    resultat.mn=provval.rem;
    if (resultat.mn<0) {provval.quot--;resultat.mn+=60;}
    //Heures de 0  23
    provval=div(provval.quot+hh+op2.hh,24);
    resultat.hh=provval.rem;
    if (resultat.hh<0) {provval.quot--;resultat.hh+=24;}
    // jours de 1  longueur_mois
    provval=div((provval.quot+jj+op2.jj-1),longueur_mois());// reprendre
    resultat.jj=provval.rem+1;
    if (resultat.jj<=0)
        {
        provval.quot--;
        int provval2=div((provval.quot+mm+op2.mm-1),12).rem+1;
        resultat.jj+=longueur_mois(provval2<=0?provval2+=12:provval2);
        }
    // mois de 1  12
    provval=div((provval.quot+mm+op2.mm-1),12);
    resultat.mm=provval.rem+1;
    if (resultat.mm<=0){provval.quot--;resultat.mm+=12;}
    resultat.aa=aa+provval.quot+op2.aa;
    return resultat;
}
Date_PV Date_PV::operator-(Date_PV op2) const
{
    op2.mn*=(-1);
    op2.hh*=(-1);
    op2.jj*=(-1);
    op2.mm*=(-1);
    op2.aa*=(-1);
    return (*this)+op2;
}
void Date_PV::operator+=(const Date_PV& op2) {(*this)=(*this)+op2;}
bool Date_PV::operator>(Date_PV op2) const
{
    if (aa!=op2.aa) return (aa>op2.aa);
    if (mm!=op2.mm) return (mm>op2.mm);
    if (jj!=op2.jj) return (jj>op2.jj);
    if (hh!=op2.hh) return (hh>op2.hh);
    return mn>op2.mn;
}
bool Date_PV::operator<(Date_PV op2) const
{
    if (aa!=op2.aa) return (aa<op2.aa);
    if (mm!=op2.mm) return (mm<op2.mm);
    if (jj!=op2.jj) return (jj<op2.jj);
    if (hh!=op2.hh) return (hh<op2.hh);
    return mn<op2.mn;
}
bool Date_PV::operator>=(const Date_PV& op2) const {return !((*this)<op2);}
bool Date_PV::operator<=(const Date_PV& op2) const {return !((*this)>op2);}
bool Date_PV::operator==(const Date_PV& op2) const {return ((*this)>=op2)&&((*this)<=op2);}
//---------------------------------------------------------------------------
// Fin de l'objet Date_PV
//---------------------------------------------------------------------------
// Implmentation de l'objet Date_dure_PV Duree driv de date
// sans les contraintes sur les nombres de jours par mois
// Date dure ne gre que les dures en nombre d'heures, ou en jours entiers, ou en mois entiers (donc max 12 mois)
//---------------------------------------------------------------------------
Date_duree_PV::Date_duree_PV():Date_PV(0,0,0,0,0){Est_une_Date=false;};

void Date_duree_PV::operator=(const Date_PV &d1)
{
    Date_PV::operator=(d1);
}
int Date_duree_PV::h(wxString heure)
{
    hh=filtre_valeurs(Est_affichable,heure,wxT("Heure non valide"),0,24);
    jj=0;
    mm=0;
    mn=0;
    return hh;
}
int Date_duree_PV::j(wxString jour)
{
    jj=filtre_valeurs(Est_affichable,jour,wxT("Jour non valide"),0,28);
    hh=0;
    mm=0;
    mn=0;
    return jj;
}
int Date_duree_PV::m(wxString mois)
{
    mm=filtre_valeurs(Est_affichable,mois,wxT("Mois non valide"),0,12);
    hh=0;
    jj=0;
    mn=0;
    return mm;
}
//---------------------------------------------------------------------------
// nombre d'heures coules depuis le dbut de l'anne
// cas d'une dure
double Date_duree_PV::nombre_d_heures() const
{
    double resultat(jj);
    for (int i=1;i<=mm;i++)
        resultat+=longueur_mois(i);
    return hh+resultat*24.0;
}
//---------------------------------------------------------------------------
// Fin de l'objet Date_duree_PV
//---------------------------------------------------------------------------
// Implmentation de l'objet Site_PV Donnes concernant l'installation photovoltaque
//--------------------------------------------------------------------------
Site_PV::Site_PV():zmt(180),pdg(30),lttd(45),srfc(20),mdl(0){};

int Site_PV::azimut() const {return zmt;};
int Site_PV::azimut(wxString p)
  {
    zmt=filtre_valeurs(Est_affichable,p,wxT("Azimut non valide"),0,360);
    return zmt;
  }
int Site_PV::pendage() const {return pdg;};
int Site_PV::pendage(wxString p)
  {
    pdg=filtre_valeurs(Est_affichable,p,wxT("Pendage non valide"),0,90);
    return pdg;
  }
int Site_PV::latitude() const {return lttd;};
int Site_PV::latitude(wxString p)
  {
    lttd=filtre_valeurs(Est_affichable,p,wxT("Latitude non valide"),-90,90);
    return lttd;
  }
int Site_PV::surface() const {return srfc;};
int Site_PV::surface(wxString p)
  {
    srfc=filtre_valeurs(Est_affichable,p,wxT("Surface non valide"),0,10000);
    return srfc;
  }
int Site_PV::modele() const {return mdl;};
int Site_PV::modele(int m)
  {
      mdl=m;
      return mdl;
  }
double Site_PV::Rendement() const
{   // 0 polycristallin 1 monocristallin 2 couche mince
    double r(15.0);
    switch (mdl)
    {
        case 0: r=0.15;break;
        case 1: r=0.20;break;
        default :r=0.10;
    }
    return r;
}
    // Retour des paramtres sous forme de chanes pour l'affichage
wxString Site_PV::azimut_s() const {return wxString::Format(wxT(" %2d"),azimut());}
wxString Site_PV::pendage_s() const {return wxString::Format(wxT(" %2d"),pendage());}
wxString Site_PV::latitude_s() const {return wxString::Format(wxT(" %2d"),latitude());}
wxString Site_PV::longitude_s() {return wxString::Format(wxT(" %2d"),longitude());}
wxString Site_PV::Decalage_s() {return wxString::Format(wxT(" %2d"),dclge());}
wxString Site_PV::surface_s() const {return wxString::Format(wxT(" %2d"),surface());}

//---------------------------------------------------------------------------
// Fin de l'objet Site_PV
//---------------------------------------------------------------------------
// Classe Donnees_mesure rassemble tous les paramtres ncessaires au calcul
//---------------------------------------------------------------------------
Donnees_mesure::Donnees_mesure():dclg(0),lngtd(0),hdte(false){};
Donnees_mesure::Donnees_mesure(const Donnees_mesure &d1){(*this)=d1;}; // constructeur de copie
// total des valeurs h j m de increment (normalement seule une des trois valeurs est non nulle)
int Donnees_mesure::val_increment()
{
    return Increment.h()+Increment.j()+Increment.m();
}
// Copies des valeurs statiques communes  toutes les instances de base_site_et_date
// (longitude dcalage et heure d't) pour permettre la sauvegarde sur le disque
void Donnees_mesure::sauve_valeurs_statiques()
{
    lngtd=Installation.longitude();
    dclg=Installation.decalage();
    hdte=Installation.heure_ete_activee();
}
// restauration des valeurs statiques  partir d'un instance de donnees_mesures
void Donnees_mesure::restaure_valeurs_statiques()
{
    Installation.fixe_longitude(lngtd);
    Installation.fixe_decalage(dclg);
    Installation.heure_ete_activee()=hdte;
}
bool Donnees_mesure::Donnees_mesure_valides() const
{
    bool resultat(Est_dans(dclg,-12,12)
        &&(Est_dans(lngtd,-180,180))
        &&(Date_depart.est_une_date_valide())
        &&Duree_mesure.est_une_duree_valide()
        &&Increment.est_une_duree_valide());
    return resultat;
}
Donnees_mesure& Donnees_mesure::operator=(const Donnees_mesure &d1)
{
    if (this!=(&d1))
        {
        dclg=d1.dclg;
        lngtd=d1.lngtd;
        hdte=d1.hdte;
        Date_depart=d1.Date_depart;
        Duree_mesure=d1.Duree_mesure;
        Increment=d1.Increment;
        Installation=d1.Installation;
        }
    return *this;
}
//---------------------------------------------------------------------------
// Fin de l'objet Donnees_mesure
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
// Classe Resultat_mesure rassemble les valeurs mesures
// permet de faire quelques statistiques en cours de mesure
//---------------------------------------------------------------------------
Resultat_mesure::Resultat_mesure():puiss(0),incid(0)
                ,puiss_max(-1),puiss_min(-1),incid_max(-1),incid_min(-1)
                ,initialise_puiss(false),initialise_incid(false){};
//---------------------------------------------------------------------------
// Met  jour la valeur de la mesure et garde trace des valeurs extrmes
// Un drapeau veille  initialiser avec la premire valeur rentre
double Resultat_mesure::puiss_incid(bool &initialise_pi,double &vpi,double & vpi_max,double &vpi_min,double val_vpi)
{
    vpi_max=(initialise_pi?vpi_max:val_vpi);
    vpi_min=(initialise_pi?vpi_min:val_vpi);
    vpi_max=(val_vpi>vpi_max?val_vpi:vpi_max);
    vpi_min=(val_vpi<vpi_min?val_vpi:vpi_min);
    vpi=val_vpi;
    initialise_pi=true;
    return vpi;
}
// Rentre une valeur de puissance incidence
double Resultat_mesure::puissance(double val_puiss)
{
    return puiss_incid(initialise_puiss,puiss,puiss_max,puiss_min,val_puiss);
}
//---------------------------------------------------------------------------
double Resultat_mesure::incidence(double val_incid)
{
    return puiss_incid(initialise_incid,incid,incid_max,incid_min,val_incid);
}
// Rcupre la valeur puissance incidence
double Resultat_mesure::puissance() const {return puiss;}
double Resultat_mesure::incidence() const {return incid;}
// Les mmes fonctions sous forme de coordonnes type xwRealPont
double Resultat_mesure::x(double val_x){return incidence(val_x);}//alias d'incidence
double Resultat_mesure::y(double val_y){return puissance(val_y);}//alias de puissance
double Resultat_mesure::x() const {return incidence();}
double Resultat_mesure::y() const {return puissance();}
//---------------------------------------------------------------------------
double Resultat_mesure::puissance_max() const {return puiss_max;};
double Resultat_mesure::puissance_min() const {return puiss_min;};
double Resultat_mesure::incidence_max() const {return incid_max;};
double Resultat_mesure::incidence_min() const {return incid_min;};
//---------------------------------------------------------------------------
// Copie les valeurs d'un rsultat mesure sans rinitialiser les valeurs extrmes
void Resultat_mesure::prend_valeurs_de(const Resultat_mesure& R)
{
    puissance(R.puissance());
    incidence(R.incidence());
}
//---------------------------------------------------------------------------
// Fentre principale
//---------------------------------------------------------------------------

//Identificateurs
const long MainFrame::idMenuQuit = wxNewId();
const long MainFrame::idMenuImprime = wxNewId();
const long MainFrame::idMenuDisclaimer = wxNewId();
const long MainFrame::idMenuAbout = wxNewId();
const long MainFrame::idMenuHelp = wxNewId();
const long MainFrame::idMenufr = wxNewId();
const long MainFrame::idMenuen = wxNewId();
const long MainFrame::idMenuToolbar1 = wxNewId();
const long MainFrame::ID_DIALOGS_FILES_OPEN = wxNewId();
const long MainFrame::ID_DIALOGS_FILE_SAVE = wxNewId();
const long MainFrame::ID_DIALOGS_FILE_SAVE_AS = wxNewId();
const long MainFrame::idOnPaint = wxNewId();
const long MainFrame::idaproposinst = wxNewId();

// identifiants des contrles
const long MainFrame::idCalcul= wxNewId();
const long MainFrame::idCalcul_pos= wxNewId();
const long MainFrame::idPar_Azimut = wxNewId();
const long MainFrame::idPar_Latitude = wxNewId();
const long MainFrame::idPar_Longitude = wxNewId();
const long MainFrame::idPar_Decalage = wxNewId();
const long MainFrame::idPar_Surface = wxNewId();
const long MainFrame::idFen_result = wxNewId();
const long MainFrame::idPar_Pendage = wxNewId();
const long MainFrame::idPar_DatDeb_aa = wxNewId();
const long MainFrame::idPar_DatDeb_hh = wxNewId();
const long MainFrame::idPar_DurMes_hh = wxNewId();
const long MainFrame::idPar_Increm_hh = wxNewId();
const long MainFrame::idPar_DatDeb_jj = wxNewId();
const long MainFrame::idPar_DurMes_jj = wxNewId();
const long MainFrame::idPar_Increm_jj = wxNewId();
const long MainFrame::idPar_DatDeb_mm = wxNewId();
const long MainFrame::idPar_DurMes_mm = wxNewId();
const long MainFrame::idPar_Increm_mm = wxNewId();
const long MainFrame::idBoitChoixPann = wxNewId();
const long MainFrame::idHeureEte = wxNewId();
// identifiants des canvas
const long MainFrame::idCourbe_production= wxNewId();
//---------------------------------------------------------------------------
BEGIN_EVENT_TABLE(MainFrame, wxFrame)
    EVT_PAINT(MainFrame::OnPaint)
    EVT_SIZE(MainFrame::OnSize)
    EVT_CLOSE(MainFrame::OnClose)
    EVT_MENU(idMenuQuit, MainFrame::OnQuit)
    EVT_MENU(idMenuImprime, MainFrame::OnImprime)
    EVT_MENU(ID_DIALOGS_FILES_OPEN, MainFrame::FileOpen)
    EVT_MENU(ID_DIALOGS_FILE_SAVE, MainFrame::FileSave)
    EVT_MENU(ID_DIALOGS_FILE_SAVE_AS, MainFrame::FileSaveAs)
    EVT_MENU(idMenuDisclaimer, MainFrame::OnDisclaimer)
    EVT_MENU(idMenuAbout, MainFrame::OnAbout)
    EVT_MENU(idMenuHelp, MainFrame::OnHelp)
    EVT_MENU(idMenufr,MainFrame::Onfr)
    EVT_MENU(idMenuen,MainFrame::Onen)
    EVT_MENU(idCalcul, MainFrame::OnCalcul)
    EVT_MENU(idCalcul_pos, MainFrame::OnCalcul_positions)
    EVT_TEXT(idPar_Azimut, MainFrame::OnPar_Azimut)
    EVT_TEXT(idPar_Latitude, MainFrame::OnPar_Latitude)
    EVT_TEXT(idPar_Longitude, MainFrame::OnPar_Longitude)
    EVT_TEXT(idPar_Decalage, MainFrame::OnPar_Decalage)
    EVT_TEXT(idPar_Surface, MainFrame::OnPar_Surface)
    EVT_TEXT(idPar_Pendage, MainFrame::OnPar_Pendage)
    EVT_TEXT(idPar_DatDeb_hh, MainFrame::OnPar_DatDeb_hh)
    EVT_TEXT(idPar_DurMes_hh, MainFrame::OnPar_DurMes_hh)
    EVT_TEXT(idPar_Increm_hh, MainFrame::OnPar_Increm_hh)
    EVT_TEXT(idPar_DatDeb_jj, MainFrame::OnPar_DatDeb_jj)
    EVT_TEXT(idPar_DurMes_jj, MainFrame::OnPar_DurMes_jj)
    EVT_TEXT(idPar_Increm_jj, MainFrame::OnPar_Increm_jj)
    EVT_TEXT(idPar_DatDeb_mm, MainFrame::OnPar_DatDeb_mm)
    EVT_TEXT(idPar_DurMes_mm, MainFrame::OnPar_DurMes_mm)
    EVT_TEXT(idPar_Increm_mm, MainFrame::OnPar_Increm_mm)
    EVT_TEXT(idPar_DatDeb_aa, MainFrame::OnPar_DatDeb_aa)
    EVT_COMBOBOX(idBoitChoixPann, MainFrame::OnBoitChoixPann)
    EVT_CHECKBOX(idHeureEte,MainFrame::OnHeureEte)
END_EVENT_TABLE()
//---------------------------------------------------------------------------
// Le constructeur
MainFrame::MainFrame() : wxFrame(NULL,wxID_ANY,wxT("Simulation panneaux photovoltaques"),wxPoint(800,100),wxSize(100,100),wxDEFAULT_FRAME_STYLE|wxFULL_REPAINT_ON_RESIZE),
                            init_done(false),item_menu_change(true),taille_modifiee(true),calcul_en_cours(false),affichage_en_cours(false),Titre_Fen(wxT("Paramtres"))

{
    firstwin()=this;
    Traducteur tr;
    tr.langue_demarrage();
    PalettePerso p;
    SetBackgroundColour(Couleur_Fenetres_defaut());
    // Calcule la taille de dpart de la fentre
    SetSize(Taille_Fenetres_defaut());
    // Calcule la taille minimale de la fentre (ne marche pas avec Wine)
    SetSizeHints(300,300,-1,-1,-1,-1);
    FixeFontEtTaille(this);
    SetIcon(PuissPV16_xpm);
    // Fiche Apropos
    AProposinst=new APropos(this,idaproposinst);
    // Graphique
    Courbe_production= new Tgraphique(this,idCourbe_production,wxPoint(100,100),wxSize(100,100),wxT("Graphique des productions"),wxT("Productions"),p.clLtGray,p.clYellow,p.clDkGray);
    Courbe_production->ajoute_une_serie(wxT("Defaut"),p.clBlack);
    // Initialisation des chemins

    //wxStandardPaths Chemins; // wxStandardPaths est protected dans wxWidgets 3 donc pas instanciable
#if defined(__WXMSW__)
    InitDir=wxStandardPaths::Get().GetDataDir();
    DonneesDir=InitDir;
    DonneesVarDir=DonneesDir;
#elif defined(__UNIX__)
    //Chemins.SetInstallPrefix(wxT("/usr/bin"));
    //InitDir=Chemins.GetInstallPrefix();
    InitDir=wxT("/usr/bin");
    DonneesDir=wxT("/usr/share/puissppv"); // Le rpertoire usr peut-tre en lecture seule
    DonneesVarDir=wxT("/var/lib/puissppv");// d'o la ncessit d'un rpertoire dans var pour les donnes modifiables
#endif
    NomFichier=tr.trad(wxT("defaut.pppv"));
    // Aide
    wxImage::AddHandler(new wxPNGHandler());
    wxFileSystem::AddHandler(new wxZipFSHandler);
    helpController = new wxHtmlHelpController(wxHF_DEFAULT_STYLE,this);
    helpController->Initialize(DonneesDir+wxT("/")+wxT("puissppvfrahlp.zip"));
    helpController->AddBook(wxFileName(DonneesDir+wxT("/")+wxT("puissppvenghlp.zip")));
#if wxCHECK_VERSION(2,9,0)
    helpController->SetShouldPreventAppExit(true);// Valeur par dfaut false provoque le plantage sous wx3.0.2 pas 2.8.2
#endif
    //---------------------------------------------------------------------------
    // Mise en place des menus
    wxMenuItem* MenuItem1;
    wxMenuItem* MenuItem2;
    wxMenuItem* MenuItem3;
    wxMenuItem* MenuItem4;
    wxMenuItem* MenuItem5;
    wxMenuItem* MenuItem6;
    wxMenuItem* MenuItem6a;
    wxMenuItem* MenuItem7;
    wxMenuItem* MenuItem8;
    wxMenuItem* MenuItem9;
    wxMenuItem* MenuItem10;
    wxMenuItem* MenuItem11;

    wxMenu* Menu1;
    wxMenu* Menu2;
    wxMenu* Menu3;
    wxMenu* Menu4;

    wxMenuBar* MenuBar1;
    MenuBar1 = new wxMenuBar();
    Menu1 = new wxMenu();
        MenuItem1 = new wxMenuItem(Menu1, ID_DIALOGS_FILES_OPEN, wxT("Ouvrir"), wxT("Charge un fichier"), wxITEM_NORMAL);
        Menu1->Append(MenuItem1);
        MenuItem2 = new wxMenuItem(Menu1, ID_DIALOGS_FILE_SAVE, wxT("Enregistrer"), wxT("Sauve le fichier en cours"), wxITEM_NORMAL);
        Menu1->Append(MenuItem2);
        MenuItem3 = new wxMenuItem(Menu1,ID_DIALOGS_FILE_SAVE_AS, wxT("Enregistrer sous..."), wxT("Sauve sous un nouveau nom"), wxITEM_NORMAL);
        Menu1->Append(MenuItem3);
        MenuItem4 = new wxMenuItem(Menu1, idMenuImprime, wxT("Impression"), wxT("Imprime le diagramme"), wxITEM_NORMAL);
        Menu1->Append(MenuItem4);
        Menu1->AppendSeparator();
        MenuItem5 = new wxMenuItem(Menu1, idMenuQuit, wxT("Quitter"), wxT("Quit the application"), wxITEM_NORMAL);
        Menu1->Append(MenuItem5);
        MenuBar1->Append(Menu1, wxT("Fichiers"));
    Menu2 = new wxMenu();
        MenuItem6 = new wxMenuItem(Menu2, idCalcul, wxT("Rapport"), wxT("Rapport"), wxITEM_NORMAL);
        Menu2->Append(MenuItem6);
        MenuItem6a = new wxMenuItem(Menu2, idCalcul_pos, wxT("Positions"), wxT("Positions"), wxITEM_NORMAL);
        Menu2->Append(MenuItem6a);
        MenuBar1->Append(Menu2, wxT("Outils"));
    Menu3 = new wxMenu();
        MenuItem7 = new wxMenuItem(Menu3, idMenufr, wxT("Franais"), wxT("Version Franaise"), wxITEM_CHECK );
        Menu3->Append(MenuItem7);
        MenuItem8 = new wxMenuItem(Menu3, idMenuen, wxT("English"), wxT("English version"), wxITEM_CHECK );
        Menu3->Append(MenuItem8);
        MenuBar1->Append(Menu3, wxT("Langage"));
    Menu4 = new wxMenu();
        MenuItem9 = new wxMenuItem(Menu4, idMenuDisclaimer, wxT("Avertissement"), wxT("Avertissement"), wxITEM_NORMAL);
        Menu4->Append(MenuItem9);
        MenuItem10 = new wxMenuItem(Menu4, idMenuAbout, wxT("A propos"), wxT("A propos"), wxITEM_NORMAL);
        Menu4->Append(MenuItem10);
        MenuItem11 = new wxMenuItem(Menu4, idMenuHelp, wxT("Aide"), wxT("Aide"), wxITEM_NORMAL);
        Menu4->Append(MenuItem11);
        MenuBar1->Append(Menu4, wxT("Aide"));
    SetMenuBar(MenuBar1);
    //---------------------------------------------------------------------------
    // Barre d'outils
    wxToolBar* Toolbar1;
    Toolbar1= CreateToolBar(wxNO_BORDER | wxTB_HORIZONTAL,idMenuToolbar1);
    wxImage::AddHandler(new wxXPMHandler());
    wxBitmap* toolBarBitmaps[9];
    toolBarBitmaps[0]=new wxBitmap(files16_xpm);
    toolBarBitmaps[1]=new wxBitmap(save16_xpm);
    toolBarBitmaps[2]=new wxBitmap(impr16_xpm);
    toolBarBitmaps[3]=new wxBitmap(go16_xpm);
    toolBarBitmaps[5]=new wxBitmap(fr16_xpm);
    toolBarBitmaps[6]=new wxBitmap(eng16_xpm);
    toolBarBitmaps[7]=new wxBitmap(help16_xpm);
    toolBarBitmaps[8]=new wxBitmap(sortie16_xpm);

    Toolbar1->SetToolBitmapSize(wxSize(toolBarBitmaps[0]->GetWidth(),toolBarBitmaps[0]->GetHeight()));

    Toolbar1->AddTool(ID_DIALOGS_FILES_OPEN ,wxT("Fichiers")        ,*(toolBarBitmaps[0]),wxT("Fichiers")                   ,wxITEM_NORMAL);
    Toolbar1->AddTool(ID_DIALOGS_FILE_SAVE  ,wxT("Sauve le fichier en cours")    ,*(toolBarBitmaps[1]),wxT("Sauve le fichier en cours")  ,wxITEM_NORMAL);
    Toolbar1->AddTool(idMenuImprime          ,wxT("Imprime")     ,*(toolBarBitmaps[2]),wxT("Imprime le rapport")                ,wxITEM_NORMAL);
    Toolbar1->AddSeparator();
    Toolbar1->AddTool(idCalcul          ,wxT("Rapport")     ,*(toolBarBitmaps[3]),wxT("Rapport")                ,wxITEM_NORMAL);
    Toolbar1->AddSeparator();
    Toolbar1->AddTool(idMenufr              ,wxT("Franais")        ,*(toolBarBitmaps[5]),wxT("Franais")                   ,wxITEM_RADIO);
    Toolbar1->AddTool(idMenuen              ,wxT("English")         ,*(toolBarBitmaps[6]),wxT("English")                    ,wxITEM_RADIO);
    Toolbar1->AddSeparator();
    Toolbar1->AddTool(idMenuHelp            ,wxT("Aide")            ,*(toolBarBitmaps[7]),wxT("Aide")                       ,wxITEM_NORMAL);
    Toolbar1->AddSeparator();
    Toolbar1->AddTool(idMenuQuit            ,wxT("Quitter")         ,*(toolBarBitmaps[8]),wxT("Sortie")                     ,wxITEM_NORMAL);
    Toolbar1->Realize();
    SetToolBar(Toolbar1);
    //---------------------------------------------------------------------------
    // Mise en page et insertion des contrles
    wxPoint pos; wxSize taille;
    pos=FaitReelle_Pos(wxPoint(10,100),this);
    taille=FaitReelle_Taille(wxSize(50,50),this);

    // Boites textes de rentre des paramtres
    Text_Par_Azimut= new wxStaticText(this,wxID_ANY,wxT("Azimut"),pos);
    Par_Azimut=new wxTextCtrl(this,idPar_Azimut,wxT("az"),pos,taille);
    Text_Par_Latitude= new wxStaticText(this,wxID_ANY,wxT("Latitude"),pos);
    Par_Latitude=new wxTextCtrl(this,idPar_Latitude,wxT("la"),pos,taille);
    Text_Par_Longitude= new wxStaticText(this,wxID_ANY,wxT("Longitude"),pos);
    Par_Longitude=new wxTextCtrl(this,idPar_Longitude,wxT("lo"),pos,taille);
    Text_Par_Decalage= new wxStaticText(this,wxID_ANY,wxT("Dcalage"),pos);
    Par_Decalage=new wxTextCtrl(this,idPar_Decalage,wxT("mn"),pos,taille);
    Text_Par_Surface= new wxStaticText(this,wxID_ANY,wxT("Surface"),pos);
    Par_Surface=new wxTextCtrl(this,idPar_Surface,wxT("su"),pos,taille);
    Text_Par_Pendage= new wxStaticText(this,wxID_ANY,wxT("Pendage"),pos);
    Par_Pendage=new wxTextCtrl(this,idPar_Pendage,wxT("pg"),pos,taille);
    Text_Dates_h= new wxStaticText(this,wxID_ANY,wxT("h"),pos);
    Text_Dates_j= new wxStaticText(this,wxID_ANY,wxT("j"),pos);
    Text_Dates_m= new wxStaticText(this,wxID_ANY,wxT("m"),pos);
    Text_Dates_a= new wxStaticText(this,wxID_ANY,wxT("Anne"),pos);
    Text_Par_DatDeb= new wxStaticText(this,wxID_ANY,wxT("Dbut rapport"),pos);
    Par_DatDeb_aa=new wxTextCtrl(this,idPar_DatDeb_aa,wxT("aa"),pos,taille);
    Par_DatDeb_hh=new wxTextCtrl(this,idPar_DatDeb_hh,wxT("hh"),pos,taille);
    Par_DatDeb_jj=new wxTextCtrl(this,idPar_DatDeb_jj,wxT("jj"),pos,taille);
    Par_DatDeb_mm=new wxTextCtrl(this,idPar_DatDeb_mm,wxT("mm"),pos,taille);
    Text_Par_DurMes= new wxStaticText(this,wxID_ANY,wxT("Dure rapport"),pos);
    Par_DurMes_hh=new wxTextCtrl(this,idPar_DurMes_hh,wxT("hh"),pos,taille);
    Par_DurMes_jj=new wxTextCtrl(this,idPar_DurMes_jj,wxT("jj"),pos,taille);
    Par_DurMes_mm=new wxTextCtrl(this,idPar_DurMes_mm,wxT("mm"),pos,taille);
    Text_Par_Increm= new wxStaticText(this,wxID_ANY,wxT("Incrment"),pos);
    Par_Increm_hh=new wxTextCtrl(this,idPar_Increm_hh,wxT("hh"),pos,taille);
    Par_Increm_jj=new wxTextCtrl(this,idPar_Increm_jj,wxT("jj"),pos,taille);
    Par_Increm_mm=new wxTextCtrl(this,idPar_Increm_mm,wxT("mm"),pos,taille);
    // Boite texte affichage des rsultats du calcul
    Fen_result=new wxTextCtrl(this,idFen_result,wxT(""),pos,taille,wxTE_LEFT|wxTE_MULTILINE|wxTE_READONLY|wxTE_RICH);
    // Types de panneaux disponibles
    modeles_panneaux.insert(std::make_pair(0,wxT("Polycristallin")));
    modeles_panneaux.insert(std::make_pair(1,wxT("Monocristallin")));
    modeles_panneaux.insert(std::make_pair(2,wxT("Film mince")));
    // ComboBox choix du type de panneau
    BoitChoixPann=new wxComboBox(this,idBoitChoixPann,wxT(""),pos,taille);
    BoitChoixPann->Append(modeles_panneaux[0]);
    BoitChoixPann->Append(modeles_panneaux[1]);
    BoitChoixPann->Append(modeles_panneaux[2]);
    BoitChoixPann->SetSelection(0);
    //CheckBox Heure d't
    HeureEte=new wxCheckBox(this,idHeureEte,wxT("Heure d't"),wxPoint(10,10),wxSize(15,10));
    // Charge le fichier par dfaut le cre s'il n'existe pas
    if(!charge_fichier(NomComplet()))
        {
        Donnees_en_cours.Date_depart.a(wxT("14"));
        wxCommandEvent ev;
        FileSave(ev);
        charge_fichier(NomComplet());
        }

    g_printData =new wxPrintData;
    g_printData->SetPaperId(wxPAPER_A4);
    init_done=true;
}
//---------------------------------------------------------------------------
// Le Destructeur
MainFrame::~MainFrame()
{
    delete g_printData;
}
wxPoint MainFrame::ALaPlace(int x,int y)
{
    return wxPoint(GetSize().GetWidth()/100*x,GetSize().GetHeight()/100*y);
}

//---------------------------------------------------------------------------
wxString MainFrame::NomComplet()
{
    return DonneesVarDir+wxT("/")+NomFichier;
}
//---------------------------------------------------------------------------
void MainFrame::OnImprime(wxCommandEvent& event)
{
    Traducteur tr;
    g_printData->SetPaperSize(wxSize(200,500));
    wxPrintDialogData g_printDialogData(*g_printData);
    g_printDialogData.EnablePageNumbers(true);
    wxPrintPreview *preview = new wxPrintPreview(new BilanPrintout(tr.trad(wxT("Prvisualisation")),Donnees_en_cours), new BilanPrintout(tr.trad(wxT("Impression")),Donnees_en_cours), & g_printDialogData);

    if (!preview->Ok())
    {
        delete preview;
        wxMessageBox(wxT("There was a problem previewing.\nPerhaps your current printer is not set correctly?"), wxT("Previewing"), wxOK);
        return;
    }
    wxPreviewFrame *frame = new wxPreviewFrame(preview, this, tr.trad(wxT("Rapport")), wxPoint(100, 100), wxSize(600, 650));
    frame->Centre(wxBOTH);
    frame->Initialize();
    frame->Show();
}
//---------------------------------------------------------------------------
void MainFrame::OnQuit(wxCommandEvent& event)
{
                wxCloseEvent eventclose;
                OnClose(eventclose);
}
void MainFrame::OnClose(wxCloseEvent& event)
{
                this->Destroy();
}
//---------------------------------------------------------------------------
void MainFrame::OnDisclaimer(wxCommandEvent& event)
{
    Traducteur tr;
    wxBitmap bitmap;
    wxImage::AddHandler(new wxPNGHandler());
    if (bitmap.LoadFile(DonneesDir+wxT("/")+tr.trad(wxT("DisclaimimageFra.png")), wxBITMAP_TYPE_PNG))
    {
        wxSplashScreen* splash __attribute__ ((unused));
        splash = new wxSplashScreen(bitmap,
          wxSPLASH_CENTRE_ON_SCREEN|wxSPLASH_TIMEOUT,
          6000, NULL, -1, wxDefaultPosition, wxDefaultSize,
          wxSIMPLE_BORDER|wxSTAY_ON_TOP);
    }
    wxYield();
}
//---------------------------------------------------------------------------
void MainFrame::OnAbout(wxCommandEvent& event)
{
    AProposinst->Show();
}
 void MainFrame::OnHelp(wxCommandEvent& event)
{
    Traducteur tr;
    helpController->DisplayContents();
    helpController->Display(tr.trad(wxT("puissppvfrahlp")));
}
void MainFrame::Onfr(wxCommandEvent& event)
{
    Traducteur tr;
    tr.fixe_langue()=fr;
    item_menu_change=true;
    Refresh();
}
void MainFrame::Onen(wxCommandEvent& event)
{
    Traducteur tr;
    tr.fixe_langue()=ang;
    item_menu_change=true;
    Refresh();
}
//---------------------------------------------------------------------------
// Chargement du fichier pppv slectionn.
bool MainFrame::charge_fichier(wxString nomfich)
{
    Traducteur tr;
    wxString Message(tr.trad(wxT("Fichier absent")));
    wxFile fichier_en_cours(nomfich,wxFile::read);
    Donnees_mesure dom;
    bool succes=fichier_en_cours.IsOpened();// le fichier existe
    if (succes)
        {
        Message=tr.trad(wxT("Mauvais format de fichier ou donnes corrompues"));
        int L=0;
        size_t ld(sizeof(dom));
                L=fichier_en_cours.Read(&dom,ld);
        }
    succes=succes&&dom.Donnees_mesure_valides();
    if (succes)
    {
        Donnees_en_cours=dom;
        Donnees_en_cours.restaure_valeurs_statiques();
        BoitChoixPann->SetSelection(Donnees_en_cours.Installation.modele());
        Message=NomFichier;
        item_menu_change=true;
    }
    item_menu_change=true;
    Titre_Fen=Message;
    Refresh();
    return succes;
}
//---------------------------------------------------------------------------
void MainFrame::FileOpen(wxCommandEvent& WXUNUSED(event) )
{
    Traducteur tr;
    wxFileDialog dialog
                 (
                    this,
                    tr.trad(wxT("Ouvrir")),
                    wxEmptyString,
                    wxEmptyString,
                    wxString(tr.trad(wxT("Fichiers"))+wxT("(*.pppv)|*.pppv|")+tr.trad(wxT("Tous fichiers"))+wxT("(*.*)|*.*"))
                 );
    dialog.CentreOnParent();
    dialog.SetDirectory(DonneesVarDir);
    if (dialog.ShowModal() == wxID_OK)
        {
        DonneesVarDir=dialog.GetDirectory();
        NomFichier=dialog.GetFilename();
        if(!charge_fichier(NomComplet()))
                {
                };
        }
}
//---------------------------------------------------------------------------
//Sauve le fichier de configuration
void MainFrame::FileSave(wxCommandEvent& event)
{
    wxFile fichier_en_cours(NomComplet(),wxFile::write);
    wxString f;
    size_t L;
    size_t Lw=0;
    Donnees_en_cours.sauve_valeurs_statiques();
    L=sizeof(Donnees_en_cours);
    Lw=fichier_en_cours.Write(&Donnees_en_cours,L);
    Refresh();
}
//---------------------------------------------------------------------------
void MainFrame::FileSaveAs(wxCommandEvent& event)
{
    Traducteur tr;

    wxFileDialog dialog(this,
                        tr.trad(wxT("Enregistrer sous...")),
                        wxEmptyString,
                        tr.trad(wxT("Sans titre"))+wxT(".pppv"),
                        wxString(tr.trad(wxT("Fichiers"))+wxT("(*.pppv)|*.pppv|")+tr.trad(wxT("Tous fichiers"))+wxT("(*.*)|*.*")),
                        wxFD_SAVE|wxFD_OVERWRITE_PROMPT);

    dialog.SetFilterIndex(0);
    dialog.CentreOnParent();
    dialog.SetDirectory(DonneesVarDir);

    if (dialog.ShowModal() == wxID_OK)
    {
// enregistrement du fichier slectionn.
    DonneesVarDir=dialog.GetDirectory();
    NomFichier=dialog.GetFilename();
    FileSave(event);
    }
    Refresh();
}
//---------------------------------------------------------------------------
void MainFrame::OnSize(wxSizeEvent& event)
{
    taille_modifiee=true;
}
//---------------------------------------------------------------------------
void MainFrame::OnPaint(wxPaintEvent& event)
{
    wxPaintDC dc(this);
    rafraichit();
}
//---------------------------------------------------------------------------
void MainFrame::rafraichit()
{
Traducteur tr;
if (!affichage_en_cours)
{
affichage_en_cours=true;
if (init_done)
    {
    if (item_menu_change)
        {
        item_menu_change=false;
        wxMenuBar* Menuprov=GetMenuBar();
        // Traduit les titres des enfants
        RenommeEnfants(this);
        // Titres de menus
        size_t nb_menus=Menuprov->GetMenuCount();
        for (size_t i=0;i<nb_menus;i++)
            Menuprov->SetMenuLabel(i,tr.trad_tout(Menuprov->GetMenuLabel(i)));
        //Items de chaque menu
        Menuprov->SetLabel(ID_DIALOGS_FILE_SAVE_AS,tr.trad(wxT("Enregistrer sous...")));
        Menuprov->SetLabel(ID_DIALOGS_FILES_OPEN,tr.trad(wxT("Ouvrir")));
        Menuprov->SetLabel(ID_DIALOGS_FILE_SAVE,tr.trad(wxT("Enregistrer")));
        Menuprov->SetLabel(idMenuQuit,tr.trad(wxT("Quitter")));
        Menuprov->SetLabel(idCalcul,tr.trad(wxT("Rapport")));
        Menuprov->SetLabel(idMenuImprime,tr.trad(wxT("Impression")));
        Menuprov->SetLabel(idMenuDisclaimer, tr.trad(wxT("Avertissement")));
        Menuprov->SetLabel(idMenuAbout, tr.trad(wxT("A propos")));
        Menuprov->SetLabel(idMenuHelp, tr.trad(wxT("Aide")));
        Menuprov->SetLabel(idMenufr,wxT("Franais"));
        Menuprov->SetLabel(idMenuen,wxT("English"));
        // Graphique
        Courbe_production->caracteristiques_axeY.titre=tr.trad(wxT("Puissance"));
        Courbe_production->caracteristiques_axeY.unite=tr.trad(wxT("u.a"));
        wxString titre_X(tr.trad(wxT("mois")));
        if (Donnees_en_cours.Increment.h()>=1) titre_X=tr.trad(wxT("heure"));
        if (Donnees_en_cours.Increment.j()>=1) titre_X=tr.trad(wxT("jour"));
        if (titre_X!=wxT("mois")) titre_X+=wxT("s ");
        Courbe_production->caracteristiques_axeX.titre=titre_X;
        // Boutons actifs ou non sur la barre d'outils
        bool fr_on=(tr.fixe_langue()==fr);
        Menuprov->Check(idMenufr,(fr_on));
        Menuprov->Check(idMenuen,(!fr_on));
        wxToolBar* Toolbarprov=GetToolBar();
        Toolbarprov->ToggleTool(idMenufr,fr_on);
        Toolbarprov->ToggleTool(idMenuen,!fr_on);
        Toolbarprov->SetToolShortHelp(ID_DIALOGS_FILES_OPEN,tr.trad(wxT("Ouvrir")));
        Toolbarprov->SetToolShortHelp(ID_DIALOGS_FILE_SAVE,tr.trad(wxT("Sauve le fichier en cours")));
        Toolbarprov->SetToolShortHelp(idMenuImprime,tr.trad(wxT("Impression")));
        Toolbarprov->SetToolShortHelp(idCalcul,tr.trad(wxT("Affiche le rapport")));
        Toolbarprov->SetToolShortHelp(idMenuHelp, tr.trad(wxT("Aide")));
        Toolbarprov->SetToolShortHelp(idMenuQuit,tr.trad(wxT("Quitter")));
        Menuprov->Refresh();
        Toolbarprov->Refresh();
        BoitChoixPann->SetSelection(Donnees_en_cours.Installation.modele());
        if (!calcul_en_cours) Affiche(Titre_Fen);
        Par_Decalage->SetToolTip(tr.trad(wxT("Dcalage horaire entre l'heure GMT et l'heure lgale (en heures)")));
        // Affichage des valeurs de dates si elles sont licites
        Date_PV d1(Donnees_en_cours.Date_depart.date_legal());
        MAJ_boite_saisie(Par_DatDeb_hh,d1,d1.h_s());
        MAJ_boite_saisie(Par_DatDeb_jj,d1,d1.j_s());
        MAJ_boite_saisie(Par_DatDeb_mm,d1,d1.m_s());
        MAJ_boite_saisie(Par_DatDeb_aa,d1,d1.a_s());
        d1=Donnees_en_cours.Duree_mesure;
        MAJ_boite_saisie(Par_DurMes_hh,d1,d1.h_s());
        MAJ_boite_saisie(Par_DurMes_jj,d1,d1.j_s());
        MAJ_boite_saisie(Par_DurMes_mm,d1,d1.m_s());
        d1=Donnees_en_cours.Increment;
        MAJ_boite_saisie(Par_Increm_hh,d1,d1.h_s());
        MAJ_boite_saisie(Par_Increm_jj,d1,d1.j_s());
        MAJ_boite_saisie(Par_Increm_mm,d1,d1.m_s());
        // Affichage des paramtres du site si ils sont licites
        Site_PV& s1=Donnees_en_cours.Installation;
        MAJ_boite_saisie(Par_Azimut,s1,s1.azimut_s());
        MAJ_boite_saisie(Par_Pendage,s1,s1.pendage_s());
        MAJ_boite_saisie(Par_Longitude,s1,s1.longitude_s());
        MAJ_boite_saisie(Par_Latitude,s1,s1.latitude_s());
        MAJ_boite_saisie(Par_Decalage,s1,s1.Decalage_s());
        MAJ_boite_saisie(Par_Surface,s1,s1.surface_s());
        HeureEte->SetValue(Donnees_en_cours.Installation.heure_ete_activee());
        }
    if(taille_modifiee)
        {
            taille_modifiee=false;
              // paramtres d'affichage
            int margex(20),ecart(200),margey(50),pasy(80);
            // Ajuste la taille de la Boite texte affichage rsultat
            int ecart1(ecart*0.5); // taille affichages textes
            int ecart2(ecart*0.3); // taille affichages hh jj mm
            int posX_zone_Resultat=margex*2+ecart+ecart2*3;
            wxPoint pos(posX_zone_Resultat,margey);
            wxSize taille(1000-posX_zone_Resultat-margex,500-margey);
            Ajuste_taille_et_pos(pos,taille,this,Fen_result);
            // Ajuste la taille de la zone graphique
            pos.y+=taille.GetY();
            Ajuste_taille_et_pos(pos,taille,this,Courbe_production);
            // Ajuste la taille des contrles
            taille=wxSize(ecart,pasy/2);
            wxSize taille1(ecart1,pasy/2); // taille boite de saisie texte
            wxSize taille2(ecart2,pasy/2); // taille boite de saisie hh jj mm
            wxSize taille3(ecart+ecart2*3,pasy/1.2); // taille combobox
            int ligne=0;
            // Boites saisie paramtres
            Ajuste_taille_et_pos(wxPoint(margex                 ,margey+ (ligne  )*pasy),taille,this,Text_Par_Azimut);
            Ajuste_taille_et_pos(wxPoint(margex+ecart           ,margey+ (ligne++)*pasy),taille1,this,Par_Azimut);
            Ajuste_taille_et_pos(wxPoint(margex                 ,margey+ (ligne  )*pasy),taille1,this,Text_Par_Latitude); // Une taille plus grande cause des problmes avec le contrle suivant sous Wine
            Ajuste_taille_et_pos(wxPoint(margex+ecart1          ,margey+ (ligne  )*pasy),taille1,this,Par_Latitude);
            Ajuste_taille_et_pos(wxPoint(margex+ecart1*2        ,margey+ (ligne  )*pasy),taille1,this,Par_Longitude);
            Ajuste_taille_et_pos(wxPoint(margex+ecart1*2+ecart1 ,margey+ (ligne++)*pasy),taille,this,Text_Par_Longitude);
            Ajuste_taille_et_pos(wxPoint(margex                 ,margey+ (ligne  )*pasy),taille,this,Text_Par_Decalage);
            Ajuste_taille_et_pos(wxPoint(margex+ecart           ,margey+ (ligne++)*pasy),taille1,this,Par_Decalage);
            Ajuste_taille_et_pos(wxPoint(margex                 ,margey+ (ligne++)*pasy),taille3,this,HeureEte);
            Ajuste_taille_et_pos(wxPoint(margex                 ,margey+ (ligne  )*pasy),taille,this,Text_Par_Surface);
            Ajuste_taille_et_pos(wxPoint(margex+ecart           ,margey+ (ligne++)*pasy),taille1,this,Par_Surface);
            Ajuste_taille_et_pos(wxPoint(margex                 ,margey+ (ligne  )*pasy),taille,this,Text_Par_Pendage);
            Ajuste_taille_et_pos(wxPoint(margex+ecart           ,margey+ (ligne++)*pasy),taille1,this,Par_Pendage);
            Ajuste_taille_et_pos(wxPoint(margex                 ,margey+ (ligne++)*pasy),taille3,this,BoitChoixPann);
            Ajuste_taille_et_pos(wxPoint(margex                 ,margey+ (ligne  )*pasy),taille1,this,Text_Dates_a);
            Ajuste_taille_et_pos(wxPoint(margex+ecart1          ,margey+ (ligne  )*pasy),taille2,this,Par_DatDeb_aa);
            Ajuste_taille_et_pos(wxPoint(margex+ecart+ecart2*0.3,margey+ (ligne  )*pasy),taille2,this,Text_Dates_h);
            Ajuste_taille_et_pos(wxPoint(margex+ecart+ecart2*1.3,margey+ (ligne  )*pasy),taille2,this,Text_Dates_j);
            Ajuste_taille_et_pos(wxPoint(margex+ecart+ecart2*2.3,margey+ (ligne++)*pasy),taille2,this,Text_Dates_m);
            Ajuste_taille_et_pos(wxPoint(margex                 ,margey+ (ligne  )*pasy),taille,this,Text_Par_DatDeb);
            Ajuste_taille_et_pos(wxPoint(margex+ecart           ,margey+ (ligne  )*pasy),taille2,this,Par_DatDeb_hh);
            Ajuste_taille_et_pos(wxPoint(margex+ecart+ecart2    ,margey+ (ligne  )*pasy),taille2,this,Par_DatDeb_jj);
            Ajuste_taille_et_pos(wxPoint(margex+ecart+ecart2*2  ,margey+ (ligne++)*pasy),taille2,this,Par_DatDeb_mm);
            Ajuste_taille_et_pos(wxPoint(margex                 ,margey+ (ligne  )*pasy),taille,this,Text_Par_DurMes);
            Ajuste_taille_et_pos(wxPoint(margex+ecart           ,margey+ (ligne  )*pasy),taille2,this,Par_DurMes_hh);
            Ajuste_taille_et_pos(wxPoint(margex+ecart+ecart2    ,margey+ (ligne  )*pasy),taille2,this,Par_DurMes_jj);
            Ajuste_taille_et_pos(wxPoint(margex+ecart+ecart2*2  ,margey+ (ligne++)*pasy),taille2,this,Par_DurMes_mm);
            Ajuste_taille_et_pos(wxPoint(margex                 ,margey+ (ligne  )*pasy),taille,this,Text_Par_Increm);
            Ajuste_taille_et_pos(wxPoint(margex+ecart           ,margey+ (ligne  )*pasy),taille2,this,Par_Increm_hh);
            Ajuste_taille_et_pos(wxPoint(margex+ecart+ecart2    ,margey+ (ligne  )*pasy),taille2,this,Par_Increm_jj);
            Ajuste_taille_et_pos(wxPoint(margex+ecart+ecart2*2  ,margey+ (ligne++)*pasy),taille2,this,Par_Increm_mm);
        }
    }
affichage_en_cours=false;
}
}
// N'affiche que des valeurs licites des paramtres
void MainFrame::MAJ_boite_saisie(wxTextCtrl* boite,base_site_et_date site_ou_date,wxString contenu_boite)
{
    if (site_ou_date.Est_affichable)
    {
    boite->Clear();
    boite->AppendText(contenu_boite);
    }
    else boite->SetInsertionPointEnd();
}
void MainFrame::Affiche_date(const wxString& message,const Date_PV& d)
{
    Traducteur tr;
    wxString Ligne;
    Ligne=tr.trad(message);Fen_result->AppendText(Ligne+TAB);
    Ligne= wxT("h")+wxString::Format(wxT(" %2d"),d.h())+TAB;
    Ligne+=tr.trad(wxT("j"))+wxString::Format(wxT(" %2d"),d.j())+TAB;
    Ligne+=wxT("m")+wxString::Format(wxT(" %2d"),d.m());
    if (d.a()>0)
        Ligne+=TAB+tr.trad(wxT("a"))+wxString::Format(wxT(" %2d"),d.a());
    Ligne+=LF;
    Fen_result->AppendText(Ligne);
}
// Gre l'affichage texte de la fentre de dialogue
void MainFrame::Affiche(wxString message)
{
    Traducteur tr;
    wxString Ligne;
    Fen_result->Clear();
    Fen_result->AppendText(tr.trad(message)+LF);
    Affiche_date(wxT("Dbut de mesure"),Donnees_en_cours.Date_depart.date_legal());
    Affiche_date(wxT("Dure de mesure"),Donnees_en_cours.Duree_mesure);
    Affiche_date(wxT("Incrment"),Donnees_en_cours.Increment);

    int index=BoitChoixPann->GetSelection();
    Ligne=tr.trad(wxT("Type de panneaux : "))+BoitChoixPann->GetString(index)+LF;
    Fen_result->AppendText(Ligne);

    Ligne=tr.trad(wxT("Azimut"))    +wxString::Format(wxT(" %2d"),Donnees_en_cours.Installation.azimut())+TAB;
    Ligne+=tr.trad(wxT("Pendage"))  +wxString::Format(wxT(" %2d"),Donnees_en_cours.Installation.pendage())+TAB;
    Ligne+=tr.trad(wxT("Latitude")) +wxString::Format(wxT(" %2d"),Donnees_en_cours.Installation.latitude())+TAB;
    Ligne+=tr.trad(wxT("Longitude"))+wxString::Format(wxT(" %2d"),Donnees_en_cours.Installation.longitude())+TAB;
    Ligne+=tr.trad(wxT("Surface"))  +wxString::Format(wxT(" %2d"),Donnees_en_cours.Installation.surface())+TAB;
    Ligne+=tr.trad(wxT("Dcalage")) +wxString::Format(wxT(" %2d"),Donnees_en_cours.Installation.decalage())+TAB;
    Ligne+=LF;
    Ligne+=tr.trad(wxT("Heure d't"));
    if(Donnees_en_cours.Installation.heure_ete_activee()) Ligne+=tr.trad(wxT(" active")); else Ligne+=tr.trad(wxT(" Inactive"));
    Ligne+=LF;
    Fen_result->AppendText(Ligne);
}
void MainFrame::saisie_val_date(Date_PV* d,wxTextCtrl* boite_active,char hjm )
{
    wxString message(wxT("Valeur modifie"));
    item_menu_change=true;
    if (d->Est_une_Date) (*d)=d->date_legal();
    try
    {
        switch (hjm)
        {
            case 'a':{d->a(boite_active->GetLineText(0));message=wxT("Anne modifie");break;}
            case 'h':{d->h(boite_active->GetLineText(0));message=wxT("Heure modifie");break;}
            case 'j':{d->j(boite_active->GetLineText(0));message=wxT("Jour modifi");break;}
            default :{d->m(boite_active->GetLineText(0));message=wxT("Mois modifi");break;}
        }
    }
    catch(Erreur_PV& epv)
    {
        message=epv.message;
    }
    if (d->Est_une_Date) (*d)=d->date_reelle();
    Titre_Fen=message;
    Refresh();
}
void MainFrame::saisie_val_site(char alp)
{
    wxString message(wxT("Valeur modifie"));
    Site_PV* s=&Donnees_en_cours.Installation;
    wxTextCtrl* ba=Par_Surface;
    item_menu_change=true;
    try
    {
        switch (alp)
        {
            case 'a':{ba=Par_Azimut;    s->azimut(ba->GetLineText(0))   ;message=wxT("Azimut modifi");break;}
            case 'l':{ba=Par_Latitude;  s->latitude(ba->GetLineText(0)) ;message=wxT("Latitude modifie");break;}
            case 'L':{ba=Par_Longitude; s->longitude(ba->GetLineText(0));message=wxT("Longitude modifie");break;}
            case 'p':{ba=Par_Pendage;   s->pendage(ba->GetLineText(0))  ;message=wxT("Pendage modifi");break;}
            case 'd':{ba=Par_Decalage;  s->decalage(ba->GetLineText(0)) ;message=wxT("Dcalage horaire modifi");break;}
            default :{ba=Par_Surface;   s->surface(ba->GetLineText(0))  ;message=wxT("Surface modifie");break;}
        }
    }
    catch(Erreur_PV& epv)
    {
        message=epv.message;
    }
    Titre_Fen=message;
    Refresh();
}
//---------------------------------------------------------------------------
// Saisie des caractristiques du site
// Ne font rien si l'vnement est dclench par un affichage en cours
void MainFrame::OnPar_Azimut(wxCommandEvent& event)
{
    if ((!affichage_en_cours)&&init_done) saisie_val_site('a');
}
void MainFrame::OnPar_Latitude(wxCommandEvent& event)
{
    if ((!affichage_en_cours)&&init_done) saisie_val_site('l');
}
void MainFrame::OnPar_Longitude(wxCommandEvent& event)
{
    if ((!affichage_en_cours)&&init_done) saisie_val_site('L');
}
void MainFrame::OnPar_Decalage(wxCommandEvent& event)
{
    if ((!affichage_en_cours)&&init_done)
        {
        Date_PV& ddpt=Donnees_en_cours.Date_depart;//ddpt est un alias de Donnes_en_cours.Date_depart
        int decalage_avant(ddpt.decalage());
        saisie_val_site('d');
        Date_PV d2(0,decalage_avant-ddpt.decalage(),0,0,0);
        ddpt+=d2;  // La Date dpart courante sera maintenue, c'est l'heure solaire qui est modifie
        }
}
void MainFrame::OnPar_Surface(wxCommandEvent& event)
{
    if ((!affichage_en_cours)&&init_done) saisie_val_site('s');
}
void MainFrame::OnPar_Pendage(wxCommandEvent& event)
{
    if ((!affichage_en_cours)&&init_done) saisie_val_site('p');
}
void MainFrame::OnBoitChoixPann(wxCommandEvent& event)
{
    Donnees_en_cours.Installation.modele(BoitChoixPann->GetSelection());
    Titre_Fen=wxT("Nature de panneau modifie");
    item_menu_change=true;
    Refresh();
}
void MainFrame::OnHeureEte(wxCommandEvent& event)
{   // L'activation de l'heure d't a change
    Date_PV& ddpt=Donnees_en_cours.Date_depart; //ddpt est un alias de Donnes_en_cours.Date_depart
    ddpt.heure_ete_activee()=HeureEte->GetValue(); // Modification de l'activation pour toutes les instances de base_site_et_date
    Date_PV d2(0,(ddpt.c_est_l_ete()?(ddpt.heure_ete_activee()?-1:1):0),0,0,0);
    ddpt+=d2; // La Date dpart courante sera maintenue, c'est l'heure solaire qui est modifie
    Titre_Fen=wxT("Heure d't modifie");
    item_menu_change=true;
    Refresh();
}
//---------------------------------------------------------------------------
// Saisie des paramtres du rapport
// Ne font rien si l'vnement est dclench par un affichage en cours
void MainFrame::OnPar_DatDeb_aa(wxCommandEvent& event)
{
     if ((!affichage_en_cours)&&init_done) saisie_val_date(&Donnees_en_cours.Date_depart,Par_DatDeb_aa,'a');
}
void MainFrame::OnPar_DatDeb_hh(wxCommandEvent& event)
{
     if ((!affichage_en_cours)&&init_done) saisie_val_date(&Donnees_en_cours.Date_depart,Par_DatDeb_hh,'h');
}
void MainFrame::OnPar_DatDeb_jj(wxCommandEvent& event)
{
    if ((!affichage_en_cours)&&init_done) saisie_val_date(&Donnees_en_cours.Date_depart,Par_DatDeb_jj,'j');
}
void MainFrame::OnPar_DatDeb_mm(wxCommandEvent& event)
{
    if ((!affichage_en_cours)&&init_done) saisie_val_date(&Donnees_en_cours.Date_depart,Par_DatDeb_mm,'m');
}
void MainFrame::OnPar_DurMes_hh(wxCommandEvent& event)
{
    if ((!affichage_en_cours)&&init_done) saisie_val_date(&Donnees_en_cours.Duree_mesure,Par_DurMes_hh,'h');
}
void MainFrame::OnPar_DurMes_jj(wxCommandEvent& event)
{
    if ((!affichage_en_cours)&&init_done) saisie_val_date(&Donnees_en_cours.Duree_mesure,Par_DurMes_jj,'j');
}
void MainFrame::OnPar_DurMes_mm(wxCommandEvent& event)
{
    if ((!affichage_en_cours)&&init_done) saisie_val_date(&Donnees_en_cours.Duree_mesure,Par_DurMes_mm,'m');
}
void MainFrame::OnPar_Increm_hh(wxCommandEvent& event)
{
    if ((!affichage_en_cours)&&init_done) saisie_val_date(&Donnees_en_cours.Increment,Par_Increm_hh,'h');
}
void MainFrame::OnPar_Increm_jj(wxCommandEvent& event)
{
    if ((!affichage_en_cours)&&init_done) saisie_val_date(&Donnees_en_cours.Increment,Par_Increm_jj,'j');
}
void MainFrame::OnPar_Increm_mm(wxCommandEvent& event)
{
    if ((!affichage_en_cours)&&init_done) saisie_val_date(&Donnees_en_cours.Increment,Par_Increm_mm,'m');
}
//---------------------------------------------------------------------------
void  MainFrame::OnCalcul(wxCommandEvent& event)
{
    // Boucle principale, calcule et affiche un rapport
    Traducteur tr;
    wxString Ligne;
    calcul_en_cours=true;
    int index_valeur(0);
    Courbe_production->purge_valeurs();
    Courbe_production->valeurs_seulement=false;
    Ligne=LF+tr.trad(wxT("Puissance")).Left(5)
    +TAB+tr.trad(wxT("Incidence")).Left(5)
    +TAB+tr.trad(wxT("heure"))
    +TAB+tr.trad(wxT("jour"))
    +TAB+tr.trad(wxT("mois"))+TAB+LF;
    Fen_result->AppendText(Ligne);
    Date_PV d1(Donnees_en_cours.Date_depart),d2(Donnees_en_cours.Duree_mesure),inc(Donnees_en_cours.Increment);
    Resultat_mesure R;
    if (!inc.zero())
        for (Date_PV i(d1);i<=(d1+d2);i=i+inc)
            {
            R.prend_valeurs_de(Calculs::Pour_une_date(i,Donnees_en_cours.Installation));
            Ligne=wxString::Format(wxT("%2d"),int(R.puissance()))+TAB+wxString::Format(wxT("%2d"),int(R.incidence()));
            Affiche_date(Ligne,i.date_legal());
            Courbe_production->ajoute_valeur(0,index_valeur++,R.puissance());
            }
    Ligne=tr.trad(wxT("Production sur la priode"))
    +wxString::Format(wxT(" = %6.1f"),Calculs::Production_entre_deux_dates(d1,d2,Donnees_en_cours.Installation)/1000.0)
    +wxT(" kWh");
    Fen_result->AppendText(Ligne);
    Courbe_production->caracteristiques_axeY.val_max_affichee=R.puissance_max();
    Courbe_production->caracteristiques_axeY.valeur_de_la_graduation()=int(R.puissance_max()/10);
    Courbe_production->caracteristiques_axeX.val_max_affichee=index_valeur;
    // la fonction valeur_de_la_graduation va renvoyer une valeur en nombre d'increments par graduation comprise entre 1 (s'il y a moins de 10 incrments)  et index_valeur/10 s'il y en a plus
    Courbe_production->caracteristiques_axeX.valeur_de_la_graduation()=int(index_valeur/10);
    Courbe_production->caracteristiques_axeX.unite=wxString::Format(wxT("%5i "),Courbe_production->caracteristiques_axeX.valeur_de_la_graduation()*Donnees_en_cours.val_increment())+tr.trad(wxT("par graduation"));
    item_menu_change=true;
    Refresh(); //Update(); cause un problme sous Wine (zone texte blanche immdiatement aprs le calcul)
    calcul_en_cours=false;
    item_menu_change=false;
}
//---------------------------------------------------------------------------
void  MainFrame::OnCalcul_positions(wxCommandEvent& event)
{
    // Affiche les coordonnes des projections du soleil sur le plan du panneau
    // Peut servir  calculer le trac de l'analemme correspondant  une heure
    // Le graphique n'est pas utilis
    Traducteur tr;
    wxString Ligne;
    calcul_en_cours=true;
    Courbe_production->purge_valeurs();
    Courbe_production->valeurs_seulement=true;
    Ligne=LF+tr.trad(wxT("Abaque pour analemme"))+LF;
    Ligne+=tr.trad(wxT("X")).Left(5)
    +TAB+tr.trad(wxT("Y")).Left(5)
    +TAB+tr.trad(wxT("heure"))
    +TAB+tr.trad(wxT("jour"))
    +TAB+tr.trad(wxT("mois"))+TAB+LF;
    Fen_result->AppendText(Ligne);
    Date_PV d1(Donnees_en_cours.Date_depart),d2(Donnees_en_cours.Duree_mesure),inc(Donnees_en_cours.Increment);
    Resultat_mesure R;
    if (!inc.zero())
        for (Date_PV i(d1);i<=(d1+d2);i=i+inc)
            {
            R.prend_valeurs_de(Calculs::Pour_une_date_position_soleil(i,Donnees_en_cours.Installation));
            Ligne=wxString::Format(wxT("%3.2f"),R.x())+TAB+wxString::Format(wxT("%3.2f"),R.y());
            Affiche_date(Ligne,i.date_legal());
            }
    Fen_result->AppendText(Ligne);
    calcul_en_cours=false;
    Refresh();
}
/*
// Calcul de test de la fonction donnant l'orbite
//  faire sauter
void  MainFrame::OnCalcul(wxCommandEvent& event)
{
    // Boucle principale, calcule et affiche un rapport
    Traducteur tr;
    wxString Ligne;
    vecteur R;
    calcul_en_cours=true;
    Courbe_production->purge_valeurs();
    Courbe_production->valeurs_seulement=true;

    double d1(Donnees_en_cours.Date_depart.nombre_de_secondes()),
    d2(Donnees_en_cours.Duree_mesure.nombre_de_secondes()),
    inc(Donnees_en_cours.Increment.nombre_de_secondes());
    Ligne=wxT("Orbite");
    double v;
    R=Calculs::Coordplanete(d1,Calculs::Orb_Terre);
    Ligne+=wxString::Format(wxT(" x = %12.4f"),R.real());
    Ligne+=wxString::Format(wxT(" y = %12.4f"),R.imag())+LF;
    Ligne+=wxString::Format(wxT(" d1 = %12.4f"),float(d1))+LF;
    Ligne+=wxString::Format(wxT(" d2 = %12.4f"),float(d2))+LF;
    Ligne+=wxString::Format(wxT(" inc = %12.4f"),float(inc))+LF;
    Fen_result->AppendText(Ligne+LF);
    Ligne=(wxT(""));
    if (inc>0)
        for (double i(d1);i<=(d1+d2);i+=inc)
            {
            Param_orbite P0(Calculs::Orb_Terre);
            //v=Calculs::Anex(i,P0.t0,P0.T,P0.excentricite());
            R=Calculs::Coordplanete(i,Calculs::Orb_Terre);
            //Ligne=wxString::Format(wxT("i=%12.4f"),i/1000000.0)+TAB;
            //Ligne+=wxString::Format(wxT("v=%12.4f"),v);
            Ligne=wxString::Format(wxT("x=%10.2f"),R.real()/1000000000.0)+TAB;
            Ligne+=wxString::Format(wxT("y=%10.2f"),R.imag()/1000000000.0);
            Fen_result->AppendText(Ligne+LF);
            //Courbe_production->ajoute_valeur(0,abs(int(R.x/1000000000.0)),abs(int(R.y/1000000000.0)));
            }
    Courbe_production->caracteristiques_axeY.val_max_affichee=300;
    Courbe_production->caracteristiques_axeY.valeur_de_la_graduation()=10;
    Courbe_production->caracteristiques_axeX.val_max_affichee=300;
    Courbe_production->valeurs_seulement=false;
    calcul_en_cours=false;
    Refresh();
}
*/
// fin  faire sauter
