/*
    Matrices est un module permettant diverses manipulations sur les matrices carrées.
    Copyright (C) 2013-2021 Vial Jean-Luc Annecy
    Contact email: vial.frjl@free.fr

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef Matrices_H
#define Matrices_H

#include <wx/wx.h>
#include <vector>

class Terreur_Matrice
{
    public:
    wxString Text_erreur;
    Terreur_Matrice();
    explicit Terreur_Matrice(wxString Terr);
};
class Matrice
{
    // Principales opérations sur des matrices carrées
    private:

    public:
        std::vector<std::vector<double> > contenu;
        unsigned dimx; // taille= nombre de colonnes ou de lignes
        Matrice();
        Matrice(unsigned taille,bool nulle_ou_unite);
        Matrice(unsigned taille, ...);
        Matrice operator*(const Matrice &M);
        Matrice operator*(const double k);
        Matrice operator/(const double k);
        Matrice operator+(const Matrice &M);
        Matrice sous_matrice(unsigned li,unsigned co);
        Matrice transposee();
        Matrice adjointe();
        Matrice inverse();
        std::vector<double> operator*(const std::vector<double> &V);
        double determinant();
};
    // Quelques opérations sur les vecteurs
    double scalaire(const std::vector<double> &v1,const std::vector<double> &v2);
    std::vector<double> prod_vect(const std::vector<double> &v1,const std::vector<double> &v2);
    std::vector<double> operator+(const std::vector<double> &v1,const std::vector<double> &v2);
    std::vector<double> operator/(const std::vector<double> &v1,const double &d);
    double norme(const std::vector<double> &v1);
#endif //Matrices_H
