#include "Matrices.h"
#include <stdarg.h>
// -----------------------------------------------
// Implémentation de la classe Terreur_Matrice
// -----------------------------------------------
Terreur_Matrice::Terreur_Matrice():Text_erreur(wxT("Erreur dans un calcul de matrice")){};
Terreur_Matrice::Terreur_Matrice(wxString Terr):Text_erreur(Terr){};
// -----------------------------------------------
// Implémentation de la classe Matrice
// -----------------------------------------------
// Constructeurs
    // constructeur par défaut
Matrice::Matrice():dimx(0){};
    // Constructeur de matrice unité (si nulle_ou_unité est vrai) et nulle dans le cas contraire
Matrice::Matrice(unsigned taille,bool nulle_ou_unite)
{
    dimx=taille;
    int diag((nulle_ou_unite ? 1:0));
    contenu.resize(dimx);
    std::vector<double> ligne(dimx);
    for( unsigned i = 0 ; i < dimx ; i++)
        {
        for (unsigned j=0;j<dimx;j++)
            ligne[j]=(j==i?diag:0);
        contenu[i]=ligne;
        }
}
// -----------------------------------------------
    // Constructeur explicite à partir d'un suite de taille*taille doubles
    // taille > 1 sinon c'est le constructeur Matrice(unsigned taille,bool nulle_ou_unite) qui est appelé
    // paramètres  : taille, puis les éléments de la ligne1, puis ceux de la ligne 2 etc
    // Attention de bien mettre des doubles comme valeurs des éléments (ex 2.0 et pas 2)
Matrice::Matrice(unsigned taille, ...)
{
    dimx=taille;
    contenu.resize(dimx);
    std::vector<double> ligne(dimx);
    va_list ap;
    va_start(ap, taille);
    for( unsigned i = 0 ; i < dimx ; i++)
        {
        for (unsigned j=0;j<dimx;j++)
            ligne[j]=va_arg(ap, double);
        contenu[i]=ligne;
        }
    va_end(ap);
}
// -----------------------------------------------
Matrice Matrice::operator*(const Matrice &M)
{   // Multiplie deux matrices de même rang entre elles
    // Envoie une exception si les rangs sont différents
    unsigned taille (M.dimx);
    if (taille!=dimx)
        {
        Terreur_Matrice erreur(wxString(wxT("Matrices de rangs différents produit impossible")));
        throw erreur;
        }
    Matrice resultat(dimx,false);// Crée une matrice nulle
    for (unsigned i=0;i<dimx;i++)
        for (unsigned j=0;j<dimx;j++)
            for (unsigned k=0;k<dimx;k++)
                resultat.contenu[i][j]+=contenu[i][k]*M.contenu[k][j];
    return resultat;
}
// -----------------------------------------------
Matrice Matrice::operator*(const double k)
{   // Multiplie la matrice par un réel
    Matrice M(*this);
    for (unsigned i=0;i<dimx;i++)
        for (unsigned j=0;j<dimx;j++)
            M.contenu[i][j]*=k;
    return M;
}
// -----------------------------------------------
std::vector<double> Matrice::operator*(const std::vector<double> &V)
{   // Produit par un vecteur
    std::vector<double> resultat(dimx);
    for (unsigned i=0;i<dimx;i++)
        for (unsigned j=0;j<dimx;j++)
            resultat[i]+=V[j]*contenu[j][i];
    return resultat;
}
// -----------------------------------------------
Matrice Matrice::operator/(const double k)
{   // Division par un réel
    // envoi d'une exception pour division par 0
    if (k==0)
        {Terreur_Matrice erreur(wxString(wxT("Division par zéro")));
        throw erreur;
        }
    return (*this)*(1/k);
}
// -----------------------------------------------
Matrice Matrice::operator+(const Matrice &M)
{   // Additionne deux matrices carrées terme à terme.
    // envoi d'une exception pour matrices de rang différents
    unsigned taille (M.dimx);
    Matrice resultat(M);
    if (taille!=dimx)
        {
        Terreur_Matrice erreur(wxString(wxT("Matrices de rang différents somme impossible")));
        throw erreur;
        }
    for (unsigned i=0;i<taille;i++)
        for (unsigned j=0;j<taille;j++)
            resultat.contenu[i][j]+=contenu[i][j];
    return M;
}
// -----------------------------------------------
Matrice Matrice::sous_matrice(unsigned li,unsigned co)
{   // sous matrice obtenue en enlevant la ligne li et la colonne co. Son déterminant est le cofacteur(li,co) de M
    Matrice resultat((dimx?dimx-1:0),false);
    if (dimx==0) return resultat;
    unsigned ligne(0), colonne(0);
    for (unsigned i=0;i<dimx;i++)
        if (i!=li)
        {
            colonne=0;
            for (unsigned j=0;j<dimx;j++)
                if (j!=co)
                {
                    resultat.contenu[ligne][colonne]=contenu[i][j];
                    colonne++;
                };
            ligne++;
        };
    return resultat;
}
// -----------------------------------------------
Matrice Matrice::transposee()
{   // Symétrique par rapport à la diagonale
    Matrice resultat(*this);
    if (dimx>1)
        for (unsigned i=0;i<dimx;i++)
            for (unsigned j=0;j<dimx;j++)
                resultat.contenu[i][j]=contenu[j][i];
    return resultat;
}
// -----------------------------------------------
double Matrice::determinant()
{   // non nul si la matrice est régulière
    double resultat(0);
    switch (dimx)
    {
    case 0:resultat=0;break;
    case 1:resultat=contenu[0][0];break;
    default:
        {Matrice M;
        int signe=-1;
        for (unsigned i=0;i<dimx;i++)
            {
                M=sous_matrice(i,0);
                signe*=(-1);
                resultat+=signe*contenu[i][0]*M.determinant();
            }
        }
    }
    return resultat;
}
// -----------------------------------------------
Matrice Matrice::adjointe()
{   // Matrice transposée des cofacteurs de la matrice de départ.
    Matrice resultat(dimx,false);
    if (dimx>1)
    {
    int signe=-1;
    for (unsigned i=0;i<dimx;i++)
        for (unsigned j=0;j<dimx;j++)
        {
            signe*=(-1);
            resultat.contenu[i][j]=signe*sous_matrice(i,j).determinant();
        }
    resultat=resultat.transposee();
    }
    return resultat;
}
// -----------------------------------------------
Matrice Matrice::inverse()
{   // Matrice dont le produit avec M est la matrice unité de même rang
    // envoi d'une exception si on tente d'inverser une matrice irrégulière
    double det(determinant());
    if (det==0)
        {Terreur_Matrice erreur(wxString(wxT("Tentative d'inverser une matrice à déterminant nul")));
        throw erreur;
        }
    Matrice resultat(adjointe()/det);
    return resultat;
}
// -----------------------------------------------
// Quelques opérations sur les vecteurs
// -----------------------------------------------
    // Produit scalaire de deux vecteurs de mêmes dimensions
    // envoi d'une exception pour des vecteurs de tailles différentes
double scalaire(const std::vector<double> &v1,const std::vector<double> &v2)
{
    if (v1.size()!=v2.size())
        {Terreur_Matrice erreur(wxString(wxT("Produit scalaire de vecteurs de tailles différentes")));
        throw erreur;
        }
    double resultat(0);
    for (unsigned i=0;i<v1.size();i++)
        resultat+=v1[i]*v2[i];
    return resultat;
}
// -----------------------------------------------
    // Produit vectoriel de deux vecteurs de mêmes dimensions
    // envoi d'une exception pour des vecteurs de tailles différentes
std::vector<double> prod_vect(const std::vector<double> &v1,const std::vector<double> &v2)
{
    if (v1.size()!=v2.size())
        {Terreur_Matrice erreur(wxString(wxT("Produit vectoriel de vecteurs de tailles différentes")));
        throw erreur;
        }
    int s=v1.size();
    std::vector<double> resultat(s);
    for (unsigned i=0;i<s;i++)
        resultat[i]=v1[(i+1>=s?i+1-s:i+1)]*v2[(i+2>=s?i+2-s:i+2)]-v1[(i+2>=s?i+2-s:i+2)]*v2[(i+1>=s?i+1-s:i+1)];
    return resultat;
}
// -----------------------------------------------
    // somme de deux vecteurs de mêmes dimensions
std::vector<double> operator+(const std::vector<double> &v1,const std::vector<double> &v2)
{
    if (v1.size()!=v2.size())
        {Terreur_Matrice erreur(wxString(wxT("somme de vecteurs de tailles différentes")));
        throw erreur;
        }
    int s=v1.size();
    std::vector<double> resultat(s);
    for (unsigned i=0;i<s;i++)
        resultat[i]=v1[i]+v2[i];
    return resultat;
}
// -----------------------------------------------
    // Division d'un vecteur par un réel.
    // Envoi d'une exception si le diviseur est nul.
std::vector<double> operator/(const std::vector<double> &v1,const double &d)
{
    if (d==0)
        {Terreur_Matrice erreur(wxString(wxT("division par zéro")));
        throw erreur;
        }
    int s=v1.size();
    std::vector<double> resultat(s);
    for (unsigned i=0;i<s;i++)
        resultat[i]=v1[i]/d;
    return resultat;
}
// -----------------------------------------------
    // Norme (longueur) d'un vecteur
double norme(const std::vector<double> &v1)
{
    double resultat(0);
    for (unsigned i=0;i<v1.size();i++)
        resultat+=v1[i]*v1[i];
    resultat=sqrt(resultat);
    return resultat;
}
