#ifndef DESSIN_H_INCLUDED
#define DESSIN_H_INCLUDED
/*
    Simulation panneaux photovoltaques. Copyright (C) 2013-2021
    Vial Jean-Luc Annecy
    Contact email: vial.frjl@free.fr

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#include <wx/wx.h>
#include "BoiteAOutils.h"

typedef std::map<int,double> Tvaleurs;
typedef Tvaleurs::iterator Tmapiter;
//---------------------------------------------------------------------------
class Tcar_axes {
private:
        int val_grad;
public:
        wxString titre,unite;
        int val_max_affichee,val_min_affichee;
        int& valeur_de_la_graduation() ;// en unite par graduation
        int nb_grad();
        Tcar_axes();
                };
//---------------------------------------------------------------------------
struct Tserie
        {
        wxString Titre;
        wxColor couleur;
        Tvaleurs valeurs;
        };
typedef std::vector<Tserie> Tseries;
//---------------------------------------------------------------------------
class   Tgraphique: public wxWindow
{

public:

        bool valeurs_seulement;
        bool cadres_visibles;
        bool EstImpression;
        Tgraphique();
        Tgraphique(wxWindow* parent,wxWindowID id,wxPoint pos,wxSize taille,wxString tip,wxString ti, wxColor col_f, wxColor col_t,wxColor col_s);
        Tcar_axes caracteristiques_axeX, caracteristiques_axeY;
        unsigned nombre_series();
        bool est_vide();
        bool ajoute_une_serie(wxString titre,wxColor couleur);
        bool change_aspect_serie(wxString titre,wxColor couleur,unsigned n);
        bool supprime_serie(unsigned n);
        bool supprime_toutes_les_series();
        void efface(wxDC& dc);
        void retrace(wxDC& dc,float correctif);
        void purge_valeurs();
        bool ajoute_valeur(int num_serie,int x,float y);
        void OnPaint (wxPaintEvent& WXUNUSED(event));
private:
        wxString titre;
        wxColor coul_fond,coul_trace,coul_shad;
        int const nbmax_series,nbmax_points;
        Tseries valeurs_stokees;
        struct {wxPoint
                pixels,
                coin_superieur_gauche_du_graphique,
                coin_inferieur_droit_du_graphique,
                origine_du_graphique,
                position_titre_X,
                position_titre_Y,
                position_cadre_serie_1,
                dimensions_cadres_series;
        } parametres_internes;
        void trace_axe(bool shadow,bool xy,wxDC& dc);
        void trace_serie(int num_serie,wxDC& dc);
        vecteur cadre_valeur(int x,float y); //limine les valeurs hors max et mini
        vecteur normalise_xy(vecteur valeur);// convertit les coordonne d'un point du graphique en coordonnes de l'cran virtuel 10000x100000
        wxPoint fait_absXY(vecteur valeur,wxDC& dc);   // convertit les coordonnes cran virtuel en coordonnes pixels de la paintbox
        void fixe_parametres();
        void trace_ligne(bool shadow,const vecteur& debut,const vecteur& fin,wxDC& dc);
        void trace_boite(int num_serie,wxDC& dc);
        DECLARE_EVENT_TABLE()
};

#endif // DESSIN_H_INCLUDED
