#include "Dessin.h"
#include "ProjetdeBase.h"
// Assure la compatibilit avec la version 2.8 de wxWidgets. A faire sauter ultrieurement
#if !wxCHECK_VERSION(2,9,0)
    #define wxPENSTYLE_SOLID wxSOLID
    #define wxPENSTYLE_DOT wxDOT
    #define wxPENSTYLE_LONG_DASH wxLONG_DASH
    #define wxBRUSHSTYLE_TRANSPARENT wxTRANSPARENT
    #define wxBRUSHSTYLE_SOLID wxSOLID
#endif
//---------------------------------------------------------------------------
// Implmentation de la classe Tcar_axes
//---------------------------------------------------------------------------
        //---------------------------------------------------------------------------
        // Constructeur
Tcar_axes::Tcar_axes():val_max_affichee(10000),val_min_affichee(0)
{
        valeur_de_la_graduation()=int((val_max_affichee-val_min_affichee)/10);
}
        //---------------------------------------------------------------------------
        // la fonction stocke et renvoie le nombre d'units entre deux graduations en s'assurant qu'il est au minimum gal  1
int& Tcar_axes::valeur_de_la_graduation()
        {
        val_grad=(val_grad<1?1:val_grad);
        return val_grad;
        }
        //---------------------------------------------------------------------------
int Tcar_axes::nb_grad()
        {
        return int((val_max_affichee-val_min_affichee)/valeur_de_la_graduation());
        }
//---------------------------------------------------------------------------
//      Implmentation de l'objet Tgraphique
//---------------------------------------------------------------------------

BEGIN_EVENT_TABLE(Tgraphique, wxWindow)
EVT_PAINT(Tgraphique::OnPaint)
END_EVENT_TABLE()

        //---------------------------------------------------------------------------
        // Constructeur objet Tgaphique
        Tgraphique::Tgraphique(wxWindow* parent,wxWindowID id,wxPoint pos,wxSize taille,wxString tip,wxString ti, wxColor col_f, wxColor col_t,wxColor col_s):
                wxWindow(parent,id,pos,taille,wxFULL_REPAINT_ON_RESIZE|wxBORDER_SUNKEN),
                valeurs_seulement(false),
                cadres_visibles(false),
                EstImpression(false),
                titre(ti),
                coul_fond(col_f),coul_trace(col_t),coul_shad(col_s),
                nbmax_series(4),nbmax_points(10000)
        {
        fixe_parametres();
        SetToolTip(tip);
        SetName(ti);
        }
        //---------------------------------------------------------------------------
        void Tgraphique::OnPaint(wxPaintEvent& WXUNUSED(event))
        {
        wxPaintDC dc(this);
        retrace(dc,1.0);
        }
//---------------------------------------------------------------------------
        void Tgraphique::trace_ligne(bool shadow,const vecteur& debut,const vecteur& fin,wxDC& dc)
        {wxPoint deb_abs,fin_abs,offset(1,1);
        deb_abs=fait_absXY(debut,dc);
        fin_abs=fait_absXY(fin,dc);
        wxColour couleur_ligne(coul_trace);
        if (shadow)
                {
                deb_abs+=offset;fin_abs+=offset;
                couleur_ligne=coul_shad;
                }
        PalettePerso p;
        if (EstImpression) dc.SetPen(wxPen(p.clBlack,2,wxPENSTYLE_SOLID));
            else dc.SetPen(wxPen(couleur_ligne,2,wxPENSTYLE_SOLID));
        dc.DrawLine(deb_abs.x,deb_abs.y,fin_abs.x,fin_abs.y);
        }
//---------------------------------------------------------------------------
//      valeur de dpart --> valeur affichable entre 0 et valmax-valmin
        vecteur Tgraphique::cadre_valeur(int x,float y)
        {float valx,valy,
        xmax(caracteristiques_axeX.val_max_affichee),
        xmin(caracteristiques_axeX.val_min_affichee),
        ymax(caracteristiques_axeY.val_max_affichee),
        ymin(caracteristiques_axeY.val_min_affichee);
        valx=((x<xmax?x:xmax)-xmin);valx=(valx>0?valx:0);
        valy=((y<ymax?y:ymax)-ymin);valy=(valy>0?valy:0);
        return vecteur(valx,valy);
        }
//---------------------------------------------------------------------------
//      Valeur affichable --> valeur en coordonnes normalises sur l'cran virtuel
        vecteur Tgraphique::normalise_xy(vecteur valeur)
        {vecteur
                csg(fait_vecteur(parametres_internes.coin_superieur_gauche_du_graphique)),
                cid(fait_vecteur(parametres_internes.coin_inferieur_droit_du_graphique)),
                origine(fait_vecteur(parametres_internes.origine_du_graphique)),
                resultat;
        double ancI,ancJ;
        ancI=(cid.real()-origine.real())/(caracteristiques_axeX.val_max_affichee-caracteristiques_axeX.val_min_affichee);
        ancJ=(csg.imag()-origine.imag())/(caracteristiques_axeY.val_max_affichee-caracteristiques_axeY.val_min_affichee);
        resultat= vecteur(valeur.real()*ancI,valeur.imag()*ancJ);
        return resultat+origine;
        }
//---------------------------------------------------------------------------
//      position sur l'cran virtuel --> coordonnes sur la zone graphique active
        wxPoint Tgraphique::fait_absXY(vecteur valeur,wxDC& dc)
        {
        vecteur resultat;
        wxPoint nbpixels(parametres_internes.pixels);
        resultat=vecteur(valeur.real()/nbpixels.x*dc.GetSize().GetWidth(),valeur.imag()/nbpixels.y*dc.GetSize().GetHeight());
        return wxPoint(int(resultat.real()),int(resultat.imag()));
        }
//---------------------------------------------------------------------------
//      Efface la paintbox
        void Tgraphique::efface(wxDC& dc)
        {
        PalettePerso p;
        dc.SetBackground(wxBrush(coul_fond,wxBRUSHSTYLE_SOLID));
        dc.Clear();
        }
//---------------------------------------------------------------------------
//      Vide les conteneurs de valeurs de toutes les sries
        void Tgraphique::purge_valeurs()
        {
        if (!valeurs_stokees.empty())
                for (unsigned i=0;i<valeurs_stokees.size();i++)
                        valeurs_stokees[i].valeurs.clear();
        }
//---------------------------------------------------------------------------
//      Trace un axe du graphique titr et indent
        void Tgraphique::trace_axe(bool shadow,bool xy,wxDC& dc)
        {Tcar_axes* axe_en_cours;
        wxString titre;
        wxPoint position_titre;
        // titre un axe
         if (xy) {axe_en_cours=&caracteristiques_axeX;
                position_titre=parametres_internes.position_titre_X;}
                else
                {axe_en_cours=&caracteristiques_axeY;
                position_titre=parametres_internes.position_titre_Y;}

        if (!shadow)
        {
        position_titre=fait_absXY(fait_vecteur(position_titre),dc);
        titre=axe_en_cours->titre+wxChar('(')+axe_en_cours->unite+wxChar(')');
        if (xy)position_titre.x-=dc.GetTextExtent(titre).x;
        dc.DrawText(titre,position_titre.x,position_titre.y);
        }
        // trace un axe
        int nbgrad=axe_en_cours->nb_grad();
        vecteur v1,v2,rotation(0,1),origine,extremite,offset(20,20);
        if (xy)
                {origine=fait_vecteur(parametres_internes.origine_du_graphique);
                 extremite=fait_vecteur(parametres_internes.coin_inferieur_droit_du_graphique);}
                 else
                 {origine=fait_vecteur(parametres_internes.coin_superieur_gauche_du_graphique);
                 extremite=fait_vecteur(parametres_internes.origine_du_graphique);
                 };
        v1=(extremite-origine);
        v2=v1;
        v1/=double(nbgrad);
        v2=v2*rotation/double(20);
        trace_ligne(shadow,origine,extremite,dc);
        for (int i=0;i<=nbgrad;i++) // indentations de l'axe
                {
                trace_ligne(shadow,origine,origine+v2,dc);
                origine+=v1;
                };
        };
//---------------------------------------------------------------------------
//      Trace une courbe en ligne brise correspondant aux valeurs d'une srie
        void Tgraphique::trace_serie(int num_serie,wxDC& dc)
        {Tserie& serie=valeurs_stokees[num_serie];
        int nb_points=serie.valeurs.size();
        PalettePerso p;
        if (nb_points>0)
                {wxPoint p0(0,0),p1(0,0);
                if (EstImpression) dc.SetPen(wxPen(p.clBlack,2,((num_serie % 2)==0?wxPENSTYLE_SOLID:wxPENSTYLE_LONG_DASH)));
                else dc.SetPen(wxPen(serie.couleur,1,wxPENSTYLE_SOLID));
                for (Tmapiter i=serie.valeurs.begin();i!=serie.valeurs.end();++i)
                        {
                        Tvaleurs::value_type v=*i;
                        vecteur point_courant=cadre_valeur(v.first,double(v.second));
                        point_courant=normalise_xy(point_courant);
                        p1=fait_absXY(point_courant,dc);
                        if (i!=serie.valeurs.begin()) dc.DrawLine(p0.x,p0.y,p1.x,p1.y);
                        p0=p1;
                         }
                }
        }
//---------------------------------------------------------------------------
//      Trace un rectangle dans la marge du graphique
//      titr (nom de la srie) renseign avec la dernire valeur de la srie
        void Tgraphique::trace_boite(int num_serie,wxDC& dc)
        {Tserie& s=valeurs_stokees[num_serie];
        vecteur csg,cid,decalage,pos_valeur;
        wxPoint csg_abs,cid_abs,pos_valeur_abs,dimensions_cadre,taille_texte;

        // affiche un cadre
        dimensions_cadre=parametres_internes.dimensions_cadres_series;
        decalage=vecteur(0,dimensions_cadre.y);
        dc.SetPen(wxPen(s.couleur,1,wxPENSTYLE_SOLID));
        csg=fait_vecteur(parametres_internes.position_cadre_serie_1);
        csg+=decalage*double(num_serie*2);
        pos_valeur=csg;
        cid=csg+fait_vecteur(dimensions_cadre);
        csg_abs=fait_absXY(csg,dc);
        cid_abs=fait_absXY(cid,dc);
        dc.SetBrush(*wxWHITE_BRUSH);
        dc.DrawRectangle(csg_abs.x,csg_abs.y,cid_abs.x-csg_abs.x,cid_abs.y-csg_abs.y);
        csg+=decalage*double(1.05);
        csg_abs=fait_absXY(csg,dc);

        // titre le cadre
        dc.DrawText(s.Titre,csg_abs.x,csg_abs.y);

        // affiche la dernire valeur d'ordonne du graphique
        vecteur pos_valeur_cid=pos_valeur+fait_vecteur(dimensions_cadre);
        pos_valeur_abs=fait_absXY(pos_valeur,dc);
        pos_valeur_abs.x++;pos_valeur_abs.y++;
        wxPoint pos_valeur_cid_abs=fait_absXY(pos_valeur_cid,dc);
        pos_valeur_cid_abs.x--;pos_valeur_cid_abs.y--;
        if (!s.valeurs.empty())
                {
                Tmapiter i=s.valeurs.end();--i;
                float v=i->second;
                wxString chaine_valeur=wxString::Format(wxT("%4.0f"),v);
                wxPoint position_texte=pos_valeur_cid_abs;
                position_texte.x-=dc.GetTextExtent(chaine_valeur).GetWidth();
                position_texte.y-=dc.GetTextExtent(chaine_valeur).GetHeight();
                dc.DrawRectangle(pos_valeur_abs.x,pos_valeur_abs.y,pos_valeur_cid_abs.x-pos_valeur_abs.x,pos_valeur_cid_abs.y-pos_valeur_abs.y);
                dc.DrawText(chaine_valeur,position_texte.x,position_texte.y);
                }
        }
//---------------------------------------------------------------------------
        void Tgraphique::retrace(wxDC& dc,float correctif)
        {
        fixe_taille_police(dc,correctif);
        int nb_series=valeurs_stokees.size();
        if (!valeurs_seulement) efface(dc);
        trace_axe(true,true,dc);
        trace_axe(false,true,dc);
        trace_axe(true,false,dc);
        trace_axe(false,false,dc);
        //trace les cadres pour chaque srie de valeur
        if(cadres_visibles) for (int i=0;i<nb_series;++i) trace_boite(i,dc);
        if (nb_series>0)
                {
                for (int i=0;i<nb_series;i++)
                        {
                        trace_serie(i,dc);
                        }
                }
        }
//---------------------------------------------------------------------------
        void Tgraphique::fixe_parametres()
        {
        int repere1(cadres_visibles?2000:1000);
        parametres_internes.pixels=wxPoint(10000,10000);
        parametres_internes.origine_du_graphique=wxPoint(repere1,9000);
        parametres_internes.coin_superieur_gauche_du_graphique=wxPoint(repere1,2000);
        parametres_internes.coin_inferieur_droit_du_graphique=wxPoint(9600,9000);
        parametres_internes.position_titre_X=wxPoint(10000,9300);
        parametres_internes.position_titre_Y=wxPoint(repere1-300,1000);
        parametres_internes.position_cadre_serie_1=wxPoint(250,2000);
        parametres_internes.dimensions_cadres_series=wxPoint(1300,900);

        caracteristiques_axeX.titre=wxT("Abscisse");
        caracteristiques_axeX.unite=wxT("unit");
        caracteristiques_axeX.val_max_affichee=100;
        caracteristiques_axeX.val_min_affichee=0;
        caracteristiques_axeX.valeur_de_la_graduation()=10;
        caracteristiques_axeY=caracteristiques_axeX;
        caracteristiques_axeY.titre=wxT("Ordonne");
        }
//---------------------------------------------------------------------------
        bool Tgraphique::ajoute_une_serie(wxString titre,wxColor couleur)
        {Tserie une_serie;
        Traducteur tr;
        // les sries sont numrotes de 0  nbmax_series-1
        bool possible=int(valeurs_stokees.size())<nbmax_series;
        if (titre==wxT("")) titre=tr.trad(wxT("sans titre"));
        une_serie.Titre=titre;
        une_serie.couleur=couleur;
        if (possible)valeurs_stokees.push_back(une_serie);
        return possible;
        }
//---------------------------------------------------------------------------
        bool Tgraphique::change_aspect_serie(wxString titre,wxColor couleur,unsigned n)
        {bool possible=(n<valeurs_stokees.size());
        if (possible)
                {valeurs_stokees[n].Titre=titre;
                valeurs_stokees[n].couleur=couleur;
                }
        return possible;
        }
//---------------------------------------------------------------------------
        bool Tgraphique::supprime_serie(unsigned n)
        {bool possible=(n<valeurs_stokees.size());
        if (possible) valeurs_stokees.erase(valeurs_stokees.begin()+n);
        return possible;
        }
//---------------------------------------------------------------------------
        bool Tgraphique::supprime_toutes_les_series()
        {bool possible=valeurs_stokees.size()>0;
        while (valeurs_stokees.size())
                supprime_serie(0);
        return possible;
        }
//---------------------------------------------------------------------------
        bool Tgraphique::est_vide()
        {
        return valeurs_stokees.size()==0;
        }
//---------------------------------------------------------------------------
// point d'entre des valeurs dans une srie de valeurs
        bool Tgraphique::ajoute_valeur(int num_serie,int x,float y)
        {bool possible=(x<nbmax_points)&&(num_serie<int(valeurs_stokees.size()));
        if (possible) valeurs_stokees[num_serie].valeurs[x]=y;
        return possible;
        }
//---------------------------------------------------------------------------
        unsigned Tgraphique::nombre_series()
                {return valeurs_stokees.size();}
//---------------------------------------------------------------------------
//      Fin de l'objet Tgraphique
//---------------------------------------------------------------------------
