#ifndef CALCULE_H_INCLUDED
#define CALCULE_H_INCLUDED
/*
    Simulation panneaux photovoltaques. Copyright (C) 2013-2021
    Vial Jean-Luc Annecy
    Contact email: vial.frjl@free.fr

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#include "BoiteAOutils.h"
class Date_PV;
class Site_PV;
class Resultat_mesure;
class Param_orbite
{
    public:
    Param_orbite(double peri,double apo,double Periode_orb,double t_peri);
    //Distances en km temps en s
    double periapside,apoapside,T,t0;
    double excentricite();
    double demi_grand_axe();
};
    namespace Calculs
{
    const double PI  =3.141592653589793238462;
    const int heure_angle_zero=8568; //23 dec 2000 0h soit 357*24 h aprs le 1 janv 2000
    const double incl_ecliptique=-23.43;
    //const double incl_ecliptique=0.0; // pas de saisons
    const double jour_sideral=23.9344696; //en heures
    // le 4 janvier 2014  12 h GMT la Terre passe au priastre.
    // le t0 du systme de date dans PuissPPV est le 1/1/2000  0h
    // t_peri en s =((365*10+366*4+3)*24+12)*3600=442152000
    const Param_orbite Orb_Terre(147098074000.0,152097701000.0,31558201.344,442152000.0);
    //const Param_orbite Orb_Terre(152097701000.0,152097701000.0,31558201.344,0.0); //orbite circulaire
    vecteur Coordplanete(double t,Param_orbite Po);
    double Anex(double t,double t0,double T,double e);
    const int constante_solaire=1400; //Watts par mtres carrs
    double EnRadians(double EnDeg);
    double EnDegres(double EnRad);
    int modulo(int dividende, int diviseur);
    double modulo_double(double dividende, double diviseur);
    Resultat_mesure Pour_une_date(const Date_PV& d,const Site_PV& s);
    Resultat_mesure Pour_une_date_position_soleil(const Date_PV& d,const Site_PV& s);
    double Production_entre_deux_dates(const Date_PV& d1,const Date_PV& d2,const Site_PV& s);
    int Valeurs_entre_deux_dates(const Date_PV& d1,const Date_PV& d2,const Date_PV& inc);
    double angle_heure(double hh);
    double angle_rev(double hh);
    double opacite(double incidence);
};
#endif //CALCULE_H_INCLUDED
