#include "Calcule.h"
#include "Matrices.h"
#include "ProjetdeBase.h"
//---------------------------------------------------------------------------
// Classe contenant les paramètres orbitaux
//---------------------------------------------------------------------------
// Constructeur explicite
Param_orbite::Param_orbite(double peri,double apo,double Periode_orb,double t_peri)
        :periapside(peri),apoapside(apo),T(Periode_orb),t0(t_peri){};
// Excentricité (une orbite ponctuelle est prise comme ayant une excentricité nulle cad un cercle
double Param_orbite::excentricite()
{
    double resultat(apoapside+periapside);
    return(resultat?(apoapside-periapside)/resultat:0);
}
// Demi grand axe
double Param_orbite::demi_grand_axe() {return (apoapside+periapside)/2;}
//---------------------------------------------------------------------------
// Espace de nommage Calculs
//---------------------------------------------------------------------------
namespace Calculs
{
    // test
    void voit_vecteur(std::vector<double> v)
    {
        double t[3]={0.0};
        double prov(0);
        for (int i=0;i<3;i++)
        {
            prov=v[i];
            t[i]=v[i];
        }
        t[2]=0;
    }
    //-------------------------------------------------------------------------
    // Fonctions liées aux mouvements des astres
    //-------------------------------------------------------------------------
    // Résolution de l'équation de Kepler par itération
    // Le résultat est l'anomalie excentrique en fonction de t
    // to est le temps au passage du périastre
    // e est l'excentricité
    // M =2*Pi/T*(t-t0)
    // Équation de Kepler
    // La fonction Kepler est strictement croissante entre -M et 2Pi-M
    double Kepler(double v,double M,double e)
    {
    return v-M-e*sin(v);
    }
    //-------------------------------------------------------------------------
    // On commence par chercher la solution pour un M donné
    // le segment exploré et l'incrément sont un angle positif compris entre 0 et 2PI
    double cherche_inversion(double valeur,double segment,double M,double e)
    {
    double precisionresultat(0.00000001),k0(Kepler(valeur,M,e)),incr(segment/2.0),k(0),resultat(valeur);
    bool valide(Est_dans(segment,0.0,2.0*PI));
    if (valide&&k0) // si k0 vaut 0, la valeur d'entrée "valeur" était la solution
        {
          if(segment>precisionresultat) // La précision est suffisante, on renvera la valeur d'entrée "valeur"
            {
            k=Kepler(valeur+incr,M,e);
            resultat=((k*k0)<=0?valeur:valeur+incr);// si le signe a changé on revient à valeur, sinon on passe à valeur+incr
            resultat=cherche_inversion(resultat,incr,M,e); // recommence tant que la précision voulue n'est pas atteinte
            }
        }
    return resultat;
    }
    //-------------------------------------------------------------------------
    // On renvoie la valeur de l'anomalie excentrique
    double Anex(double t,double t0,double T,double e)
    {
    double M=modulo_double(2.0*PI*(t-t0)/T,2.0*PI);
    double resultat=cherche_inversion(0,2.0*PI,M,e);
    return resultat;
    }
    //-------------------------------------------------------------------------
    // Coordonnées cartésiennes en m (origine Soleil) d'une planète à l'instant t (en sec) sur son orbite
    // formules d'après http://www.astrosurf.com/nitschelm/mecanique.pdf
    vecteur Coordplanete(double t,Param_orbite Po)
    {
        vecteur Resultat;
        double v=Anex(t,Po.t0,Po.T,Po.excentricite());
        double e=Po.excentricite();
        double a=Po.demi_grand_axe();
        Resultat.real(a*(cos(v)-e));
        Resultat.imag(a*sqrt(1.0-e*e)*sin(v));
        // Changement de repère. Le nouvel axe des X est parallèle à la direction Soleil Terre
        // au moment heure_angle_zero cad au solstice d'hiver
        static double v0=Anex(heure_angle_zero*3600,Po.t0,Po.T,Po.excentricite()); // angle de correction
        // n'est calculé que lors du premier appel de la fonction
        vecteur rot_cor=std::polar(1.0,-v0);
        Resultat=Resultat*rot_cor;
        return Resultat;
    }
    //-------------------------------------------------------------------------
    // Fin fonctions astronomiques
    //-------------------------------------------------------------------------
    double EnRadians(double EnDeg)
    {
        return EnDeg/180.0*PI;
    }
    double EnDegres(double EnRad)
    {
        return EnRad/PI*180.0;
    }
    //-------------------------------------------------------------------------
    // version filtrée de la fonction standard acos
    double ArcCos(double v)
    {
        v=(v<-1.0?-1.0:v);
        v=(v> 1.0? 1.0:v);
        return acos(v);
    }
    //-------------------------------------------------------------------------
    // Modulo
    // la fonction standard % donne un résultat ... non standard pour les nombres négatifs
    int modulo(int dividende, int diviseur)
    {
        int resultat(dividende % diviseur);
        resultat=(resultat<0?resultat+diviseur:resultat);
        return resultat;
    }
    //-------------------------------------------------------------------------
    // Modulo_double
    // la fonction standard fmod donne un résultat ... non standard pour les nombres négatifs
    double modulo_double(double dividende, double diviseur)
    {
        double resultat(fmod(dividende,diviseur));
        resultat=(resultat<0?resultat+diviseur:resultat);
        return resultat;
    }
    /*
    //---------------------------------------------------------------------------
    // Calcule une date (orbite circulaire)
    //---------------------------------------------------------------------------
    Resultat_mesure Pour_une_date(Date_PV d,Site_PV s)
    {
        Resultat_mesure R;
        double dir_soleil=EnRadians(angle_rev(d.nombre_d_heures()));
        double incl(EnRadians(incl_ecliptique)),lat(EnRadians(-s.latitude())),azim(EnRadians(s.azimut())),pend(EnRadians(s.pendage()));
        double alpha=EnRadians(angle_heure(d.nombre_d_heures()));
        // Mte Coordonnées repère Terre fixe dans repère solaire écliptique
        // Mre Coordonnées repère Terre tournant (rotation) dans repère Terre fixe
        // Mle Coordonnées repère local (x=N y=E z=vert) dans repère Terre tournant
        Matrice
                Mte(3,cos(incl),0.0,-sin(incl),
                    0.0,1.0,0.0,
                    sin(incl),0.0,cos(incl)),
                Mre(3,cos(alpha),sin(alpha),0.0,
                    -sin(alpha),cos(alpha),0.0,
                    0.0,0.0,1.0),
                Mle(3,sin(lat),0.0,-cos(lat),
                    0.0,1.0,0.0,
                    cos(lat),0.0,sin(lat) );
        double resultat_puiss(0),resultat_incid(0);
        std::vector<double> soleil(3),panneau(3),verticale(3);
        soleil[0]=cos(dir_soleil);soleil[1]=sin(dir_soleil);soleil[2]=0.0;
        verticale[0]=0.0;verticale[1]=0.0;verticale[2]=1.0;
        panneau[0]=sin(pend)*cos(azim);
        panneau[1]=sin(pend)*sin(azim);
        panneau[2]=cos(pend);
        panneau=(Mte*(Mre*(Mle*panneau)));
        double soleil_leve(scalaire(soleil,(Mte*(Mre*(Mle*verticale)))));
        double incidence(180.0-EnDegres(ArcCos(soleil_leve)));
        resultat_incid=scalaire(soleil,panneau);
        resultat_puiss=scalaire(soleil,panneau)*s.surface()*s.Rendement()*constante_solaire/opacite(incidence);
        R.incidence((soleil_leve<=0)&&(resultat_incid<0)?EnDegres(ArcCos(-resultat_incid)):-1);
        R.puissance((soleil_leve<=0)&&(resultat_puiss<0)?(-resultat_puiss):0);
        return R;
    }
    */
    //---------------------------------------------------------------------------
    // Calcule une date (orbite elliptique)
    //---------------------------------------------------------------------------
        Resultat_mesure Puissance_ou_position(Date_PV d,const Site_PV& s,bool puissance_si_vrai)
    {
        Resultat_mesure R;
        vecteur pos_Terre; pos_Terre=Coordplanete(d.nombre_de_secondes(),Orb_Terre);
        Param_orbite P0(Orb_Terre);

        double incl(EnRadians(incl_ecliptique)),lat(EnRadians(-s.latitude())),azim(EnRadians(s.azimut())),pend(EnRadians(s.pendage()));
        double alpha=EnRadians(angle_heure(d.nombre_d_heures())-d.longitude());
        // Mte Coordonnées repère Terre fixe dans repère solaire écliptique
        // Mre Coordonnées repère Terre tournant (rotation) dans repère Terre fixe
        // Mle Coordonnées repère local (x=N y=E z=vert) dans repère Terre tournant
        Matrice
                Mte(3,cos(incl),0.0,-sin(incl),
                    0.0,1.0,0.0,
                    sin(incl),0.0,cos(incl)),
                Mre(3,cos(alpha),sin(alpha),0.0,
                    -sin(alpha),cos(alpha),0.0,
                    0.0,0.0,1.0),
                Mle(3,sin(lat),0.0,-cos(lat),
                    0.0,1.0,0.0,
                    cos(lat),0.0,sin(lat) );
        std::vector<double> soleil(3),panneau(3),verticale(3);
        soleil[0]=pos_Terre.real()/std::abs(pos_Terre);soleil[1]=pos_Terre.imag()/std::abs(pos_Terre);soleil[2]=0.0;
        verticale[0]=0.0;verticale[1]=0.0;verticale[2]=1.0;
        panneau[0]=sin(pend)*cos(azim);
        panneau[1]=sin(pend)*sin(azim);
        panneau[2]=cos(pend);
        //---------------------------------------------------------------------------
        if (puissance_si_vrai) // cas d'un calcul de puissance incidence
        {
            panneau=(Mte*(Mre*(Mle*panneau)));
            double resultat_puiss(0),resultat_incid(0);
            double soleil_leve(scalaire(soleil,(Mte*(Mre*(Mle*verticale)))));
            double incidence(180.0-EnDegres(ArcCos(soleil_leve)));
            double facteur_distance;
            facteur_distance=pow(std::abs(pos_Terre/P0.demi_grand_axe()),-2.0);
            resultat_incid=scalaire(soleil,panneau);
            resultat_puiss=facteur_distance*scalaire(soleil,panneau)*s.surface()*s.Rendement()*constante_solaire/opacite(incidence);
            R.incidence((soleil_leve<=0)&&(resultat_incid<0)?EnDegres(ArcCos(-resultat_incid)):-1);
            R.puissance((soleil_leve<=0)&&(resultat_puiss<0)?(-resultat_puiss):0);
        }
        //---------------------------------------------------------------------------
        else // Cas du calcul des projections du soleil sur le panneau
        {
            std::vector<double> panneauX(3),panneauY(3),Ombre(3);
            if (pend==0)
            {
            panneauX[0]=0;panneauX[1]=1;panneauX[2]=0;// Axe x dirigé vers l'Ouest
            panneauY[0]=1;panneauY[1]=0;panneauY[2]=0;// Axe Y pour les analemmes dans la direction SN
            }
            else
            {
            panneauX=prod_vect(panneau,verticale);panneauX=panneauX/(norme(panneauX)+0.000001);
            panneauY=prod_vect(panneauX,panneau); panneauY=panneauY/(norme(panneauY)+0.000001);
            }
        panneauX=(Mte*(Mre*(Mle*panneauX)));
        panneauY=(Mte*(Mre*(Mle*panneauY)));
        panneau=(Mte*(Mre*(Mle*panneau)));
        Ombre=prod_vect(panneau,prod_vect(panneau,soleil))/(cos(scalaire(soleil,panneau))+0.000001);
        double soleil_leve(scalaire(soleil,(Mte*(Mre*(Mle*verticale)))));
        double panneau_eclaire(scalaire (soleil,panneau));
        double resultat_x=scalaire(Ombre,panneauX)*(100); // coordonnée X de la projection sur le panneau
        double resultat_y=scalaire(Ombre,panneauY)*(100);
        R.x((soleil_leve<=0)&&(panneau_eclaire<0)?resultat_x:0);
        R.y((soleil_leve<=0)&&(panneau_eclaire<0)?(resultat_y):0);
        }
        return R;
    }
    //---------------------------------------------------------------------------
    // Calcule l'incidence et la puissance pour une date d
    //---------------------------------------------------------------------------
    Resultat_mesure Pour_une_date(const Date_PV& d,const Site_PV& s)
    {
        return Puissance_ou_position(d,s,true);
    }
    //---------------------------------------------------------------------------
    // Calcule de la position de l'ombre du soleil dans le plan du panneau (pour analemme)
    //---------------------------------------------------------------------------
    Resultat_mesure Pour_une_date_position_soleil(const Date_PV& d,const Site_PV& s)
    {
        return Puissance_ou_position(d,s,false);
    }
    //---------------------------------------------------------------------------
    // Production entre deux dates d1 et d1+d2 avec un incrément d'une heure
    //---------------------------------------------------------------------------
    double Production_entre_deux_dates(const Date_PV& d1,const Date_PV& d2,const Site_PV& s)
    {
        double cumul(0);
        Date_PV inc(0,1,0,0,0);
        for (Date_PV i(d1);i<=(d1+d2);i=i+inc)
            cumul+=Pour_une_date(i,s).puissance();
        return cumul;
    }
    //---------------------------------------------------------------------------
    // Nombre de valeurs entre deux dates d1 et d1+d2 avec un incrément inc
    // Si inc est nul, retourne 0
    //---------------------------------------------------------------------------
    int Valeurs_entre_deux_dates(const Date_PV& d1,const Date_PV& d2,const Date_PV& inc)
    {
        int resultat(0);
        //if (inc.zero()) inc=Date_PV(1,0,0,0,0);
        if (!inc.zero())
            for (Date_PV i(d1);i<=(d1+d2);i=i+inc)
                resultat++;
        return resultat;
    }
    //---------------------------------------------------------------------------
    // Angle de rotation en degrés 0deg à 0 h à 360 en un jour sidéral
    // calcul à partir de la hh ième heure depuis le début de l'année 2000
    // angle à 0 le 23 12 2000 à 0 h GMT(=angle_heure_zero) (après 357 jours de 2000) à la longitude 0
    double angle_heure(double hh)
    {
        //double jour_sideral(24.0*Orb_Terre.T/(Orb_Terre.T+24.0*3600));
        double resultat=(modulo_double(hh-heure_angle_zero,jour_sideral)/jour_sideral*360.0);
        return resultat;
    }
    //---------------------------------------------------------------------------
    // angle de révolution à la hh heure suivant le début de l'année
    double angle_rev(double hh)
    {
        double jj=hh/24.0;
        return modulo_double(jj-354.0,365.0)/365.0*360;
    }
    //---------------------------------------------------------------------------
    // rapport constante solaire espace/au sol tenant compte de l'absorption par l'atmosphère
    // incidence en degrés
    // valeur approchée tirée du site ... à retrouver
    double opacite(double incidence)
    {
        double resultat,a(0.0004857),b(-0.0182857) ,c(1.4);
        incidence=abs(incidence);
        resultat=a*incidence*incidence+b*incidence+c;
        resultat=(incidence<20.0?1.229:resultat);
        return resultat;
    }
}
//---------------------------------------------------------------------------
// Fin calculs
//---------------------------------------------------------------------------
