#include "BoiteAOutils.h"
#include <wx/intl.h>
#include <wx/tooltip.h>
//---------------------------------------------------------------------------
vecteur fait_vecteur(wxPoint p){return vecteur(p.x,p.y);}
//---------------------------------------------------------------------------
// mulation de la fonction RandomRange
// retourne un entier dans l'intervalle [low, High[
int RandomRange_bis(int low,int high)
{
        if (high <low) high=low;
        return (rand() % (high-low))+low;
}
//---------------------------------------------------------------------------
//      Implmentation de l'objet Traducteur
//---------------------------------------------------------------------------
        void Traducteur::ajoute_une_entree(wxString Tf,wxString Ta)
{
        Dictionnaire di;
        di.insert(std::make_pair(ang,Ta));
        textes.insert(std::make_pair(Tf,di));
}
//---------------------------------------------------------------------------
        Traducteur::Traducteur()
{
        ajoute_une_entree(wxT(" active"),wxT(" enabled"));
        ajoute_une_entree(wxT(" inactive"),wxT(" disabled"));
        ajoute_une_entree(wxT("&Rubriques d'aide"),wxT("&Help topics"));
        ajoute_une_entree(wxT("10 octobre 2013 / 31 juillet 2022"),wxT("10 Oct 2013 / 31 Jul. 2022"));
        ajoute_une_entree(wxT("a"),wxT("y"));
        ajoute_une_entree(wxT("Abaque pour analemme"),wxT("table for analemma"));
        ajoute_une_entree(wxT("A propos"),wxT("About"));
        ajoute_une_entree(wxT("Affiche le rapport"),wxT("Show result"));
        ajoute_une_entree(wxT("Aide"),wxT("Help"));
        ajoute_une_entree(wxT("Anne"),wxT("Year"));
        ajoute_une_entree(wxT("Anne modifie"),wxT("Year changed"));
        ajoute_une_entree(wxT("Anne non valide"),wxT("Invalid year"));
        ajoute_une_entree(wxT("Annule"),wxT("Cancel"));
        ajoute_une_entree(wxT("Avertissement"),wxT("Disclaimer"));
        ajoute_une_entree(wxT("Azimut modifi"),wxT("Azimut changed"));
        ajoute_une_entree(wxT("Azimut non valide"),wxT("Invalid azimut"));
        ajoute_une_entree(wxT("Dbut de mesure"),wxT("Starting hour"));
        ajoute_une_entree(wxT("Dbut rapport"),wxT("Beginning"));
        ajoute_une_entree(wxT("Dcalage horaire modif"),wxT("Hour gap changed"));
        ajoute_une_entree(wxT("Dcalage non valide"),wxT("Invalid hour gap"));
        ajoute_une_entree(wxT("Dcalage"),wxT("Hour gap"));
        ajoute_une_entree(wxT("DisclaimimageFra.png"),wxT("DisclaimimageEng.png"));
        ajoute_une_entree(wxT("Mauvais format de fichier ou donnes corrompues"),wxT("Bad format or corrupted file"));
        ajoute_une_entree(wxT("Dure de mesure"),wxT("Measurement length"));
        ajoute_une_entree(wxT("Dure rapport"),wxT("Length"));
        ajoute_une_entree(wxT("Dcalage horaire entre l'heure GMT et l'heure lgale (en heures)"),wxT("Time difference between GMT and local time (in hours)"));
        ajoute_une_entree(wxT("Enregistrer"),wxT("Save"));
        ajoute_une_entree(wxT("Enregistrer sous..."),wxT("Save as ..."));
        ajoute_une_entree(wxT("Fermer"),wxT("Close"));
        ajoute_une_entree(wxT("Fichier d'aide non trouv\n"),wxT("Help file not found\n"));
        ajoute_une_entree(wxT("Fichiers"),wxT("Files"));
        ajoute_une_entree(wxT("Fichier absent"),wxT("Missing File"));
        ajoute_une_entree(wxT("Graphique des productions"),wxT("Production graph"));
        ajoute_une_entree(wxT("Heure d't modifie"),wxT("Daylight saving time changed"));
        ajoute_une_entree(wxT("Heure d't"),wxT("Daylight saving time"));
        ajoute_une_entree(wxT("Heure modifie"),wxT("Hour changed"));
        ajoute_une_entree(wxT("Heure non valide"),wxT("Invalid hour"));
        ajoute_une_entree(wxT("heure"),wxT("hour"));
        ajoute_une_entree(wxT("Impression"),wxT("Print"));
        ajoute_une_entree(wxT("Incidence"),wxT("Incidence"));
        ajoute_une_entree(wxT("Incrment"),wxT("Increment"));
        ajoute_une_entree(wxT("j"),wxT("d"));
        ajoute_une_entree(wxT("Jour modifi"),wxT("Day changed"));
        ajoute_une_entree(wxT("Jour non valide"),wxT("Invalid day"));
        ajoute_une_entree(wxT("jour"),wxT("day"));
        ajoute_une_entree(wxT("Langage"),wxT("Language"));
        ajoute_une_entree(wxT("Latitude modifie"),wxT("Latitude changed"));
        ajoute_une_entree(wxT("Longitude modifie"),wxT("Longitude changed"));
        ajoute_une_entree(wxT("Latitude non valide"),wxT("Invalid latitude"));
        ajoute_une_entree(wxT("Mois modifi"),wxT("Month changed"));
        ajoute_une_entree(wxT("Mois non valide"),wxT("Invalid month"));
        ajoute_une_entree(wxT("mois"),wxT("month"));
        ajoute_une_entree(wxT("Nature de panneau modifie"),wxT("Type of panel has changed"));
        ajoute_une_entree(wxT("Outils"),wxT("Tools"));
        ajoute_une_entree(wxT("Ouvrir"),wxT("Open"));
        ajoute_une_entree(wxT("Paramtres"),wxT("Parameters"));
        ajoute_une_entree(wxT("par graduation"),wxT("per graduation"));
        ajoute_une_entree(wxT("Pas d'erreur"),wxT("It's Ok"));
        ajoute_une_entree(wxT("Pendage modifi"),wxT("Dip changed"));
        ajoute_une_entree(wxT("Pendage non valide"),wxT("Invalid dip"));
        ajoute_une_entree(wxT("Pendage"),wxT("Dip"));
        ajoute_une_entree(wxT("Prvisualisation"),wxT("Preview"));
        ajoute_une_entree(wxT("Puissance"),wxT("Power"));
        ajoute_une_entree(wxT("Production sur la priode"),wxT("Yield over this period"));
        ajoute_une_entree(wxT("puissppvfrahlp"),wxT("puissppvenghlp"));
        ajoute_une_entree(wxT("Quitter"),wxT("Exit"));
        ajoute_une_entree(wxT("Rapport"),wxT("Report"));
        ajoute_une_entree(wxT("Renomme"),wxT("Rename"));
        ajoute_une_entree(wxT("Sans titre"),wxT("untitled"));
        ajoute_une_entree(wxT("Sauve le fichier en cours"),wxT("Save the current file"));
        ajoute_une_entree(wxT("Simulation panneaux photovoltaques"),wxT("Photovoltaic panels simulation"));
        ajoute_une_entree(wxT("Supprime"),wxT("Delete"));
        ajoute_une_entree(wxT("Surface modifie"),wxT("Surface changed"));
        ajoute_une_entree(wxT("Surface non valide"),wxT("Invalid surface"));
        ajoute_une_entree(wxT("Tous fichiers"),wxT("All files"));
        ajoute_une_entree(wxT("Tu.a"),wxT("a.u"));
        ajoute_une_entree(wxT("Type de panneaux : "),wxT("Type of panel : "));
        ajoute_une_entree(wxT("Valeur modifie"),wxT("Altered value"));
}
//---------------------------------------------------------------------------
        langues& Traducteur::fixe_langue()
{
        static langues Langue_active=fr;
        return Langue_active;
}
//---------------------------------------------------------------------------
        //fixe la langue de dpart
        void Traducteur::langue_demarrage()
{
        bool est_francais(true);
#if defined(__WXMSW__)
        // 1036 pour le franais
        est_francais=(GetSystemDefaultLangID()==1036);
#elif defined(__UNIX__)
        wxString lg;
        wxGetEnv(wxT("LANG"),&lg);
        lg=lg.Left(2);
        est_francais=(lg==wxT("fr"));
#endif
        if (est_francais) fixe_langue()=fr;
                else fixe_langue()=ang;
}
//---------------------------------------------------------------------------
        wxString Traducteur::trad(wxString T)
{
        if (textes.find(T)==textes.end()) return T;
        langues L=fixe_langue();
        if (L==fr) return T;
        return textes[T][L];
}
//---------------------------------------------------------------------------
        wxString Traducteur::trad_tout(wxString T)
{
        wxString traduction=T;
        for(std::map<wxString,Dictionnaire>::iterator i=textes.begin();i!=textes.end();++i)
                if (T==i->first) traduction=trad(T);
                else  for(langues j=suivant(fr);j<=ang;j=suivant(j))
                        if (T==i->second[j])
                                traduction=trad(i->first);
        return traduction;
}
//---------------------------------------------------------------------------
//      Fin de l'objet Traducteur
//---------------------------------------------------------------------------
wxColor& Couleur_Fenetres_defaut()
{
        static wxColor couleur_fen=wxSystemSettings::GetColour(wxSYS_COLOUR_ACTIVEBORDER);
        return couleur_fen;
}
wxRect& Taille_Fenetres_defaut()
{
        //Fixe une position et une taille initiale
        static wxRect taille_fen(250,50,600,600);
        return taille_fen;
}
wxPoint FaitReelle_Pos(wxPoint posvirtuelle,wxWindow* fen)
{
        int X= fen->GetClientSize().GetWidth();
        int Y= fen->GetClientSize().GetHeight();
        return wxPoint(int(posvirtuelle.x*X/1000.0),int(posvirtuelle.y*Y/1000.0));
}
wxSize FaitReelle_Taille(wxSize Sizevirtuelle,wxWindow* fen)
{
        int X= fen->GetClientSize().GetWidth();
        int Y= fen->GetClientSize().GetHeight();
        Sizevirtuelle.Scale(float(X/1000.0),float(Y/1000.0));
        return Sizevirtuelle;
}
void Ajuste_taille_et_pos(wxPoint pos,wxSize taille,wxWindow* fen_mere,wxWindow* fen_fille)
{
        pos=FaitReelle_Pos(pos,fen_mere);
        taille=FaitReelle_Taille(taille,fen_mere);
        fen_fille->SetSize(wxRect(pos,taille));
}
void FixeFontEtTaille(wxWindow* fen)
{
        wxFont Police(fen->GetFont());
        Police.SetPointSize(8);
        fen->SetFont(Police);
}
//---------------------------------------------------------------------------
        PalettePerso::PalettePerso():clDkGray(128,128,128),clCream(255,251,240),clAqua(0,255,255),clLtGray(192,192,192),clRed(255,0,0),clBlack(0,0,0),
                                    clYellow(255,255,0),clLime(0,255,0)
        {
        }
//---------------------------------------------------------------------------
void RenommeEnfants(wxWindow* Sujet)
{
        Traducteur tr;
        wxToolTip* tt;
        wxFrame* p_frame;
        // Sous Windows Setlabel ajuste correctement le titre des "Frames' mais pas sous Linux
        // d'o la ncessit de distinguer WxXindow et wxFrame
        p_frame=dynamic_cast<wxFrame*>(Sujet);
        if (p_frame!=NULL) // C'est une wxWFrame
            p_frame->SetTitle(tr.trad_tout(p_frame->GetTitle()));
        else // C'est une simple wxWindow
            Sujet->SetLabel(tr.trad_tout(Sujet->GetLabel()));
        tt=Sujet->GetToolTip();
        if (tt!=NULL)
            Sujet->SetToolTip(tr.trad_tout(tt->GetTip()));
        // Mme chose pour les enfants
        wxWindowList list;
        list=Sujet->GetChildren();
        wxWindowList::compatibility_iterator node;
        node=list.GetFirst();
        for (node = list.GetFirst(); node; node = node->GetNext() )
            {
            wxWindow *current = node->GetData();
            RenommeEnfants(current);
            }
}
//---------------------------------------------------------------------------
//      Ajuste la taille de la police  celle de la fentre courante
        void fixe_taille_police(wxDC& dc,float correctif)
        {
        // Correctif introduit pour tenir compte du problme avec la dfinition de l'impression sous Linux
        // en mode impression mais pas en preview. Je n'ai pas trouv mieux pour le moment
        float hauteur_police=8;
        float hauteur_ecran=dc.GetSize().GetHeight();
        float largeur_ecran=dc.GetSize().GetWidth();
        float def_ecran=dc.GetPPI().GetHeight();
        if (hauteur_ecran>largeur_ecran)hauteur_ecran=largeur_ecran; //ne tient compte que de la plus petite dimension
        hauteur_police*=hauteur_ecran/(def_ecran*2*correctif);
        hauteur_police=(hauteur_police<3?3:hauteur_police);
        dc.SetFont(wxFont(int(hauteur_police),wxFONTFAMILY_DEFAULT,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false));
        }
    //---------------------------------------------------------------------------
wxSize Taille_moyenne_police(wxDC* dc)
{
    wxString Sample(wxT("QQQMMMWWWChiffres Lettres AQlWX0123456"));
    wxSize taille_texte=dc->GetTextExtent(Sample);
    taille_texte.x/=Sample.length();
    return taille_texte;
}
//---------------------------------------------------------------------------
void Base_Tabule_ecrit(wxDC* dc,wxString st,wxPoint pos)
{   // crit st  la position pos (x en nombre de caractre et y nombre de lignes de texte)
    // La taille de la police n'est recalcule qu'en cas de changement de dc
    static wxDC* dcanc(dc);
    static wxSize taille_texte=Taille_moyenne_police(dc);
    if (dc!=dcanc)
    {
        dcanc=dc;
        taille_texte=Taille_moyenne_police(dc); // changement de dc, recalcule de taille_texte
    }
    dc->DrawText(st,pos.x*taille_texte.GetWidth(),pos.y*taille_texte.GetHeight());
}
