#ifndef MAINFRAME_H_INCLUDED
#define MAINFRAME_H_INCLUDED
/*
    Aliments permet une représentation graphique de l'équilibre GPL d'une ration alimentaire.
    Copyright (C) 1994 (version Dos) 2009-2021 Vial Jean-Luc Annecy
    Contact email: vial.frjl@free.fr

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

// On ajoute les headers "basiques" de wxWidgets
#include <wx/wx.h>
#include "BoiteAOutils.h"
#include "Dessin.h"
#include <wx/html/helpctrl.h>

class Canvas;
class APropos;
class BilanRepas;
class FicheEdition;

//---------------------------------------------------------------------------
// Objets propres au programme Aliments
//---------------------------------------------------------------------------

enum groupe_d_aliment {al_protidiques,laitages,feculents,corps_gras,crudites,cuidites,sucres,tous_les_groupes};

class Tgroupes
{
        std::map<groupe_d_aliment,wxString> liste_noms;
        void ajoute_un_nom_de_groupe(groupe_d_aliment gr,wxString ngr);
public:
        Tgroupes();
        wxString nom(groupe_d_aliment gr);
};
class TAliment_contenu
{
        groupe_d_aliment groupe;
        float G,P,L,Q;

public:
        TAliment_contenu();
        TAliment_contenu(const TAliment_contenu &al);
        TAliment_contenu(float gl,float pr,float li,float Qu,groupe_d_aliment gr);
        TAliment_contenu& operator=(const TAliment_contenu &al);
        float& Gval();
        float& Pval();
        float& Lval();
        float& Qval();
        groupe_d_aliment& groupeval();
};
typedef std::map<wxString,TAliment_contenu> TTableau_aliments;
typedef std::pair<wxString,TAliment_contenu> TAliment_nomme;

class TAliment
{
        float gpl_pourcent(float coeff, float gpl);
public:
        TAliment_nomme Aliment_nomme;
        TAliment();
        TAliment(const TAliment &al);
        TAliment(wxString Nom,float gl,float pr,float li,float Qu,groupe_d_aliment gr);
        TAliment(wxString Nom,TAliment_contenu al);
        explicit TAliment(const TAliment_nomme& aln);
        wxString& unite_energie();
        wxString& pourcent_en();
        float& g();
        float& p();
        float& l();
        float& Qte();
        float g_pourcent();
        float l_pourcent();
        float p_pourcent();
        float energie();
        float poids_sec();
        wxString& nom();
        groupe_d_aliment& groupe();
        void ajuste_a_nouvelle_quantite(float nouv);
        TAliment operator+(const TAliment &al);
        TAliment operator-(const TAliment &al);
        TAliment& operator=(const TAliment &al);
};
        typedef TTableau_aliments::iterator Tmapiter;
        TAliment Calcule_bilan(TTableau_aliments &T,const groupe_d_aliment &gr);
//---------------------------------------------------------------------------
// variables globales
//---------------------------------------------------------------------------
TTableau_aliments& Aliments_disponibles();
TTableau_aliments& Menu_en_cours();
TAliment& al_cible_defaut();
TAliment& al_courant();
TAliment& al_repas_en_cours();
TAliment& al_repas();
TAliment& al_curseur();
TAliment& al_cible();

//---------------------------------------------------------------------------
// Définition de la classe "MainFrame"
class MainFrame : public wxFrame
{
public:
// Le constructeur
MainFrame();
// Le destructeur
~MainFrame();
        bool init_done;
        bool item_menu_change;
        bool taille_modifiee;
        // Aide
        wxHtmlHelpController* helpController;

        // Contrôles
        static const long idBoutPlus;
        wxButton* BoutPlus;
        void OnBoutPlus(wxCommandEvent& event);
        static const long idBoutMoins;
        wxButton* BoutMoins;
        void OnBoutMoins(wxCommandEvent& event);

        static const long idChoisir;
        wxButton* Choisir;
        void OnChoisir(wxCommandEvent& event);
        static const long idModif;
        wxButton* Modif;
        void OnModif(wxCommandEvent& event);

        static const long idPurge;
        wxButton* Purge;
        void OnPurge(wxCommandEvent& event);

        static const long idAjuste;
        wxButton* Ajuste;
        void OnAjuste(wxCommandEvent& event);
        // Choix incrément dans wxPanel à cause du bug de lecture de la souris dans les radiobox insérées directement
        wxPanel* BoutonsRadio;
        wxRadioBox* Increment;
        static const long idIncrement;
        void OnIncrement(wxCommandEvent& event);

        // Canvas de dessin
        static const long idCanvas1;
        Tgraphique* Canvas1;

        // Combobox Choix aliments
        static const long idBoitChoixAlim;
        void OnBoitChoixAlim(wxCommandEvent& event);
        void OnBoitChoixAlim_enter(wxCommandEvent& event);
        wxComboBox* BoitChoixAlim;

        // Boite texte affichage saisie valeur énergétique
        static const long idAjusteValEn;
        void OnAjusteValEn(wxCommandEvent& event);
        wxTextCtrl* AjusteValEn;

        // Progress bar quantité
        static const long idPoidsRepas;
        wxGauge* PoidsRepas;

        static const long idLabelUnite;
        wxStaticText* LabelUnite;

        wxString NomFichier;
        // Fonctions publiques

private:
        // Noms par défaut
        wxString InitDir;
        wxString DonneesDir;
        wxString DonneesVarDir;
        wxString NomComplet();
        void Met_a_jour_BoitChoixAlim();

        bool charge_fichier(wxString nomfich);
        bool charge_fichier_ancien_format(wxString nomfich);
        void FileOpen(wxCommandEvent& event);
        void FilesOpen(wxCommandEvent& event);
        void FileSave(wxCommandEvent& event);
        void FileSaveAs(wxCommandEvent& event);

        void OnImprime(wxCommandEvent& event);
        void OnQuit(wxCommandEvent& event);
        void OnClose(wxCloseEvent& event);
        void OnBilanRepas(wxCommandEvent& event);
        void OnFicheEdition(wxCommandEvent& event);
        void OnRepertoireAliments(wxCommandEvent& event);
        void OnMenuUnite(wxCommandEvent& event);
        void OnMenuPourcentEn(wxCommandEvent& event);
        void OnDisclaimer(wxCommandEvent& event);
        void OnAbout(wxCommandEvent& event);
        void OnHelp(wxCommandEvent& event);
        void Onfr(wxCommandEvent& event);
        void Onen(wxCommandEvent& event);
        void Ones(wxCommandEvent& event);
        void OnCloseAbout(wxCommandEvent& event);
        void OnPaint(wxPaintEvent& event);
        void AjouteEnleve(const wxChar &Key);
        void verifie_aliment_cible();
        void Choisi_Modif(bool cas_choisi);
        void rafraichit();
        void OnSize(wxSizeEvent& event);

        // Identificateurs
        static const long idBoutonsRadio;
        static const long idMenuQuit;
        static const long idMenuImprime;
        static const long idMenuBilanRepas;
        static const long idMenuFicheEdition;
        static const long idMenuRepertoireAliments;
        static const long idMenuUnite;
        static const long idMenuPourcentEn;
        static const long idMenuDisclaimer;
        static const long idMenuAbout;
        static const long idMenuHelp;
        static const long idMenufr;
        static const long idMenuen;
        static const long idMenues;
        static const long idMenuToolbar1;
        static const long ID_DIALOGS_FILES_OPEN;
        static const long ID_DIALOGS_FILE_SAVE;
        static const long ID_DIALOGS_FILE_SAVE_AS;
        static const long idaproposinst;
        static const long idBilanRepas;
        static const long idFicheEdition;
        static const long idOnPaint;

        APropos* AProposinst;
        BilanRepas* BilanRepasinst;
        FicheEdition* FicheEditioninst;
        wxPrintData *g_printData;
        DECLARE_EVENT_TABLE()
};
//---------------------------------------------------------------------------
        // Variable globale retournant un pointeur vers la fenêtre principale
        MainFrame*& firstwin();
//---------------------------------------------------------------------------
#endif // MAINFRAME_H_INCLUDED
