#include "ProjetdeBase.h"
#include "Dessin.h"
#include "APropos.h"
#include "BilanRepas.h"
#include "FicheEdition.h"

#include "../Icones/aliments16.xpm"
#include "../Icones/balance16.xpm"
#include "../Icones/livre16.xpm"
#include "../Icones/impr16.xpm"
#include "../Icones/sortie16.xpm"
#include "../Icones/files16.xpm"
#include "../Icones/fr16.xpm"
#include "../Icones/eng16.xpm"
#include "../Icones/es16.xpm"
#include "../Icones/help16.xpm"
#include "../Icones/save16.xpm"

#include <wx/file.h>
#include <wx/filename.h>
#include <wx/stdpaths.h>
#include <wx/splash.h>
#include "wx/filesys.h"
#include "wx/fs_zip.h"

//---------------------------------------------------------------------------
//Constantes de paramétrages
const size_t LMAX_NOM_ALIMENT(20);
const double COEF_418(4.18);
const int MAX_GAUGE(5000);
//---------------------------------------------------------------------------

const wxString nomincr[]={wxT(" 5 g"),wxT("10 g"),wxT("50 g")};
//---------------------------------------------------------------------------
//Variables utilisées pour tests
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
// variables globales
//---------------------------------------------------------------------------
MainFrame*& firstwin()
{
    static MainFrame* fen=0;
    return fen;
}
TTableau_aliments& Aliments_disponibles()
{
        static TTableau_aliments tablal;
        return tablal;
}
TTableau_aliments& Menu_en_cours()
{
        static TTableau_aliments tablal;
        return tablal;
}
TAliment& al_cible_defaut()
{
    static TAliment al(wxT("Equilibre"),61.4,20.4,18.2,100,laitages);
    return al;
}
TAliment& al_courant()
{
    static TAliment al;
    return al;
}
TAliment& al_repas_en_cours()
{
    static TAliment al;
    return al;
}
TAliment& al_repas()
{
    static TAliment al;
    return al;
}
TAliment& al_curseur()
{
    static TAliment al;
    return al;
}
TAliment& al_cible()
{
    static TAliment al;
    return al;
}
//---------------------------------------------------------------------------
void liste_par_defaut()
{
    Aliments_disponibles().insert(al_cible_defaut().Aliment_nomme);
    TAliment al=TAliment(wxT("glu"),10,0,0,100,laitages);
    Aliments_disponibles().insert(al.Aliment_nomme);
    al=TAliment(wxT("pro"),0,10,0,100,laitages);
    Aliments_disponibles().insert(al.Aliment_nomme);
    al=TAliment(wxT("lip"),0,0,10,100,laitages);
    Aliments_disponibles().insert(al.Aliment_nomme);
}
//---------------------------------------------------------------------------
void clone_liste(TTableau_aliments& de,TTableau_aliments& vers)
{
    if (!de.empty())
        {
            vers.clear();
            for(Tmapiter i=de.begin();i!=de.end();++i)
                vers.insert(*i);
        }
}
//---------------------------------------------------------------------------
// Gestion des impressions
//---------------------------------------------------------------------------
// Déclaration du Printout utilisé
class GraphPrintout: public BasePrintout
{
 public:
  GraphPrintout(const wxChar *title = wxT("My printout"),Tgraphique* canva=NULL):BasePrintout(title),ca(canva) {}
  Tgraphique* ca;
  bool OnPrintPage(int page);
  bool HasPage(int page);
  //bool OnBeginDocument(int startPage, int endPage);
  void GetPageInfo(int *minPage, int *maxPage, int *selPageFrom, int *selPageTo);
};
//---------------------------------------------------------------------------
bool GraphPrintout::HasPage(int page)
{   // HasPage n'est pas appelé avant OnPrintPage pour la première page affichée
    // Mais est appelée d'abord pour toutes les autres pages.
    return page==1;
}
//---------------------------------------------------------------------------
void GraphPrintout::GetPageInfo(int *minPage, int *maxPage, int *selPageFrom, int *selPageTo)
{
    (*minPage)=1;
    (*maxPage)=1;
}
//---------------------------------------------------------------------------
bool GraphPrintout::OnPrintPage(int page)
{
    wxDC *dc = GetDC();
    if (dc)
    {
        ca->EstImpression=true;
        ca->Dessine_ardoise(*dc,correctif_preview());
        ca->EstImpression=false;
        dc->DrawText(wxString::Format(wxT("Page %4d"),page),10,10);
        return true;
    }
    else
        return false;
}
//-------------------------------------------------------------------------
//      Fin Objet Print out pour l'impression
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
//      Initialisation de la classe Tgroupes
//---------------------------------------------------------------------------
        void Tgroupes::ajoute_un_nom_de_groupe(groupe_d_aliment gr,wxString ngr)
{
        liste_noms.insert(std::make_pair(gr,ngr));
}
//---------------------------------------------------------------------------
        Tgroupes::Tgroupes()
{
        Traducteur tr;
        ajoute_un_nom_de_groupe(al_protidiques,tr.trad(wxT("aliments protidiques")));
        ajoute_un_nom_de_groupe(laitages,tr.trad(wxT("laitages")));
        ajoute_un_nom_de_groupe(feculents,tr.trad(wxT("féculents")));
        ajoute_un_nom_de_groupe(corps_gras,tr.trad(wxT("corps gras")));
        ajoute_un_nom_de_groupe(crudites,tr.trad(wxT("crudités")));
        ajoute_un_nom_de_groupe(cuidites,tr.trad(wxT("cuidités")));
        ajoute_un_nom_de_groupe(sucres,tr.trad(wxT("sucres")));
        ajoute_un_nom_de_groupe(tous_les_groupes,tr.trad(wxT("Tous les groupes")));
}
//---------------------------------------------------------------------------
        wxString Tgroupes::nom(groupe_d_aliment gr)
{
        return liste_noms[gr];
}
//---------------------------------------------------------------------------
//      Fin de l'objet Tgroupes
//---------------------------------------------------------------------------
//      Implémentation de l'objet TAliment_contenu
//---------------------------------------------------------------------------
//      Constructeur par défaut
        TAliment_contenu::TAliment_contenu():groupe(tous_les_groupes),G(0),P(0),L(0),Q(0)
        {
        }
//---------------------------------------------------------------------------
//      Constructeur explicite
        TAliment_contenu::TAliment_contenu(float gl,float pr,float li,float Qu,groupe_d_aliment gr)
                :groupe(gr), G(gl), P(pr), L(li), Q(Qu)
        {}
//---------------------------------------------------------------------------
//      Constructeur de copie
        TAliment_contenu::TAliment_contenu(const TAliment_contenu &al)
        {
                G=al.G;
                P=al.P;
                L=al.L;
                Q=al.Q;
                groupe=al.groupe;
        }
//---------------------------------------------------------------------------
        TAliment_contenu& TAliment_contenu::operator=(const TAliment_contenu &al)
        {
                if (this!= &al)
                {
                    G=al.G;
                    P=al.P;
                    L=al.L;
                    Q=al.Q;
                    groupe=al.groupe;
                }
                return *this;
        }
//---------------------------------------------------------------------------
        float& TAliment_contenu::Gval()
        {return G;}
//---------------------------------------------------------------------------
        float& TAliment_contenu::Pval()
        {return P;}
//---------------------------------------------------------------------------
        float& TAliment_contenu::Lval()
        {return L;}
//---------------------------------------------------------------------------
        float& TAliment_contenu::Qval()
        {return Q;}
//---------------------------------------------------------------------------
        groupe_d_aliment& TAliment_contenu::groupeval()
        {return groupe;}
//---------------------------------------------------------------------------
//      Implémentation de l'objet TAliment
//---------------------------------------------------------------------------
//      Constructeur par défaut
        TAliment::TAliment()
        {
        Aliment_nomme.first=wxT("Inconnu");
        };
//---------------------------------------------------------------------------
//      Constructeur de copie
        TAliment::TAliment(const TAliment &al):Aliment_nomme(al.Aliment_nomme)
        {
        }
//---------------------------------------------------------------------------
//      Constructeur explicite
        TAliment::TAliment(wxString Nom,float gl,float pr,float li,float Qu, groupe_d_aliment gr)
        {
        Aliment_nomme.first=Nom;
        TAliment_contenu al(gl,pr,li,Qu,gr);
        Aliment_nomme.second=al;
        }
//---------------------------------------------------------------------------
//      Constructeur explicite à partir de d'une paire TAliment_nommé
         TAliment::TAliment(const TAliment_nomme& aln):Aliment_nomme(aln)
        {
        }
//---------------------------------------------------------------------------
//      Constructeur explicite à partir de TAliment_contenu
        TAliment::TAliment(wxString Nom,TAliment_contenu al)
        {
        Aliment_nomme.first=Nom;
        Aliment_nomme.second=al;
        }
//---------------------------------------------------------------------------
// les valeurs unite_energie et pourcent_en sont identiques pour tous les TAliments
        wxString& TAliment::unite_energie()
        {static wxString unite=wxT("kJ");
        return unite;
        }
//---------------------------------------------------------------------------
        wxString& TAliment::pourcent_en()
        {static wxString unite=wxT("énergie");
        return unite;
        }
//---------------------------------------------------------------------------
        float& TAliment::g()
        {return Aliment_nomme.second.Gval();}
//---------------------------------------------------------------------------
        float& TAliment::p()
        {return Aliment_nomme.second.Pval();}
//---------------------------------------------------------------------------
        float& TAliment::l()
        {return Aliment_nomme.second.Lval();}
//---------------------------------------------------------------------------
        float& TAliment::Qte()
        {return Aliment_nomme.second.Qval();}
//---------------------------------------------------------------------------
        float TAliment::gpl_pourcent(float coeff, float gpl)
        {
        if (unite_energie()==wxT("kJ")) coeff*=COEF_418;
        if (pourcent_en()==wxT("masse"))
                return (100* gpl/poids_sec());
                else
                return (100 * gpl* coeff /energie());
        }
//---------------------------------------------------------------------------
        float TAliment::g_pourcent()
        { return gpl_pourcent(4,g());}
//---------------------------------------------------------------------------
        float TAliment::p_pourcent()
        { return gpl_pourcent(4,p());}
//---------------------------------------------------------------------------
        float TAliment::l_pourcent()
        { return gpl_pourcent(9,l());}
//---------------------------------------------------------------------------
        float TAliment::energie()
        {
        float total;
        total=g()*4 + p()*4 + l()*9;
        if (unite_energie()== wxT("kJ")) total*=COEF_418;
        return total+0.01;
        }
//---------------------------------------------------------------------------
        float TAliment::poids_sec()
        {float total=g()+p()+l()+0.01;
        return total;
        }
//---------------------------------------------------------------------------
        groupe_d_aliment& TAliment::groupe()
        {return Aliment_nomme.second.groupeval();}
//---------------------------------------------------------------------------
        wxString& TAliment::nom()
        {return Aliment_nomme.first;}
//---------------------------------------------------------------------------
        TAliment TAliment::operator+(const TAliment &al)
        {TAliment a=al;
        a.g()+=g();
        a.p()+=p();
        a.l()+=l();
        a.Qte()+=Qte();
        return a;
        }
//---------------------------------------------------------------------------
        TAliment TAliment::operator-(const TAliment &al)
        {TAliment a=al;
        a.g()=g()-a.g();
        a.p()=p()-a.p();
        a.l()=l()-a.l();
        a.Qte()=Qte()-a.Qte();
        return a;
        }
//---------------------------------------------------------------------------
        TAliment& TAliment::operator=(const TAliment &al)
        {
        if (this!= &al)
            {
            Aliment_nomme.first=al.Aliment_nomme.first;
            Aliment_nomme.second=al.Aliment_nomme.second;
            }
        return *this;
        }
//---------------------------------------------------------------------------
        void TAliment::ajuste_a_nouvelle_quantite(float nouv)
        {nouv=(nouv>0.001?nouv:0.001);
        float anc=(Qte()>0?Qte():0.001);
        g()*=nouv/anc;
        p()*=nouv/anc;
        l()*=nouv/anc;
        Qte()=nouv;
        }
//---------------------------------------------------------------------------
// Fin implémentation TAliment
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
//      Fonctions non membres manipulant TTAbleau_aliment
//---------------------------------------------------------------------------
//        Crée un tableau avec toutes les clés >=reponse
//---------------------------------------------------------------------------
        TTableau_aliments qui_convient(wxString reponse,TTableau_aliments &tablal)
                {
                TTableau_aliments T;
                int j=0;
                for (Tmapiter i=tablal.lower_bound(reponse);i!=tablal.end();++i)
                        {if (++j>10)
                        {i=tablal.end();--i;}
                        else
                        T.insert(*i);
                        }
                return T;
                }
//---------------------------------------------------------------------------
        TAliment Calcule_bilan(TTableau_aliments &T,const groupe_d_aliment &gr)
{       TAliment Repas;
        for (Tmapiter i=T.begin();i!=T.end();++i)
        {
        if ((i->second.groupeval()==gr)||(gr==tous_les_groupes))
                {
                Repas.g()+= i->second.Gval();
                Repas.p()+= i->second.Pval();
                Repas.l()+= i->second.Lval();
                Repas.Qte()+=i->second.Qval();
                }
        }
        return Repas;
}
//---------------------------------------------------------------------------
// Fenêtre principale
//---------------------------------------------------------------------------

//Identificateurs
const long MainFrame::idMenuQuit = wxNewId();
const long MainFrame::idMenuImprime = wxNewId();
const long MainFrame::idMenuBilanRepas = wxNewId();
const long MainFrame::idMenuRepertoireAliments = wxNewId();
const long MainFrame::idMenuFicheEdition = wxNewId();
const long MainFrame::idMenuUnite = wxNewId();
const long MainFrame::idMenuPourcentEn = wxNewId();
const long MainFrame::idMenuDisclaimer = wxNewId();
const long MainFrame::idMenuAbout = wxNewId();
const long MainFrame::idMenuHelp = wxNewId();
const long MainFrame::idMenufr = wxNewId();
const long MainFrame::idMenuen = wxNewId();
const long MainFrame::idMenues = wxNewId();
const long MainFrame::idMenuToolbar1 = wxNewId();
const long MainFrame::ID_DIALOGS_FILES_OPEN = wxNewId();
const long MainFrame::ID_DIALOGS_FILE_SAVE = wxNewId();
const long MainFrame::ID_DIALOGS_FILE_SAVE_AS = wxNewId();
const long MainFrame::idOnPaint = wxNewId();
const long MainFrame::idaproposinst = wxNewId();
const long MainFrame::idBilanRepas = wxNewId();
const long MainFrame::idFicheEdition = wxNewId();

// identifiants des contrôles

const long MainFrame::idBoutonsRadio = wxNewId();
const long MainFrame::idIncrement= wxNewId();
const long MainFrame::idBoutPlus= wxNewId();
const long MainFrame::idBoutMoins= wxNewId();
const long MainFrame::idChoisir= wxNewId();
const long MainFrame::idModif= wxNewId();
const long MainFrame::idPurge= wxNewId();
const long MainFrame::idAjuste= wxNewId();
const long MainFrame::idBoitChoixAlim= wxNewId();
const long MainFrame::idAjusteValEn= wxNewId();
const long MainFrame::idPoidsRepas= wxNewId();
const long MainFrame::idLabelUnite= wxNewId();

// identifiants des canvas
const long MainFrame::idCanvas1= wxNewId();


//---------------------------------------------------------------------------
BEGIN_EVENT_TABLE(MainFrame, wxFrame)
    EVT_PAINT(MainFrame::OnPaint)
    EVT_SIZE(MainFrame::OnSize)
    EVT_CLOSE(MainFrame::OnClose)
    EVT_RADIOBOX(idIncrement,MainFrame::OnIncrement)
    EVT_COMBOBOX(idBoitChoixAlim, MainFrame::OnBoitChoixAlim)
    EVT_TEXT_ENTER(idBoitChoixAlim, MainFrame::OnBoitChoixAlim_enter)
    EVT_TEXT_ENTER(idAjusteValEn, MainFrame::OnAjusteValEn)
    EVT_MENU(idMenuQuit, MainFrame::OnQuit)
    EVT_MENU(idMenuImprime, MainFrame::OnImprime)
    EVT_MENU(ID_DIALOGS_FILES_OPEN, MainFrame::FileOpen)
    EVT_MENU(ID_DIALOGS_FILE_SAVE, MainFrame::FileSave)
    EVT_MENU(ID_DIALOGS_FILE_SAVE_AS, MainFrame::FileSaveAs)
    EVT_MENU(idMenuBilanRepas,MainFrame::OnBilanRepas)
    EVT_MENU(idMenuFicheEdition,MainFrame::OnFicheEdition)
    EVT_MENU(idMenuRepertoireAliments,MainFrame::OnRepertoireAliments)
    EVT_MENU(idMenuUnite,MainFrame::OnMenuUnite)
    EVT_MENU(idMenuPourcentEn,MainFrame::OnMenuPourcentEn)
    EVT_MENU(idMenuDisclaimer, MainFrame::OnDisclaimer)
    EVT_MENU(idMenuAbout, MainFrame::OnAbout)
    EVT_MENU(idMenuHelp, MainFrame::OnHelp)
    EVT_MENU(idMenufr,MainFrame::Onfr)
    EVT_MENU(idMenuen,MainFrame::Onen)
    EVT_MENU(idMenues,MainFrame::Ones)
    EVT_BUTTON(idBoutPlus,MainFrame::OnBoutPlus)
    EVT_BUTTON(idBoutMoins,MainFrame::OnBoutMoins)
    EVT_BUTTON(idChoisir,MainFrame::OnChoisir)
    EVT_BUTTON(idModif,MainFrame::OnModif)
    EVT_BUTTON(idPurge,MainFrame::OnPurge)
    EVT_BUTTON(idAjuste,MainFrame::OnAjuste)
END_EVENT_TABLE()
//---------------------------------------------------------------------------
// Le constructeur
MainFrame::MainFrame() : wxFrame(NULL,wxID_ANY,wxT("Aliments"),wxPoint(800,100),wxSize(100,100),wxDEFAULT_FRAME_STYLE|wxFULL_REPAINT_ON_RESIZE)
                            ,init_done(false),item_menu_change(true),taille_modifiee(true)

{
    firstwin()=this;
    Traducteur tr;
    tr.langue_demarrage();
    SetBackgroundColour(Couleur_Fenetres_defaut());
    // Calcule la taille de départ de la fenêtre
    SetSize(Taille_Fenetres_defaut());
    SetPosition(Taille_Fenetres_defaut().GetPosition());
    // Calcule la taille minimale de la fenêtre (ne marche pas avec Wine)
    SetSizeHints(200,200,-1,-1,-1,-1);
    FixeFontEtTaille(this);
    SetIcon(aliments16_xpm);
    // Fiche Apropos
    AProposinst=new APropos(this,idaproposinst);
    // Fiche bilan repas
    BilanRepasinst=new BilanRepas(this,idBilanRepas);
    // Fiche éditeur d'aliment
    FicheEditioninst=new FicheEdition(this,idFicheEdition,&Aliments_disponibles(),&NomFichier);

    // Initialisation des chemins
    // wxStandardPaths est protected dans wxWidgets 3 donc pas instanciable
#if defined(__WXMSW__)
    InitDir=wxStandardPaths::Get().GetDataDir();
    DonneesDir=InitDir;
    DonneesVarDir=DonneesDir;
#elif defined(__UNIX__)
    InitDir=wxT("/usr/bin");
    DonneesDir=wxT("/usr/share/aliments"); // Le répertoire usr peut-être en lecture seule
    DonneesVarDir=wxT("/var/lib/aliments");// d'où la nécessité d'un répertoire dans var pour les données modifiables
#endif

    NomFichier=tr.trad(wxT("defaut.alim"));

    // Aide
    wxImage::AddHandler(new wxPNGHandler());
    wxFileSystem::AddHandler(new wxZipFSHandler);
    helpController = new wxHtmlHelpController(wxHF_DEFAULT_STYLE,this);
    helpController->Initialize(DonneesDir+wxT("/")+wxT("alimentsfrahlp.zip"));
    helpController->AddBook(wxFileName(DonneesDir+wxT("/")+   wxT("alimentsenghlp.zip")));
    helpController->AddBook(wxFileName(DonneesDir+wxT("/")+   wxT("alimentsesphlp.zip")));

#if wxCHECK_VERSION(2,9,0)
    helpController->SetShouldPreventAppExit(true);// Valeur par défaut false provoque le plantage sous wx3.0.2 pas 2.8.2
#endif
//---------------------------------------------------------------------------
    // Mise en place des menus
    wxMenuItem* MenuItem1;
    wxMenuItem* MenuItem2;
    wxMenuItem* MenuItem3;
    wxMenuItem* MenuItem4;
    wxMenuItem* MenuItem5;
    wxMenuItem* MenuItem6;
    wxMenuItem* MenuItem7;
    wxMenuItem* MenuItem8;
    wxMenuItem* MenuItem9;
    wxMenuItem* MenuItem10;
    wxMenuItem* MenuItem11;
    wxMenuItem* MenuItem12;
    wxMenuItem* MenuItem13;
    wxMenuItem* MenuItem14;
    wxMenuItem* MenuItem15;
    wxMenuItem* MenuItem16;
    wxMenu* Menu1;
    wxMenu* Menu2;
    wxMenu* Menu3;
    wxMenu* Menu4;
    wxMenu* Menu5;
    wxMenuBar* MenuBar1;
    MenuBar1 = new wxMenuBar();
    Menu1 = new wxMenu();
        MenuItem1 = new wxMenuItem(Menu1, ID_DIALOGS_FILES_OPEN, wxT("Ouvrir"), wxT("Charge un fichier"), wxITEM_NORMAL);
        Menu1->Append(MenuItem1);
        MenuItem2 = new wxMenuItem(Menu1, ID_DIALOGS_FILE_SAVE, wxT("Enregistrer"), wxT("Sauve le fichier en cours"), wxITEM_NORMAL);
        Menu1->Append(MenuItem2);
        MenuItem3 = new wxMenuItem(Menu1,ID_DIALOGS_FILE_SAVE_AS, wxT("Enregistrer sous..."), wxT("Sauv sous un nouveau nom"), wxITEM_NORMAL);
        Menu1->Append(MenuItem3);
        MenuItem4 = new wxMenuItem(Menu1, idMenuImprime, wxT("Impression"), wxT("Imprime le diagramme"), wxITEM_NORMAL);
        Menu1->Append(MenuItem4);
        Menu1->AppendSeparator();
        MenuItem5 = new wxMenuItem(Menu1, idMenuQuit, wxT("Quitter"), wxT("Quit the application"), wxITEM_NORMAL);
        Menu1->Append(MenuItem5);
        MenuBar1->Append(Menu1, wxT("Fichiers"));
    Menu2 = new wxMenu();
        MenuItem6 = new wxMenuItem(Menu2, idMenuRepertoireAliments, wxT("Aliments disponibles"), wxT("Aliments disponibles"), wxITEM_NORMAL);
        Menu2->Append(MenuItem6);
        MenuItem7 = new wxMenuItem(Menu2, idMenuBilanRepas, wxT("Bilan repas"), wxT("Bilan repas"), wxITEM_NORMAL);
        Menu2->Append(MenuItem7);
        MenuItem8 = new wxMenuItem(Menu2, idMenuFicheEdition, wxT("Editeur d'aliments"), wxT("Editeur d'aliments"), wxITEM_NORMAL);
        Menu2->Append(MenuItem8);
        MenuBar1->Append(Menu2, wxT("Outils"));
    Menu3 = new wxMenu();
        MenuItem9 = new wxMenuItem(Menu3, idMenuUnite, wxT("Unité"), wxT("Unité"), wxITEM_NORMAL);
        Menu3->Append(MenuItem9);
        MenuItem10 = new wxMenuItem(Menu3, idMenuPourcentEn, wxT("Pourcentage de "), wxT("Pourcentage de "), wxITEM_NORMAL);
        Menu3->Append(MenuItem10);
        MenuBar1->Append(Menu3, wxT("Paramètres"));
    Menu4 = new wxMenu();
        MenuItem11 = new wxMenuItem(Menu4, idMenufr, wxT("Français"), wxT("Version Française"), wxITEM_CHECK );
        Menu4->Append(MenuItem11);
        MenuItem12 = new wxMenuItem(Menu4, idMenuen, wxT("English"), wxT("English version"), wxITEM_CHECK );
        Menu4->Append(MenuItem12);
        MenuItem13 = new wxMenuItem(Menu4, idMenues, wxT("Castellano"), wxT("Versión Castellana"), wxITEM_CHECK );
        Menu4->Append(MenuItem13);
        MenuBar1->Append(Menu4, wxT("Langage"));
    Menu5 = new wxMenu();
        MenuItem14 = new wxMenuItem(Menu5, idMenuDisclaimer, wxT("Avertissement"), wxT("Avertissement"), wxITEM_NORMAL);
        Menu5->Append(MenuItem14);
        MenuItem15 = new wxMenuItem(Menu5, idMenuAbout, wxT("A propos"), wxT("A propos"), wxITEM_NORMAL);
        Menu5->Append(MenuItem15);
        MenuItem16 = new wxMenuItem(Menu5, idMenuHelp, wxT("Aide"), wxT("Aide sur Aliments"), wxITEM_NORMAL);
        Menu5->Append(MenuItem16);
        MenuBar1->Append(Menu5, wxT("Aide"));
    SetMenuBar(MenuBar1);
    //---------------------------------------------------------------------------
    // Barre d'outils
    wxToolBar* Toolbar1;
    Toolbar1= CreateToolBar(wxNO_BORDER | wxTB_HORIZONTAL,idMenuToolbar1);
    wxImage::AddHandler(new wxXPMHandler());
    wxBitmap* toolBarBitmaps[9];
    toolBarBitmaps[0]=new wxBitmap(files16_xpm);
    toolBarBitmaps[1]=new wxBitmap(save16_xpm);
    toolBarBitmaps[2]=new wxBitmap(impr16_xpm);
    toolBarBitmaps[3]=new wxBitmap(balance16_xpm);
    toolBarBitmaps[4]=new wxBitmap(livre16_xpm);
    toolBarBitmaps[5]=new wxBitmap(fr16_xpm);
    toolBarBitmaps[6]=new wxBitmap(eng16_xpm);
    toolBarBitmaps[7]=new wxBitmap(es16_xpm);
    toolBarBitmaps[8]=new wxBitmap(help16_xpm);
    toolBarBitmaps[9]=new wxBitmap(sortie16_xpm);

    Toolbar1->SetToolBitmapSize(wxSize(toolBarBitmaps[0]->GetWidth(),toolBarBitmaps[0]->GetHeight()));

    Toolbar1->AddTool(ID_DIALOGS_FILES_OPEN ,wxT("Fichiers")        ,*(toolBarBitmaps[0]),wxT("Fichiers")                   ,wxITEM_NORMAL);
    Toolbar1->AddTool(ID_DIALOGS_FILE_SAVE  ,wxT("Sauve le fichier en cours")    ,*(toolBarBitmaps[1]),wxT("Sauve le fichier en cours")  ,wxITEM_NORMAL);
    Toolbar1->AddTool(idMenuImprime          ,wxT("Imprime")     ,*(toolBarBitmaps[2]),wxT("Imprime le triangle")                ,wxITEM_NORMAL);
    Toolbar1->AddSeparator();
    Toolbar1->AddTool(idMenuBilanRepas          ,wxT("Bilan repas")     ,*(toolBarBitmaps[3]),wxT("Bilan repas")                ,wxITEM_NORMAL);
    Toolbar1->AddTool(idMenuRepertoireAliments          ,wxT("Aliments disponibles")     ,*(toolBarBitmaps[4]),wxT("Aliments disponibles")                ,wxITEM_NORMAL);
    Toolbar1->AddSeparator();
    Toolbar1->AddTool(idMenufr              ,wxT("Français")        ,*(toolBarBitmaps[5]),wxT("Français")                   ,wxITEM_RADIO);
    Toolbar1->AddTool(idMenuen              ,wxT("English")         ,*(toolBarBitmaps[6]),wxT("English")                    ,wxITEM_RADIO);
    Toolbar1->AddTool(idMenues              ,wxT("español")         ,*(toolBarBitmaps[7]),wxT("español")                    ,wxITEM_RADIO);
    Toolbar1->AddSeparator();
    Toolbar1->AddTool(idMenuHelp            ,wxT("Aide")            ,*(toolBarBitmaps[8]),wxT("Aide")                       ,wxITEM_NORMAL);
    Toolbar1->AddSeparator();
    Toolbar1->AddTool(idMenuQuit            ,wxT("Quitter")         ,*(toolBarBitmaps[9]),wxT("Sortie")                     ,wxITEM_NORMAL);
    Toolbar1->Realize();
    SetToolBar(Toolbar1);
    //---------------------------------------------------------------------------
    // Mise en page et insertion des contrôles
    wxPoint pos; wxSize taille;
    // Panneau de contrôle indispensable sinon les évènements mouse ne sont pas émis par la wxRadiobox (bogue
    // corrigée dans les versions suivantes de wxWidgets
    pos=FaitReelle_Pos(wxPoint(10,300),this);  taille=FaitReelle_Taille(wxSize(10,10),this);
    BoutonsRadio= new wxPanel(this,idBoutonsRadio,pos,taille,wxFULL_REPAINT_ON_RESIZE);
    BoutonsRadio->SetBackgroundColour(Couleur_Fenetres_defaut());
    pos=FaitReelle_Pos(wxPoint(10,100),BoutonsRadio);
    taille=FaitReelle_Taille(wxSize(190,900),BoutonsRadio);
    Increment =new wxRadioBox(BoutonsRadio,idIncrement ,wxT("Valeur de l'incrément"),pos,taille,3,nomincr,1,wxRA_SPECIFY_ROWS|wxFULL_REPAINT_ON_RESIZE);

    pos=FaitReelle_Pos(wxPoint(10,100),this);
    taille=FaitReelle_Taille(wxSize(50,50),this);
    BoutPlus=new wxButton(this,idBoutPlus,wxT("+"),pos,taille);
    BoutMoins=new wxButton(this,idBoutMoins,wxT("-"),pos,taille);

    Choisir=new wxButton(this,idChoisir,wxT("Choisit"),pos,taille);
    Modif=new wxButton(this,idModif,wxT("Modifie"),pos,taille);
    Purge=new wxButton(this,idPurge,wxT("Purge"),pos,taille);
    Ajuste=new wxButton(this,idAjuste,wxT("Ajuste"),pos,taille);
    // ComboBox choix des aliments
    //Sous Linux, l'évènement Enter est traité même en l'absence de wxTE_PROCESS_ENTER
    wxString ChoixDefaut[3];
    ChoixDefaut[0]=wxT("Un");
    ChoixDefaut[1]=wxT("Deux");
    ChoixDefaut[2]=wxT("Trois");
    BoitChoixAlim=new wxComboBox(this,idBoitChoixAlim,wxT(""),wxPoint(10,10),wxSize(100,20),3,ChoixDefaut,wxTE_PROCESS_ENTER);
    BoitChoixAlim->SetSelection(0);
    // Progress bar quantité et label donnant l'unité
    PoidsRepas= new wxGauge(this,idPoidsRepas,int(MAX_GAUGE*COEF_418),wxPoint(100,100),wxSize(50,100),wxGA_VERTICAL|wxGA_SMOOTH);
    LabelUnite=new wxStaticText(this,idLabelUnite,wxT("kJ"),pos,taille,wxST_NO_AUTORESIZE);
    // Boite texte affichage saisie valeur énergétique
    AjusteValEn=new wxTextCtrl(this,idAjusteValEn,wxT(""),pos,taille,wxTE_PROCESS_ENTER);

    // Charge la liste d'aliments par défaut la crée si elle n'existe pas
    if(!charge_fichier(NomComplet()))
        {wxCommandEvent ev;
        FileSave(ev);
        charge_fichier(NomComplet());
        }

    // Règle l'apparence des boutons au démarrage et charge le premier aliment de la liste
    wxCommandEvent Eventprov;
    OnBoitChoixAlim(Eventprov);
    Choisi_Modif(true);
    Canvas1= new Tgraphique(this,idCanvas1,wxPoint(100,100),wxSize(100,100),wxT("Triangle"));

    g_printData =new wxPrintData;
    g_printData->SetPaperId(wxPAPER_A4);
    init_done=true;
}
//---------------------------------------------------------------------------
// Le Destructeur
MainFrame::~MainFrame()
{
    delete g_printData;
}
//---------------------------------------------------------------------------
void MainFrame::Met_a_jour_BoitChoixAlim()
{
    // Mets à jour la combobox ChoixAlim
    BoitChoixAlim->Clear();
    if (Aliments_disponibles().size()==0) wxMessageBox(wxT("Liste vide"));
        else
        {
        for (Tmapiter i=Aliments_disponibles().begin();i!=Aliments_disponibles().end();++i)
            BoitChoixAlim->Append(i->first);
        BoitChoixAlim->SetSelection(0);
        }
}
//---------------------------------------------------------------------------
wxString MainFrame::NomComplet()
{
    return DonneesVarDir+wxT("/")+NomFichier;
}
//---------------------------------------------------------------------------
void MainFrame::OnImprime(wxCommandEvent& event)
{
    Traducteur tr;
    wxPrintDialogData g_printDialogData(*g_printData);
    g_printDialogData.EnablePageNumbers(true);
    wxPrintPreview *preview = new wxPrintPreview(new GraphPrintout(wxT("Liste 1"),Canvas1), new GraphPrintout(wxT("Liste 2"),Canvas1),& g_printDialogData);
    if (!preview->Ok())
    {
        delete preview;
        wxMessageBox(wxT("There was a problem previewing.\nPerhaps your current printer is not set correctly?"), wxT("Previewing"), wxOK);
        return;
    }
    wxPreviewFrame *frame = new wxPreviewFrame(preview, this, tr.trad(wxT("Aliments")), wxPoint(100, 100), wxSize(600, 650));
    frame->Centre(wxBOTH);
    frame->Initialize();
    frame->Show();
}
//---------------------------------------------------------------------------
void MainFrame::OnQuit(wxCommandEvent& event)
{
                wxCloseEvent eventclose;
                OnClose(eventclose);
}
void MainFrame::OnClose(wxCloseEvent& event)
{
                this->Destroy();
}
//---------------------------------------------------------------------------
void MainFrame::OnBilanRepas(wxCommandEvent& event)
{
    Traducteur tr;
    BilanRepasinst->conteneur_aliments_Bilan=(&Menu_en_cours());
    // Windows assimile Label (de WxWindow) et Title (de wxFrame) mais pas Linux
    // D'où la nécessité d'utiliser Title pour les wxFrame
    BilanRepasinst->SetTitle(tr.trad(wxT("Bilan repas")));
    BilanRepasinst->est_repertoire=false;
    BilanRepasinst->liste_modifiee=true;
    BilanRepasinst->Show();
    BilanRepasinst->Refresh();
    Refresh();
}
void MainFrame::OnRepertoireAliments(wxCommandEvent& event)
{
    Traducteur tr;
    BilanRepasinst->conteneur_aliments_Bilan=(&Aliments_disponibles());
    BilanRepasinst->SetTitle(tr.trad(wxT("Aliments disponibles")));
    BilanRepasinst->est_repertoire=true;
    BilanRepasinst->liste_modifiee=true;
    BilanRepasinst->Show();
    Refresh();
}
void MainFrame::OnFicheEdition(wxCommandEvent& event)
{
    FicheEditioninst->Show();
    FicheEditioninst->Affichage_modifie=true;
    //FicheEditioninst->MakeModal(); deprecated au delà de 2.9
    Disable();
    FicheEditioninst->Refresh();
}
//---------------------------------------------------------------------------
void MainFrame::OnDisclaimer(wxCommandEvent& event)
{
    Traducteur tr;
    wxBitmap bitmap;
    wxImage::AddHandler(new wxPNGHandler());
    if (bitmap.LoadFile(DonneesDir+wxT("/")+tr.trad(wxT("DisclaimimageFra.png")), wxBITMAP_TYPE_PNG))
    {
        wxSplashScreen* splash __attribute__ ((unused));
        splash = new wxSplashScreen(bitmap,
          wxSPLASH_CENTRE_ON_SCREEN|wxSPLASH_TIMEOUT,
          6000, NULL, -1, wxDefaultPosition, wxDefaultSize,
          wxSIMPLE_BORDER|wxSTAY_ON_TOP);
    }
    wxYield();
}
//---------------------------------------------------------------------------
void MainFrame::OnAbout(wxCommandEvent& event)
{
    AProposinst->Show();
}
 void MainFrame::OnHelp(wxCommandEvent& event)
{
    Traducteur tr;
    helpController->DisplayContents();
    helpController->Display(tr.trad(wxT("alimentsfrahlp")));
}
void MainFrame::Onfr(wxCommandEvent& event)
{
    Traducteur tr;
    tr.fixe_langue()=fr;
    item_menu_change=true;
    Refresh();
}
void MainFrame::Onen(wxCommandEvent& event)
{
    Traducteur tr;
    tr.fixe_langue()=ang;
    item_menu_change=true;
    Refresh();
}
void MainFrame::Ones(wxCommandEvent& event)
{
    Traducteur tr;
    tr.fixe_langue()=esp;
    item_menu_change=true;
    Refresh();
}
//---------------------------------------------------------------------------
//      Espace de nom calcule
//---------------------------------------------------------------------------
namespace Calcule
{       int increment=5;
//---------------------------------------------------------------------------
        void ajuste_valeur_repas()
        {
        al_curseur()=al_repas_en_cours()+al_courant();
        }
//---------------------------------------------------------------------------
        void plus_dix()
        {al_courant().ajuste_a_nouvelle_quantite(al_courant().Qte()+increment);
        ajuste_valeur_repas();
        }
//---------------------------------------------------------------------------
        void moins_dix()
        {al_courant().ajuste_a_nouvelle_quantite(al_courant().Qte()-increment);
        ajuste_valeur_repas();
        }
}
//---------------------------------------------------------------------------
//      Fin espace de nom calcule
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
// Gestion des fichiers
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
// Chargement du fichier alim au format ancien.
bool MainFrame::charge_fichier_ancien_format(wxString nomfich)
    {
    Traducteur tr;
    wxFile fichier_en_cours(nomfich,wxFile::read);
    bool succes=fichier_en_cours.IsOpened();
    char tf[LMAX_NOM_ALIMENT];
    if (succes)
        {
        int L=0;
        TAliment_nomme Al;
        Aliments_disponibles().clear();
        // variante pour récupérer les fichiers au format ancien
        wxMessageBox(tr.trad(wxT("Ce fichier est récupéré de l'ancien format. Enregistrez le sous un nouveau nom si vous voulez conservez l'original")));
                while (L<fichier_en_cours.Length())
                {
                L+=fichier_en_cours.Read(&tf,LMAX_NOM_ALIMENT);// passage par tf lourd, mais je n'ai pas su utiliser directement f
                wxString f(tf,wxConvISO8859_1); // laborieux enfin je récupère mes accents !
                f[f.Len()-1]=wxChar(wxT(' '));
                f.Trim(true);
                Al.first=(f);
                float v;
                int valb[4];
                int vint=0;
                for (int i=0;i<4;i++) valb[i]=0;
                L+=fichier_en_cours.Read(&v,sizeof(v));
                Al.second.Gval()=v;
                L+=fichier_en_cours.Read(&v,sizeof(v));
                Al.second.Pval()=v;
                L+=fichier_en_cours.Read(&v,sizeof(v));
                Al.second.Lval()=v;
                L+=fichier_en_cours.Read(&v,sizeof(v));
                Al.second.Qval()=v;
                for (int i=0;i<4;i++)
                    {
                     L+=fichier_en_cours.Read(&vint,sizeof(unsigned char));
                     valb[i]=vint;
                    }
                Al.second.groupeval()=groupe_d_aliment(valb[0]); // le groupe est le premier byte de la valeur float les autres sont inutilisés
                Aliments_disponibles().insert(Al);
                }
        }
    return succes;
    }
//---------------------------------------------------------------------------
// Chargement du fichier alim sélectionné.
bool MainFrame::charge_fichier(wxString nomfich)
{
    wxFile fichier_en_cours(nomfich,wxFile::read);
    bool succes=fichier_en_cours.IsOpened();
    char tf[LMAX_NOM_ALIMENT];
    if (succes)
        {
        int L=0;
        TAliment_nomme Al;
        Aliments_disponibles().clear();
        while (L<fichier_en_cours.Length())
                {
                for (unsigned int i=0;i<LMAX_NOM_ALIMENT;i++) tf[i]=' ';
                L+=fichier_en_cours.Read(&tf,LMAX_NOM_ALIMENT);// passage par tf lourd, mais je n'ai pas su utiliser directement f
                //wxString f(wxChar(' '),LMAX_NOM_ALIMENT);
                wxString f(tf,wxConvISO8859_1); // laborieux enfin je récupère mes accents !
                f[f.Len()-1]=wxChar(wxT(' '));
                f.Trim(true);
                Al.first=(f);
                L+=fichier_en_cours.Read(&Al.second,sizeof(Al.second));
                Aliments_disponibles().insert(Al);
                }
    if ((*Aliments_disponibles().begin()).second.Qval()!=100) // le groupe est enregistré à la place de la quantité dans les fichiers alim ancien
        if (succes) succes=charge_fichier_ancien_format(nomfich);
            Met_a_jour_BoitChoixAlim();
        verifie_aliment_cible();
        }
    FicheEditioninst->Fichier_modifie=true;
    FicheEditioninst->Liste_modifiee=true;
    BilanRepasinst->liste_modifiee=true;
    Refresh();
    return succes;
}
//---------------------------------------------------------------------------
void MainFrame::FileOpen(wxCommandEvent& WXUNUSED(event) )
{
    Traducteur tr;
    wxFileDialog dialog
                 (
                    this,
                    tr.trad(wxT("Ouvrir un fichier d'aliments")),
                    wxEmptyString,
                    wxEmptyString,
                    wxString(tr.trad(wxT("Fichiers d'aliments"))+wxT("(*.alim)|*.alim|")+tr.trad(wxT("Tous fichiers"))+wxT("(*.*)|*.*"))
                 );
    dialog.CentreOnParent();
    dialog.SetDirectory(DonneesVarDir);
    if (dialog.ShowModal() == wxID_OK)
        {
        DonneesVarDir=dialog.GetDirectory();
        NomFichier=dialog.GetFilename();
        if(!charge_fichier(NomComplet()))
                {
                };
        }
}
//---------------------------------------------------------------------------
//Sauve le fichier d'aliments
void MainFrame::FileSave(wxCommandEvent& event)
{
    wxFile fichier_en_cours(NomComplet(),wxFile::write);
    if (Aliments_disponibles().size()==0) liste_par_defaut();
    wxString f;
    size_t Lw=0;
    char tf[LMAX_NOM_ALIMENT];
    wxCharBuffer tf1;
    for (Tmapiter i=Aliments_disponibles().begin();i!=Aliments_disponibles().end();++i)
        {
        f=(*i).first;
        f=f.Append(wxChar(' '),LMAX_NOM_ALIMENT);
        tf1=f.To8BitData(); // indispensable depuis que wx est compilé en mode unicode
        for (size_t j=0;j<LMAX_NOM_ALIMENT;j++) tf[j]=tf1[j];
        Lw+=fichier_en_cours.Write(tf,LMAX_NOM_ALIMENT);
        TAliment_contenu c=(*i).second;
        size_t L=sizeof(c);
        Lw+=fichier_en_cours.Write(&c,L);
        }
    Refresh();
}
//---------------------------------------------------------------------------
void MainFrame::FileSaveAs(wxCommandEvent& event)
{
    Traducteur tr;

    wxFileDialog dialog(this,
                        tr.trad(wxT("Enregistrer sous...")),
                        wxEmptyString,
                        tr.trad(wxT("Sans titre")),
                        wxString(tr.trad(wxT("Fichiers d'aliments"))+wxT("(*.alim)|*.alim|")+tr.trad(wxT("Tous fichiers"))+wxT("(*.*)|*.*")),
                        wxFD_SAVE|wxFD_OVERWRITE_PROMPT);

    dialog.SetFilterIndex(0);
    dialog.CentreOnParent();
    dialog.SetDirectory(DonneesVarDir);

    if (dialog.ShowModal() == wxID_OK)
    {
// enregistrement du fichier aliments sélectionné.
    DonneesVarDir=dialog.GetDirectory();
    NomFichier=dialog.GetFilename();
    FileSave(event);
    }
    Refresh();
}
//---------------------------------------------------------------------------
// Fin Gestion des fichiers
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
void MainFrame::OnSize(wxSizeEvent& event)
{
    taille_modifiee=true;
}
//---------------------------------------------------------------------------
void MainFrame::OnPaint(wxPaintEvent& event)
{
    wxPaintDC dc(this);
    rafraichit();
}
//---------------------------------------------------------------------------
void MainFrame::rafraichit()
{
    Traducteur tr;
    TAliment al;

    if (item_menu_change)
        {
        wxMenuBar* Menuprov=GetMenuBar();
        // Traduit les titres des enfants
        RenommeEnfants(this);
        // Titres de menus
        size_t nb_menus=Menuprov->GetMenuCount();
        for (size_t i=0;i<nb_menus;i++)
            Menuprov->SetMenuLabel(i,tr.trad_tout(Menuprov->GetMenuLabel(i)));
        //Items de chaque menu
        Menuprov->SetLabel(ID_DIALOGS_FILE_SAVE_AS,tr.trad(wxT("Enregistrer sous...")));
        Menuprov->SetLabel(ID_DIALOGS_FILES_OPEN,tr.trad(wxT("Ouvrir")));
        Menuprov->SetLabel(ID_DIALOGS_FILE_SAVE,tr.trad(wxT("Enregistrer")));
        Menuprov->SetLabel(idMenuQuit,tr.trad(wxT("Quitter")));
        Menuprov->SetLabel(idMenuImprime,tr.trad(wxT("Impression")));
        Menuprov->SetLabel(idMenuBilanRepas,tr.trad(wxT("Bilan repas")));
        Menuprov->SetLabel(idMenuRepertoireAliments,tr.trad(wxT("Aliments disponibles")));
        Menuprov->SetLabel(idMenuFicheEdition,tr.trad(wxT("Editeur d'aliments")));
        Menuprov->SetLabel(idMenuUnite,tr.trad(wxT("énergie en "))+(al.unite_energie()));
        Menuprov->SetLabel(idMenuPourcentEn,tr.trad(wxT("Pourcentage de "))+tr.trad(al.pourcent_en()));
        Menuprov->SetLabel(idMenuDisclaimer, tr.trad(wxT("Avertissement")));
        Menuprov->SetLabel(idMenuAbout, tr.trad(wxT("A propos")));
        Menuprov->SetLabel(idMenuHelp, tr.trad(wxT("Aide")));
        Menuprov->SetLabel(idMenufr,tr.trad(wxT("Français")));
        Menuprov->SetLabel(idMenuen,tr.trad(wxT("English")));

        // Boutons actifs ou non sur la barre d'outils
        langues langue_en_cours=tr.fixe_langue();
        Menuprov->Check(idMenufr,(langue_en_cours==fr));
        Menuprov->Check(idMenuen,(langue_en_cours==ang));
        Menuprov->Check(idMenues,(langue_en_cours==esp));
        wxToolBar* Toolbarprov=GetToolBar();
        Toolbarprov->ToggleTool(idMenufr,langue_en_cours==fr);
        Toolbarprov->ToggleTool(idMenuen,langue_en_cours==ang);
        Toolbarprov->ToggleTool(idMenues,langue_en_cours==esp);
        Toolbarprov->SetToolShortHelp(ID_DIALOGS_FILES_OPEN,tr.trad(wxT("Ouvrir")));
        Toolbarprov->SetToolShortHelp(ID_DIALOGS_FILE_SAVE,tr.trad(wxT("Sauve le fichier en cours")));
        Toolbarprov->SetToolShortHelp(idMenuImprime,tr.trad(wxT("Impression")));
        Toolbarprov->SetToolShortHelp(idMenuBilanRepas,tr.trad(wxT("Bilan repas")));
        Toolbarprov->SetToolShortHelp(idMenuRepertoireAliments,tr.trad(wxT("Aliments disponibles")));
        Toolbarprov->SetToolShortHelp(idMenuHelp, tr.trad(wxT("Aide")));
        Toolbarprov->SetToolShortHelp(idMenuQuit,tr.trad(wxT("Quitter")));
        Menuprov->Refresh();
        Toolbarprov->Refresh();

         // Label unité
        LabelUnite->SetLabel(al.unite_energie());

        BilanRepasinst->item_menu_change=true;
        item_menu_change=false;
        }
    if(taille_modifiee)
        {
          // Ajuste la taille de la zone graphique
        wxPoint pos(360,50);
        wxSize taille(630,850);
        Ajuste_taille_et_pos(pos,taille,this,Canvas1);
        // Ajuste la taille des contrôles
            // Progress bar quantité
        Ajuste_taille_et_pos(wxPoint(295,430),wxSize(55,50),this,LabelUnite);
        Ajuste_taille_et_pos(wxPoint(270,490),wxSize(75,490),this,PoidsRepas);
            // combobox taille
        Ajuste_taille_et_pos(wxPoint(10,10),wxSize(250,70),this,BoitChoixAlim);
            // Boite texte affichage saisie valeur énergétique
        Ajuste_taille_et_pos(wxPoint(270,345),wxSize(75,60),this,AjusteValEn);
        AjusteValEn->Clear();
        AjusteValEn->AppendText(wxString::Format(wxT("%4.0f"),al_curseur().energie()));
            // Boutons réponse
        taille=wxSize(125,70);
        int labx(270),laby(40),pasy(75);

        Ajuste_taille_et_pos(wxPoint(10,115),taille,this,BoutMoins);
        Ajuste_taille_et_pos(wxPoint(140,115),taille,this,BoutPlus);
        taille=wxSize(75,70);
        Ajuste_taille_et_pos(wxPoint(labx,laby       ),taille,this,Choisir);
        Ajuste_taille_et_pos(wxPoint(labx,laby+  pasy),taille,this,Modif);

        Ajuste_taille_et_pos(wxPoint(labx,laby+2*pasy),taille,this,Purge);
        Ajuste_taille_et_pos(wxPoint(labx,laby+3*pasy),taille,this,Ajuste);
            // Boutons radios choix de l'incrément
        Ajuste_taille_et_pos(wxPoint(10,190),wxSize(260,150),this,BoutonsRadio);
        Ajuste_taille_et_pos(wxPoint(10,10),wxSize(900,900),BoutonsRadio,Increment);
        }
        else
        {
            // Boutons Ajuste et purge
            Ajuste->Enable(int(Calcule_bilan(Menu_en_cours(),tous_les_groupes).energie())>0);
            Purge->Enable(!(Menu_en_cours().empty()));
            //Progress bar poids repas
            PoidsRepas->SetValue(int(al_curseur().energie()));
            // Met à jour la liste déroulante s'il y a eu un changement
        if (FicheEditioninst->Liste_modifiee)
            {
            Met_a_jour_BoitChoixAlim();
            BilanRepasinst->liste_modifiee=true;
            FicheEditioninst->Liste_modifiee=false;
            }
         }
        // Rafraîchit les autres fenêtres
        if (BilanRepasinst->IsShown())
            {
            BilanRepasinst->Refresh();
            BilanRepasinst->Update();
            }
        taille_modifiee=false;
  }
//---------------------------------------------------------------------------
void MainFrame::OnIncrement(wxCommandEvent& event)
{
        switch (Increment->GetSelection())
                {
                case 1:Calcule::increment=10;break;
                case 2:Calcule::increment=50;break;
                default :Calcule::increment=5;
                }
}
//---------------------------------------------------------------------------
void MainFrame::OnBoitChoixAlim(wxCommandEvent& event)
{
    wxString ch;
    int index=BoitChoixAlim->GetSelection();
    ch=BoitChoixAlim->GetString(index);
    Tmapiter al= Aliments_disponibles().find(ch);
    if(al!=Aliments_disponibles().end())
        {
        al_courant().Aliment_nomme=(*al);
        al_courant().ajuste_a_nouvelle_quantite(0);
        al=Menu_en_cours().find(ch);
        if (al!=Menu_en_cours().end())
            {if ((*al).second.Qval()>0) al_courant().Aliment_nomme=(*al);}
            else Menu_en_cours()[ch];
        Choisi_Modif(false);
        }
    al_repas_en_cours()=al_repas()-al_courant();
}
//---------------------------------------------------------------------------
void MainFrame::OnBoitChoixAlim_enter(wxCommandEvent& event)
{
    wxString ch(BoitChoixAlim->GetValue());
    ch=ch.Trim().MakeCapitalized(); // fonction implémentée seulement à partir de 2.9
    int index=wxNOT_FOUND;
    if (ch.length())
        for (Tmapiter al(Aliments_disponibles().begin());al!=Aliments_disponibles().end();++al)
        {
            if(al->first.Left(ch.Length())==ch)
            {
                index=BoitChoixAlim->FindString(al->first);
                BoitChoixAlim->SetSelection(index);
            }
        }
    if (index!=wxNOT_FOUND)OnBoitChoixAlim(event); // Met à jour la fenêtre texte de la combobox
}
//---------------------------------------------------------------------------
void MainFrame::AjouteEnleve(const wxChar &Key)
{       using namespace Calcule;
        Traducteur tr;
        if (!Modif->IsEnabled())
                {
                if (Key==wxChar('+')) plus_dix();
                if (Key==wxChar('-')) moins_dix();
                Menu_en_cours()[al_courant().nom()]=al_courant().Aliment_nomme.second;
                if (BilanRepasinst->IsShown()) BilanRepasinst->liste_modifiee=true;
                taille_modifiee=true;
                Refresh();
                Update();
                }
}
//---------------------------------------------------------------------------
void  MainFrame::OnBoutPlus(wxCommandEvent& event)
{
    AjouteEnleve(wxChar('+'));
}
//---------------------------------------------------------------------------
void  MainFrame::OnBoutMoins(wxCommandEvent& event)
{
    AjouteEnleve(wxChar('-'));
}
//---------------------------------------------------------------------------
void  MainFrame::Choisi_Modif(bool cas_choisi)
{
    Choisir->Enable(!cas_choisi);
    Modif->Enable(cas_choisi&&Menu_en_cours().size()>0);
    BoitChoixAlim->Enable(cas_choisi);
    al_repas()=al_curseur();
    BoutPlus->Enable(!cas_choisi);
    BoutMoins->Enable(!cas_choisi);
    Increment->Enable(!cas_choisi);
}
//---------------------------------------------------------------------------
void  MainFrame::OnChoisir(wxCommandEvent& event)
{
    Choisi_Modif(true);
}
//---------------------------------------------------------------------------
void  MainFrame::OnModif(wxCommandEvent& event)
{
    Choisi_Modif(false);
}
//---------------------------------------------------------------------------
void  MainFrame::OnPurge(wxCommandEvent& event)
{
        Traducteur tr;
        Menu_en_cours().clear();
        TAliment T;
        al_courant()=T;
        al_repas()=T;
        al_curseur()=T;
        Choisi_Modif(true);
        if (BilanRepasinst->IsShown()) BilanRepasinst->liste_modifiee=true;
        taille_modifiee=true;// Forcera la mise à jour de la fenêtre de saisie de valeur énergétique
        Refresh();
        Update();
}
//---------------------------------------------------------------------------
void  MainFrame::OnAjuste(wxCommandEvent& event)
{
        TAliment Repas,al;
        double Nouvelle_valeur(0);
        // Si la valeur est valide et le menu n'est pas vide
        if ((AjusteValEn->GetLineText(0).ToDouble(&Nouvelle_valeur))&!(Menu_en_cours().empty()))
                {
                Repas=Calcule_bilan(Menu_en_cours(),tous_les_groupes);
                double ancienne_valeur=Repas.energie();
                double rapport=Nouvelle_valeur/ancienne_valeur;
                for (Tmapiter i=Menu_en_cours().begin();i!=Menu_en_cours().end();++i)
                        {
                         al.Aliment_nomme=(*i);
                         al.ajuste_a_nouvelle_quantite(al.Qte()*(rapport));
                         i->second=al.Aliment_nomme.second;
                         }
                al_repas().ajuste_a_nouvelle_quantite(al_repas().Qte()*(rapport));
                al_repas_en_cours().ajuste_a_nouvelle_quantite(al_repas_en_cours().Qte()*(rapport));
                al_curseur().ajuste_a_nouvelle_quantite(al_curseur().Qte()*(rapport));
                al_courant().ajuste_a_nouvelle_quantite(al_courant().Qte()*(rapport));
                if (BilanRepasinst->IsShown()) BilanRepasinst->liste_modifiee=true;
                Refresh();
                }
}
//---------------------------------------------------------------------------
void  MainFrame::OnAjusteValEn(wxCommandEvent& event)
{
        OnAjuste(event);
}
//---------------------------------------------------------------------------
// Vérifie  qu'il existe une cible dans le langage courant  au sein du fichier Aliments_disponible.
// Si le fichier aliment chargé était dans une langue différente ou qu'il n'y avait pas d'aliment cible
// ajoute une cible par défaut dans le langage courant
void MainFrame::verifie_aliment_cible()
        {
        Traducteur tr;
        al_cible()=al_cible_defaut();
        al_cible().nom()=tr.trad(wxT("Equilibre"));
        Tmapiter t=Aliments_disponibles().find(al_cible().nom());
        if (t!=Aliments_disponibles().end()) al_cible().Aliment_nomme=(*t);
                else Aliments_disponibles().insert(al_cible().Aliment_nomme);
        if (t!=Aliments_disponibles().end())
                al_cible().Aliment_nomme= *t;
        }
//---------------------------------------------------------------------------
void  MainFrame::OnMenuUnite(wxCommandEvent& event)
{
        TAliment al;
        if (al.unite_energie()==wxT("kcal"))
                al.unite_energie()=wxT("kJ");
        else    al.unite_energie()=wxT("kcal");
            PoidsRepas->SetRange((al.unite_energie()==wxT("kcal")?MAX_GAUGE:int(MAX_GAUGE*COEF_418)));
        if (BilanRepasinst->IsShown()) BilanRepasinst->liste_modifiee=true;
        item_menu_change=true;
        taille_modifiee=true;// Forcera la mise à jour de la fenêtre de saisie de valeur énergétique
        Refresh();
}
//---------------------------------------------------------------------------
void  MainFrame::OnMenuPourcentEn(wxCommandEvent& event)
{
        TAliment al;
        Traducteur tr;
        if (al.pourcent_en()==wxT("masse"))
                al.pourcent_en()=wxT("énergie");
        else    al.pourcent_en()=wxT("masse");
        if (BilanRepasinst->IsShown()) BilanRepasinst->liste_modifiee=true;
        item_menu_change=true;
        Refresh();
}
