/*
    Aliments permet une représentation graphique de l'équilibre GPL d'une ration alimentaire.
    Copyright (C) 1994 (version Dos) 2009-2021 Vial Jean-Luc Annecy
    Contact email: vial.frjl@free.fr

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef FICHEEDITION_H_INCLUDED
#define FICHEEDITION_H_INCLUDED

#include <wx/wx.h>
#include "ProjetdeBase.h"

class FicheEdition: public wxFrame
{

public:

bool Liste_modifiee;
bool Affichage_modifie;
bool Fichier_modifie;
// Labels

// Le constructeur
    FicheEdition(wxWindow* parent,wxWindowID idfenbilanrepas,TTableau_aliments* tc,wxString* nf);
// Le destructeur
    ~FicheEdition();
private:
//---------------------------------------------------------------------------
//Données internes à la fiche
    bool taille_modifiee;
    TAliment contenu_fiche;
    typedef enum {aucune_ac,renomme,modifie,supprime,ajoute,annule} type_d_action;
    typedef enum {af_initial,af_renomme,af_modifie,af_supprime,af_ajoute,af_annule} type_d_affichage;
    type_d_affichage affichage_actif;

    struct derniere_operation_type
    {
            TAliment avant;
            type_d_action action;
    }derniere_operation;
// Le conteneur
    TTableau_aliments* conteneur_aliments;
    wxString* VersNomFichier;
        // Combobox Nom des groupes
    static const long idNomGroupes;
    wxComboBox* NomGroupes;
    void OnNomGroupes(wxCommandEvent& event);
        // Boutons
    static const long idAnnule;
    wxButton* Annule;
    void OnAnnule(wxCommandEvent& event);
    static const long idAjoute;
    wxButton* Ajoute;
    void OnAjoute(wxCommandEvent& event);
    static const long idSupprime;
    wxButton* Supprime;
    void OnSupprime(wxCommandEvent& event);
    static const long idRenomme;
    wxButton* Renomme;
    void OnRenomme(wxCommandEvent& event);
    // Labels
    static const long idLabelEffectif;
    wxStaticText* LabelEffectif;
    static const long idLabelG;
    wxStaticText* LabelG;
    static const long idLabelP;
    wxStaticText* LabelP;
    static const long idLabelL;
    wxStaticText* LabelL;
    static const long idLabelGPourcent;
    wxStaticText* LabelGPourcent;
    static const long idLabelPPourcent;
    wxStaticText* LabelPPourcent;
    static const long idLabelLPourcent;
    wxStaticText* LabelLPourcent;
    static const long idLabelEnergieEn;
    wxStaticText* LabelEnergieEn;
    static const long idLabelValeurEnergetique;
    wxStaticText* LabelValeurEnergetique;
        // Boites textes pour les saisies
    static const long idFenNomAlim;
    void OnFenNomAlim(wxCommandEvent& event);
    wxTextCtrl* FenNomAlim;
    static const long idNouvNom;
    void OnNouvNom(wxCommandEvent& event);
    wxTextCtrl* NouvNom;
    static const long idGEdit;
    void OnGEdit(wxCommandEvent& event);
    wxTextCtrl* GEdit;
    static const long idPEdit;
    void OnPEdit(wxCommandEvent& event);
    wxTextCtrl* PEdit;
    static const long idLEdit;
    void OnLEdit(wxCommandEvent& event);
    wxTextCtrl* LEdit;

    void Fixe_le_type_d_affichage(type_d_affichage tdaf);
    void Fixe_la_derniere_operation(type_d_action tdop);
    void Met_a_jour_FicheEdition(TAliment al);
    void Remplis_champs_de_saisie();
    void OnPaint(wxPaintEvent& event);
    void OnSize(wxSizeEvent& event);
    void OnQuit(wxCloseEvent& event);

    DECLARE_EVENT_TABLE()
};

#endif // FICHEEDITION_H_INCLUDED
