#include "FicheEdition.h"
#include "BoiteAOutils.h"
#include "ProjetdeBase.h"
#include "../Icones/aliments16.xpm"

//---------------------------------------------------------------------------
//Identificateurs
const long FicheEdition::idNomGroupes = wxNewId();
const long FicheEdition::idAnnule = wxNewId();
const long FicheEdition::idAjoute = wxNewId();
const long FicheEdition::idSupprime = wxNewId();
const long FicheEdition::idRenomme = wxNewId();
const long FicheEdition::idLabelEffectif= wxNewId();
const long FicheEdition::idLabelG= wxNewId();
const long FicheEdition::idLabelP= wxNewId();
const long FicheEdition::idLabelL= wxNewId();
const long FicheEdition::idLabelGPourcent= wxNewId();
const long FicheEdition::idLabelPPourcent= wxNewId();
const long FicheEdition::idLabelLPourcent= wxNewId();
const long FicheEdition::idLabelEnergieEn= wxNewId();
const long FicheEdition::idLabelValeurEnergetique= wxNewId();
const long FicheEdition::idFenNomAlim= wxNewId();
const long FicheEdition::idNouvNom= wxNewId();
const long FicheEdition::idGEdit= wxNewId();
const long FicheEdition::idPEdit= wxNewId();
const long FicheEdition::idLEdit= wxNewId();

BEGIN_EVENT_TABLE(FicheEdition, wxFrame)
    EVT_COMBOBOX(idNomGroupes, FicheEdition::OnNomGroupes)
    EVT_TEXT_ENTER(idFenNomAlim, FicheEdition::OnFenNomAlim)
    EVT_TEXT_ENTER(idNouvNom, FicheEdition::OnNouvNom)
    EVT_TEXT_ENTER(idGEdit, FicheEdition::OnGEdit)
    EVT_TEXT_ENTER(idPEdit, FicheEdition::OnPEdit)
    EVT_TEXT_ENTER(idLEdit, FicheEdition::OnLEdit)
    EVT_BUTTON(idAnnule,FicheEdition::OnAnnule)
    EVT_BUTTON(idAjoute,FicheEdition::OnAjoute)
    EVT_BUTTON(idSupprime,FicheEdition::OnSupprime)
    EVT_BUTTON(idAnnule,FicheEdition::OnAnnule)
    EVT_BUTTON(idRenomme,FicheEdition::OnRenomme)
    EVT_PAINT(FicheEdition::OnPaint)
    EVT_SIZE(FicheEdition::OnSize)
    EVT_CLOSE(FicheEdition::OnQuit)
END_EVENT_TABLE()

// Le constructeur
        FicheEdition::FicheEdition(wxWindow* parent,wxWindowID idfenbilanrepas,TTableau_aliments* tc,wxString* nf)
            :wxFrame(parent,idfenbilanrepas,wxT("Editeur d'aliments")
            ,wxPoint(300,100),wxDefaultSize,wxFULL_REPAINT_ON_RESIZE|wxDEFAULT_FRAME_STYLE)
            ,Liste_modifiee(false),Affichage_modifie(false),Fichier_modifie(true),taille_modifiee(true)
            ,conteneur_aliments(tc),VersNomFichier(nf)

{   FixeFontEtTaille(this);
    SetBackgroundColour(Couleur_Fenetres_defaut());
    wxRect taille_fen=Taille_Fenetres_defaut();
    // Propose une position à l'OS qui  ... en fait ce qu'il veut (semble respecter l'indication X, mais pas Y sous Win, mais pas sousLinux Ubuntu)
    SetPosition(wxPoint(taille_fen.GetX(),taille_fen.GetY()+taille_fen.GetHeight()));
    taille_fen.SetHeight(200);
    SetSize(taille_fen);
    SetIcon(aliments16_xpm);
    // Combobox groupes
    wxString ChoixDefaut[]={wxT("Vide")};
    NomGroupes=new wxComboBox(this,idNomGroupes,wxT(""),wxPoint(340,25),wxSize(140,25),1,ChoixDefaut,wxCB_READONLY);
    Annule=new wxButton(this,idAnnule,wxT("Annule"),wxPoint(425,95),wxSize(55,25));
    Ajoute=new wxButton(this,idAjoute,wxT("Ajoute"),wxPoint(365,95),wxSize(55,25));
    Supprime=new wxButton(this,idSupprime,wxT("Supprime"),wxPoint(305,95),wxSize(55,25));
    Renomme=new wxButton(this,idRenomme,wxT("Renomme"),wxPoint(245,95),wxSize(55,25));
    // Boites texte de saisie
    FenNomAlim=new wxTextCtrl(this,idFenNomAlim,wxT(""),wxPoint(10,25),wxSize(110,25),wxTE_PROCESS_ENTER);
    NouvNom=new wxTextCtrl(this,idNouvNom,wxT(""),wxPoint(10,95),wxSize(110,25),wxTE_PROCESS_ENTER);
    GEdit=new wxTextCtrl(this,idGEdit,wxT(""),wxPoint(140,25),wxSize(40,25),wxTE_PROCESS_ENTER);
    PEdit=new wxTextCtrl(this,idPEdit,wxT(""),wxPoint(200,25),wxSize(40,25),wxTE_PROCESS_ENTER);
    LEdit=new wxTextCtrl(this,idLEdit,wxT(""),wxPoint(260,25),wxSize(40,25),wxTE_PROCESS_ENTER);
    // Labels
    LabelEffectif=new wxStaticText(this,idLabelEffectif,wxT("Effectif"),wxPoint(5,80),wxSize(200,15),wxST_NO_AUTORESIZE);
    LabelG=new wxStaticText(this,idLabelG,wxT("P"),wxPoint(150,5),wxSize(40,15),wxST_NO_AUTORESIZE|wxALIGN_CENTRE);
    LabelP=new wxStaticText(this,idLabelP,wxT("G"),wxPoint(210,5),wxSize(40,15),wxST_NO_AUTORESIZE|wxALIGN_CENTRE);
    LabelL=new wxStaticText(this,idLabelL,wxT("L"),wxPoint(270,5),wxSize(40,15),wxST_NO_AUTORESIZE|wxALIGN_CENTRE);
    LabelGPourcent=new wxStaticText(this,idLabelGPourcent,wxT("P%"),wxPoint(145,55),wxSize(40,20),wxST_NO_AUTORESIZE|wxALIGN_CENTRE);
    LabelPPourcent=new wxStaticText(this,idLabelPPourcent,wxT("G%"),wxPoint(205,55),wxSize(40,20),wxST_NO_AUTORESIZE|wxALIGN_CENTRE);
    LabelLPourcent=new wxStaticText(this,idLabelLPourcent,wxT("L%"),wxPoint(265,55),wxSize(40,20),wxST_NO_AUTORESIZE|wxALIGN_CENTRE);
    LabelEnergieEn=new wxStaticText(this,idLabelEnergieEn,wxT("Pourcentage de "),wxPoint(10,55),wxSize(120,20),wxST_NO_AUTORESIZE);
    LabelValeurEnergetique=new wxStaticText(this,idLabelValeurEnergetique,wxT("Valeur énergétique"),wxPoint(320,55),wxSize(160,20),wxST_NO_AUTORESIZE);
    affichage_actif=af_initial;
}
// Le destructeur
FicheEdition::~FicheEdition(){};

//---------------------------------------------------------------------------
void FicheEdition::Fixe_le_type_d_affichage(type_d_affichage tdaf)
{
    affichage_actif=tdaf;
    Affichage_modifie=true;
    Liste_modifiee=true;
    Refresh();
    Update();
}
//---------------------------------------------------------------------------
void FicheEdition::Fixe_la_derniere_operation(type_d_action tdop)
{
    derniere_operation.action=tdop;
    derniere_operation.avant=contenu_fiche;
}
//---------------------------------------------------------------------------
void FicheEdition::Remplis_champs_de_saisie()
{
    NomGroupes->SetSelection(contenu_fiche.groupe());
    FenNomAlim->Clear();
    FenNomAlim->AppendText(contenu_fiche.nom());
    GEdit->Clear();GEdit->AppendText(wxString::Format(wxT("%4.1f"),contenu_fiche.g()));
    PEdit->Clear();PEdit->AppendText(wxString::Format(wxT("%4.1f"),contenu_fiche.p()));
    LEdit->Clear();LEdit->AppendText(wxString::Format(wxT("%4.1f"),contenu_fiche.l()));
}
//---------------------------------------------------------------------------
void FicheEdition::Met_a_jour_FicheEdition(TAliment al)
{

    Traducteur tr;
    Tgroupes groupes;
        // Traduit la combobox
    if (NomGroupes->GetString(0)==wxT("Vide")||(NomGroupes->GetString(0)!=tr.trad(groupes.nom(al_protidiques))))
    {
        NomGroupes->Clear();
        for (groupe_d_aliment i=al_protidiques;i<=tous_les_groupes;i=suivant(i))
            NomGroupes->Append(groupes.nom(i));
        NomGroupes->SetSelection(al.groupe());
    }
    if (Affichage_modifie)
    {
        // Mise à jour des champs de commentaire
        //LabelEnergieEn->SetLabel(tr.trad(wxT("Pourcentage de "))+tr.trad(al.pourcent_en()));
        //LabelValeurEnergetique->SetLabel(tr.trad(wxT("Valeur énergétique"))+wxT(" ")+wxString::Format(wxT(" %4.1f"),al.energie())+al.unite_energie());
        FenNomAlim->Clear();
        FenNomAlim->AppendText(al.nom());
        LabelEffectif->SetLabel(*VersNomFichier+tr.trad(wxT(" contient "))+wxString::Format(wxT("%4li"),(long)conteneur_aliments->size())+TAB+tr.trad(wxT("Aliments")));
        LabelG->SetLabel(tr.trad(wxT("Glucides")).Left(3));
        LabelP->SetLabel(tr.trad(wxT("Protides")).Left(3));
        LabelL->SetLabel(tr.trad(wxT("Lipides")).Left(3));
        //LabelGPourcent->SetLabel(wxString::Format(wxT("%04.1f"),al.g_pourcent())+wxT(" %"));
        //LabelPPourcent->SetLabel(wxString::Format(wxT("%04.1f"),al.p_pourcent())+wxT(" %"));
        //LabelLPourcent->SetLabel(wxString::Format(wxT("%04.1f"),al.l_pourcent())+wxT(" %"));
        // choix des contrôles activés
        FenNomAlim->Enable(affichage_actif!=af_renomme);
        NouvNom->Enable(affichage_actif==af_renomme);
        Annule->Enable(Liste_modifiee&&(derniere_operation.action!=aucune_ac));
        Supprime->Enable(affichage_actif==af_initial);
        Renomme->Enable(affichage_actif==af_initial);
        Ajoute->Enable(affichage_actif==af_ajoute);
        GEdit->Enable(affichage_actif!=af_ajoute);
        PEdit->Enable(affichage_actif!=af_ajoute);
        LEdit->Enable(affichage_actif!=af_ajoute);
        NomGroupes->Enable(affichage_actif!=af_ajoute);
    }
}
//---------------------------------------------------------------------------
void FicheEdition::OnSize(wxSizeEvent& event)
{
    taille_modifiee=true;
}
//---------------------------------------------------------------------------
void FicheEdition::OnPaint(wxPaintEvent& event)
{
    Traducteur tr;
    wxPaintDC dc(this);
    // Ajuste la taille des contrôles
    // teste "inconnu" pour un contenu fiche encore vierge
    // teste le chargement d'un nouveau fichier d'aliment entre deux éditions
    if ((contenu_fiche.nom()==wxT("Inconnu"))||(Fichier_modifie))
        {
        Fichier_modifie=false;
        Affichage_modifie=true;
        affichage_actif=af_initial;
        contenu_fiche.Aliment_nomme=(*conteneur_aliments->begin());
        Fixe_la_derniere_operation(aucune_ac);
        Remplis_champs_de_saisie();
        }
    Met_a_jour_FicheEdition(contenu_fiche);
    if (Affichage_modifie)
        {
        Affichage_modifie=false;
        Remplis_champs_de_saisie();
        firstwin()->Refresh();
        }
    if (taille_modifiee)
        {// paramètres d'affichage
        taille_modifiee=false;
        int labx(20),ecart(140),laby(30),pasy(180),h_text(pasy-laby),l_text(ecart-labx);
        int ligne(0),tabul(0);
        wxSize taille1(l_text,h_text),taille2(l_text*2,h_text),taille3(l_text*2.5,h_text);
        //première ligne
        tabul++;tabul++;
        Ajuste_taille_et_pos(wxPoint(labx+ecart*(tabul++),laby+ (ligne  )*pasy),taille1,this,LabelG);
        Ajuste_taille_et_pos(wxPoint(labx+ecart*(tabul++),laby+ (ligne  )*pasy),taille1,this,LabelP);
        Ajuste_taille_et_pos(wxPoint(labx+ecart*(tabul  ),laby+ (ligne  )*pasy),taille1,this,LabelL);
        tabul=0;ligne++;//Deuxième ligne
        Ajuste_taille_et_pos(wxPoint(labx+ecart*(tabul++),laby+ (ligne)*pasy),taille2,this,FenNomAlim);tabul++;
        Ajuste_taille_et_pos(wxPoint(labx+ecart*(tabul++),laby+ (ligne  )*pasy),taille1,this,GEdit);
        Ajuste_taille_et_pos(wxPoint(labx+ecart*(tabul++),laby+ (ligne  )*pasy),taille1,this,PEdit);
        Ajuste_taille_et_pos(wxPoint(labx+ecart*(tabul++),laby+ (ligne  )*pasy),taille1,this,LEdit);
        Ajuste_taille_et_pos(wxPoint(labx+ecart*(tabul  ),laby+ (ligne  )*pasy),taille2,this,NomGroupes);
        tabul=0;ligne++;//Troisième ligne
        Ajuste_taille_et_pos(wxPoint(labx+ecart*(tabul++),laby+ (ligne  )*pasy),taille3,this,LabelEnergieEn);tabul++;
        Ajuste_taille_et_pos(wxPoint(labx+ecart*(tabul++),laby+ (ligne  )*pasy),taille1,this,LabelGPourcent);
        Ajuste_taille_et_pos(wxPoint(labx+ecart*(tabul++),laby+ (ligne  )*pasy),taille1,this,LabelPPourcent);
        Ajuste_taille_et_pos(wxPoint(labx+ecart*(tabul++),laby+ (ligne  )*pasy),taille1,this,LabelLPourcent);
        Ajuste_taille_et_pos(wxPoint(labx+ecart*(tabul  ),laby+ (ligne  )*pasy),taille2,this,LabelValeurEnergetique);
        tabul=0;ligne++;//Quatrième ligne
        Ajuste_taille_et_pos(wxPoint(labx+ecart*(tabul++),laby+ (ligne  )*pasy),taille2,this,NouvNom);tabul++;
        Ajuste_taille_et_pos(wxPoint(labx+ecart*(tabul++),laby+ (ligne  )*pasy),taille1,this,Ajoute);
        Ajuste_taille_et_pos(wxPoint(labx+ecart*(tabul++),laby+ (ligne  )*pasy),taille1,this,Supprime);
        Ajuste_taille_et_pos(wxPoint(labx+ecart*(tabul++),laby+ (ligne  )*pasy),taille1,this,Renomme);
        Ajuste_taille_et_pos(wxPoint(labx+ecart*(tabul  ),laby+ (ligne  )*pasy),taille1,this,Annule);
        tabul=0;ligne++;//Cinquième ligne
        Ajuste_taille_et_pos(wxPoint(labx+ecart*(tabul++),laby+ (ligne)*pasy),taille3,this,LabelEffectif);
        }
}
//---------------------------------------------------------------------------
void FicheEdition::OnQuit(wxCloseEvent& event)
{
    Fixe_la_derniere_operation(aucune_ac);
    Fixe_le_type_d_affichage(af_initial);
    //MakeModal(false);
    firstwin()->Enable();
    firstwin()->Refresh();
    Hide();
}
//---------------------------------------------------------------------------
void  FicheEdition::OnAnnule(wxCommandEvent& event)
{
        TAliment_nomme al=derniere_operation.avant.Aliment_nomme;
        switch (derniere_operation.action)
        {
            case modifie:   {conteneur_aliments->operator [](al.first)=al.second;
                            contenu_fiche=TAliment(al);
                            break;};
            case renomme :  {conteneur_aliments->erase(contenu_fiche.nom());}
            case supprime:  {conteneur_aliments->insert(al);
                            contenu_fiche=TAliment(al);
                            break;}
            case ajoute:    {conteneur_aliments->erase(al.first);
                            contenu_fiche.nom()=wxT("Inconnu");
                            break;}
            default:        {};
         }
         Fixe_la_derniere_operation(aucune_ac);
         Fixe_le_type_d_affichage(af_initial);
}
//---------------------------------------------------------------------------
void FicheEdition::OnNomGroupes(wxCommandEvent& event)
{
        Fixe_la_derniere_operation(modifie);
        groupe_d_aliment gr=groupe_d_aliment(NomGroupes->GetSelection());
        contenu_fiche.groupe()=gr;
        Tmapiter al=conteneur_aliments->find(contenu_fiche.nom());
        al->second.groupeval()=contenu_fiche.groupe();
        Fixe_le_type_d_affichage(af_modifie);
}
//---------------------------------------------------------------------------
void  FicheEdition::OnAjoute(wxCommandEvent& event)
{
        Fixe_la_derniere_operation(ajoute);
        contenu_fiche.Qte()=100;
        conteneur_aliments->insert(contenu_fiche.Aliment_nomme);
        Fixe_le_type_d_affichage(af_initial);
}
//---------------------------------------------------------------------------
void  FicheEdition::OnSupprime(wxCommandEvent& event)
{
        Fixe_la_derniere_operation(aucune_ac);
        wxString Nom_saisi=FenNomAlim->GetLineText(0);
        if (conteneur_aliments->erase(Nom_saisi))
            {
            derniere_operation.action=supprime;
            contenu_fiche.nom()=wxT("Inconnu");
            Fixe_le_type_d_affichage(af_modifie);
            }
}
//---------------------------------------------------------------------------
void  FicheEdition::OnRenomme(wxCommandEvent& event)
{
        Traducteur tr;
        wxString Nom_saisi=FenNomAlim->GetLineText(0);
        NouvNom->Clear();
        NouvNom->AppendText(Nom_saisi);
        Fixe_le_type_d_affichage(af_renomme);
}
//---------------------------------------------------------------------------
void  FicheEdition::OnFenNomAlim(wxCommandEvent& event)
{
        wxString Nom_saisi=FenNomAlim->GetLineText(0).Trim().MakeCapitalized();
        Tmapiter al=conteneur_aliments->find(Nom_saisi);
        if( al!=conteneur_aliments->end())
            {Fixe_la_derniere_operation(aucune_ac);
             contenu_fiche.Aliment_nomme=*al;
             Fixe_le_type_d_affichage(af_initial);
            }
        else
            {Fixe_la_derniere_operation(modifie);
            if (Nom_saisi!=wxT(""))
                {
                contenu_fiche.nom()=Nom_saisi;
                Fixe_le_type_d_affichage(af_ajoute);
                }
            }
}
//---------------------------------------------------------------------------
void  FicheEdition::OnNouvNom(wxCommandEvent& event)
{
        wxString Nom_saisi=FenNomAlim->GetLineText(0);
        wxString Nouveau=NouvNom->GetLineText(0).Trim().MakeCapitalized();
        Traducteur tr;
        if (conteneur_aliments->find(Nouveau)==conteneur_aliments->end()&&Nouveau.Len()!=0)
            {
            Fixe_la_derniere_operation(renomme);
            Tmapiter al=conteneur_aliments->find(Nom_saisi);
            conteneur_aliments->erase(al);
            contenu_fiche.nom()=Nouveau;
            conteneur_aliments->insert(contenu_fiche.Aliment_nomme);
            Fixe_le_type_d_affichage(af_modifie);
            }
        else
            {
            wxMessageBox(tr.trad(wxT("Impossible! existe déjà!")).c_str());
            Fixe_le_type_d_affichage(af_initial);
            }
}
//---------------------------------------------------------------------------
void  FicheEdition::OnGEdit(wxCommandEvent& event)
{
        wxString ValSais=GEdit->GetLineText(0);
        double v;
        if(ValSais.ToDouble(&v))
            {
            Fixe_la_derniere_operation(modifie);
            double d=contenu_fiche.poids_sec()-contenu_fiche.g()+v-100;
            contenu_fiche.g()=(d<0?v:v-d);
            Tmapiter al=conteneur_aliments->find(contenu_fiche.nom());
            al->second.Gval()=contenu_fiche.g();
            Fixe_le_type_d_affichage(af_modifie);
            }
        else
            Fixe_le_type_d_affichage(af_initial);
}
//---------------------------------------------------------------------------
void  FicheEdition::OnPEdit(wxCommandEvent& event)
{
        wxString ValSais=PEdit->GetLineText(0);
        double v;
        if(ValSais.ToDouble(&v))
            {
            Fixe_la_derniere_operation(modifie);
            double d=contenu_fiche.poids_sec()-contenu_fiche.p()+v-100;
            contenu_fiche.p()=(d<0?v:v-d);
            Tmapiter al=conteneur_aliments->find(contenu_fiche.nom());
            al->second.Pval()=contenu_fiche.p();
            Fixe_le_type_d_affichage(af_modifie);
            }
        else
            Fixe_le_type_d_affichage(af_initial);
}
//---------------------------------------------------------------------------
void  FicheEdition::OnLEdit(wxCommandEvent& event)
{
        wxString ValSais=LEdit->GetLineText(0);
        double v;
        if(ValSais.ToDouble(&v))
            {
            Fixe_la_derniere_operation(modifie);
            double d=contenu_fiche.poids_sec()-contenu_fiche.l()+v-100;
            contenu_fiche.l()=(d<0?v:v-d);
            Tmapiter al=conteneur_aliments->find(contenu_fiche.nom());
            al->second.Lval()=contenu_fiche.l();
            Fixe_le_type_d_affichage(af_modifie);
            }
        else
            Fixe_le_type_d_affichage(af_initial);
}
