#include "ProjetdeBase.h"
#include "Dessin.h"
// Assure la compatibilité avec la version 2.8 de wxWidgets. A faire sauter ultérieurement
#if !wxCHECK_VERSION(2,9,0)
    #define wxPENSTYLE_SOLID wxSOLID
    #define wxPENSTYLE_DOT wxDOT
    #define wxPENSTYLE_LONG_DASH wxLONG_DASH
    #define wxBRUSHSTYLE_TRANSPARENT wxTRANSPARENT
    #define wxBRUSHSTYLE_SOLID wxSOLID
#endif
//---------------------------------------------------------------------------
class TSprite
        {
        public:
        wxPoint pos;
        Tformes forme;
        TSprite();
        TSprite(const TSprite &sp);
        TSprite(Tformes f,wxPoint p);
        TSprite& operator=(const TSprite &sp);
        };

        TSprite::TSprite()
        {
        forme=aucune;
        }
        TSprite::TSprite(const TSprite &sp)
        {
        *this=sp;
        }
        TSprite::TSprite(Tformes f,wxPoint p)
        {
        forme=f;
        pos=p;
        }
        TSprite& TSprite::operator=(const TSprite &sp)
        {
        forme=sp.forme;
        pos=sp.pos;
        return *this;
        }
//---------------------------------------------------------------------------
//      Objet Triangle de Dessin
//---------------------------------------------------------------------------
class   Triangle
{
        double Pi,Racine_de_3;
        vecteur rot30,rot60,rot120,centre, cote,origine;
        std::vector<wxString> titres;
        void trace_un_tiers(const vecteur& vc,const vecteur& vb,vecteur offset,wxColour couleur,wxDC& dc);
        void titre_triangle(wxDC& dc);
        Tgraphique* canvas_actif;
public:
        Triangle(Tgraphique* g,wxPoint co,wxPoint ce,wxString t1,wxString t2,wxString t3);
        void trace_triangle(const vecteur& offset,wxColour couleur,wxDC& dc);
        wxPoint Coordonnees_absolues(double coordTri_G,double coordTri_L);

};
//---------------------------------------------------------------------------
        Triangle::Triangle(Tgraphique* g,wxPoint co, wxPoint ce,wxString t1,wxString t2,wxString t3):
            Pi(3.1415927),
            Racine_de_3(1.7320508),
            rot30(std::polar(1.0,Pi/6.0)),
            rot60(std::polar(1.0,Pi/3.0)),
            rot120(std::polar(1.0,2*Pi/3.0)),
            centre(vecteur(ce.x,ce.y)),
            cote(vecteur(co.x,co.y)),
            origine(centre-(cote/rot30)/Racine_de_3),
            canvas_actif(g)
        {
        titres.push_back(t1);
        titres.push_back(t2);
        titres.push_back(t3);
        }
//---------------------------------------------------------------------------
        void Triangle::trace_triangle(const vecteur& offset,wxColour couleur,wxDC& dc)
        {vecteur vcote,vbase;
        vcote=cote/double(10);
        vbase=vcote;
        vcote/=rot60;
        vecteur origine_anc=origine;
        for (int i=0;i<3;++i)
                {trace_un_tiers(vcote,vbase,offset,couleur,dc);
                vbase*=rot120;
                vcote*=rot120;
                origine=(origine-centre)*rot120+centre;
                }
        origine=origine_anc;
        titre_triangle(dc);
        }
//---------------------------------------------------------------------------
        void Triangle::trace_un_tiers(const vecteur& vc,const vecteur& vb,vecteur offset,wxColour couleur,wxDC& dc)
        {
        vecteur gauche,droite;
        dc.SetPen(wxPen(couleur,1,wxPENSTYLE_SOLID));
        for (double i=0;i<10;++i)
                {
                gauche=origine+(vc*i);
                droite=gauche+(10-i)*vb;
                dc.DrawLine(wxCoord(gauche.real()+offset.real()),wxCoord(gauche.imag()+offset.imag()),wxCoord(droite.real()+offset.real()),wxCoord(droite.imag()+offset.imag()));
                }
        }
//---------------------------------------------------------------------------
        wxPoint Triangle::Coordonnees_absolues(double coordTri_G,double coordTri_L)
        {vecteur vcote=cote/double(10),vbase=vcote,resultat;
        vcote/=rot60;
        resultat=origine+vcote*coordTri_G/double(10) +vbase*coordTri_L/double(10);
        return wxPoint(int(resultat.real()),int(resultat.imag()));
        }
//---------------------------------------------------------------------------
        void Triangle::titre_triangle(wxDC& dc)
        {
        wxPoint p1;
        std::vector<wxPoint> decalage;
        float L_text=dc.GetTextExtent(titres[2]).GetWidth();
        float H_text=dc.GetTextExtent(titres[2]).GetHeight();
        p1=Coordonnees_absolues(100,0);
        p1.y-=int(canvas_actif->val_pas(dc)+H_text);
        decalage.push_back(p1);
        p1=Coordonnees_absolues(0,100);
        p1.x+=int(canvas_actif->val_pas(dc)-L_text/2);
        p1.y+=int(H_text/3);
        decalage.push_back(p1);
        p1=Coordonnees_absolues(0,0);
        p1.x-=int(L_text/2+ canvas_actif->val_pas(dc));
        p1.y+=int(H_text/3);
        decalage.push_back(p1);
        for (int i=0;i<3;++i)
                dc.DrawText(titres[i],decalage[i].x,decalage[i].y);
        }
//---------------------------------------------------------------------------
//      Fin de triangle de Dessin
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
//      Implémentation de l'objet Tgraphique
//---------------------------------------------------------------------------

BEGIN_EVENT_TABLE(Tgraphique, wxWindow)
EVT_PAINT(Tgraphique::OnPaint)
END_EVENT_TABLE()

        //---------------------------------------------------------------------------
        // Constructeur objet TGaphique
        Tgraphique::Tgraphique(wxWindow* parent,wxWindowID id,wxPoint pos,wxSize taille,wxString tip):wxWindow(parent,id,pos,taille,wxFULL_REPAINT_ON_RESIZE|wxBORDER_SUNKEN),
        EstImpression(false)
        {
        SetToolTip(tip);
        }
        //---------------------------------------------------------------------------
        void Tgraphique::OnPaint(wxPaintEvent& WXUNUSED(event))
        {
        wxPaintDC dc(this);
        Dessine_ardoise(dc,1.0);
        }
//---------------------------------------------------------------------------
        float Tgraphique::val_pas(wxDC& dc) // utilise la taille de la fenêtre d'affichage imprimante ou écran)
                {
                double scx,scy;
                dc.GetUserScale(&scx,&scy);
                return(dc.GetSize().GetWidth()/(60.0*scx));
                }
//---------------------------------------------------------------------------
        void    Tgraphique::dessine_forme(TSprite spr,wxDC& dc)
        {
        PalettePerso p;
        int pas=int(val_pas(dc));
        wxPoint p1;
        p1=spr.pos;
        dc.SetPen(wxPen(*wxWHITE,1,wxPENSTYLE_SOLID));
        switch (spr.forme)
                {case cible:
                        {
                        dc.SetBrush(wxBrush(*wxRED,wxBRUSHSTYLE_SOLID));
                        dc.DrawEllipse(p1.x-pas,p1.y-pas,2*pas,2*pas);break;
                        }
                case aliment:
                        {
                        dc.SetBrush(wxBrush(*wxGREEN,wxBRUSHSTYLE_SOLID));
                        dc.DrawEllipse(p1.x-pas,p1.y-pas,2*pas,2*pas);break;
                        }
                case repas:
                        {
                         dc.SetBrush(wxBrush(p.clLtGray,wxBRUSHSTYLE_SOLID));
                         dc.DrawEllipse(p1.x-pas,p1.y-pas,2*pas,2*pas);break;
                        }
                case actif:
                        {
                        dc.SetBrush(wxBrush(p.clLime,wxBRUSHSTYLE_SOLID));
                        dc.DrawEllipse(p1.x-pas,p1.y-pas,2*pas,2*pas);break;
                        }
                case curseur:
                        {
                         pas*=2;
                         dc.SetBrush(wxBrush(p.clYellow,wxBRUSHSTYLE_SOLID));
                         dc.DrawEllipse(p1.x-pas,p1.y-pas,2*pas,2*pas);
                         pas=int(val_pas(dc));
                         dc.SetBrush(wxBrush(p.clBlack,wxBRUSHSTYLE_SOLID));
                         dc.DrawEllipse(p1.x-pas,p1.y-pas,2*pas,2*pas);
                         dc.SetBrush(wxBrush(p.clLtGray,wxBRUSHSTYLE_SOLID));
                        }
                default: ;//wxMessageBox(wxT("pas de forme"));
                }
        }
//---------------------------------------------------------------------------
        void Tgraphique::efface_ardoise(wxDC& dc)
                {PalettePerso p;
                dc.SetBackground(wxBrush((EstImpression?*wxWHITE:p.clLtGray),wxBRUSHSTYLE_SOLID));
                dc.Clear();
                }
//---------------------------------------------------------------------------
        void Tgraphique::Dessine_ardoise(wxDC& dc,float correctif)
        {
        PalettePerso p;
        float pas=val_pas(dc);
        fixe_taille_police(dc,correctif);
        Traducteur tr;
        wxPoint p1,p2;
        efface_ardoise(dc);
        wxPoint cote(int(pas*46),0),centre(int(pas*30),int(pas*32));
        Triangle tri(this,cote,centre,tr.trad(wxT("Glucides")),tr.trad(wxT("Lipides")),tr.trad(wxT("Protides")));
        // Tracé double pour effet d'ombrage
        tri.trace_triangle(vecteur(1,1),p.clDkGray,dc);
        // tracé simple en cas d'impression
        if(!EstImpression)
            tri.trace_triangle(vecteur(0,0),*wxWHITE,dc);
        if (!Menu_en_cours().empty())
                {for (Tmapiter i=Menu_en_cours().begin();i!=Menu_en_cours().end();++i)
                        {TAliment al;
                        al.Aliment_nomme=*i;
                        if (al.Qte()>0)
                                place_aliment(aliment,al,tri,dc);
                        }
                p1=tri.Coordonnees_absolues(al_repas().g_pourcent(),al_repas().l_pourcent());
                p2=tri.Coordonnees_absolues(al_courant().g_pourcent(),al_courant().l_pourcent());
                dc.SetPen(wxPen(p.clDkGray,2,wxPENSTYLE_SOLID));
                dc.DrawLine(p1.x,p1.y,p2.x,p2.y);
                place_aliment(curseur,al_curseur(),tri,dc);
                place_aliment(actif,al_courant(),tri,dc);
                place_aliment(repas,al_repas(),tri,dc);
                place_aliment(cible,al_cible(),tri,dc);
                }
        }
//---------------------------------------------------------------------------
        void Tgraphique::place_aliment(Tformes f,TAliment al,Triangle T,wxDC& dc)
        {wxPoint p;
        TSprite s(f,T.Coordonnees_absolues(al.g_pourcent(),al.l_pourcent()));
        if (al.Qte()>0.1) dessine_forme(s,dc);
        }
//---------------------------------------------------------------------------
//      Fin de l'objet Tgraphique
//---------------------------------------------------------------------------
