#ifndef BOITEAOUTILS_H_INCLUDED
#define BOITEAOUTILS_H_INCLUDED
/*
    Aliments permet une représentation graphique de l'équilibre GPL d'une ration alimentaire.
    Copyright (C) 1994 (version Dos) 2009-2021 Vial Jean-Luc Annecy
    Contact email: vial.frjl@free.fr

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <vector>
#include <map>
#include <complex> // à cause de "vecteur"
#include <wx/string.h>
#include <wx/wx.h>
#include <wx/print.h>
//---------------------------------------------------------------------------
// Déclaration du Printout utilisé
class BasePrintout: public wxPrintout
{
public:
    explicit BasePrintout(const wxChar *title);
    float correctif_preview();
    void FixeFontEtTaille();
    void OnPreparePrinting();
};
//---------------------------------------------------------------------------
typedef std::complex<double>  vecteur;
//---------------------------------------------------------------------------
// Utilitaires divers
template<class Te> Te suivant(Te m)
{
        return (Te(int(m)+1));
};
//---------------------------------------------------------------------------
// Émulation de la fonction RandomRange
// retourne un entier dans l'intervalle [low, High[
int RandomRange_bis(int low,int high);
//---------------------------------------------------------------------------

        template<class T> T brasse(T a_brasser)
        // Bug RandomRange corrigé (retourne des valeurs dans [min,max[
        //au lieu de [min,]max comme indiqué dans la documentation
        {typename T::value_type v;
        int nb_elements=a_brasser.size();
        srand((unsigned)time(NULL));
        if (nb_elements)
                {
                for (int i=0;i<nb_elements;i++)
                        {
                        int tirage=RandomRange_bis(i,nb_elements);
                        v=a_brasser[i];
                        a_brasser[i]=a_brasser[tirage];
                        a_brasser[tirage]=v;
                        }
                }
        return a_brasser;
        }
//---------------------------------------------------------------------------
        void RenommeEnfants(wxWindow* Sujet);
//---------------------------------------------------------------------------
// Traducteur
//---------------------------------------------------------------------------
        typedef enum {fr,ang,esp}langues;
        class Traducteur
{
        typedef std::map<langues,wxString> Dictionnaire;
        std::map<wxString,Dictionnaire>textes;
        void ajoute_une_entree(wxString Tf,wxString Ta,wxString Te);
public:
        Traducteur();
        void langue_demarrage();
        langues& fixe_langue();
        wxString trad(wxString T);
        wxString trad_tout(wxString T);
};
//---------------------------------------------------------------------------
// Paramètres globaux
// Taille et couleur par défaut des fenêtres
        wxColor& Couleur_Fenetres_defaut();
        wxRect& Taille_Fenetres_defaut();
        void FixeFontEtTaille(wxWindow* fen);
        class PalettePerso
{
public:
        PalettePerso();
        wxColour clDkGray,clCream,clAqua,clLtGray,clRed,clBlack,clYellow,clLime;
};
//---------------------------------------------------------------------------
//      Ajuste la taille de la police à celle de la fenêtre courante
void fixe_taille_police(wxDC& dc,float correctif);
void Base_Tabule_ecrit(wxDC* dc,wxString st,wxPoint pos);
//---------------------------------------------------------------------------
// Conversion taille et position virtuelle sur une grille 1000 x 1000 en taille réelle sur la fenêtre
        wxPoint FaitReelle_Pos(wxPoint posvirtuelle,wxWindow* fen);
        wxSize FaitReelle_Taille(wxSize Sizevirtuelle,wxWindow* fen);
        void Ajuste_taille_et_pos(wxPoint pos,wxSize taille,wxWindow* fen_mere,wxWindow* fen_fille);

const wxString LF=wxT("\n");
const wxString TAB(wxChar(9));
//---------------------------------------------------------------------------

#endif //BOITEAOUTILS_H_INCLUDED
