#include "BoiteAOutils.h"
#include <wx/intl.h>
#include <wx/tooltip.h>
//---------------------------------------------------------------------------
// Gestion des impressions
//---------------------------------------------------------------------------
// Implémentation du Printout minimal
BasePrintout::BasePrintout(const wxChar *title = wxT("My printout")):wxPrintout(title){}
//---------------------------------------------------------------------------
float BasePrintout::correctif_preview()
{
    // Correctif pitoyable mais je n'ai pas trouvé mieux pour le moment
    #if defined(__WXMSW__)
    return (IsPreview()?1.7:1.6);
    #elif defined(__UNIX__)
    return(IsPreview()?2.0:2.4);
    #endif
}
//---------------------------------------------------------------------------
void BasePrintout::FixeFontEtTaille()
{
    wxDC *dc = GetDC();
    if (dc)
    {
    // la police est mise à l'échelle lors de l'impression
    // cela tient compte des différences de définition entre l'écran et la page imprimée
    // ainsi que de la différence de taille entre les deux.
    dc->SetFont(wxFont(10,wxFONTFAMILY_DEFAULT,wxFONTSTYLE_ITALIC,wxFONTWEIGHT_NORMAL,false));
    // le bloc suivant peut être remplacé par l'instruction MapScreenSizeToPage()
    // mais le résultat semble moins précis
    int ppiScreenX, ppiScreenY;
    GetPPIScreen(&ppiScreenX, &ppiScreenY);
    int ppiPrinterX, ppiPrinterY;
    GetPPIPrinter(&ppiPrinterX, &ppiPrinterY);
    float scale = (float)((float)ppiPrinterX/(float)ppiScreenX);
    int pageWidth, pageHeight;
    int w, h;
    dc->GetSize(&w, &h);
    GetPageSizePixels(&pageWidth,&pageHeight);
    float overallScale =scale*(float)(w/(float)pageWidth);
    dc->SetUserScale(overallScale, overallScale);
    // Fin du bloc
    }
}
//---------------------------------------------------------------------------
void BasePrintout::OnPreparePrinting()
{
    FixeFontEtTaille();
}
//---------------------------------------------------------------------------
// Fin gestion impression
//---------------------------------------------------------------------------
// Émulation de la fonction RandomRange
// retourne un entier dans l'intervalle [low, High[
int RandomRange_bis(int low,int high)
{
        if (high <low) high=low;
        return (rand() % (high-low))+low;
}
//---------------------------------------------------------------------------
//      Implémentation de l'objet Traducteur
//---------------------------------------------------------------------------
        void Traducteur::ajoute_une_entree(wxString Tf,wxString Ta,wxString Te)
{
        Dictionnaire di;
        di.insert(std::make_pair(ang,Ta));
        di.insert(std::make_pair(esp,Te));
        textes.insert(std::make_pair(Tf,di));
}
//---------------------------------------------------------------------------
        Traducteur::Traducteur()
{
        ajoute_une_entree(wxT(" contient "),wxT("  of  "),wxT("contiene"));
        ajoute_une_entree(wxT(" la quantité de l'aliment choisi"),wxT(" the quantity of the selected food"),wxT("la cantidad de la comida elegida"));
        ajoute_une_entree(wxT("3 mars 1997 / mars 24"),wxT("3 Mar 1997 / Mar 2024"),wxT("3 marzo 1997 / marzo 2024"));
        ajoute_une_entree(wxT("A propos"),wxT("About Aliments"),wxT("Acerca de Aliments"));
        ajoute_une_entree(wxT("Aide"),wxT("Help"),wxT("Ayuda"));
        ajoute_une_entree(wxT("Ajoute"),wxT("Add"),wxT("Añade"));
        ajoute_une_entree(wxT("Ajuste"),wxT("Adjust"),wxT("Ajusta"));
        ajoute_une_entree(wxT("Aliments disponibles"),wxT("Available foods"),wxT("Alimentos disponibles"));
        ajoute_une_entree(wxT("aliments protidiques"),wxT("Meat & Meat alternative"),wxT("Alimentos proteicos"));
        ajoute_une_entree(wxT("Aliments"),wxT("Foods"),wxT("Alimentos"));
        ajoute_une_entree(wxT("alimentsfrahlp"),wxT("alimentsenghlp"),wxT("alimentsesphlp"));
        ajoute_une_entree(wxT("Annule"),wxT("Cancel"),wxT("Cancela"));
        ajoute_une_entree(wxT("Avertissement"),wxT("Disclaimer"),wxT("Advertencia"));
        ajoute_une_entree(wxT("Bilan repas"),wxT("Meal balance"),wxT("Equilibrio de la comida"));
        ajoute_une_entree(wxT("Ce fichier est récupéré de l'ancien format. Enregistrez le sous un nouveau nom si vous voulez conservez l'original"),wxT("This file have been translated from an older format. Save it under a new name to keep both versions"),wxT("Este archivo ha sido recuperado de uno previo formato. Guardalo con un nuevo nombre"));
        ajoute_une_entree(wxT("Choisit"),wxT("Choose"),wxT("Elige"));
        ajoute_une_entree(wxT("corps gras"),wxT("fat"),wxT("Aceites y grasas"));
        ajoute_une_entree(wxT("crudités"),wxT("fruits"),wxT("Fruta"));
        ajoute_une_entree(wxT("cuidités"),wxT("vegetables"),wxT("Hortalizas y verduras"));
        ajoute_une_entree(wxT("defaut"),wxT("default"),wxT("afalta"));
        ajoute_une_entree(wxT("DisclaimimageFra.png"),wxT("DisclaimimageEng.png"),wxT("DisclaimimageEsp.png"));
        ajoute_une_entree(wxT("Editeur d'aliments"),wxT("Foods manager"),wxT("Modificaciones de los alimentos"));
        ajoute_une_entree(wxT("énergie en "),wxT("energy unit "),wxT("Unidad de energía"));
        ajoute_une_entree(wxT("énergie"),wxT("energy"),wxT("energía"));
        ajoute_une_entree(wxT("Enregistrer sous..."),wxT("Save as..."),wxT("Almacenar como..."));
        ajoute_une_entree(wxT("Enregistrer"),wxT("Save"),wxT("Almacenar"));
        ajoute_une_entree(wxT("Equilibre"),wxT("Balance"),wxT("Equilibrio"));
        ajoute_une_entree(wxT("État du menu en cours"),wxT("Current meal's state"),wxT("Corriente comida"));
        ajoute_une_entree(wxT("féculents"),wxT("Grain, bread & cereals"),wxT("Cereales"));
        ajoute_une_entree(wxT("Fermer"),wxT("Close"),wxT("Cerrar"));
        ajoute_une_entree(wxT("Fichier d'aide non trouvé\n"),wxT("Help file not found\n"),wxT("Ayuda no encontrada"));
        ajoute_une_entree(wxT("Fichier d'aliment : "),wxT("Foods' file : "),wxT("Archivo de alimento"));
        ajoute_une_entree(wxT("Fichiers d'aliments"),wxT("Foods' files"),wxT("Archivos de alimentos"));
        ajoute_une_entree(wxT("Fichiers"),wxT("Files"),wxT("Archivos"));
        ajoute_une_entree(wxT("Glucides"),wxT("Carbohydrate"),wxT("Glúcido"));
        ajoute_une_entree(wxT("Impossible! existe déjà!"),wxT("Try again! already present"),wxT("¡Imposible, ya existe!"));
        ajoute_une_entree(wxT("Impression"),wxT("Print"),wxT("Impresión"));
        ajoute_une_entree(wxT("laitages"),wxT("Milk & milk products"),wxT("lácteo"));
        ajoute_une_entree(wxT("Langage"),wxT("Language"),wxT("Idioma"));
        ajoute_une_entree(wxT("Lipides"),wxT("Fat"),wxT("Lípidos"));
        ajoute_une_entree(wxT("masse"),wxT("weight"),wxT("masa"));
        ajoute_une_entree(wxT("Modifie"),wxT("Change"),wxT("Cambia"));
        ajoute_une_entree(wxT("Nom                         Glucide   Protides  Lipides   Qté"),wxT("Name                        Carbohyd  Protein      Fat   Qty"),wxT("Nombre                     Glúcido  proteína    Lípidos   Qtd"));
        ajoute_une_entree(wxT("nom"),wxT("name"),wxT("nombre"));
        ajoute_une_entree(wxT("Nouv. nom"),wxT("New name"),wxT("Nuevo nombre"));
        ajoute_une_entree(wxT("Outils"),wxT("Tools"),wxT("Herramientas"));
        ajoute_une_entree(wxT("Ouvrir un fichier d'aliments"),wxT("Open a foods' collection"),wxT("Abrir una archiva de alimentos"));
        ajoute_une_entree(wxT("Ouvrir"),wxT("Open"),wxT("Abrir"));
        ajoute_une_entree(wxT("Paramètres"),wxT("Parameters"),wxT("Parámetros"));
        ajoute_une_entree(wxT("parmi les aliments disponibles"),wxT("among available aliments"),wxT("entre los alimentos disponibles"));
        ajoute_une_entree(wxT("pour le groupe "),wxT("for the group "),wxT("para el grupo"));
        ajoute_une_entree(wxT("Pourcentage de "),wxT("Percent of "),wxT("Porcentaje de "));
        ajoute_une_entree(wxT("Pourcentages"),wxT("Percent"),wxT("Porcentaje"));
        ajoute_une_entree(wxT("Protides"),wxT("Protein"),wxT("Proteínas"));
        ajoute_une_entree(wxT("Purge"),wxT("Clear"),wxT("Limpia"));
        ajoute_une_entree(wxT("Qté"),wxT("Qty"),wxT("Qtd"));
        ajoute_une_entree(wxT("Quitter"),wxT("Exit"),wxT("Salir"));
        ajoute_une_entree(wxT("Récapitulation"),wxT("Recap form"),wxT("Resumen"));
        ajoute_une_entree(wxT("Renomme"),wxT("Rename"),wxT("Nuevo nombre"));
        ajoute_une_entree(wxT("Rubriques d'aide"),wxT("Help topics"),wxT("Rubricas de ayuda"));
        ajoute_une_entree(wxT("Sans titre"),wxT("No title"),wxT("Sin título"));
        ajoute_une_entree(wxT("Sauve le fichier en cours"),wxT("Save the current file"),wxT("Almacenar el corriente archivo"));
        ajoute_une_entree(wxT("sucres"),wxT("sugar"),wxT("azúcar"));
        ajoute_une_entree(wxT("Supprime"),wxT("Delete"),wxT("Suprime"));
        ajoute_une_entree(wxT("Tous les groupes"),wxT("All groups"),wxT("Todos grupos"));
        ajoute_une_entree(wxT("Triangle"),wxT("Triangle"),wxT("Triángulo"));
        ajoute_une_entree(wxT("Valeur de l'incrément"),wxT("Increment step"),wxT("Incremente"));
        ajoute_une_entree(wxT("Valeur énergétique"),wxT("Energy value"),wxT("Valor energético"));
}
//---------------------------------------------------------------------------
        langues& Traducteur::fixe_langue()
{
        static langues Langue_active=fr;
        return Langue_active;
}
//---------------------------------------------------------------------------
        //fixe la langue de départ
        void Traducteur::langue_demarrage()
{
        wxString lg;
        wxGetEnv(wxT("LANG"),&lg);
        lg=lg.Left(2);
        if (lg==wxT("en")) fixe_langue()=ang;
        if (lg==wxT("es")) fixe_langue()=esp;
}
//---------------------------------------------------------------------------
// Traduit T du français dans la langue courante
        wxString Traducteur::trad(wxString T)
{
        if (textes.find(T)==textes.end()) return T;
        langues L=fixe_langue();
        if (L==fr) return T;
        return textes[T][L];
}
//---------------------------------------------------------------------------
// Traduit T de sa langue (l'une des langues reconnues) dans la langue courante
        wxString Traducteur::trad_tout(wxString T)
{
        wxString traduction=T;
        for(std::map<wxString,Dictionnaire>::iterator i=textes.begin();i!=textes.end();++i)
                if (T==i->first) traduction=trad(T);
                else  for(langues j=suivant(fr);j<=esp;j=suivant(j))
                        if (T==i->second[j])
                                traduction=trad(i->first);
        return traduction;
}
//---------------------------------------------------------------------------
//      Fin de l'objet Traducteur
//---------------------------------------------------------------------------
wxColor& Couleur_Fenetres_defaut()
{
        static wxColor couleur_fen=wxSystemSettings::GetColour(wxSYS_COLOUR_ACTIVEBORDER);
        return couleur_fen;
}
wxRect& Taille_Fenetres_defaut()
{
        //Fixe une position et une taille initiale
        // format pos.x, pos.y, Largeur, Hauteur
        static wxRect taille_fen(250,50,621,500);
        return taille_fen;
}
wxPoint FaitReelle_Pos(wxPoint posvirtuelle,wxWindow* fen)
{
        int X= fen->GetClientSize().GetWidth();
        int Y= fen->GetClientSize().GetHeight();
        return wxPoint(int(posvirtuelle.x*X/1000.0),int(posvirtuelle.y*Y/1000.0));
}
wxSize FaitReelle_Taille(wxSize Sizevirtuelle,wxWindow* fen)
{
        int X= fen->GetClientSize().GetWidth();
        int Y= fen->GetClientSize().GetHeight();
        Sizevirtuelle.Scale(float(X/1000.0),float(Y/1000.0));
        return Sizevirtuelle;
}
void Ajuste_taille_et_pos(wxPoint pos,wxSize taille,wxWindow* fen_mere,wxWindow* fen_fille)
{
        pos=FaitReelle_Pos(pos,fen_mere);
        taille=FaitReelle_Taille(taille,fen_mere);
        fen_fille->SetSize(wxRect(pos,taille));
}
void FixeFontEtTaille(wxWindow* fen)
{
        wxFont Police(fen->GetFont());
        Police.SetPointSize(8);
        fen->SetFont(Police);
}
//---------------------------------------------------------------------------
        PalettePerso::PalettePerso():clDkGray(128,128,128),clCream(255,251,240),clAqua(0,255,255),clLtGray(192,192,192),clRed(255,0,0),clBlack(0,0,0),
                                    clYellow(255,255,0),clLime(0,255,0)
        {
        }
//---------------------------------------------------------------------------
void RenommeEnfants(wxWindow* Sujet)
{
        Traducteur tr;
        wxToolTip* tt;
        wxFrame* p_frame;
        // Sous Windows Setlabel ajuste correctement le titre des "Frames' mais pas sous Linux
        // d'où la nécessité de distinguer WxXindow et wxFrame
        p_frame=dynamic_cast<wxFrame*>(Sujet);
        if (p_frame!=NULL) // C'est une wxWFrame
            p_frame->SetTitle(tr.trad_tout(p_frame->GetTitle()));
        else // C'est une simple wxWindow
            Sujet->SetLabel(tr.trad_tout(Sujet->GetLabel()));
        tt=Sujet->GetToolTip();
        if (tt!=NULL)
            Sujet->SetToolTip(tr.trad_tout(tt->GetTip()));
        // Même chose pour les enfants
        wxWindowList list;
        list=Sujet->GetChildren();
        wxWindowList::compatibility_iterator node;
        for (node = list.GetFirst(); node; node = node->GetNext() )
            {
            wxWindow *current = node->GetData();
            RenommeEnfants(current);
            }
}
//---------------------------------------------------------------------------
//      Ajuste la taille de la police à celle de la fenêtre courante
        void fixe_taille_police(wxDC& dc,float correctif)
        {
        // Correctif introduit pour tenir compte du problème avec la définition de l'impression sous Linux
        // en mode impression mais pas en preview. Je n'ai pas trouvé mieux pour le moment
        float hauteur_police=8;
        float hauteur_ecran=dc.GetSize().GetHeight();
        float largeur_ecran=dc.GetSize().GetWidth();
        float def_ecran=dc.GetPPI().GetHeight();
        if (hauteur_ecran>largeur_ecran)hauteur_ecran=largeur_ecran; //ne tient compte que de la plus petite dimension
        hauteur_police*=hauteur_ecran/(def_ecran*2*correctif);
        hauteur_police=(hauteur_police<3?3:hauteur_police);
        dc.SetFont(wxFont(int(hauteur_police),wxFONTFAMILY_DEFAULT,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_NORMAL,false));
}
//---------------------------------------------------------------------------
void Base_Tabule_ecrit(wxDC* dc,wxString st,wxPoint pos)
{   // Ecrit st à la position pos (x en nombre de caractère et y nombre de lignes de texte)
    wxSize taille_texte=dc->GetTextExtent(wxT("Q"));
    dc->DrawText(st,pos.x*taille_texte.GetWidth(),pos.y*taille_texte.GetHeight());
}
