#include "BilanRepas.h"
#include "BoiteAOutils.h"
#include "../Icones/aliments16.xpm"
//---------------------------------------------------------------------------
// Gestion des impressions
//---------------------------------------------------------------------------
// Déclaration du Printout utilisé
class BilanPrintout: public BasePrintout
{
 public:
  BilanPrintout(const wxChar *title = wxT("My printout"),TTableau_aliments* contenu_fiche_imprime=NULL,groupe_d_aliment groupe=tous_les_groupes):BasePrintout(title),Nb_de_pages(1),cfi(contenu_fiche_imprime),gr(groupe) {}
  bool OnPrintPage(int page);
  void Tabule_ecrit(wxString st,wxPoint pos);
  int Nombre_de_lignes_par_pages();
  int Nombre_de_pages();
  int Nb_de_pages;
  void pied_de_page(int marge,int ligne);
  TTableau_aliments* cfi;
  groupe_d_aliment gr;
  void OnPreparePrinting();
  bool HasPage(int page);
  //bool OnBeginDocument(int startPage, int endPage);
  void GetPageInfo(int *minPage, int *maxPage, int *selPageFrom, int *selPageTo);
};
//---------------------------------------------------------------------------
void BilanPrintout::OnPreparePrinting()
{
   FixeFontEtTaille();
   Nb_de_pages=Nombre_de_pages();
}
//---------------------------------------------------------------------------
bool BilanPrintout::HasPage(int page)
{   // HasPage n'est pas appelé avant OnPrintPage pour la première page affichée
    // Mais est appelée d'abord pour toutes les autres pages.
    return page<=Nombre_de_pages();
}
//---------------------------------------------------------------------------
void BilanPrintout::GetPageInfo(int *minPage, int *maxPage, int *selPageFrom, int *selPageTo)
{
    (*minPage)=1;// un appel direct de Nombre_de_pages() serait plus logique, mais il semble y avoir un bug
    (*maxPage)=Nb_de_pages;// GetPageInfo semble parfois appelée avant qu'un wxDC valide existe (le test de "if (dc)" ne suffit pas
                        // l'appel de sc->GetSize() fait planter le programme
}
//---------------------------------------------------------------------------
void BilanPrintout::pied_de_page(int marge,int ligne)
{
        Traducteur tr;
        TAliment Repas;
        Tgroupes g;
        wxString LigneText;
        LigneText=tr.trad(wxT("Bilan repas"))+wxT(" ")+tr.trad(wxT("pour le groupe "))+g.nom(gr);
        Repas=Calcule_bilan(*cfi,gr);
        ligne++;
        Tabule_ecrit(LigneText,wxPoint(marge+15,ligne++));
        LigneText= wxString::Format(wxT("%4.1f"),Repas.g())+wxT("   ");
        LigneText+=wxString::Format(wxT("%4.1f"),Repas.p())+wxT("   ");
        LigneText+=wxString::Format(wxT("%4.1f"),Repas.l())+wxT("   ");
        LigneText+=wxString::Format(wxT("%4.1f"),Repas.Qte())+wxT(" gr");
        Tabule_ecrit(LigneText,wxPoint(marge+15,ligne++));
        LigneText=tr.trad(wxT("Pourcentage de "));
        LigneText+=tr.trad(Repas.pourcent_en());
        Tabule_ecrit(LigneText,wxPoint(marge+15,ligne++));
        LigneText= wxString::Format(wxT("%3.1f"),Repas.g_pourcent())+wxT("   ");
        LigneText+=wxString::Format(wxT("%3.1f"),Repas.p_pourcent())+wxT("   ");
        LigneText+=wxString::Format(wxT("%3.1f"),Repas.l_pourcent())+wxT("   ");
        LigneText+=wxString::Format(wxT("%3.1f"),Repas.energie())+wxT(" ")+Repas.unite_energie();
        Tabule_ecrit(LigneText,wxPoint(marge+15,ligne++));
}
//---------------------------------------------------------------------------
bool BilanPrintout::OnPrintPage(int page)
{
    wxDC *dc = GetDC();
    if (dc)
    {
        FixeFontEtTaille();// Appel nécessaire à chaque changement de pages
        dc->SetBrush(*wxWHITE_BRUSH);
            // Début bloc correction fond noir
        // Ce bloc est nécessaire du fait d'un bug sous Linux depuis Ubuntu 18.04
        // Si on ne trace pas un rectanglela page est imprimée en noir sur le preview
        dc->Clear();
        int L,H;dc->GetSize(&L,&H);
        dc->DrawRectangle(0,0,L,H);
        //Fin bloc correction fond noir
        int nb_lignes_par_pages(Nombre_de_lignes_par_pages()-10),ligne(0),derligne(2),marge(2);
        TAliment al;
        Traducteur tr;
        Tabule_ecrit(wxString::Format(wxT("PAGE %d"), page),wxPoint(marge,ligne++));
        Tabule_ecrit(tr.trad(wxT("nom")).Left(10),wxPoint(marge,++ligne));
        Tabule_ecrit(tr.trad(wxT("Glucides")).Left(3),wxPoint(marge+15,ligne));
        Tabule_ecrit(tr.trad(wxT("Protides")).Left(3),wxPoint(marge+20,ligne));
        Tabule_ecrit(tr.trad(wxT("Lipides")).Left(3) ,wxPoint(marge+25,ligne));
        Tabule_ecrit(tr.trad(wxT("Qté")).Left(10)    ,wxPoint(marge+30,ligne));
        //Tabule_ecrit(wxString::Format(wxT("Nb Pages %4d"),Nombre_de_pages()),wxPoint(15,++ligne));//sauter
        //Tabule_ecrit(wxString::Format(wxT("Nb lignes %4d"),nb_lignes_par_pages),wxPoint(15,++ligne));//sauter
        int ligne_du_tableau=0;
        int premiere_ligne=(page-1)*nb_lignes_par_pages*2;
        int dernier_ligne=premiere_ligne+nb_lignes_par_pages*2;
        bool colonne2(false);
        wxPoint decale(0,0);
        for (Tmapiter i=cfi->begin();i!=cfi->end();++i)
                {
                if (i->second.Qval()>0.1)
                  if ((i->second.groupeval()==gr)||(gr==tous_les_groupes))
                        {
                        ++ligne_du_tableau;
                        colonne2=((ligne_du_tableau-1)/nb_lignes_par_pages)%2;
                        decale=wxPoint((colonne2?35:0),(colonne2?-nb_lignes_par_pages:0));
                        if ((ligne_du_tableau>premiere_ligne)&&(ligne_du_tableau<=dernier_ligne))
                            {
                            al.Aliment_nomme=*i;
                            Tabule_ecrit(al.nom().Left(20),wxPoint(marge+decale.x,(++ligne)+decale.y));
                            Tabule_ecrit(wxString::Format(wxT("%4.1f"),al.g())  ,wxPoint(marge+15+decale.x,ligne+decale.y));
                            Tabule_ecrit(wxString::Format(wxT("%4.1f"),al.p())  ,wxPoint(marge+20+decale.x,ligne+decale.y));
                            Tabule_ecrit(wxString::Format(wxT("%4.1f"),al.l())  ,wxPoint(marge+25+decale.x,ligne+decale.y));
                            Tabule_ecrit(wxString::Format(wxT("%4.1f"),al.Qte()),wxPoint(marge+30+decale.x,ligne+decale.y));
                            }
                        derligne=(derligne>ligne+decale.y?derligne:ligne+decale.y);
                        }
                }
        if (page==Nb_de_pages) pied_de_page(marge,derligne);
        return true;
    }
    else
        return false;
}
//---------------------------------------------------------------------------
// Écrit st à la position pos (x en nombre de caractère et y nombre de lignes de texte)
void BilanPrintout::Tabule_ecrit(wxString st,wxPoint pos)
{
    wxDC *dc = GetDC();
    Base_Tabule_ecrit(dc,st,pos);
}
//---------------------------------------------------------------------------
int BilanPrintout::Nombre_de_lignes_par_pages()
{
    wxDC *dc = GetDC();
    int wp(10),wh(10),charH(10),nb_lignes_par_page(40);
    double scx(1),scy(1);
    if (dc)
    {
        charH=int(dc->GetCharHeight());
        dc->GetSize(&wp,&wh);
        dc->GetUserScale(&scx,&scy);
    }
    nb_lignes_par_page=int(wh/(charH*scy+0.01));
    return nb_lignes_par_page+1;
}
//---------------------------------------------------------------------------
int BilanPrintout::Nombre_de_pages()
{
    int nb_lignes=0,pied_de_page=10;
    for (Tmapiter i=cfi->begin();i!=cfi->end();++i)
        if (i->second.Qval()>0.1)
          if ((i->second.groupeval()==gr)||(gr==tous_les_groupes))  ++nb_lignes;
    return int((nb_lignes+pied_de_page)/(Nombre_de_lignes_par_pages()*2))+1;
}
//---------------------------------------------------------------------------
// Fin BilanPrintout
//---------------------------------------------------------------------------
// Position des tabulations
    const int NOMB_TAB=5;
    int Tab[NOMB_TAB]={5,20,30,40,50};
//---------------------------------------------------------------------------
//Identificateurs
const long BilanRepas::idBoutPrint= wxNewId();
const long BilanRepas::idListeAliments = wxNewId();
const long BilanRepas::idNomGroupes = wxNewId();
const long BilanRepas::idTitres = wxNewId();
const long BilanRepas::idLMasse = wxNewId();
const long BilanRepas::idLPourcent = wxNewId();
const long BilanRepas::idTotal = wxNewId();
const long BilanRepas::idPourcentages = wxNewId();
const long BilanRepas::idPourcentde = wxNewId();

BEGIN_EVENT_TABLE(BilanRepas, wxFrame)
    EVT_PAINT(BilanRepas::OnPaint)
    EVT_SIZE(BilanRepas::OnSize)
    EVT_BUTTON(idBoutPrint,BilanRepas::OnBoutPrint)
    EVT_CLOSE(BilanRepas::OnQuit)
    EVT_COMBOBOX(idNomGroupes, BilanRepas::OnNomGroupes)
END_EVENT_TABLE()
//---------------------------------------------------------------------------
// Le constructeur
        BilanRepas::BilanRepas(wxWindow* parent,wxWindowID idfenbilanrepas):
             wxFrame(parent,idfenbilanrepas,wxT("Bilan repas"),wxPoint(300,100),wxDefaultSize,wxDEFAULT_FRAME_STYLE|wxFULL_REPAINT_ON_RESIZE)
            ,item_menu_change(true),liste_modifiee(false)
            ,est_repertoire(false),taille_modifiee(true),valindex(int(tous_les_groupes))
{   FixeFontEtTaille(this);
    wxPoint pos(10,10);
    wxSize taille(10,10);
    SetBackgroundColour(Couleur_Fenetres_defaut());
    wxRect taille_fen=Taille_Fenetres_defaut();
    taille_fen.SetX(taille_fen.GetX()+taille_fen.GetWidth());
    taille_fen.SetY(taille_fen.GetY());
    taille_fen.SetWidth(350);
    taille_fen.SetHeight(350);
    SetSize(taille_fen);
    SetIcon(aliments16_xpm);

    // Labels
    LabelTitres= new wxStaticText(this,idTitres,wxT("Nom                         Glucide   Protides  Lipides   Qté"),pos,taille,wxST_NO_AUTORESIZE);
    LabelLMasse= new wxStaticText(this,idLMasse,wxT("masse"),pos,taille,wxST_NO_AUTORESIZE);
    LabelLPourcent= new wxStaticText(this,idLPourcent,wxT("Pourcentages"),pos,taille,wxST_NO_AUTORESIZE);
    LabelTotal= new wxStaticText(this,idTotal,wxT("xx"),pos,taille,wxST_NO_AUTORESIZE);
    LabelPourcentages= new wxStaticText(this,idPourcentages,wxT("yy"),pos,taille,wxST_NO_AUTORESIZE);
    LabelPourcentde= new wxStaticText(this,idPourcentde,wxT("yy"),pos,taille,wxST_NO_AUTORESIZE);
    // Fenêtre d'affichage
    ListeAliments=new wxTextCtrl(this,idListeAliments,wxT(""),pos,taille,wxTE_LEFT|wxTE_MULTILINE|wxTE_READONLY|wxTE_RICH);
    wxTextAttr Style;
    Style=ListeAliments->GetDefaultStyle();
    wxArrayInt Tabs; // Tabulations en dixième de mm
    Tabs.Add(300);
    Tabs.Add(400);
    Tabs.Add(500);
    Tabs.Add(600);
    Tabs.Add(700);
    Style.SetTabs(Tabs);
    Style.SetTextColour(*wxRED);
    ListeAliments->SetDefaultStyle(Style);
    ListeAliments->AppendText(wxT("Titre"));
    // ComboBox choix des aliments
    wxString ChoixDefaut[]={wxT("Vide")};
    NomGroupes=new wxComboBox(this,idNomGroupes,wxT(""),wxPoint(10,10),wxSize(150,40),1,ChoixDefaut,wxCB_READONLY);
    // Boutons
    BoutPrint=new wxButton(this,idBoutPrint,wxT("Impression"),pos,taille);
    g_printData =new wxPrintData;
    g_printData->SetPaperId(wxPAPER_A4);
}
// Le destructeur
BilanRepas::~BilanRepas(){};

//---------------------------------------------------------------------------
        void BilanRepas::Affiche_proportions()
{
        Traducteur tr;
        TAliment Repas;
        wxString Ligne;
        Tgroupes g;
        Ligne=tr.trad(wxT("Bilan repas"))+wxT(" ")+tr.trad(wxT("pour le groupe "))+g.nom(groupe_d_aliment(NomGroupes->GetSelection()));
        groupe_d_aliment gr=groupe_d_aliment(NomGroupes->GetSelection());
        Repas=Calcule_bilan(*conteneur_aliments_Bilan,gr);
        ListeAliments->AppendText(LF);
        ListeAliments->AppendText(Ligne);
        ListeAliments->AppendText(LF);
        Ligne =tr.trad(wxT("masse"))+TAB;
        Ligne+=wxString::Format(wxT("%4.1f"),Repas.g())+TAB;
        Ligne+=wxString::Format(wxT("%4.1f"),Repas.p())+TAB;
        Ligne+=wxString::Format(wxT("%4.1f"),Repas.l())+TAB;
        Ligne+=wxString::Format(wxT("%4.1f"),Repas.Qte())+wxT(" gr")+LF;
        ListeAliments->AppendText(Ligne);
        Ligne=tr.trad(wxT("Pourcentage de "))+LF;
        Ligne+=tr.trad(Repas.pourcent_en())+TAB;
        Ligne+=wxString::Format(wxT("%3.1f"),Repas.g_pourcent())+TAB;
        Ligne+=wxString::Format(wxT("%3.1f"),Repas.p_pourcent())+TAB;
        Ligne+=wxString::Format(wxT("%3.1f"),Repas.l_pourcent())+TAB;
        Ligne+=wxString::Format(wxT("%3.1f"),Repas.energie())+wxT(" ")+Repas.unite_energie()+LF;
        ListeAliments->AppendText(Ligne);
}
//---------------------------------------------------------------------------
        void BilanRepas::Affiche()
        {
                wxString Ligne;
                TAliment al;
                Traducteur tr;
                Tgroupes g;
                ListeAliments->Clear();
                Ligne=
                (est_repertoire?tr.trad(wxT("Fichier d'aliment : "))+firstwin()->NomFichier:tr.trad(wxT("État du menu en cours")));
                Ligne+=LF;
                Ligne+=tr.trad(wxT("nom"))+TAB;
                Ligne+=tr.trad(wxT("Glucides")).Left(3)+TAB;
                Ligne+=tr.trad(wxT("Protides")).Left(3)+TAB;
                Ligne+=tr.trad(wxT("Lipides")).Left(3)+TAB;
                Ligne+= tr.trad(wxT("Qté"));
                ListeAliments->AppendText(Ligne+LF);
        if (NomGroupes->GetSelection()==wxNOT_FOUND)
            NomGroupes->SetSelection(int(tous_les_groupes));
        groupe_d_aliment gr=groupe_d_aliment(NomGroupes->GetSelection());
        for (Tmapiter i=conteneur_aliments_Bilan->begin();i!=conteneur_aliments_Bilan->end();++i)
                {
                if (i->second.Qval()>0.1)
                  if ((i->second.groupeval()==gr)||(gr==tous_les_groupes))
                        {al.Aliment_nomme=*i;
                        Ligne =al.nom()+TAB;
                        Ligne+=wxString::Format(wxT("%4.1f"),al.g())+TAB;
                        Ligne+=wxString::Format(wxT("%4.1f"),al.p())+TAB;
                        Ligne+=wxString::Format(wxT("%4.1f"),al.l())+TAB;
                        Ligne+=wxString::Format(wxT("%4.1f"),al.Qte());
                        ListeAliments->AppendText(Ligne+LF);
                        }
                }
        Affiche_proportions();
        ListeAliments->SetInsertionPoint(1);
        TAliment Repas;
        Repas=Calcule_bilan(*conteneur_aliments_Bilan,gr);
        LabelTotal->SetLabel(wxString::Format(wxT("%04.1f"),Repas.g())+TAB+wxString::Format(wxT("%04.1f"),Repas.p())+TAB+wxString::Format(wxT("%04.1f"),Repas.l())+TAB+wxString::Format(wxT("%04.1f"),Repas.Qte())+wxT(" gr"));
        LabelPourcentages->SetLabel(wxString::Format(wxT("%03.1f"),Repas.g_pourcent())+TAB+wxString::Format(wxT("%03.1f"),Repas.p_pourcent())+TAB+wxString::Format(wxT("%03.1f"),Repas.l_pourcent())+TAB+wxString::Format(wxT("%04.1f"),Repas.energie())+wxT(" ")+Repas.unite_energie());
        }
//---------------------------------------------------------------------------
void BilanRepas::OnSize(wxSizeEvent& event)
{
    taille_modifiee=true;
}
//---------------------------------------------------------------------------
void BilanRepas::OnPaint(wxPaintEvent& event)
{
    wxPaintDC dc(this);
    Traducteur tr;
    TAliment al;
    if (taille_modifiee)
    {
         // Ajuste la taille des contrôles
        Ajuste_taille_et_pos(wxPoint(20,200),wxSize(960,550),this,ListeAliments);
        Ajuste_taille_et_pos(wxPoint(750,30),wxSize(200,70),this,BoutPrint);
        Ajuste_taille_et_pos(wxPoint(40,150),wxSize(960,50),this,LabelTitres);
        Ajuste_taille_et_pos(wxPoint(20,760),wxSize(300,50),this,LabelLMasse);
        Ajuste_taille_et_pos(wxPoint(370,760),wxSize(600,50),this,LabelTotal);
        Ajuste_taille_et_pos(wxPoint(20,840),wxSize(300,50),this,LabelLPourcent);
        Ajuste_taille_et_pos(wxPoint(370,840),wxSize(600,50),this,LabelPourcentages);
        Ajuste_taille_et_pos(wxPoint(300,920),wxSize(500,50),this,LabelPourcentde);
        Ajuste_taille_et_pos(wxPoint(20,30),wxSize(700,70),this,NomGroupes);
    }
    if (item_menu_change)
        {
        LabelPourcentde->SetLabel(tr.trad(wxT("Pourcentage de "))+ tr.trad(al.pourcent_en()));
        Tgroupes groupes;
        if (NomGroupes->GetString(0)==wxT("Vide")||(NomGroupes->GetString(0)!=tr.trad(groupes.nom(al_protidiques))))
            {
            NomGroupes->Clear();
            for (groupe_d_aliment i=al_protidiques;i<=tous_les_groupes;i=suivant(i))
                NomGroupes->Append(groupes.nom(i));
            NomGroupes->SetSelection(valindex);
            }
        }
    if (liste_modifiee||item_menu_change) {Affiche();liste_modifiee=false;}
    valindex=NomGroupes->GetSelection();
    taille_modifiee=false;
    item_menu_change=false;
}
//---------------------------------------------------------------------------
void BilanRepas::OnBoutPrint(wxCommandEvent& event)
{
    Traducteur tr;
    wxPrintDialogData g_printDialogData(*g_printData);
    g_printDialogData.EnablePageNumbers(true);
    g_printDialogData.SetMaxPage(3);
    if (NomGroupes->GetSelection()==wxNOT_FOUND)
        NomGroupes->SetSelection(int(tous_les_groupes));
    groupe_d_aliment gr=groupe_d_aliment(NomGroupes->GetSelection());
    wxPrintPreview *preview = new wxPrintPreview(new BilanPrintout(wxT("Liste 1"),conteneur_aliments_Bilan,gr), new BilanPrintout(wxT("Liste 2"),conteneur_aliments_Bilan,gr), & g_printDialogData);
    if (!preview->Ok())
    {
        delete preview;
        wxMessageBox(wxT("There was a problem previewing.\nPerhaps your current printer is not set correctly?"), wxT("Previewing"), wxOK);
        return;
    }
    wxPreviewFrame *frame = new wxPreviewFrame(preview, this, tr.trad(wxT("Aliments disponibles")), wxPoint(100, 100), wxSize(600, 650));
    frame->Centre(wxBOTH);
    frame->Initialize();
    frame->Show();
}
//---------------------------------------------------------------------------
void BilanRepas::OnQuit(wxCloseEvent& event)
{
    Hide();
}
//---------------------------------------------------------------------------
void BilanRepas::OnNomGroupes(wxCommandEvent& event)
{
    valindex=NomGroupes->GetSelection();
    Affiche();
    Refresh();
}
